/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.distUI;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.ViewBeanManager;
import com.sun.identity.authentication.client.AuthClientUtils;
import com.sun.identity.authentication.distUI.AuthExceptionViewBean;
import com.sun.identity.authentication.distUI.AuthenticationServletBase;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessageImpl;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginServlet
extends AuthenticationServletBase {
    public static final String DEFAULT_MODULE_URL = "../UI";
    public static String PACKAGE_NAME = LoginServlet.getPackageName((String)LoginServlet.class.getName());
    private static final String REDIRECT_JSP = "Redirect.jsp";
    private static Debug debug = Debug.getInstance((String)"amLoginServlet");

    protected void initializeRequestContext(RequestContext requestContext) {
        super.initializeRequestContext(requestContext);
        ViewBeanManager viewBeanManager = new ViewBeanManager(requestContext, PACKAGE_NAME);
        ((RequestContextImpl)requestContext).setViewBeanManager(viewBeanManager);
        HttpServletRequest request = requestContext.getRequest();
        HttpServletResponse response = requestContext.getResponse();
        try {
            RequestUtils.checkContentLength(request);
        }
        catch (L10NMessageImpl e) {
            if (debug.messageEnabled()) {
                ISLocaleContext localeContext = new ISLocaleContext();
                localeContext.setLocale(request);
                Locale locale = localeContext.getLocale();
                if (debug.messageEnabled()) {
                    debug.message("Error in check content lenght : " + e.getL10NMessage(locale));
                }
            }
            AuthExceptionViewBean vb = (AuthExceptionViewBean)viewBeanManager.getViewBean(AuthExceptionViewBean.class);
            vb.forwardTo(requestContext);
            throw new CompleteRequestException();
        }
        String authCookieValue = AuthClientUtils.getAuthCookieValue(request);
        if (authCookieValue != null && authCookieValue.length() != 0 && !authCookieValue.equalsIgnoreCase("LOGOUT")) {
            if (debug.messageEnabled()) {
                debug.message("authCookieValue : " + authCookieValue);
            }
            if (authCookieValue != null && authCookieValue.length() != 0 && !AuthClientUtils.isLocalServer(authCookieValue, false)) {
                block13: {
                    debug.message("Routing the request to Original Auth server");
                    try {
                        HashMap origRequestData = AuthClientUtils.sendAuthRequestToOrigServer(request, response, authCookieValue);
                        if (debug.messageEnabled()) {
                            debug.message("origRequestData : " + origRequestData);
                        }
                        String redirect_url = null;
                        String clientType = null;
                        String output_data = null;
                        if (origRequestData != null && !origRequestData.isEmpty()) {
                            redirect_url = (String)origRequestData.get("AM_REDIRECT_URL");
                            output_data = (String)origRequestData.get("OUTPUT_DATA");
                            clientType = (String)origRequestData.get("AM_CLIENT_TYPE");
                        }
                        if (redirect_url != null && !redirect_url.equals("") && AuthClientUtils.isGenericHTMLClient(clientType)) {
                            debug.message("Redirecting the response");
                            response.sendRedirect(redirect_url);
                        }
                        if (output_data != null && !output_data.equals("")) {
                            debug.message("Printing the forwarded response");
                            PrintWriter outP = response.getWriter();
                            outP.println(output_data);
                        }
                    }
                    catch (Exception e) {
                        if (!debug.messageEnabled()) break block13;
                        debug.message("LoginServlet error in Request Routing : " + e.toString());
                    }
                }
                throw new CompleteRequestException();
            }
        }
    }

    public String getModuleURL() {
        String result = super.getModuleURL();
        if (result != null) {
            return result;
        }
        return DEFAULT_MODULE_URL;
    }

    protected void onSessionTimeout(RequestContext requestContext) throws ServletException {
    }
}

