/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.windowsdesktopsso;

import com.sun.identity.authentication.modules.windowsdesktopsso.WindowsDesktopSSOConfig;
import com.sun.identity.authentication.modules.windowsdesktopsso.WindowsDesktopSSOPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.util.DerValue;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import sun.misc.BASE64Decoder;
import sun.security.provider.Sun;

public class WindowsDesktopSSO
extends AMLoginModule {
    private static final String amAuthWindowsDesktopSSO = "amAuthWindowsDesktopSSO";
    private static final String[] configAttributes = new String[]{"iplanet-am-auth-windowsdesktopsso-principal-name", "iplanet-am-auth-windowsdesktopsso-keytab-file", "iplanet-am-auth-windowsdesktopsso-kerberos-realm", "iplanet-am-auth-windowsdesktopsso-kdc", "iplanet-am-auth-windowsdesktopsso-returnRealm", "iplanet-am-auth-windowsdesktopsso-auth-level", "serviceSubject"};
    private static final int PRINCIPAL = 0;
    private static final int KEYTAB = 1;
    private static final int REALM = 2;
    private static final int KDC = 3;
    private static final int RETURNREALM = 4;
    private static final int AUTHLEVEL = 5;
    private static final int SUBJECT = 6;
    private static Hashtable configTable = new Hashtable();
    private Principal userPrincipal = null;
    private Subject serviceSubject = null;
    private String servicePrincipalName = null;
    private String keyTabFile = null;
    private String kdcRealm = null;
    private String kdcServer = null;
    private boolean returnRealm = false;
    private String authLevel = null;
    private Map options = null;
    private String confIndex = null;
    private Debug debug = Debug.getInstance((String)"amAuthWindowsDesktopSSO");
    private static byte[] spnegoOID = new byte[]{6, 6, 43, 6, 1, 5, 5, 2};
    private static byte[] MS_KERBEROS_OID = new byte[]{6, 9, 42, -122, 72, -126, -9, 18, 1, 2, 2};
    private static byte[] KERBEROS_V5_OID = new byte[]{6, 9, 42, -122, 72, -122, -9, 18, 1, 2, 2};

    public void init(Subject subject, Map sharedState, Map options) {
        this.options = options;
    }

    public Principal getPrincipal() {
        return this.userPrincipal;
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        byte[] kerberosToken;
        byte[] spnegoToken;
        int result = 0;
        if (!this.getConfigParams()) {
            this.initWindowsDesktopSSOAuth(this.options);
        }
        if ((spnegoToken = this.getSPNEGOToken()) == null) {
            this.debug.message("spnego token is not valid.");
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "token", null);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("SPNEGO token: \n" + DerValue.printByteArray(spnegoToken, 0, spnegoToken.length));
        }
        if ((kerberosToken = this.parseToken(spnegoToken)) == null) {
            this.debug.message("kerberos token is not valid.");
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "token", null);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("Kerberos token retrieved from SPNEGO token: \n" + DerValue.printByteArray(kerberosToken, 0, kerberosToken.length));
        }
        try {
            this.authenticateToken(kerberosToken);
            this.debug.message("WindowsDesktopSSO authentication succeeded.");
            result = -1;
        }
        catch (GSSException e) {
            int major = e.getMajor();
            if (major == 8) {
                this.debug.message("Credential expired. Re-establish credential...");
                this.serviceLogin();
                try {
                    this.authenticateToken(kerberosToken);
                    this.debug.message("Authentication succeeded with new cred.");
                    result = -1;
                }
                catch (Exception ee) {
                    this.debug.message("Authentication failed with new cred.");
                    throw new AuthLoginException(amAuthWindowsDesktopSSO, "auth", null, ee);
                }
            }
            this.debug.message("Authentication failed with GSSException.");
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "auth", null, e);
        }
        catch (AuthLoginException e) {
            throw e;
        }
        catch (Exception e) {
            this.debug.message("Authentication failed with generic exception.");
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "auth", null, e);
        }
        return result;
    }

    private void authenticateToken(final byte[] kerberosToken) throws AuthLoginException, GSSException, Exception {
        this.debug.message("In authenticationToken ...");
        Subject.doAs(this.serviceSubject, new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                GSSContext context = GSSManager.getInstance().createContext((GSSCredential)null);
                WindowsDesktopSSO.this.debug.message("Context created.");
                byte[] outToken = context.acceptSecContext(kerberosToken, 0, kerberosToken.length);
                if (outToken != null && WindowsDesktopSSO.this.debug.messageEnabled()) {
                    WindowsDesktopSSO.this.debug.message("Token returned from acceptSecContext: \n" + DerValue.printByteArray(outToken, 0, outToken.length));
                }
                if (!context.isEstablished()) {
                    WindowsDesktopSSO.this.debug.message("Cannot establish context !");
                    throw new AuthLoginException(WindowsDesktopSSO.amAuthWindowsDesktopSSO, "context", null);
                }
                WindowsDesktopSSO.this.debug.message("Context establised !");
                GSSName user = context.getSrcName();
                WindowsDesktopSSO.this.storeUsernamePasswd(((Object)user).toString(), null);
                if (WindowsDesktopSSO.this.debug.messageEnabled()) {
                    WindowsDesktopSSO.this.debug.message("User authenticated: " + ((Object)user).toString());
                }
                if (user != null) {
                    WindowsDesktopSSO.this.setPrincipal(((Object)user).toString());
                }
                context.dispose();
                return null;
            }
        });
    }

    public void destroyModuleState() {
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.serviceSubject = null;
        this.servicePrincipalName = null;
        this.keyTabFile = null;
        this.kdcRealm = null;
        this.kdcServer = null;
        this.authLevel = null;
        this.options = null;
        this.confIndex = null;
    }

    private void setPrincipal(String user) {
        int index;
        String principal = user;
        if (!this.returnRealm && (index = user.indexOf("@")) != -1) {
            principal = user.substring(0, index);
        }
        this.userPrincipal = new WindowsDesktopSSOPrincipal(principal);
    }

    private byte[] getSPNEGOToken() {
        byte[] token;
        block3: {
            token = null;
            HttpServletRequest req = this.getHttpServletRequest();
            String header = req.getHeader("Authorization");
            if (header.startsWith("Negotiate")) {
                header = header.substring("Negotiate".length()).trim();
                BASE64Decoder decoder = new BASE64Decoder();
                try {
                    token = decoder.decodeBuffer(header);
                }
                catch (Exception e) {
                    this.debug.error("Decoding token error.");
                    if (!this.debug.messageEnabled()) break block3;
                    this.debug.message("Stack trace: ", (Throwable)e);
                }
            }
        }
        return token;
    }

    private byte[] parseToken(byte[] rawToken) {
        byte[] token = rawToken;
        DerValue tmpToken = new DerValue(rawToken);
        if (this.debug.messageEnabled()) {
            this.debug.message("token tag:" + DerValue.printByte(tmpToken.getTag()));
        }
        if (tmpToken.getTag() != 96) {
            return null;
        }
        ByteArrayInputStream tmpInput = new ByteArrayInputStream(tmpToken.getData());
        byte[] oidArray = new byte[spnegoOID.length];
        tmpInput.read(oidArray, 0, oidArray.length);
        if (Arrays.equals(oidArray, spnegoOID)) {
            this.debug.message("SPNEGO OID found in the Auth Token");
            tmpToken = new DerValue(tmpInput);
            if (tmpToken.getTag() == -96) {
                this.debug.message("DerValue: found init token");
                tmpToken = new DerValue(tmpToken.getData());
                if (tmpToken.getTag() == 48) {
                    this.debug.message("DerValue: 0x30 constructed token found");
                    tmpInput = new ByteArrayInputStream(tmpToken.getData());
                    tmpToken = new DerValue(tmpInput);
                    while (tmpToken.getTag() != -1 && tmpToken.getTag() != -94) {
                        tmpToken = new DerValue(tmpInput);
                    }
                    if (tmpToken.getTag() != -1) {
                        tmpToken = new DerValue(tmpToken.getData());
                        token = tmpToken.getData();
                    }
                }
            }
        } else {
            int i;
            this.debug.message("SPNEGO OID not found in the Auth Token");
            byte[] krb5Oid = new byte[KERBEROS_V5_OID.length];
            for (i = 0; i < oidArray.length; ++i) {
                krb5Oid[i] = oidArray[i];
            }
            tmpInput.read(krb5Oid, i, krb5Oid.length - i);
            if (!Arrays.equals(krb5Oid, KERBEROS_V5_OID)) {
                this.debug.message("Kerberos V5 OID not found in the Auth Token");
                token = null;
            } else {
                this.debug.message("Kerberos V5 OID found in the Auth Token");
            }
        }
        return token;
    }

    private boolean getConfigParams() {
        this.servicePrincipalName = this.getMapAttr(this.options, 0);
        this.keyTabFile = this.getMapAttr(this.options, 1);
        this.kdcRealm = this.getMapAttr(this.options, 2);
        this.kdcServer = this.getMapAttr(this.options, 3);
        this.authLevel = this.getMapAttr(this.options, 5);
        this.returnRealm = Boolean.valueOf(this.getMapAttr(this.options, 4));
        if (this.debug.messageEnabled()) {
            this.debug.message("WindowsDesktopSSO params: \nprincipal: " + this.servicePrincipalName + "\nkeytab file: " + this.keyTabFile + "\nrealm : " + this.kdcRealm + "\nkdc server: " + this.kdcServer + "\ndomain principal: " + this.returnRealm + "\nauth level: " + this.authLevel);
        }
        this.confIndex = this.getRequestOrg() + "/" + this.options.get("moduleInstanceName");
        Map configMap = (Map)configTable.get(this.confIndex);
        if (configMap == null) {
            return false;
        }
        String principalName = (String)configMap.get(configAttributes[0]);
        String tabFile = (String)configMap.get(configAttributes[1]);
        String realm = (String)configMap.get(configAttributes[2]);
        String kdc = (String)configMap.get(configAttributes[3]);
        if (!(principalName != null && tabFile != null && realm != null && kdc != null && this.servicePrincipalName.equalsIgnoreCase(principalName) && this.keyTabFile.equals(tabFile) && this.kdcRealm.equals(realm) && this.kdcServer.equalsIgnoreCase(kdc))) {
            return false;
        }
        this.serviceSubject = (Subject)configMap.get(configAttributes[6]);
        if (this.serviceSubject == null) {
            return false;
        }
        this.debug.message("Retrieved config params from cache.");
        return true;
    }

    private void initWindowsDesktopSSOAuth(Map options) throws AuthLoginException {
        this.debug.message("Init WindowsDesktopSSO. This should not happen often.");
        this.verifyAttributes();
        this.serviceLogin();
        HashMap<String, Subject> configMap = (HashMap<String, Subject>)configTable.get(this.confIndex);
        if (configMap == null) {
            configMap = new HashMap<String, Subject>();
        }
        configMap.put(configAttributes[6], this.serviceSubject);
        configMap.put(configAttributes[0], (Subject)((Object)this.servicePrincipalName));
        configMap.put(configAttributes[1], (Subject)((Object)this.keyTabFile));
        configMap.put(configAttributes[2], (Subject)((Object)this.kdcRealm));
        configMap.put(configAttributes[3], (Subject)((Object)this.kdcServer));
        configTable.put(this.confIndex, configMap);
    }

    private synchronized void serviceLogin() throws AuthLoginException {
        this.debug.message("New Service Login ...");
        System.setProperty("java.security.krb5.realm", this.kdcRealm);
        System.setProperty("java.security.krb5.kdc", this.kdcServer);
        System.setProperty("java.security.auth.login.config", "/dev/null");
        try {
            Provider defProv = null;
            boolean switchProvider = true;
            Provider[] provList = Security.getProviders();
            defProv = provList[0];
            Sun sunProv = new Sun();
            if (this.debug.messageEnabled()) {
                this.debug.message("default provider: " + defProv.getName() + ", sun provider: " + sunProv.getName());
            }
            if (!defProv.getName().equals(sunProv.getName())) {
                Security.removeProvider(sunProv.getName());
                Security.insertProviderAt(sunProv, 1);
            } else {
                switchProvider = false;
            }
            if (this.debug.messageEnabled()) {
                StringBuffer provs = new StringBuffer();
                provList = Security.getProviders();
                for (int i = 0; i < provList.length; ++i) {
                    Provider Prov = provList[i];
                    provs.append("\t" + Prov.getName() + "\n");
                }
                this.debug.message("Current providers = " + provs.toString());
            }
            Configuration config = Configuration.getConfiguration();
            WindowsDesktopSSOConfig wtc = null;
            if (config instanceof WindowsDesktopSSOConfig) {
                wtc = (WindowsDesktopSSOConfig)config;
                wtc.setRefreshConfig("true");
            } else {
                wtc = new WindowsDesktopSSOConfig(config);
            }
            wtc.setPrincipalName(this.servicePrincipalName);
            wtc.setKeyTab(this.keyTabFile);
            Configuration.setConfiguration(wtc);
            LoginContext lc = new LoginContext("com.sun.identity.authentication.windowsdesktopsso");
            lc.login();
            this.serviceSubject = lc.getSubject();
            this.debug.message("Service login succeeded.");
            if (switchProvider) {
                Security.removeProvider(defProv.getName());
                Security.insertProviderAt(defProv, 1);
                boolean bl = false;
            }
        }
        catch (Exception e) {
            this.debug.error("Service Login Error: ");
            if (this.debug.messageEnabled()) {
                this.debug.message("Stack trace: ", (Throwable)e);
            }
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "serviceAuth", null, e);
        }
    }

    private String getMapAttr(Map options, int index) {
        return CollectionHelper.getMapAttr((Map)options, (String)configAttributes[index]);
    }

    private void verifyAttributes() throws AuthLoginException {
        if (this.servicePrincipalName == null || this.servicePrincipalName.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullprincipal", null);
        }
        if (this.keyTabFile == null || this.keyTabFile.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullkeytab", null);
        }
        if (this.kdcRealm == null || this.kdcRealm.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullrealm", null);
        }
        if (this.kdcServer == null || this.kdcServer.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullkdc", null);
        }
        if (this.authLevel == null || this.authLevel.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullauthlevel", null);
        }
        if (!new File(this.keyTabFile).exists()) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nokeytab", null);
        }
        try {
            this.setAuthLevel(Integer.parseInt(this.authLevel));
        }
        catch (Exception e) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "authlevel", null, e);
        }
    }
}

