/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class CreateAgent
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        String[] args;
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String agentName = this.getStringOptionValue("agentname");
        String agentType = this.getStringOptionValue("agenttype");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        Map attributeValues = Collections.EMPTY_MAP;
        if (datafile != null || attrValues != null) {
            attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        }
        if (attributeValues == null || attributeValues.isEmpty()) {
            throw new CLIException(this.getResourceString("agent-creation-pwd-needed"), 127);
        }
        boolean hasPassword = false;
        Iterator i = attributeValues.keySet().iterator();
        while (i.hasNext() && !hasPassword) {
            Set values;
            String k = (String)i.next();
            if (!k.equals("userpassword") || (values = (Set)attributeValues.get(k)) == null || values.isEmpty()) continue;
            String pwd = (String)values.iterator().next();
            hasPassword = pwd.trim().length() > 0;
        }
        if (!hasPassword) {
            throw new CLIException(this.getResourceString("agent-creation-pwd-needed"), 127);
        }
        String[] params = new String[]{realm, agentType, agentName};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_AGENT", params);
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            Set set = amir.getAllowedIdOperations(IdType.AGENTONLY);
            if (!set.contains(IdOperation.CREATE)) {
                String[] args2 = new String[]{realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("does-not-support-agent-creation"), args2), 127);
            }
            AgentConfiguration.createAgent(adminSSOToken, realm, agentName, agentType, attributeValues);
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-agent-succeeded"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_CREATE_AGENT", params);
        }
        catch (ConfigurationException e) {
            args = new String[]{realm, agentType, agentName, e.getMessage()};
            this.debugError("CreateAgent.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT", args);
            throw new CLIException(e, 127);
        }
        catch (IdRepoException e) {
            args = new String[]{realm, agentType, agentName, e.getMessage()};
            this.debugError("CreateAgent.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            args = new String[]{realm, agentType, agentName, e.getMessage()};
            this.debugError("CreateAgent.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            args = new String[]{realm, agentType, agentName, e.getMessage()};
            this.debugError("CreateAgent.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_CREATE_AGENT", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

