/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.config.AuthConfigurationEntry;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GetAuthConfigurationEntries
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String configName = this.getStringOptionValue("name");
        String[] params = new String[]{realm, configName};
        this.writeLog(0, Level.INFO, "ATTEMPT_GET_AUTH_CONFIG_ENTRIES", params);
        try {
            Map configData = AMAuthConfigUtils.getNamedConfig(configName, realm, adminSSOToken);
            IOutput outputWriter = this.getOutputWriter();
            boolean hasData = false;
            if (configData != null && !configData.isEmpty()) {
                Set tmp = (Set)configData.get("iplanet-am-auth-configuration");
                if (tmp != null && !tmp.isEmpty()) {
                    hasData = true;
                    String xml = (String)tmp.iterator().next();
                    ArrayList entryList = new ArrayList(AMAuthConfigUtils.xmlToAuthConfigurationEntry(xml));
                    outputWriter.printlnMessage(this.getResourceString("authentication-get-auth-config-entries-succeeded"));
                    Iterator i = entryList.iterator();
                    while (i.hasNext()) {
                        AuthConfigurationEntry e = (AuthConfigurationEntry)i.next();
                        String options = e.getOptions();
                        if (options == null) {
                            options = "";
                        }
                        Object[] args = new Object[]{e.getLoginModuleName(), e.getControlFlag(), options};
                        outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("authentication-get-auth-config-entries-entry"), args));
                    }
                }
            } else {
                this.writeLog(0, Level.INFO, "FAILED_GET_AUTH_CONFIG_ENTRIES", params);
                throw new CLIException(this.getResourceString("authentication-get-auth-config-entries-not-found"), 127);
            }
            if (!hasData) {
                outputWriter.printlnMessage(this.getResourceString("authentication-get-auth-config-entries-no-values"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_GET_AUTH_CONFIG_ENTRIES", params);
        }
        catch (AMConfigurationException e) {
            this.debugError("GetAuthConfigurationEntries.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_GET_AUTH_CONFIG_ENTRIES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            this.debugError("GetAuthConfigurationEntries.handleRequest", e);
            this.writeLog(0, Level.INFO, "FAILED_GET_AUTH_CONFIG_ENTRIES", params);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("GetAuthConfigurationEntries.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_GET_AUTH_CONFIG_ENTRIES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

