/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.datastore;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class ListDataStores
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String[] params = new String[]{realm};
        this.writeLog(0, Level.INFO, "ATTEMPT_LIST_DATASTORES", params);
        try {
            Set names;
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", adminSSOToken);
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realm, null);
            Set set = names = cfg != null ? cfg.getSubConfigNames() : Collections.EMPTY_SET;
            if (names != null && !names.isEmpty()) {
                this.getOutputWriter().printlnMessage(this.getResourceString("datastore-list-datastores-succeeded"));
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    this.getOutputWriter().printlnMessage(name);
                }
            } else {
                this.getOutputWriter().printlnMessage(this.getResourceString("datastore-list-datastores-no-entries"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_LIST_DATASTORES", params);
        }
        catch (SMSException e) {
            this.debugError("ListDataStores.handleRequest", e);
            this.writeLog(0, Level.INFO, "FAILED_LIST_DATASTORES", params);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("ListDataStores.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_LIST_DATASTORES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

