/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.datastore;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.List;
import java.util.Map;

public class UpdateDataStore
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String name = this.getStringOptionValue("name");
        String datafile = this.getStringOptionValue("datafile");
        List listValues = rc.getOption("attributevalues");
        if (datafile == null && listValues == null) {
            throw new CLIException(this.getResourceString("datastore-update-datastore-missing-data"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, listValues);
        String[] params = new String[]{realm, name};
        this.writeLog(0, Level.INFO, "ATTEMPT_UPDATE_DATASTORE", params);
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", adminSSOToken);
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realm, null);
            if (cfg != null) {
                ServiceConfig ss = cfg.getSubConfig(name);
                if (ss != null) {
                    ss.setAttributes(attributeValues);
                    this.getOutputWriter().printlnMessage(this.getResourceString("datastore-update-datastore-succeeded"));
                } else {
                    this.getOutputWriter().printlnMessage(this.getResourceString("datastore-update-datastore-not-found"));
                }
            } else {
                this.getOutputWriter().printlnMessage(this.getResourceString("datastore-update-datastore-not-found"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_UPDATE_DATASTORE", params);
        }
        catch (SMSException e) {
            String[] p = new String[]{realm, name, e.getMessage()};
            this.debugError("UpdateDataStore.handleRequest", e);
            this.writeLog(0, Level.INFO, "FAILED_UPDATE_DATASTORE", p);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] p = new String[]{realm, name, e.getMessage()};
            this.debugError("UpdateDataStore.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_UPDATE_DATASTORE", p);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

