/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class RemovePrivileges
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        List privileges = rc.getOption("privileges");
        IdType idType = this.convert2IdType(type);
        String[] params = new String[]{realm, type, idName};
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_IDREPO_REMOVE_PRIVILEGES", params);
            DelegationManager mgr = new DelegationManager(adminSSOToken, realm);
            Set privilegeObjects = mgr.getPrivileges();
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            String uid = amid.getUniversalId();
            Iterator i = privileges.iterator();
            while (i.hasNext()) {
                Set subjects;
                String name = (String)i.next();
                DelegationPrivilege dp = this.getDelegationPrivilege(name, privilegeObjects);
                boolean removed = false;
                if (dp != null && (subjects = dp.getSubjects()).contains(uid)) {
                    subjects.remove(uid);
                    mgr.addPrivilege(dp);
                    removed = true;
                }
                if (removed) continue;
                String[] args = new String[]{idName, name};
                String msg = MessageFormat.format(this.getResourceString("delegation-does-not-have-privilege"), args);
                throw new CLIException(msg, 127);
            }
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("idrepo-remove-privileges-succeed"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_IDREPO_REMOVE_PRIVILEGES", params);
        }
        catch (DelegationException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("RemovePrivileges.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_REMOVE_PRIVILEGES", args);
            throw new CLIException(e, 127);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("RemovePrivileges.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_REMOVE_PRIVILEGES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("RemovePrivileges.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_REMOVE_PRIVILEGES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

