/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.sm.SMSException;
import java.util.logging.Level;

public class CloneServer
extends AuthenticatedCommand {
    private static final String CLONE_NAME = "cloneservername";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String serverName = this.getStringOptionValue("servername");
        String cloneServerName = this.getStringOptionValue(CLONE_NAME);
        String[] params = new String[]{serverName, cloneServerName};
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_CLONE_SERVER", params);
            if (ServerConfiguration.isServerInstanceExist(adminSSOToken, serverName)) {
                if (ServerConfiguration.isServerInstanceExist(adminSSOToken, cloneServerName)) {
                    outputWriter.printlnMessage(this.getResourceString("clone-server-exists"));
                } else {
                    ServerConfiguration.cloneServerInstance(adminSSOToken, serverName, cloneServerName);
                    outputWriter.printlnMessage(this.getResourceString("clone-server-succeeded"));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("clone-server-no-exists"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_CLONE_SERVER", params);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CLONE_SERVER", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_CLONE_SERVER", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CLONE_SERVER", args);
            throw new CLIException(e, 127);
        }
    }
}

