/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import java.io.DataInputStream;
import java.io.IOException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;

public class LDAPUtils {
    private LDAPUtils() {
    }

    public static void createSchemaFromLDIF(String file, LDAPConnection ld) throws IOException, LDAPException {
        LDAPUtils.createSchemaFromLDIF(new LDIF(file), ld);
    }

    public static void createSchemaFromLDIF(DataInputStream stream, LDAPConnection ld) throws IOException, LDAPException {
        LDAPUtils.createSchemaFromLDIF(new LDIF(stream), ld);
    }

    public static void createSchemaFromLDIF(LDIF ldif, LDAPConnection ld) throws IOException, LDAPException {
        LDIFRecord rec = ldif.nextRecord();
        while (rec != null) {
            LDIFContent content = null;
            String DN2 = null;
            try {
                content = rec.getContent();
                DN2 = rec.getDN();
                if (content instanceof LDIFModifyContent) {
                    ld.modify(DN2, ((LDIFModifyContent)content).getModifications());
                } else if (content instanceof LDIFAttributeContent || content instanceof LDIFAddContent) {
                    Object attrSet = null;
                    LDAPAttribute[] attrs = content instanceof LDIFAttributeContent ? ((LDIFAttributeContent)content).getAttributes() : ((LDIFAddContent)content).getAttributes();
                    LDAPEntry amEntry = new LDAPEntry(DN2, new LDAPAttributeSet(attrs));
                    ld.add(amEntry);
                }
            }
            catch (LDAPException e) {
                switch (e.getLDAPResultCode()) {
                    case 20: {
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 68: {
                        LDAPModificationSet modSet = new LDAPModificationSet();
                        LDAPAttribute[] attrs = content instanceof LDIFAttributeContent ? ((LDIFAttributeContent)content).getAttributes() : ((LDIFAddContent)content).getAttributes();
                        for (int i = 0; i < attrs.length; ++i) {
                            modSet.add(0, attrs[i]);
                        }
                        try {
                            ld.modify(DN2, modSet);
                        }
                        catch (LDAPException ex) {}
                        break;
                    }
                }
            }
            rec = ldif.nextRecord();
        }
    }
}

