/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.authentication;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AuthConfigurationEntry;
import com.sun.identity.console.authentication.AuthConfigViewBean;
import com.sun.identity.console.authentication.model.AuthConfigurationModelImpl;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.model.AMModel;
import com.sun.web.ui.model.CCOrderableListModel;
import com.sun.web.ui.model.CCOrderableListModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.orderablelist.CCOrderableList;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.Serializable;
import java.util.ArrayList;

public class ReorderAuthChainsViewBean
extends AMPrimaryMastHeadViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/authentication/ReorderAuthChains.jsp";
    static final String PG_SESSION_TRACKING = "acReorderTrack";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String REORDER_LIST = "reorderList";
    private CCPageTitleModel ptModel;

    public ReorderAuthChainsViewBean() {
        super("ReorderAuthChains");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(REORDER_LIST, CCOrderableList.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        CCPageTitle view = null;
        if (name.equals(PGTITLE_TWO_BTNS)) {
            view = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name);
        } else if (name.equals(REORDER_LIST)) {
            CCOrderableListModel model = new CCOrderableListModel();
            model.setSelectedLabel("authentication.module.config.reorder.label");
            view = new CCOrderableList((ContainerView)this, (CCOrderableListModelInterface)model, name);
        } else {
            view = this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name);
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        CCOrderableList list = (CCOrderableList)this.getChild(REORDER_LIST);
        CCOrderableListModel model = (CCOrderableListModel)list.getModel();
        String xml = (String)this.getPageSessionAttribute("authConfigEntryList");
        ArrayList chains = new ArrayList(AMAuthConfigUtils.xmlToAuthConfigurationEntry(xml));
        OptionList optList = new OptionList();
        int sz = chains.size();
        for (int i = 0; i < sz; ++i) {
            AuthConfigurationEntry entry = (AuthConfigurationEntry)chains.get(i);
            String name = entry.getLoginModuleName();
            String flag = entry.getControlFlag();
            String options = entry.getOptions();
            String displayName = name + " - " + flag;
            if (options != null && options.trim().length() > 0) {
                displayName = displayName + " - " + options;
            }
            optList.add(displayName, Integer.toString(i));
        }
        model.setSelectedOptionList(optList);
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        String xml = (String)this.getPageSessionAttribute("authConfigEntryList");
        ArrayList chains = new ArrayList(AMAuthConfigUtils.xmlToAuthConfigurationEntry(xml));
        ArrayList newChains = new ArrayList();
        CCOrderableList list = (CCOrderableList)this.getChild(REORDER_LIST);
        list.restoreStateData();
        CCOrderableListModel model = (CCOrderableListModel)list.getModel();
        OptionList optList = model.getSelectedOptionList();
        int sz = optList.size();
        for (int i = 0; i < sz; ++i) {
            String idx = optList.getValue(i);
            int num = Integer.parseInt(idx);
            newChains.add(chains.get(num));
        }
        this.setPageSessionAttribute("authConfigEntryList", (Serializable)((Object)AMAuthConfigUtils.authConfigurationEntryToXMLString(newChains)));
        this.forwardToAuthConfigViewBean();
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.forwardToAuthConfigViewBean();
    }

    private void forwardToAuthConfigViewBean() {
        AuthConfigViewBean vb = (AuthConfigViewBean)this.getViewBean(AuthConfigViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.ok");
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        return new AuthConfigurationModelImpl(rc.getRequest(), this.getPageSessionAttributes());
    }
}

