/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.authentication.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMAuthenticationSchema;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.console.authentication.model.AuthPropertiesModel;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AuthPropertiesModelImpl
extends AMModelBase
implements AuthPropertiesModel {
    private static final String CORE_AUTH_SERVICE = "iPlanetAMAuthService";
    private String currentRealm = null;

    public AuthPropertiesModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
        this.currentRealm = (String)map.get("currentRealm");
        if (this.currentRealm == null) {
            this.currentRealm = "/";
        }
    }

    public void setCurrentRealm(String realm) {
        this.currentRealm = realm;
    }

    public Map getValues() throws AMConsoleException {
        String[] params = new String[]{this.currentRealm, CORE_AUTH_SERVICE, "*"};
        this.logEvent("ATTEMPT_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", params);
        Map attrs = null;
        try {
            ServiceConfig config = this.getCoreAuthServiceConfig();
            attrs = config.getAttributes();
            this.logEvent("SUCCEED_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", params);
            if (attrs == null || attrs.isEmpty()) {
                debug.warning("no attributes were returned for Core ...");
            }
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, CORE_AUTH_SERVICE, strError};
            this.logEvent("SMS_EXCEPTION_GET_ATTR_VALUE_OF_SERVICE_UNDER_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
        return attrs == null ? Collections.EMPTY_MAP : attrs;
    }

    public String getServiceName(String instance) {
        String name;
        block5: {
            name = null;
            try {
                AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), this.currentRealm);
                AMAuthenticationInstance inst = mgr.getAuthenticationInstance(instance);
                if (inst != null) {
                    AMAuthenticationSchema schema = mgr.getAuthenticationSchema(inst.getType());
                    name = schema.getServiceName();
                } else if (debug.warningEnabled()) {
                    debug.warning("AuthPropertiesModel.getServiceName,  the requested instance " + instance + " does not exist.");
                }
            }
            catch (AMConfigurationException ace) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("problem getting service name for " + instance, (Throwable)((Object)ace));
            }
        }
        return name;
    }

    public boolean hasAuthAttributes(String type) {
        boolean has = false;
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), this.currentRealm);
            AMAuthenticationSchema schema = mgr.getAuthenticationSchema(type);
            has = !schema.getAttributeSchemas().isEmpty();
        }
        catch (AMConfigurationException e) {
            debug.warning("AuthPropertiesModelImpl.hasAuthAttributes", (Throwable)((Object)e));
        }
        return has;
    }

    public Map getAuthTypes() {
        HashMap<String, String> authAndLocalizedTypes = Collections.EMPTY_MAP;
        try {
            this.logEvent("ATTEMPT_GET_AUTH_TYPE", null);
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), "/");
            Set types = mgr.getAuthenticationTypes();
            authAndLocalizedTypes = new HashMap<String, String>(types.size());
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                String authType = (String)iter.next();
                AMAuthenticationSchema schema = mgr.getAuthenticationSchema(authType);
                String svcName = schema.getServiceName();
                String localizedName = svcName != null && svcName.length() > 0 ? this.getLocalizedServiceName(svcName) : authType;
                authAndLocalizedTypes.put(authType, localizedName);
            }
            this.logEvent("SUCCEED_GET_AUTH_TYPE", null);
        }
        catch (AMConfigurationException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramEx = new String[]{strError};
            this.logEvent("SMS_EXCEPTION_GET_AUTH_TYPE", paramEx);
            debug.warning("AuthPropertiesModelImpl.getAuthTypes", (Throwable)((Object)e));
        }
        return authAndLocalizedTypes;
    }

    public Set getAuthInstances() {
        Set instances = null;
        if (this.currentRealm != null) {
            String[] param = new String[]{this.currentRealm};
            this.logEvent("ATTEMPT_GET_AUTH_INSTANCE", param);
            try {
                AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), this.currentRealm);
                instances = mgr.getAuthenticationInstances();
                this.logEvent("SUCCEED_GET_AUTH_INSTANCE", param);
            }
            catch (AMConfigurationException e) {
                String strError = this.getErrorString((Throwable)((Object)e));
                String[] paramsEx = new String[]{this.currentRealm, strError};
                this.logEvent("AUTH_CONFIG_EXCEPTION_GET_AUTH_INSTANCE", paramsEx);
                debug.warning("AuthPropertiesModelImpl.getAuthInstances", (Throwable)((Object)e));
            }
        }
        return instances == null ? Collections.EMPTY_SET : instances;
    }

    public void removeAuthInstance(Set names) throws AMConsoleException {
        StringBuffer errorList = new StringBuffer();
        String message = null;
        try {
            String[] params = new String[2];
            params[0] = this.currentRealm;
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), this.currentRealm);
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String instance;
                params[1] = instance = (String)i.next();
                this.logEvent("ATTEMPT_REMOVE_AUTH_INSTANCE", params);
                try {
                    mgr.deleteAuthenticationInstance(instance);
                    this.logEvent("SUCCEED_REMOVE_AUTH_INSTANCE", params);
                }
                catch (AMConfigurationException e) {
                    String strError = this.getErrorString((Throwable)((Object)e));
                    String[] paramsEx = new String[]{this.currentRealm, instance, strError};
                    this.logEvent("AUTH_CONFIG_EXCEPTION_REMOVE_AUTH_INSTANCE", paramsEx);
                    debug.warning("failed to delete", (Throwable)((Object)e));
                    message = e.getMessage();
                    if (errorList.length() > 0) {
                        errorList.append(", ");
                    }
                    errorList.append(instance);
                }
            }
        }
        catch (AMConfigurationException ace) {
            String strError = this.getErrorString((Throwable)((Object)ace));
            String[] paramsEx = new String[]{this.currentRealm, "*", strError};
            this.logEvent("AUTH_CONFIG_EXCEPTION_REMOVE_AUTH_INSTANCE", paramsEx);
            debug.error("cant delete auth instance: ", (Throwable)((Object)ace));
            throw new AMConsoleException(strError);
        }
        if (errorList.length() > 0) {
            String[] tmp = new String[]{errorList.toString(), message};
            throw new AMConsoleException(MessageFormat.format(this.getLocalizedString("authentication.instance.delete.failed"), tmp));
        }
    }

    public void createAuthInstance(String name, String type) throws AMConsoleException {
        String[] params = new String[]{this.currentRealm, name, type};
        this.logEvent("ATTEMPT_CREATE_AUTH_INSTANCE", params);
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), this.currentRealm);
            AMAuthenticationSchema as = mgr.getAuthenticationSchema(type);
            mgr.createAuthenticationInstance(name, type, as.getAttributeValues());
            this.logEvent("SUCCEED_CREATE_AUTH_INSTANCE", params);
        }
        catch (AMConfigurationException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, name, type, strError};
            this.logEvent("AUTH_CONFIG_EXCEPTION_CREATE_AUTH_INSTANCE", paramsEx);
            debug.warning("AuthPropertiesModelImpl.createAuthInstance ", (Throwable)((Object)e));
            throw new AMConsoleException(strError);
        }
    }

    public void setValues(Map modifiedValues) throws AMConsoleException {
        String[] params = new String[]{this.currentRealm, CORE_AUTH_SERVICE};
        this.logEvent("ATTEMPT_MODIFY_AUTH_INSTANCE", params);
        try {
            ServiceConfig sc = this.getCoreAuthServiceConfig();
            sc.setAttributes(modifiedValues);
            this.logEvent("SUCCEED_MODIFY_AUTH_INSTANCE", params);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, CORE_AUTH_SERVICE, strError};
            this.logEvent("SMS_EXCEPTION_MODIFY_AUTH_INSTANCE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, CORE_AUTH_SERVICE, strError};
            this.logEvent("SSO_EXCEPTION_MODIFY_AUTH_INSTANCE", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private ServiceConfig getCoreAuthServiceConfig() throws SMSException {
        OrganizationConfigManager scm = new OrganizationConfigManager(this.getUserSSOToken(), this.currentRealm);
        return scm.getServiceConfig(CORE_AUTH_SERVICE);
    }

    public Map getInstanceValues(String name) {
        Map values = null;
        String[] params = new String[]{this.currentRealm, name};
        this.logEvent("ATTEMPT_GET_AUTH_INSTANCE_PROFILE", params);
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), this.currentRealm);
            AMAuthenticationInstance ai = mgr.getAuthenticationInstance(name);
            values = ai.getAttributeValues();
            this.logEvent("SUCCEED_GET_AUTH_INSTANCE_PROFILE", params);
        }
        catch (AMConfigurationException e) {
            String[] paramsEx = new String[]{this.currentRealm, name, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("AUTH_CONFIGURATION_EXCEPTION_GET_AUTH_INSTANCE_PROFILE", paramsEx);
            debug.warning("AuthPropertiesModelImpl.getInstanceValues", (Throwable)((Object)e));
        }
        return values == null ? Collections.EMPTY_MAP : values;
    }

    public void setInstanceValues(String instance, Map values) throws AMConsoleException {
        String[] params = new String[]{this.currentRealm, instance};
        this.logEvent("ATTEMPT_MODIFY_AUTH_INSTANCE_PROFILE", params);
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), this.currentRealm);
            AMAuthenticationInstance ai = mgr.getAuthenticationInstance(instance);
            ai.setAttributeValues(values);
            this.logEvent("SUCCEED_MODIFY_AUTH_INSTANCE_PROFILE", params);
        }
        catch (AMConfigurationException e) {
            debug.warning("AuthPropertiesModelImpl.setInstanceValues", (Throwable)((Object)e));
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, instance, strError};
            this.logEvent("AUTH_CONFIGURATION_EXCEPTION_MODIFY_AUTH_INSTANCE_PROFILE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SMSException e) {
            debug.warning("AuthPropertiesModelImpl.setInstanceValues", (Throwable)e);
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, instance, strError};
            this.logEvent("SMS_EXCEPTION_MODIFY_AUTH_INSTANCE_PROFILE", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            debug.warning("AuthPropertiesModelImpl.setInstanceValues", (Throwable)((Object)e));
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, instance, strError};
            this.logEvent("SSO_EXCEPTION_MODIFY_AUTH_INSTANCE_PROFILE", paramsEx);
            throw new AMConsoleException(strError);
        }
    }
}

