/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.SearchResults;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.StringLengthComparator;
import com.sun.identity.idm.IdType;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import netscape.ldap.util.DN;

public class AMAdminUtils {
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());

    public static final SSOToken getSuperAdminSSOToken() throws SecurityException {
        return adminSSOToken;
    }

    public static Object getValue(Collection collection) {
        return collection == null || collection.isEmpty() ? "" : collection.iterator().next();
    }

    public static int getIntValue(Set set, int defaultValue) throws NumberFormatException {
        int value = defaultValue;
        if (set != null && !set.isEmpty()) {
            String str = (String)set.iterator().next();
            if ((str = str.trim()).length() > 0) {
                value = Integer.parseInt(str);
            }
        }
        return value;
    }

    public static Set wrapInSet(Object obj) {
        HashSet<Object> set = null;
        if (obj != null) {
            set = new HashSet<Object>(2);
            set.add(obj);
        } else {
            set = Collections.EMPTY_SET;
        }
        return set;
    }

    public static Set toSet(Object[] array) {
        HashSet<String> set = null;
        if (array != null && array.length > 0) {
            set = new HashSet<String>(array.length * 2);
            for (int i = 0; i < array.length; ++i) {
                set.add(array[i].toString().trim());
            }
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    public static List toList(Object[] array) {
        ArrayList<String> list = null;
        if (array != null && array.length > 0) {
            list = new ArrayList<String>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i].toString().trim());
            }
        }
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public static int getInt(Set set, int defaultValue) throws NumberFormatException {
        int val = defaultValue;
        if (set != null && !set.isEmpty()) {
            String str = (String)set.iterator().next();
            val = Integer.parseInt(str);
        }
        return val;
    }

    public static void removeMapEntries(Map map, Set set) {
        if (set != null && !set.isEmpty()) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                map.remove(iter.next());
            }
        }
    }

    public static Map upCaseKeys(Map map) {
        HashMap uc = new HashMap(map.size() * 2);
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = ((String)entry.getKey()).toUpperCase();
            uc.put(key, entry.getValue());
        }
        return uc;
    }

    public static int getIntegerAttribute(ServiceSchemaManager svcSchemaMgr, SchemaType type, String attribute) throws NumberFormatException, SMSException {
        int value = -1;
        Set tmp = AMAdminUtils.getAttribute(svcSchemaMgr, type, attribute);
        if (tmp != null && !tmp.isEmpty()) {
            Iterator iter = tmp.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                if (s == null || s.length() <= 0) continue;
                value = Integer.parseInt(s);
            }
        }
        return value;
    }

    public static Set getAttribute(ServiceSchemaManager svcSchemaMgr, SchemaType type, String attribute) throws SMSException {
        AttributeSchema as;
        Set value = null;
        ServiceSchema schema = svcSchemaMgr.getSchema(type);
        if (schema != null && (as = schema.getAttributeSchema(attribute)) != null) {
            value = as.getDefaultValues();
        }
        return value == null ? Collections.EMPTY_SET : value;
    }

    public static String getStringFromInputStream(InputStream is) {
        StringBuffer buff = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line = reader.readLine();
            while (line != null) {
                buff.append(line).append('\n');
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            debug.error("PolicyModelImpl.getStringFromInputStream", (Throwable)e);
        }
        return buff.toString();
    }

    public static InputStream getInputStreamFromString(String buff) {
        return new ByteArrayInputStream(buff.getBytes());
    }

    public static void removeAllCaseIgnore(Set master, Set deletingSet) {
        if (deletingSet != null && !deletingSet.isEmpty()) {
            Set lcSet = AMAdminUtils.lowerCase(deletingSet);
            Iterator iter = master.iterator();
            while (iter.hasNext()) {
                String e = (String)iter.next();
                if (!lcSet.contains(e.toLowerCase())) continue;
                iter.remove();
            }
        }
    }

    public static Set lowerCase(Set set) {
        HashSet<String> lcSet = new HashSet<String>(set.size() * 2);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String e = (String)iter.next();
            lcSet.add(e.toLowerCase());
        }
        return lcSet;
    }

    public static String getParent(String dn) {
        if (dn != null) {
            return new DN(dn).getParent().toString();
        }
        return "";
    }

    public static String getFirstElement(Set set) {
        return set != null && !set.isEmpty() ? (String)set.iterator().next() : "";
    }

    public static String getSearchResultWarningMessage(SearchResults results, AMModel model) {
        String message = null;
        if (results != null) {
            int errorCode = results.getErrorCode();
            if (errorCode == 1) {
                message = model.getLocalizedString("sizeLimitExceeded.message");
            } else if (errorCode == 2) {
                message = model.getLocalizedString("timeLimitExceeded.message");
            }
        }
        return message != null ? message : "";
    }

    public static String getString(Collection collection, String delimiter, boolean reverse) {
        StringBuffer buff = new StringBuffer();
        if (collection != null && !collection.isEmpty()) {
            boolean empty = true;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (!reverse) {
                    if (empty) {
                        empty = false;
                    } else {
                        buff.append(delimiter);
                    }
                    buff.append(i.next().toString());
                    continue;
                }
                buff.insert(0, delimiter).insert(0, i.next().toString());
            }
        }
        return buff.toString();
    }

    public static String getStringAttribute(ServiceSchemaManager svcSchemaMgr, SchemaType type, String attribute) throws SMSException {
        Iterator iter;
        String value = "";
        Set tmp = AMAdminUtils.getAttribute(svcSchemaMgr, type, attribute);
        if (tmp != null && !tmp.isEmpty() && (iter = tmp.iterator()).hasNext()) {
            value = (String)iter.next();
        }
        return value;
    }

    public static String replaceString(String string, String orig, String substitution) {
        int idx = string.indexOf(orig);
        while (idx != -1) {
            string = string.substring(0, idx) + substitution + string.substring(idx + orig.length());
            idx = string.indexOf(orig, idx + substitution.length());
        }
        return string;
    }

    public static List replaceString(List list, String orig, String substitution) {
        ArrayList<String> manipulated = new ArrayList<String>(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String str = (String)iter.next();
            manipulated.add(AMAdminUtils.replaceString(str, orig, substitution));
        }
        return manipulated;
    }

    public static Map getValuesFromDelimitedString(String deString, String delimiter) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(deString, delimiter);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int idx = token.indexOf(61);
            if (idx == -1) continue;
            map.put(token.substring(0, idx), token.substring(idx + 1));
        }
        return map;
    }

    public static Set getDelimitedValues(String deString, String delimiter) {
        HashSet<String> set = new HashSet<String>();
        if (deString != null && deString.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(deString, delimiter);
            while (st.hasMoreTokens()) {
                set.add(st.nextToken().trim());
            }
        }
        return set;
    }

    private static Set getAttributeSchemas(String serviceName, SchemaType schemaType) {
        Set attributeSchemas = null;
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, adminSSOToken);
            ServiceSchema ss = mgr.getSchema(schemaType);
            if (ss != null) {
                attributeSchemas = ss.getAttributeSchemas();
            }
        }
        catch (SSOException e) {
            debug.warning("AMAdminUtils.getAttributeSchemas", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("AMAdminUtils.getAttributeSchemas", (Throwable)e);
        }
        return attributeSchemas != null ? attributeSchemas : Collections.EMPTY_SET;
    }

    public static Set getDisplayableAttributeNames(String serviceName, SchemaType schemaType) {
        HashSet<AttributeSchema> displayable = null;
        Set attributeSchemas = AMAdminUtils.getAttributeSchemas(serviceName, schemaType);
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            displayable = new HashSet<AttributeSchema>(attributeSchemas.size() * 2);
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext()) {
                AttributeSchema as = (AttributeSchema)i.next();
                String i18nKey = as.getI18NKey();
                if (i18nKey == null || i18nKey.trim().length() <= 0) continue;
                displayable.add(as);
            }
        }
        return displayable != null ? displayable : Collections.EMPTY_SET;
    }

    public static ServiceSchema getSchemaSchema(String serviceName, IdType idType) {
        ServiceSchema serviceSchema = null;
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, adminSSOToken);
            serviceSchema = mgr.getSchema(idType.getName());
        }
        catch (SSOException e) {
            debug.warning("AMAdminUtils.getAttributeSchemas", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("AMAdminUtils.getAttributeSchemas", (Throwable)e);
        }
        return serviceSchema;
    }

    public static void makeMapValuesEmpty(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            entry.setValue(Collections.EMPTY_SET);
        }
    }

    public static List toList(OptionList optList) {
        Option[] options;
        ArrayList<String> list = new ArrayList<String>();
        if (optList != null && (options = optList.toOptionArray()) != null && options.length > 0) {
            for (int i = 0; i < options.length; ++i) {
                list.add(options[i].getValue());
            }
        }
        return list;
    }

    public static List orderByStringLength(Collection collection) {
        ArrayList ordered = new ArrayList(collection);
        Collections.sort(ordered, new StringLengthComparator());
        return ordered;
    }

    public static Map cloneStringToSetMap(Map orig) {
        HashMap cloned = null;
        if (orig != null) {
            cloned = new HashMap(orig.size() * 2);
            Iterator i = orig.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Set values = (Set)orig.get(key);
                HashSet<String> cloneValues = null;
                if (values != null) {
                    cloneValues = new HashSet<String>(values.size() * 2);
                    Iterator j = values.iterator();
                    while (j.hasNext()) {
                        String val = (String)j.next();
                        cloneValues.add(val);
                    }
                }
                cloned.put(key, cloneValues);
            }
        }
        return cloned;
    }

    public static void removeAllByDN(Set originalSet, Collection toDelete) {
        Set setDNs = AMAdminUtils.toDNs(toDelete);
        Iterator iter = originalSet.iterator();
        while (iter.hasNext()) {
            String strDN = (String)iter.next();
            DN dn = new DN(strDN.toLowerCase());
            if (!AMAdminUtils.containsDN(setDNs, dn)) continue;
            iter.remove();
        }
    }

    private static Set toDNs(Collection set) {
        HashSet<DN> setDNs = new HashSet<DN>();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            String strDN = (String)i.next();
            DN dn = new DN(strDN.toLowerCase());
            setDNs.add(dn);
        }
        return setDNs;
    }

    private static boolean containsDN(Set set, DN dn) {
        boolean contain = false;
        Iterator i = set.iterator();
        while (i.hasNext() && !contain) {
            DN d = (DN)i.next();
            contain = d.equals(dn);
        }
        return contain;
    }

    public static Set getUserAttributeNames() {
        TreeSet<String> userAttributeNames = new TreeSet<String>();
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager("iPlanetAMUserService", token);
            ServiceSchema ss = mgr.getSchema(SchemaType.USER);
            Set attributeSchemas = ss.getAttributeSchemas();
            if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
                Iterator i = attributeSchemas.iterator();
                while (i.hasNext()) {
                    AttributeSchema.Type type;
                    AttributeSchema as = (AttributeSchema)i.next();
                    String i18nKey = as.getI18NKey();
                    if (i18nKey == null || i18nKey.length() <= 0 || !(type = as.getType()).equals(AttributeSchema.Type.SINGLE)) continue;
                    AttributeSchema.UIType uiType = as.getUIType();
                    AttributeSchema.Syntax syntax = as.getSyntax();
                    if (uiType != null || syntax.equals(AttributeSchema.Syntax.PASSWORD)) continue;
                    userAttributeNames.add(as.getName());
                }
            }
        }
        catch (SSOException e) {
            debug.error("AMAdminUtil.getUserAttributeNames", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("AMAdminUtil.getUserAttributeNames", (Throwable)e);
        }
        return userAttributeNames;
    }
}

