/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.delegation;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.delegation.DelegationViewBean;
import com.sun.identity.console.delegation.model.DelegationModel;
import com.sun.identity.console.delegation.model.DelegationModelImpl;
import com.sun.identity.console.property.PrivilegeXMLBuilder;
import com.sun.identity.console.realm.RealmPropertiesBase;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DelegationPropertiesViewBean
extends RealmPropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/delegation/DelegationProperties.jsp";
    public static final String CURRENT_IDENTITY = "currentIdentity";
    private AMPropertySheetModel psModel;
    private CCPageTitleModel ptModel;
    private static final String PAGETITLE = "pgtitle";
    protected static final String DELEGATION_PROPERTIES = "DelegationProperties";
    private boolean submitCycle;
    private boolean hasPrivileges;

    public DelegationPropertiesViewBean() {
        super(DELEGATION_PROPERTIES);
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String curRealm;
        if (!this.initialized && (curRealm = (String)this.getPageSessionAttribute("currentRealm")) != null) {
            super.initialize();
            this.initialized = true;
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        this.registerChild(DELEGATION_PROPERTIES, AMPropertySheet.class);
        this.psModel.registerChildren((ContainerViewBase)this);
        this.ptModel.registerChildren((ContainerViewBase)this);
        super.registerChildren();
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(DELEGATION_PROPERTIES) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.psModel, name) : (this.psModel.isChildSupported(name) ? this.psModel.createChild((View)this, name, this.getModel()) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        DelegationModel model = (DelegationModel)this.getModel();
        if (model != null) {
            if (!this.submitCycle && this.hasPrivileges) {
                AMPropertySheet ps = (AMPropertySheet)this.getChild(DELEGATION_PROPERTIES);
                this.psModel.clear();
                ps.setAttributeValues(this.getPrivileges(model), model);
            }
            this.setPageTitle(model);
        }
        if (!this.hasPrivileges) {
            this.disableButton("button1", true);
            this.disableButton("button2", true);
        }
    }

    private Map getPrivileges(DelegationModel model) {
        HashMap map = null;
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        String uid = (String)this.getPageSessionAttribute(CURRENT_IDENTITY);
        try {
            Set privileges = model.getPrivileges(curRealm, uid);
            if (privileges != null && !privileges.isEmpty()) {
                map = new HashMap(privileges.size() * 2);
                Iterator iter = privileges.iterator();
                while (iter.hasNext()) {
                    DelegationPrivilege p = (DelegationPrivilege)iter.next();
                    HashSet<String> val = new HashSet<String>(2);
                    val.add(Boolean.TRUE.toString());
                    map.put(p.getName(), val);
                }
            }
        }
        catch (AMConsoleException a) {
            this.setInlineAlertMessage("warning", "message.warning", "nopermissions.message");
        }
        return map == null ? Collections.EMPTY_MAP : map;
    }

    private void setPageTitle(DelegationModel model) {
        String[] tmp = new String[]{this.getDisplayName()};
        this.ptModel.setPageTitleText(MessageFormat.format(model.getLocalizedString("page.title.realms.properties"), tmp));
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new DelegationModelImpl(req, this.getPageSessionAttributes());
    }

    private void createPropertyModel() {
        String curRealm;
        PrivilegeXMLBuilder builder = PrivilegeXMLBuilder.getInstance();
        String xml = builder.getXML(curRealm = (String)this.getPageSessionAttribute("currentRealm"), this.getModel());
        if (xml.length() > 0) {
            this.psModel = new AMPropertySheetModel(xml);
            this.psModel.clear();
            this.hasPrivileges = true;
        } else {
            this.psModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyBlank.xml"));
            this.setInlineAlertMessage("info", "message.information", "delegation.no.privileges");
        }
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        DelegationModel model = (DelegationModel)this.getModel();
        String uid = (String)this.getPageSessionAttribute(CURRENT_IDENTITY);
        AMPropertySheet ps = (AMPropertySheet)this.getChild(DELEGATION_PROPERTIES);
        String realm = (String)this.getPageSessionAttribute("currentRealm");
        try {
            PrivilegeXMLBuilder builder = PrivilegeXMLBuilder.getInstance();
            Set privileges = builder.getAllPrivileges(realm, model);
            Map values = ps.getAttributeValues(privileges);
            model.setPrivileges(realm, uid, values);
            this.setInlineAlertMessage("info", "message.information", "delegation.privilege.updated");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        DelegationViewBean vb = (DelegationViewBean)this.getViewBean(DelegationViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBackButtonLabel() {
        String[] arg = new String[]{this.getModel().getLocalizedString("table.delegation.summary")};
        return MessageFormat.format(this.getModel().getLocalizedString("back.button"), arg);
    }

    protected String getBreadCrumbDisplayName() {
        String message = "breadcrumbs.realm.pivilege.editPrivilege";
        DelegationModel model = (DelegationModel)this.getModel();
        String[] tmp = new String[]{this.getDisplayName()};
        return MessageFormat.format(model.getLocalizedString(message), tmp);
    }

    protected boolean startPageTrail() {
        return false;
    }

    private String getDisplayName() {
        String displayName = "";
        DelegationModel model = (DelegationModel)this.getModel();
        String uid = (String)this.getPageSessionAttribute(CURRENT_IDENTITY);
        try {
            AMIdentity entity = IdUtils.getIdentity(model.getUserSSOToken(), uid);
            displayName = AMFormatUtils.getIdentityDisplayName((AMModel)model, entity);
        }
        catch (IdRepoException e) {
            this.setInlineAlertMessage("error", "message.error", model.getErrorString(e));
        }
        return displayName;
    }
}

