/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.CloseWindowViewBean;
import com.sun.identity.console.base.MessageViewBean;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.service.MAPCreateDeviceViewBean;
import com.sun.identity.console.service.MAPDeviceProfileViewBean;
import com.sun.identity.console.service.MAPDuplicationDeviceViewBean;
import com.sun.identity.console.service.model.MAPServiceModel;
import com.sun.identity.console.service.model.MAPServiceModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCTabsModel;
import com.sun.web.ui.model.CCTabsModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.masthead.CCSecondaryMasthead;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import com.sun.web.ui.view.tabs.CCNodeEventHandlerInterface;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MAPClientManagerViewBean
extends AMViewBeanBase
implements CCNodeEventHandlerInterface {
    public static final String DEFAULT_DISPLAY_URL = "/console/service/MAPClientManager.jsp";
    static final String PAGE_SESSION_PROFILE_NAME = "pgSessionProfileName";
    static final String PAGE_SESSION_STYLE_NAME = "pgSessionStyleName";
    private static final String SEC_MH_COMMON = "secMhCommon";
    private static final String TAB_CLIENT_DETECTION = "tabClientDetection";
    private static final String PGTITLE = "pgtitle";
    private static final String TF_FILTER = "tfFilter";
    private static final String BTN_SEARCH = "btnSearch";
    private static final String TBL_CLIENTS = "tblClients";
    private static final String TBL_BUTTON_ADD = "tblButtonAdd";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_NAME = "tblDataName";
    private static final String TBL_CUSTOMIZABLE = "tblCustomizable";
    private static final String TBL_COL_ACTION = "tblColAction";
    private static final String TBL_DATA_ACTION_HREF = "tblDataActionHref";
    private static final String TBL_DATA_ACTION_LABEL = "tblDataActionLabel";
    private static final String TBL_DATA_ACTION_DUPLICATE_HREF = "tblDataActionDuplicateHref";
    private static final String TBL_DATA_ACTION_DUPLICATE_LABEL = "tblDataActionDuplicateLabel";
    private static final String TBL_DATA_ACTION_DELETE_HREF = "tblDataActionDeleteHref";
    private static final String TBL_DATA_ACTION_DELETE_LABEL = "tblDataActionDeleteLabel";
    private static final String TBL_DATA_ACTION_DEFAULT_HREF = "tblDataActionDefaultHref";
    private static final String TBL_DATA_ACTION_DEFAULT_LABEL = "tblDataActionDefaultLabel";
    private static final String SINGLECHOICE_STYLE = "singleChoiceStyle";
    private CCActionTableModel tblModel = null;
    private CCPageTitleModel ptModel;

    public MAPClientManagerViewBean() {
        super("MAPClientManager");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createTableModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(TAB_CLIENT_DETECTION, CCTabs.class);
        this.registerChild(PGTITLE, CCPageTitle.class);
        this.registerChild(SEC_MH_COMMON, CCSecondaryMasthead.class);
        this.registerChild(TF_FILTER, CCTextField.class);
        this.registerChild(BTN_SEARCH, CCButton.class);
        this.registerChild(TBL_CLIENTS, CCActionTable.class);
        this.registerChild(SINGLECHOICE_STYLE, CCDropDownMenu.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(TBL_CLIENTS) ? new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name) : (name.equals(TAB_CLIENT_DETECTION) ? this.createTab(name) : (name.equals(SEC_MH_COMMON) ? new CCSecondaryMasthead((ContainerView)this, name) : (name.equals(PGTITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : super.createChild(name))))));
        return view;
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.close");
        this.ptModel.setPageTitleText("map.client.manager.window.title");
    }

    private View createTab(String name) {
        CCTabsModel tabModel = new CCTabsModel();
        MAPServiceModel model = (MAPServiceModel)((Object)this.getModel());
        Set profileNames = model.getProfileNames();
        if (profileNames != null && !profileNames.isEmpty()) {
            Iterator iter = profileNames.iterator();
            while (iter.hasNext()) {
                String val = (String)iter.next();
                tabModel.addNode((CCNavNodeInterface)new CCNavNode(val.hashCode(), val, val, val));
            }
            tabModel.setSelectedNode(this.getProfileName().hashCode());
        }
        return new CCTabs((View)this, (CCTabsModelInterface)tabModel, name);
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblMAPClientDetection.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setMaxRows(this.getModel().getPageSize());
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.clientDetection.client.column.name");
        this.tblModel.setActionValue(TBL_COL_ACTION, (Object)"table.clientDetection.action.column.name");
        this.tblModel.setActionValue(TBL_BUTTON_ADD, (Object)"clientDetection.newDevice.button");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.setStyles();
        this.populateTableModel();
    }

    private void setStyles() {
        MAPServiceModel model = (MAPServiceModel)((Object)this.getModel());
        Set styles = model.getStyleNames(this.getProfileName());
        if (styles != null && !styles.isEmpty()) {
            OptionList styleList = new OptionList();
            Iterator iter = styles.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                styleList.add(name, name);
            }
            CCDropDownMenu menu = (CCDropDownMenu)this.getChild(SINGLECHOICE_STYLE);
            menu.setOptions(styleList);
        }
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new MAPServiceModelImpl(req, this.getPageSessionAttributes());
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        String profileName = this.getProfileName(nodeID);
        this.setPageSessionAttribute(PAGE_SESSION_PROFILE_NAME, (Serializable)((Object)profileName));
        this.removePageSessionAttribute(PAGE_SESSION_STYLE_NAME);
        this.setDisplayFieldValue(SINGLECHOICE_STYLE, "");
        this.forwardTo();
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleTblButtonAddRequest(RequestInvocationEvent event) {
        MAPCreateDeviceViewBean vb = (MAPCreateDeviceViewBean)this.getViewBean(MAPCreateDeviceViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblDataActionHrefRequest(RequestInvocationEvent event) {
        String name = (String)this.getDisplayFieldValue(TBL_DATA_ACTION_HREF);
        MAPDeviceProfileViewBean vb = (MAPDeviceProfileViewBean)this.getViewBean(MAPDeviceProfileViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.deviceName = name;
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblDataActionDefaultHrefRequest(RequestInvocationEvent event) {
        String name = (String)this.getDisplayFieldValue(TBL_DATA_ACTION_DEFAULT_HREF);
        this.deleteDevice(name, "clientDetection.client.defaulted.message");
        this.forwardTo();
    }

    public void handleTblDataActionDeleteHrefRequest(RequestInvocationEvent event) {
        String name = (String)this.getDisplayFieldValue(TBL_DATA_ACTION_DELETE_HREF);
        this.deleteDevice(name, "clientDetection.client.deleted.message");
        this.forwardTo();
    }

    private void deleteDevice(String deviceName, String message) {
        MAPServiceModel model = (MAPServiceModel)((Object)this.getModel());
        try {
            model.removeClient(deviceName);
            this.setInlineAlertMessage("info", "message.information", message);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleTblDataActionDuplicateHrefRequest(RequestInvocationEvent event) {
        String name = (String)this.getDisplayFieldValue(TBL_DATA_ACTION_DUPLICATE_HREF);
        MAPServiceModel model = (MAPServiceModel)((Object)this.getModel());
        MAPDuplicationDeviceViewBean vb = (MAPDuplicationDeviceViewBean)this.getViewBean(MAPDuplicationDeviceViewBean.class);
        vb.clientType = model.getClientTypePrefix() + name;
        vb.deviceName = model.getDeviceNamePrefix() + model.getDeviceUserAgent(name);
        vb.setDisplayFieldValue("tfOrigClientType", name);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    private String getProfileName(int nodeID) {
        MAPServiceModel model = (MAPServiceModel)((Object)this.getModel());
        Set profileNames = model.getProfileNames();
        String profileName = null;
        if (profileNames != null && !profileNames.isEmpty()) {
            Iterator iter = profileNames.iterator();
            while (iter.hasNext() && profileName == null) {
                String val = (String)iter.next();
                if (val.hashCode() != nodeID) continue;
                profileName = val;
            }
        }
        return profileName;
    }

    private String getBaseStyle() {
        String baseId = (String)this.getDisplayFieldValue(SINGLECHOICE_STYLE);
        if (baseId == null || baseId.trim().length() == 0) {
            baseId = (String)this.getPageSessionAttribute(PAGE_SESSION_STYLE_NAME);
            if (baseId == null || baseId.trim().length() == 0) {
                baseId = this.getProfileName();
            }
            this.setDisplayFieldValue(SINGLECHOICE_STYLE, baseId);
        }
        this.setPageSessionAttribute(PAGE_SESSION_STYLE_NAME, (Serializable)((Object)baseId));
        return baseId;
    }

    private String getProfileName() {
        String name = (String)this.getPageSessionAttribute(PAGE_SESSION_PROFILE_NAME);
        if (name == null || name.trim().length() == 0) {
            name = "HDML";
        }
        this.setPageSessionAttribute(PAGE_SESSION_PROFILE_NAME, (Serializable)((Object)name));
        return name;
    }

    private void populateTableModel() {
        this.tblModel.clearAll();
        boolean first = true;
        String filter = (String)this.getDisplayFieldValue(TF_FILTER);
        MAPServiceModel model = (MAPServiceModel)((Object)this.getModel());
        Set devices = model.getDeviceNames(this.getProfileName(), this.getBaseStyle(), filter);
        if (devices != null && !devices.isEmpty()) {
            Iterator iter = devices.iterator();
            while (iter.hasNext()) {
                if (!first) {
                    this.tblModel.appendRow();
                } else {
                    first = false;
                }
                String name = (String)iter.next();
                this.tblModel.setValue(TBL_DATA_NAME, (Object)name);
                this.tblModel.setValue(TBL_DATA_ACTION_HREF, (Object)name);
                this.tblModel.setValue(TBL_DATA_ACTION_DEFAULT_HREF, (Object)name);
                this.tblModel.setValue(TBL_DATA_ACTION_DUPLICATE_HREF, (Object)name);
                this.tblModel.setValue(TBL_DATA_ACTION_DELETE_HREF, (Object)name);
                this.tblModel.setValue(TBL_DATA_ACTION_LABEL, (Object)"clientDetection.edit.hyperlink.label");
                this.tblModel.setValue(TBL_DATA_ACTION_DUPLICATE_LABEL, (Object)"clientDetection.duplicate.hyperlink.label");
                if (model.isCustomizable(name)) {
                    this.tblModel.setValue(TBL_CUSTOMIZABLE, (Object)"clientDetection.customizable.label");
                } else {
                    this.tblModel.setValue(TBL_CUSTOMIZABLE, (Object)"");
                }
                if (model.hasDefaultSetting(name)) {
                    this.tblModel.setValue(TBL_DATA_ACTION_DEFAULT_LABEL, (Object)"clientDetection.default.hyperlink.label");
                } else {
                    this.tblModel.setValue(TBL_DATA_ACTION_DEFAULT_LABEL, (Object)"");
                }
                if (model.canBeDeleted(name)) {
                    this.tblModel.setValue(TBL_DATA_ACTION_DELETE_LABEL, (Object)"clientDetection.delete.hyperlink.label");
                    continue;
                }
                this.tblModel.setValue(TBL_DATA_ACTION_DELETE_LABEL, (Object)"");
            }
        }
    }

    public String endTblDataActionDefaultHrefDisplay(ChildContentDisplayEvent event) {
        String lbl = (String)this.tblModel.getValue(TBL_DATA_ACTION_DEFAULT_LABEL);
        return lbl != null && lbl.length() > 0 ? event.getContent() : "";
    }

    public String endTblDataActionDeleteHrefDisplay(ChildContentDisplayEvent event) {
        String lbl = (String)this.tblModel.getValue(TBL_DATA_ACTION_DELETE_LABEL);
        return lbl != null && lbl.length() > 0 ? event.getContent() : "";
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        CloseWindowViewBean vb = (CloseWindowViewBean)this.getViewBean(CloseWindowViewBean.class);
        vb.forwardTo(this.getRequestContext());
    }

    public void forwardTo(RequestContext reqContext) throws NavigationException {
        MAPServiceModel model = (MAPServiceModel)((Object)this.getModel());
        Set profileNames = model.getProfileNames();
        if (profileNames == null || profileNames.isEmpty()) {
            MessageViewBean vb = (MessageViewBean)this.getViewBean(MessageViewBean.class);
            vb.setMessage("info", "message.information", "map.no.profiles");
            vb.forwardTo(reqContext);
        } else {
            super.forwardTo(reqContext);
        }
    }
}

