/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.internal;

import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.SendNotificationException;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Hash;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public class AgentsRepo
extends IdRepo
implements ServiceListener {
    public static final String NAME = "com.sun.identity.idm.plugins.internal.AgentsRepo";
    private static final String statusAttribute = "sunIdentityServerDeviceStatus";
    private static final String statusActive = "Active";
    private static final String statusInactive = "Inactive";
    private static final String version = "1.0";
    private static final String comma = ",";
    private static final String agentserviceName = "AgentService";
    private static final String agentGroupNode = "agentgroup";
    private static final String instancesNode = "ou=Instances,";
    private static final String labeledURI = "labeledURI";
    private static final String hashAlgStr = "{SHA-1}";
    IdRepoListener repoListener;
    Debug debug;
    private String realmName;
    private Map supportedOps;
    private static ServiceSchemaManager ssm = null;
    private static ServiceConfigManager scm = null;
    ServiceConfig orgConfig;
    ServiceConfig agentGroupConfig;
    String ssmListenerId;
    String scmListenerId;
    private static String notificationURLname = "com.sun.identity.client.notification.url";
    private static String notificationURLenabled = "com.sun.identity.agents.config.change.notification.enable";
    public static final String AGENT_CONFIG_SERVICE = "agentconfig";
    static final String AGENT_NOTIFICATION = "AgentConfigChangeNotification";
    static final String AGENT_ID = "agentName";
    static final String AGENT_IDTYPE = "IdType";
    IdRepoException initializationException;

    public AgentsRepo() {
        block8: {
            this.repoListener = null;
            this.debug = Debug.getInstance((String)"amAgentsRepo");
            this.supportedOps = new HashMap();
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (this.debug.messageEnabled()) {
                this.debug.message(": AgentsRepo adding Listener");
            }
            try {
                ssm = new ServiceSchemaManager(adminToken, agentserviceName, version);
                scm = new ServiceConfigManager(adminToken, agentserviceName, version);
                if (ssm != null) {
                    this.ssmListenerId = ssm.addListener(this);
                }
                if (scm != null) {
                    this.scmListenerId = scm.addListener(this);
                }
            }
            catch (SMSException smse) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("AgentsRepo.AgentsRepo: Unable to init ssm and scm due to " + smse);
                }
            }
            catch (SSOException ssoe) {
                if (!this.debug.warningEnabled()) break block8;
                this.debug.warning("AgentsRepo.AgentsRepo: Unable to init ssm and scm due to " + (Object)((Object)ssoe));
            }
        }
        this.loadSupportedOps();
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo invoked");
        }
    }

    public int addListener(SSOToken token, IdRepoListener listener) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.addListener().");
        }
        this.repoListener = listener;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String create(SSOToken token, IdType type, String agentName, Map attrMap) throws IdRepoException, SSOException {
        ServiceConfig aTypeConfig;
        String agentType;
        block16: {
            if (agentName.startsWith("\"")) {
                agentName = "\\" + agentName;
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("AgentsRepo.create() called: " + type + ": " + agentName);
            }
            if (this.initializationException != null) {
                this.debug.error("AgentsRepo.create: Realm " + this.realmName + " does not exist.");
                throw this.initializationException;
            }
            if (attrMap == null || attrMap.isEmpty()) {
                if (!this.debug.messageEnabled()) throw new IdRepoException("amIdRepo", "201", null);
                this.debug.message("AgentsRepo.create(): Attribute Map is empty ");
                throw new IdRepoException("amIdRepo", "201", null);
            }
            agentType = null;
            aTypeConfig = null;
            if (attrMap != null && !attrMap.isEmpty()) {
                if (attrMap.keySet().contains("AgentType")) {
                    HashSet aTypeSet = (HashSet)attrMap.get("AgentType");
                    if (aTypeSet != null && !aTypeSet.isEmpty()) {
                        agentType = (String)aTypeSet.iterator().next();
                        attrMap.remove("AgentType");
                        break block16;
                    } else {
                        this.debug.error("AgentsRepo.create():Unable to create agents. Agent Type " + aTypeSet + " is empty");
                        throw new IdRepoException("amIdRepo", "201", null);
                    }
                }
                if (!type.equals(IdType.AGENTONLY)) {
                    this.debug.error("AgentsRepo.create():Unable to create agents. Agent Type " + agentType + " is empty");
                    throw new IdRepoException("amIdRepo", "201", null);
                }
                agentType = "2.2_Agent";
            }
        }
        try {
            Object[] args;
            Set vals = (Set)attrMap.get("userpassword");
            if (vals != null) {
                HashSet<String> hashedVals = new HashSet<String>();
                Iterator it = vals.iterator();
                while (it.hasNext()) {
                    String val = (String)it.next();
                    hashedVals.add(hashAlgStr + Hash.hash((String)val));
                }
                attrMap.remove("userpassword");
                attrMap.put("userpassword", hashedVals);
            }
            if (type.equals(IdType.AGENTONLY) || type.equals(IdType.AGENT)) {
                this.orgConfig = this.getOrgConfig(token);
                if (!this.orgConfig.getSubConfigNames().contains(agentName)) {
                    this.orgConfig.addSubConfig(agentName, agentType, 0, attrMap);
                    aTypeConfig = this.orgConfig.getSubConfig(agentName);
                    return aTypeConfig.getDN();
                }
                args = new Object[]{agentName, type};
                throw new IdRepoException("amIdRepo", "224", args);
            }
            if (!type.equals(IdType.AGENTGROUP)) return aTypeConfig.getDN();
            this.agentGroupConfig = this.getAgentGroupConfig(token);
            if (!this.agentGroupConfig.getSubConfigNames().contains(agentName)) {
                this.agentGroupConfig.addSubConfig(agentName, agentType, 0, attrMap);
                aTypeConfig = this.agentGroupConfig.getSubConfig(agentName);
                return aTypeConfig.getDN();
            }
            args = new Object[]{agentName, type};
            throw new IdRepoException("amIdRepo", "224", args);
        }
        catch (SMSException smse) {
            this.debug.error("AgentsRepo.create():Unable to create agents ", (Throwable)smse);
            Object[] args = new Object[]{NAME};
            throw new IdRepoException("amIdRepo", "226", args);
        }
    }

    public void delete(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        block8: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AgentsRepo.delete() called: " + type + ": " + name);
            }
            if (this.initializationException != null) {
                this.debug.error("AgentsRepo.delete: Realm " + this.realmName + " does not exist.");
                throw this.initializationException;
            }
            ServiceConfig aCfg = null;
            try {
                if (type.equals(IdType.AGENTONLY) || type.equals(IdType.AGENT)) {
                    this.orgConfig = this.getOrgConfig(token);
                    aCfg = this.orgConfig.getSubConfig(name);
                    if (aCfg != null) {
                        this.orgConfig.removeSubConfig(name);
                        break block8;
                    }
                    Object[] args = new Object[]{name, type};
                    throw new IdRepoException("amIdRepo", "223", args);
                }
                if (!type.equals(IdType.AGENTGROUP)) break block8;
                this.agentGroupConfig = this.getAgentGroupConfig(token);
                aCfg = this.agentGroupConfig.getSubConfig(name);
                if (aCfg != null) {
                    Set members = this.getMembers(token, type, name, IdType.AGENTONLY);
                    Iterator it = members.iterator();
                    ServiceConfig memberCfg = null;
                    while (it.hasNext()) {
                        String agent = (String)it.next();
                        memberCfg = this.orgConfig.getSubConfig(agent);
                        if (memberCfg == null) continue;
                        memberCfg.setLabeledUri("");
                    }
                    this.agentGroupConfig.removeSubConfig(name);
                    break block8;
                }
                Object[] args = new Object[]{name, type};
                throw new IdRepoException("amIdRepo", "223", args);
            }
            catch (SMSException smse) {
                this.debug.error("AgentsRepo.delete: Unable to delete agents ", (Throwable)smse);
                Object[] args = new Object[]{NAME};
                throw new IdRepoException("amIdRepo", "200", args);
            }
        }
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.getAttributes() with attrNames called: " + type + ": " + name);
        }
        if (this.initializationException != null) {
            this.debug.error("AgentsRepo.getAttributes: Realm " + this.realmName + " does not exist.");
            throw this.initializationException;
        }
        CaseInsensitiveHashMap allAtt = new CaseInsensitiveHashMap(this.getAttributes(token, type, name));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Iterator it = attrNames.iterator();
        while (it.hasNext()) {
            String attrName = (String)it.next();
            if (!allAtt.containsKey(attrName)) continue;
            resultMap.put(attrName, allAtt.get(attrName));
        }
        return resultMap;
    }

    public Map getAttributes(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.getAttributes() called: " + type + ": " + name);
        }
        if (this.initializationException != null) {
            this.debug.error("AgentsRepo.getAttributes: Realm " + this.realmName + " does not exist.");
            throw this.initializationException;
        }
        if (type.equals(IdType.AGENT) || type.equals(IdType.AGENTONLY) || type.equals(IdType.AGENTGROUP)) {
            Map agentsAttrMap = new HashMap(2);
            try {
                if (type.equals(IdType.AGENTONLY)) {
                    this.orgConfig = this.getOrgConfig(token);
                    agentsAttrMap = this.getAgentAttrs(this.orgConfig, name);
                } else if (type.equals(IdType.AGENTGROUP)) {
                    this.agentGroupConfig = this.getAgentGroupConfig(token);
                    agentsAttrMap = this.getAgentAttrs(this.agentGroupConfig, name);
                } else if (type.equals(IdType.AGENT)) {
                    this.orgConfig = this.getOrgConfig(token);
                    agentsAttrMap = this.getAgentAttrs(this.orgConfig, name);
                    String groupName = this.getGroupName(this.orgConfig, name);
                    if (groupName != null && groupName.trim().length() > 0) {
                        this.agentGroupConfig = this.getAgentGroupConfig(token);
                        Map agentGroupMap = this.getAgentAttrs(this.agentGroupConfig, groupName);
                        if (agentsAttrMap != null && agentGroupMap != null) {
                            agentGroupMap.putAll(agentsAttrMap);
                            agentsAttrMap = agentGroupMap;
                        }
                    }
                }
                return agentsAttrMap;
            }
            catch (SMSException e) {
                this.debug.error("AgentsRepo.getAttributes(): Unable to read agent attributes ", (Throwable)e);
                Object[] args = new Object[]{NAME};
                throw new IdRepoException("amIdRepo", "200", args);
            }
            catch (IdRepoException idpe) {
                this.debug.error("AgentsRepo.getAttributes(): Unable to read agent attributes ", (Throwable)idpe);
                Object[] args = new Object[]{NAME};
                throw new IdRepoException("amIdRepo", "200", args);
            }
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    private Map getAgentAttrs(ServiceConfig svcConfig, String agentName) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.getAgentAttrs() called: " + agentName);
        }
        Map answer = new HashMap(2);
        try {
            ServiceConfig aCfg = svcConfig.getSubConfig(agentName);
            if (aCfg != null) {
                answer = aCfg.getAttributesWithoutDefaults();
                HashSet<String> vals = new HashSet<String>(2);
                vals.add(aCfg.getSchemaID());
                answer.put("AgentType", vals);
            }
        }
        catch (SMSException sme) {
            this.debug.error("AgentsRepo.getAgentAttrs(): Error occurred while getting " + agentName, (Throwable)sme);
            throw new IdRepoException(sme.getMessage());
        }
        return answer;
    }

    public Map getBinaryAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void setBinaryAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.EDIT.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.getMembers called" + type + ": " + name + ": " + membersType);
        }
        if (this.initializationException != null) {
            this.debug.error("AgentsRepo.getMembers: Realm " + this.realmName + " does not exist.");
            throw this.initializationException;
        }
        HashSet<String> results = new HashSet<String>();
        if (type.equals(IdType.USER) || type.equals(IdType.AGENT)) {
            this.debug.error("AgentsRepo.getMembers: Membership operation is not supported for Users or Agents");
            throw new IdRepoException("amIdRepo", "203", null);
        }
        if (!membersType.equals(IdType.AGENTONLY) && !membersType.equals(IdType.AGENT)) {
            this.debug.error("AgentsRepo.getMembers: Cannot get member from a non-agent type " + membersType.getName());
            Object[] args = new Object[]{NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        if (type.equals(IdType.AGENTGROUP)) {
            try {
                this.orgConfig = this.getOrgConfig(token);
                Iterator items = this.orgConfig.getSubConfigNames().iterator();
                while (items.hasNext()) {
                    String lUri;
                    String agent = (String)items.next();
                    ServiceConfig aCfg = null;
                    aCfg = this.orgConfig.getSubConfig(agent);
                    if (aCfg == null || (lUri = aCfg.getLabeledUri()) == null || !lUri.equalsIgnoreCase(name)) continue;
                    results.add(agent);
                }
            }
            catch (SMSException sme) {
                this.debug.error("AgentsRepo.getMembers: Caught exception while getting agents from groups", (Throwable)sme);
                Object[] args = new Object[]{NAME, type.getName(), name};
                throw new IdRepoException("amIdRepo", "212", args);
            }
        } else {
            Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        return results;
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.getMemberships called " + type + ": " + name + ": " + membershipType);
        }
        if (this.initializationException != null) {
            this.debug.error("AgentsRepo.getMemberships: Realm " + this.realmName + " does not exist.");
            throw this.initializationException;
        }
        if (!(type.equals(IdType.AGENT) || type.equals(IdType.AGENTONLY) || type.equals(IdType.AGENTGROUP))) {
            this.debug.message("AgentsRepo:getMemberships supported only for agents");
            Object[] args = new Object[]{NAME};
            throw new IdRepoException("amIdRepo", "225", args);
        }
        Set results = new HashSet();
        if (membershipType.equals(IdType.AGENTGROUP)) {
            try {
                this.orgConfig = this.getOrgConfig(token);
                results = this.getGroupNames(this.orgConfig, name);
            }
            catch (SMSException sme) {
                this.debug.error("AgentsRepo.getMemberships: Caught exception while getting memberships for Agent", (Throwable)sme);
                Object[] args = new Object[]{NAME, type.getName(), name};
                throw new IdRepoException("amIdRepo", "212", args);
            }
        } else {
            Object[] args = new Object[]{NAME, IdOperation.READ.getName(), membershipType.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        return results;
    }

    private String getGroupName(ServiceConfig orgConfig, String agentName) throws SSOException, SMSException {
        Set groups = this.getGroupNames(orgConfig, agentName);
        return groups != null && !groups.isEmpty() ? (String)groups.iterator().next() : null;
    }

    private Set getGroupNames(ServiceConfig orgConfig, String agentName) throws SSOException, SMSException {
        String lUri;
        HashSet<String> results = new HashSet<String>(2);
        ServiceConfig aCfg = orgConfig.getSubConfig(agentName);
        if (aCfg != null && (lUri = aCfg.getLabeledUri()) != null && lUri.length() > 0) {
            results.add(lUri);
        }
        return results;
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public boolean isExists(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.isExists() called: " + type + ": " + name);
        }
        if (this.initializationException != null) {
            this.debug.error("AgentsRepo.isExists: Realm " + this.realmName + " does not exist.");
            throw this.initializationException;
        }
        boolean exist = false;
        Map answer = this.getAttributes(token, type, name);
        if (answer != null && !answer.isEmpty()) {
            exist = true;
        }
        return exist;
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo: modifyMemberShip called " + type + ": " + name + ": " + members + ": " + membersType);
        }
        if (this.initializationException != null) {
            this.debug.error("AgentsRepo.modifyMemberShip: Realm " + this.realmName + " does not exist.");
            throw this.initializationException;
        }
        if (members == null || members.isEmpty()) {
            this.debug.error("AgentsRepo.modifyMemberShip: Members set is empty");
            throw new IdRepoException("amIdRepo", "201", null);
        }
        if (type.equals(IdType.USER) || type.equals(IdType.AGENT)) {
            this.debug.error("AgentsRepo.modifyMembership: Membership to users and agents is not supported");
            throw new IdRepoException("amIdRepo", "203", null);
        }
        if (!membersType.equals(IdType.AGENTONLY)) {
            this.debug.error("AgentsRepo.modifyMembership: A non-agent type cannot be made a member of any identity" + membersType.getName());
            Object[] args = new Object[]{NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        if (type.equals(IdType.AGENTGROUP)) {
            try {
                this.orgConfig = this.getOrgConfig(token);
                Iterator it = members.iterator();
                ServiceConfig aCfg = null;
                while (it.hasNext()) {
                    String agent = (String)it.next();
                    aCfg = this.orgConfig.getSubConfig(agent);
                    if (aCfg == null) continue;
                    switch (operation) {
                        case 1: {
                            aCfg.setLabeledUri(name);
                            break;
                        }
                        case 2: {
                            aCfg.setLabeledUri("");
                        }
                    }
                }
            }
            catch (SMSException sme) {
                this.debug.error("AgentsRepo.modifyMembership: Caught exception while  adding/removing agents to groups", (Throwable)sme);
                Object[] args = new Object[]{NAME, type.getName(), name};
                throw new IdRepoException("amIdRepo", "212", args);
            }
        } else {
            this.debug.error("AgentsRepo.modifyMembership: Memberships cannot bemodified for type= " + type.getName());
            Object[] args = new Object[]{NAME, type.getName()};
            throw new IdRepoException("amIdRepo", "209", args);
        }
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.removeAttributes() called: " + type + ": " + name);
        }
        if (this.initializationException != null) {
            this.debug.error("AgentsRepo.removeAttributes: Realm " + this.realmName + " does not exist.");
            throw this.initializationException;
        }
        if (attrNames == null || attrNames.isEmpty()) {
            if (this.debug.messageEnabled()) {
                this.debug.message("AgentsRepo.removeAttributes(): Attributes are empty");
            }
            throw new IdRepoException("amIdRepo", "201", null);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.removeAttributes(): Attribute  names" + attrNames);
        }
        ServiceConfig aCfg = null;
        try {
            if (type.equals(IdType.AGENTONLY)) {
                this.orgConfig = this.getOrgConfig(token);
                aCfg = this.orgConfig.getSubConfig(name);
                Iterator it = attrNames.iterator();
                while (it.hasNext()) {
                    String attrName = (String)it.next();
                    if (aCfg != null) {
                        aCfg.removeAttribute(attrName);
                        continue;
                    }
                    Object[] args = new Object[]{name, type};
                    throw new IdRepoException("amIdRepo", "223", args);
                }
            }
        }
        catch (SMSException smse) {
            this.debug.error("AgentsRepo.removeAttributes(): Unable to remove agent attributes ", (Throwable)smse);
            Object[] args = new Object[]{NAME, type.getName(), name};
            throw new IdRepoException("amIdRepo", "212", args);
        }
    }

    public void removeListener() {
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, int maxTime, int maxResults, Set returnAttrs, boolean returnAllAttrs, int filterOp, Map avPairs, boolean recursive) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.search() called: " + type + ": " + pattern);
        }
        if (this.initializationException != null) {
            this.debug.error("AgentsRepo.search: Realm " + this.realmName + " does not exist.");
            throw this.initializationException;
        }
        Set agentRes = new HashSet(2);
        HashMap<String, Map> agentAttrs = new HashMap<String, Map>();
        int errorCode = 0;
        Object aCfg = null;
        try {
            if (type.equals(IdType.AGENTONLY) || type.equals(IdType.AGENT)) {
                this.orgConfig = this.getOrgConfig(token);
                agentRes = this.getAgentPattern(token, type, this.orgConfig, pattern, avPairs);
            } else if (type.equals(IdType.AGENTGROUP)) {
                this.agentGroupConfig = this.getAgentGroupConfig(token);
                agentRes = this.getAgentPattern(token, type, this.agentGroupConfig, pattern, avPairs);
            }
            if (agentRes != null && !agentRes.isEmpty()) {
                Iterator it = agentRes.iterator();
                while (it.hasNext()) {
                    String agName = (String)it.next();
                    Map attrsMap = this.getAttributes(token, type, agName);
                    if (attrsMap != null && !attrsMap.isEmpty()) {
                        agentAttrs.put(agName, attrsMap);
                        continue;
                    }
                    return new RepoSearchResults(new HashSet(), 0, Collections.EMPTY_MAP, type);
                }
            }
        }
        catch (SSOException sse) {
            this.debug.error("AgentsRepo.search(): Unable to retrieve entries: ", (Throwable)((Object)sse));
            Object[] args = new Object[]{NAME};
            throw new IdRepoException("amIdRepo", "219", args);
        }
        return new RepoSearchResults(agentRes, errorCode, agentAttrs, type);
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, Map avPairs, boolean recursive, int maxResults, int maxTime, Set returnAttrs) throws IdRepoException, SSOException {
        return this.search(token, type, pattern, maxTime, maxResults, returnAttrs, returnAttrs == null, 0, avPairs, recursive);
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.setAttributes() called: " + type + ": " + name);
        }
        if (this.initializationException != null) {
            this.debug.error("AgentsRepo.setAttributes: Realm " + this.realmName + " does not exist.");
            throw this.initializationException;
        }
        if (attributes == null || attributes.isEmpty()) {
            if (this.debug.messageEnabled()) {
                this.debug.message("AgentsRepo.setAttributes(): Attributes are empty");
            }
            throw new IdRepoException("amIdRepo", "201", null);
        }
        ServiceConfig aCfg = null;
        try {
            if (type.equals(IdType.AGENTONLY)) {
                this.orgConfig = this.getOrgConfig(token);
                aCfg = this.orgConfig.getSubConfig(name);
            } else if (type.equals(IdType.AGENTGROUP)) {
                this.agentGroupConfig = this.getAgentGroupConfig(token);
                aCfg = this.agentGroupConfig.getSubConfig(name);
            } else {
                Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
                throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
            }
            Set vals = (Set)attributes.get("userpassword");
            if (vals != null) {
                HashSet<String> hashedVals = new HashSet<String>();
                Iterator it = vals.iterator();
                while (it.hasNext()) {
                    String val = (String)it.next();
                    if (val.startsWith(hashAlgStr)) continue;
                    hashedVals.add(hashAlgStr + Hash.hash((String)val));
                    attributes.remove("userpassword");
                    attributes.put("userpassword", hashedVals);
                }
            }
            if (aCfg == null) {
                Object[] args = new Object[]{name, type};
                throw new IdRepoException("amIdRepo", "223", args);
            }
            aCfg.setAttributes(attributes);
        }
        catch (SMSException smse) {
            this.debug.error("AgentsRepo.setAttributes(): Unable to set agent attributes ", (Throwable)smse);
            Object[] args = new Object[]{NAME, type.getName(), name};
            throw new IdRepoException("amIdRepo", "212", args);
        }
    }

    public Set getSupportedOperations(IdType type) {
        return (Set)this.supportedOps.get(type);
    }

    public Set getSupportedTypes() {
        return this.supportedOps.keySet();
    }

    public void initialize(Map configParams) {
        super.initialize(configParams);
        Set realms = (Set)configParams.get("agentsRepoRealmName");
        if (realms != null && !realms.isEmpty()) {
            this.realmName = DNMapper.orgNameToDN((String)realms.iterator().next());
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (this.getOrgConfig(adminToken) == null) {
                this.debug.error("AgentsRepo.getAgentGroupConfig: Realm " + this.realmName + " does not exist.");
                String slashRealmName = DNMapper.orgNameToRealmName(this.realmName);
                Object[] args = new Object[]{slashRealmName};
                this.initializationException = new IdRepoException("amIdRepo", "312", args);
            }
            this.getAgentGroupConfig(adminToken);
        }
    }

    public boolean isActive(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        Map attributes = this.getAttributes(token, type, name);
        if (attributes == null) {
            Object[] args = new Object[]{NAME, name};
            throw new IdRepoException("amIdRepo", "202", args);
        }
        Set activeVals = (Set)attributes.get(statusAttribute);
        if (activeVals == null || activeVals.isEmpty()) {
            return true;
        }
        Iterator it = activeVals.iterator();
        String active = (String)it.next();
        return active.equalsIgnoreCase(statusActive);
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, boolean active) throws IdRepoException, SSOException {
        HashMap attrs = new HashMap();
        HashSet<String> vals = new HashSet<String>(2);
        if (active) {
            vals.add(statusActive);
        } else {
            vals.add(statusInactive);
        }
        attrs.put(statusAttribute, vals);
        this.setAttributes(token, type, name, attrs, false);
    }

    public void shutdown() {
        scm.removeListener(this.scmListenerId);
        ssm.removeListener(this.ssmListenerId);
    }

    private void loadSupportedOps() {
        HashSet<IdOperation> opSet = new HashSet<IdOperation>(2);
        opSet.add(IdOperation.EDIT);
        opSet.add(IdOperation.READ);
        opSet.add(IdOperation.CREATE);
        opSet.add(IdOperation.DELETE);
        HashSet opSet2 = new HashSet(opSet);
        opSet2.remove(IdOperation.EDIT);
        opSet2.remove(IdOperation.CREATE);
        opSet2.remove(IdOperation.DELETE);
        this.supportedOps.put(IdType.AGENTONLY, Collections.unmodifiableSet(opSet));
        this.supportedOps.put(IdType.AGENTGROUP, Collections.unmodifiableSet(opSet));
        this.supportedOps.put(IdType.AGENT, Collections.unmodifiableSet(opSet2));
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.loadSupportedOps() called: supportedOps Map = " + this.supportedOps);
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.globalConfigChanged..");
        }
        IdType idType = groupName.equalsIgnoreCase("default") ? IdType.AGENTONLY : IdType.AGENTGROUP;
        String name = serviceComponent.substring(serviceComponent.indexOf(47) + 1);
        this.sendNotificationSet(type, idType, name);
        if (this.repoListener != null) {
            this.repoListener.objectChanged(name, type, this.repoListener.getConfigMap());
        }
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.organizationConfigChanged..");
        }
        if (orgName.equalsIgnoreCase(this.realmName)) {
            IdType idType = groupName.equalsIgnoreCase("default") ? IdType.AGENTONLY : IdType.AGENTGROUP;
            String name = serviceComponent.substring(serviceComponent.indexOf(47) + 1);
            this.sendNotificationSet(type, idType, name);
            if (this.repoListener != null) {
                this.repoListener.objectChanged(name, type, this.repoListener.getConfigMap());
            }
        }
    }

    public void schemaChanged(String serviceName, String version) {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.schemaChanged..");
        }
        if (this.repoListener != null) {
            this.repoListener.allObjectsChanged();
        }
    }

    public String getFullyQualifiedName(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        RepoSearchResults results = this.search(token, type, name, null, true, 0, 0, null);
        Set dns = results.getSearchResults();
        if (dns.size() != 1) {
            Object[] args = new String[]{name};
            throw new IdRepoException("amIdRepo", "220", args);
        }
        return "sms://AgentsRepo/" + dns.iterator().next().toString();
    }

    public boolean supportsAuthentication() {
        return true;
    }

    public boolean authenticate(Callback[] credentials) throws IdRepoException, AuthLoginException {
        boolean answer;
        block9: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AgentsRepo.authenticate() called");
            }
            String username = null;
            String password = null;
            for (int i = 0; i < credentials.length; ++i) {
                char[] passwd;
                if (credentials[i] instanceof NameCallback) {
                    username = ((NameCallback)credentials[i]).getName();
                    if (!this.debug.messageEnabled()) continue;
                    this.debug.message("AgentsRepo.authenticate() username: " + username);
                    continue;
                }
                if (!(credentials[i] instanceof PasswordCallback) || (passwd = ((PasswordCallback)credentials[i]).getPassword()) == null) continue;
                password = new String(passwd);
                password = hashAlgStr + Hash.hash((String)password);
                if (!this.debug.messageEnabled()) continue;
                this.debug.message("AgentsRepo.authenticate() passwd present");
            }
            if (username == null || username.length() == 0 || password == null) {
                Object[] args = new Object[]{NAME};
                throw new IdRepoException("amIdRepo", "221", args);
            }
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            answer = false;
            String userid = username;
            try {
                if (DN.isDN((String)username)) {
                    userid = LDAPDN.explodeDN((String)username, (boolean)true)[0];
                }
                HashSet<String> pSet = new HashSet<String>(2);
                pSet.add("userpassword");
                Map ansMap = new HashMap();
                String userPwd = null;
                ansMap = this.getAttributes(adminToken, IdType.AGENTONLY, userid, pSet);
                Set userPwdSet = (Set)ansMap.get("userpassword");
                if (userPwdSet != null && !userPwdSet.isEmpty() && !(answer = password.equals(userPwd = (String)userPwdSet.iterator().next()))) {
                    throw new InvalidPasswordException("invalid password", userid);
                }
                if (this.debug.messageEnabled()) {
                    this.debug.message("AgentsRepo.authenticate() result: " + answer);
                }
            }
            catch (SSOException ssoe) {
                if (!this.debug.warningEnabled()) break block9;
                this.debug.warning("AgentsRepo.authenticate(): Unable to authenticate SSOException:" + (Object)((Object)ssoe));
            }
        }
        return answer;
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType sType, Map attrMap) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap) throws IdRepoException, SSOException {
        Object[] args = new Object[]{"com.sun.identity.idm.plugins.specialusers.SpecialRepo", IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServicesAndOCs) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    private ServiceConfig getOrgConfig(SSOToken token) {
        block7: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AgentsRepo.getOrgConfig() called. ");
            }
            try {
                if (this.orgConfig == null) {
                    if (scm == null) {
                        scm = new ServiceConfigManager(token, agentserviceName, version);
                    }
                    this.orgConfig = scm.getOrganizationConfig(this.realmName, null);
                }
            }
            catch (SMSException smse) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("AgentsRepo.getOrgConfig(): Unable to init ssm and scm due to " + smse);
                }
            }
            catch (SSOException ssoe) {
                if (!this.debug.warningEnabled()) break block7;
                this.debug.warning("AgentsRepo.getOrgConfig(): Unable to init ssm and scm due to " + (Object)((Object)ssoe));
            }
        }
        return this.orgConfig;
    }

    private ServiceConfig getAgentGroupConfig(SSOToken token) {
        block8: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AgentsRepo.getAgentGroupConfig() called. ");
            }
            try {
                if (this.agentGroupConfig == null) {
                    if (scm == null) {
                        scm = new ServiceConfigManager(token, agentserviceName, version);
                    }
                    String agentGroupDN = this.constructDN(agentGroupNode, instancesNode, this.realmName, version, agentserviceName);
                    ServiceConfig orgConfig = this.getOrgConfig(token);
                    if (orgConfig != null) {
                        orgConfig.checkAndCreateGroup(agentGroupDN, agentGroupNode);
                        this.agentGroupConfig = scm.getOrganizationConfig(this.realmName, agentGroupNode);
                    }
                }
            }
            catch (SMSException smse) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("AgentsRepo.getAgentGroupConfig: Unable to init ssm and scm due to " + smse);
                }
            }
            catch (SSOException ssoe) {
                if (!this.debug.warningEnabled()) break block8;
                this.debug.warning("AgentsRepo.getAgentGroupConfig: Unable to init ssm and scm due to " + (Object)((Object)ssoe));
            }
        }
        return this.agentGroupConfig;
    }

    private boolean isAgentTypeSearch(ServiceConfig aConfig, String pattern) throws IdRepoException {
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.isAgentTypeSearch() called: " + pattern);
        }
        String agentType = null;
        boolean agentTypeflg = false;
        try {
            Iterator items = aConfig.getSubConfigNames().iterator();
            while (items.hasNext()) {
                agentType = (String)items.next();
                if (!agentType.equalsIgnoreCase(pattern)) continue;
                agentTypeflg = true;
                break;
            }
        }
        catch (SMSException sme) {
            this.debug.error("AgentsRepo.isAgentTypeSearch(): Error occurred while checking AgentType sent for pattern " + pattern, (Throwable)sme);
            throw new IdRepoException(sme.getMessage());
        }
        return agentTypeflg;
    }

    private Set getAgentPattern(SSOToken token, IdType type, ServiceConfig aConfig, String pattern, Map avPairs) throws IdRepoException {
        Set set;
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.getAgentPattern() called: pattern : " + pattern + "\navPairs : " + avPairs);
        }
        if (aConfig == null) {
            return Collections.EMPTY_SET;
        }
        String agentType = null;
        if (avPairs != null && !avPairs.isEmpty() && (set = (Set)avPairs.get("AgentType")) != null && !set.isEmpty()) {
            agentType = set.iterator().next().toString();
            avPairs.remove("AgentType");
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("AgentsRepo.getAgentPattern() agentType : " + agentType);
        }
        try {
            Set agentRes = agentType != null ? aConfig.getSubConfigNames(pattern, agentType) : aConfig.getSubConfigNames(pattern);
            if (this.debug.messageEnabled()) {
                this.debug.message("AgentsRepo.getAgentPattern() agentRes : " + agentRes);
            }
            if (agentRes == null || agentRes.isEmpty() || avPairs == null || avPairs.isEmpty()) {
                return agentRes == null ? Collections.EMPTY_SET : agentRes;
            }
            HashSet<String> agents = new HashSet<String>(2);
            Iterator itr = agentRes.iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Map attrMap = this.getAttributes(token, type, name);
                if (attrMap == null || attrMap.isEmpty()) continue;
                Iterator it = avPairs.keySet().iterator();
                block4: while (it.hasNext()) {
                    String attr = (String)it.next();
                    Set attrValues = (Set)avPairs.get(attr);
                    Set presentSet = (Set)attrMap.get(attr);
                    if (presentSet == null || presentSet.isEmpty()) continue;
                    CaseInsensitiveHashSet presentValues = new CaseInsensitiveHashSet((Collection)presentSet);
                    Iterator i = attrValues.iterator();
                    while (i.hasNext()) {
                        String avName = (String)i.next();
                        if (presentValues == null || !presentValues.contains(avName)) continue;
                        agents.add(name);
                        continue block4;
                    }
                }
            }
            return agents;
        }
        catch (SSOException sse) {
            this.debug.error("AgentsRepo.getAgentPattern(): Error occurred while checking AgentName sent for pattern " + pattern, (Throwable)((Object)sse));
            throw new IdRepoException(sse.getMessage());
        }
        catch (SMSException sme) {
            this.debug.error("AgentsRepo.getAgentPattern(): Error occurred while checking AgentName sent for pattern " + pattern, (Throwable)sme);
            throw new IdRepoException(sme.getMessage());
        }
    }

    String constructDN(String groupName, String configName, String orgName, String version, String serviceName) throws SMSException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("ou=").append(groupName).append(comma).append(configName).append("ou=").append(version).append(comma).append("ou=").append(serviceName).append(comma).append("ou=services").append(comma);
        orgName = DNMapper.orgNameToDN(orgName);
        sb.append(orgName);
        return sb.toString();
    }

    private void sendNotificationSet(int type, IdType agentIdTypeforNotificationSet, String agentNameforNotificationSet) {
        block18: {
            try {
                HashSet<String> nSet = new HashSet<String>(2);
                nSet.add(notificationURLenabled);
                Map ansMap = new HashMap();
                SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                ansMap = this.getAttributes(adminToken, agentIdTypeforNotificationSet, agentNameforNotificationSet, nSet);
                Set neSet = (Set)ansMap.get(notificationURLenabled);
                if (neSet != null && !neSet.isEmpty() && ((String)neSet.iterator().next()).equalsIgnoreCase("true")) {
                    switch (type) {
                        case 4: {
                            if (agentIdTypeforNotificationSet == null) break;
                            String modItem = null;
                            HashSet<String> aNameSet = new HashSet<String>(2);
                            if (this.debug.messageEnabled()) {
                                this.debug.message("AgentsRepo.sendNotificationSet(): agentIdTypeforNotificationSet " + agentIdTypeforNotificationSet);
                                this.debug.message("AgentsRepo.sendNotificationSet(): agentNameforNotificationSet " + agentNameforNotificationSet);
                            }
                            if (agentIdTypeforNotificationSet.equals(IdType.AGENTGROUP)) {
                                Set members = this.getMembers(adminToken, agentIdTypeforNotificationSet, agentNameforNotificationSet, IdType.AGENTONLY);
                                Iterator it = members.iterator();
                                while (it.hasNext()) {
                                    String agent = (String)it.next();
                                    aNameSet.add(agent);
                                }
                            } else {
                                aNameSet.add(agentNameforNotificationSet);
                            }
                            if (this.debug.messageEnabled()) {
                                this.debug.message("AgentsRepo.sendNotificationSet(): aNameSet " + aNameSet);
                            }
                            if (aNameSet == null || aNameSet.isEmpty()) break;
                            Iterator itr = aNameSet.iterator();
                            while (itr.hasNext()) {
                                agentNameforNotificationSet = (String)itr.next();
                                agentIdTypeforNotificationSet = IdType.AGENTONLY;
                                StringBuffer xmlsb = new StringBuffer(1000);
                                xmlsb.append("<").append(AGENT_NOTIFICATION).append(" ").append(AGENT_ID).append("=\"").append(agentNameforNotificationSet).append("\"").append(" ").append(AGENT_IDTYPE).append("=\"").append(agentIdTypeforNotificationSet.getName()).append("\"/>");
                                modItem = xmlsb.toString();
                                if (this.debug.messageEnabled()) {
                                    this.debug.message("AgentsRepo.sendNotificationSet(): modItem " + modItem);
                                }
                                nSet = new HashSet(2);
                                nSet.add(notificationURLname);
                                ansMap = new HashMap();
                                String nval = null;
                                ansMap = this.getAttributes(adminToken, agentIdTypeforNotificationSet, agentNameforNotificationSet, nSet);
                                Set nvalSet = (Set)ansMap.get(notificationURLname);
                                if (nvalSet == null || nvalSet.isEmpty()) continue;
                                nval = (String)nvalSet.iterator().next();
                                try {
                                    URL url = new URL(nval);
                                    Notification notification = new Notification(modItem);
                                    NotificationSet ns = new NotificationSet(AGENT_CONFIG_SERVICE);
                                    ns.addNotification(notification);
                                    try {
                                        PLLServer.send(url, ns);
                                        if (!this.debug.messageEnabled()) continue;
                                        this.debug.message("AgentsRepo:sendNotificationSet Sent Notification to URL: " + url + " Data: " + ns);
                                    }
                                    catch (SendNotificationException ne) {
                                        if (!this.debug.warningEnabled()) continue;
                                        this.debug.warning("AgentsRepo.sendNotificationSet: failed sending notification to: " + url, (Throwable)ne);
                                    }
                                }
                                catch (MalformedURLException e) {
                                    if (!this.debug.warningEnabled()) continue;
                                    this.debug.warning("AgentsRepo.sendNotificationSet:():  invalid URL: ", (Throwable)e);
                                }
                            }
                            break;
                        }
                    }
                }
            }
            catch (IdRepoException idpe) {
                this.debug.error("AgentsRepo.sendNotificationSet(): Unable to send notification due to " + idpe);
            }
            catch (SSOException ssoe) {
                if (!this.debug.warningEnabled()) break block18;
                this.debug.warning("AgentsRepo.sendNotificationSet(): Unable to send notification due to " + (Object)((Object)ssoe));
            }
        }
    }
}

