/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.internal;

import com.iplanet.services.ldap.ServerConfigMgr;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.server.SMSAuthModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoFatalException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Hash;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class SpecialRepo
extends IdRepo
implements ServiceListener {
    public static final String NAME = "com.sun.identity.idm.plugins.internal.SpecialRepo";
    private static final String statusAttribute = "inetUserStatus";
    private static final String statusActive = "Active";
    private static final String statusInactive = "Inactive";
    private static final String snAttribute = "sn";
    private static final String cnAttribute = "cn";
    private static final String gnAttribute = "givenName";
    private static final String empNumAttribute = "employeeNumber";
    private static final String aliasAttribute = "iplanet-am-user-alias-list";
    private static final String successAttribute = "iplanet-am-user-success-url";
    private static final String failureAttribute = "iplanet-am-user-failure-url";
    private static final String mailAttribute = "mail";
    private static final String addrAttribute = "postalAddress";
    private static final String msisdnAttribute = "sunIdentityMSISDNNumber";
    private static final String phoneAttribute = "telephoneNumber";
    IdRepoListener repoListener;
    Debug debug;
    private Map supportedOps;
    ServiceSchemaManager ssm;
    ServiceConfigManager scm;
    ServiceConfig globalConfig;
    ServiceConfig userConfig;
    ServiceConfig roleConfig;
    String ssmListenerId;
    String scmListenerId;

    public SpecialRepo() {
        block5: {
            this.repoListener = null;
            this.debug = Debug.getInstance((String)"amSpecialRepo");
            this.supportedOps = new HashMap();
            this.ssm = null;
            this.scm = null;
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                this.ssm = new ServiceSchemaManager(adminToken, "sunIdentityRepositoryService", "1.0");
                this.scm = new ServiceConfigManager(adminToken, "sunIdentityRepositoryService", "1.0");
            }
            catch (SMSException smse) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("SpecialRepo.SpecialRepo: Unable to init ssm and scm due to " + smse);
                }
            }
            catch (SSOException ssoe) {
                if (!this.debug.warningEnabled()) break block5;
                this.debug.warning("SpecialRepo.SpecialRepo: Unable to init ssm and scm due to " + (Object)((Object)ssoe));
            }
        }
        this.loadSupportedOps();
        if (this.debug.messageEnabled()) {
            this.debug.message(": SpecialRepo invoked");
        }
    }

    public int addListener(SSOToken token, IdRepoListener listener) throws IdRepoException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message(": SpecialRepo addListener");
        }
        this.repoListener = listener;
        try {
            if (this.ssm == null) {
                this.ssm = new ServiceSchemaManager(token, "sunIdentityRepositoryService", "1.0");
            }
            if (this.scm == null) {
                this.scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
            }
            this.ssmListenerId = this.ssm.addListener(this);
            this.scmListenerId = this.scm.addListener(this);
        }
        catch (SMSException smse) {
            this.debug.error("SpecialRepo.addListener: Unable to add listener to SM Updates to special users will not reflect", (Throwable)smse);
        }
        return 0;
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public String create(SSOToken token, IdType type, String name, Map attrMap) throws IdRepoException, SSOException {
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void delete(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServicesAndOCs) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        CaseInsensitiveHashMap allAtt = new CaseInsensitiveHashMap(this.getAttributes(token, type, name));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Iterator it = attrNames.iterator();
        while (it.hasNext()) {
            String attrName = (String)it.next();
            if (!allAtt.containsKey(attrName)) continue;
            resultMap.put(attrName, allAtt.get(attrName));
        }
        return resultMap;
    }

    public Map getAttributes(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (type.equals(IdType.USER) || type.equals(IdType.ROLE)) {
            try {
                if (this.globalConfig == null) {
                    if (this.scm == null) {
                        this.scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
                    }
                    this.globalConfig = this.scm.getGlobalConfig(null);
                }
                if (type.equals(IdType.USER)) {
                    if (this.userConfig == null) {
                        this.userConfig = this.globalConfig.getSubConfig("users");
                    }
                    Iterator items = this.userConfig.getSubConfigNames().iterator();
                    while (items.hasNext()) {
                        ServiceConfig usc1;
                        String n = (String)items.next();
                        if (!n.equalsIgnoreCase(name) || (usc1 = this.userConfig.getSubConfig(name)) == null) continue;
                        Map answer = usc1.getAttributes();
                        if (name.equalsIgnoreCase("amadmin") || name.equalsIgnoreCase("anonymous")) {
                            answer.remove("userPassword");
                        }
                        return answer;
                    }
                    Object[] args = new Object[]{name};
                    throw new IdRepoException("amIdRepo", "202", args);
                }
                if (type.equals(IdType.ROLE)) {
                    if (this.roleConfig == null) {
                        this.roleConfig = this.globalConfig.getSubConfig("roles");
                    }
                    Iterator items = this.roleConfig.getSubConfigNames().iterator();
                    while (items.hasNext()) {
                        ServiceConfig usc1;
                        String n = (String)items.next();
                        if (!n.equalsIgnoreCase(name) || (usc1 = this.roleConfig.getSubConfig(name)) == null) continue;
                        return usc1.getAttributes();
                    }
                    Object[] args = new Object[]{name};
                    throw new IdRepoException("amIdRepo", "202", args);
                }
            }
            catch (SMSException smse) {
                this.debug.error("SpecialRepo: Unable to read user attributes ", (Throwable)smse);
                Object[] args = new Object[]{NAME};
                throw new IdRepoException("amIdRepo", "200", args);
            }
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Map getBinaryAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void setBinaryAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.EDIT.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        if (type.equals(IdType.ROLE) && membersType.equals(IdType.USER)) {
            try {
                Set members = Collections.EMPTY_SET;
                if (this.roleConfig == null) {
                    if (this.globalConfig == null) {
                        if (this.scm == null) {
                            this.scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
                        }
                        this.globalConfig = this.scm.getGlobalConfig(null);
                    }
                    this.roleConfig = this.globalConfig.getSubConfig("roles");
                }
                Set roleNames = this.roleConfig.getSubConfigNames();
                ServiceConfig rConfig = null;
                if (roleNames != null && !roleNames.isEmpty()) {
                    CaseInsensitiveHashSet rns = new CaseInsensitiveHashSet();
                    rns.addAll(roleNames);
                    if (rns.contains(name)) {
                        rConfig = this.roleConfig.getSubConfig(name);
                    }
                }
                if (rConfig == null) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("SpecialRepo:getMembers failed for" + name);
                    }
                    Object[] args = new Object[]{NAME, type.getName(), name};
                    throw new IdRepoException("amIdRepo", "207", args);
                }
                Map attrs = rConfig.getAttributes();
                members = (Set)attrs.get("members");
                return members;
            }
            catch (SMSException smse) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("SpecialRepo: Unable to read user attributes ", (Throwable)smse);
                }
                Object[] args = new Object[]{NAME};
                throw new IdRepoException("amIdRepo", "200", args);
            }
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        if (type.equals(IdType.USER) && membershipType.equals(IdType.ROLE)) {
            try {
                if (this.userConfig == null) {
                    if (this.globalConfig == null) {
                        if (this.scm == null) {
                            this.scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
                        }
                        this.globalConfig = this.scm.getGlobalConfig(null);
                    }
                    this.userConfig = this.globalConfig.getSubConfig("users");
                }
                Set userNames = this.userConfig.getSubConfigNames();
                ServiceConfig uConfig = null;
                if (userNames != null && !userNames.isEmpty()) {
                    CaseInsensitiveHashSet uns = new CaseInsensitiveHashSet();
                    uns.addAll(userNames);
                    if (uns.contains(name)) {
                        uConfig = this.userConfig.getSubConfig(name);
                    }
                }
                if (uConfig != null) {
                    Map attrs = uConfig.getAttributes();
                    return (Set)attrs.get("roles");
                }
                if (this.debug.messageEnabled()) {
                    this.debug.message("SpecialRepo:getMemberships failed for" + name);
                }
                Object[] args = new Object[]{NAME, type.getName(), name};
                throw new IdRepoException("amIdRepo", "207", args);
            }
            catch (SMSException smse) {
                this.debug.error("SpecialRepo: Unable to read user attributes ", (Throwable)smse);
                Object[] args = new Object[]{NAME};
                throw new IdRepoException("amIdRepo", "200", args);
            }
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        if (type.equals(IdType.USER)) {
            try {
                if (this.userConfig == null) {
                    if (this.globalConfig == null) {
                        if (this.scm == null) {
                            this.scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
                        }
                        this.globalConfig = this.scm.getGlobalConfig(null);
                    }
                    this.userConfig = this.globalConfig.getSubConfig("users");
                }
                CaseInsensitiveHashSet userSet = new CaseInsensitiveHashSet();
                userSet.addAll(this.userConfig.getSubConfigNames());
                if (userSet != null && userSet.contains(name)) {
                    return Collections.EMPTY_MAP;
                }
            }
            catch (SMSException smse) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("SpecialRepo: Unable to get service attributes ", (Throwable)smse);
                }
                Object[] args = new Object[]{NAME, type.getName(), name};
                throw new IdRepoException("amIdRepo", "212", args);
            }
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public boolean isExists(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            return true;
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.EDIT.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType sType, Map attrMap) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public void removeListener() {
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, int maxTime, int maxResults, Set returnAttrs, boolean returnAllAttrs, int filterOp, Map avPairs, boolean recursive) throws IdRepoException, SSOException {
        Set<String> userRes = new HashSet();
        HashMap<String, Map> userAttrs = new HashMap<String, Map>();
        int errorCode = 0;
        try {
            if (this.globalConfig == null) {
                if (this.scm == null) {
                    this.scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
                }
                this.globalConfig = this.scm.getGlobalConfig(null);
            }
            if (type.equals(IdType.USER)) {
                if (this.userConfig == null) {
                    this.userConfig = this.globalConfig.getSubConfig("users");
                }
                if (pattern.equals("*") && avPairs != null && !avPairs.isEmpty()) {
                    Set uidVals = (Set)avPairs.get("uid");
                    if (uidVals != null && !uidVals.isEmpty()) {
                        pattern = (String)uidVals.iterator().next();
                    } else {
                        return new RepoSearchResults(Collections.EMPTY_SET, 0, Collections.EMPTY_MAP, type);
                    }
                }
                if (pattern.indexOf(42) != -1) {
                    userRes = this.userConfig.getSubConfigNames(pattern);
                } else {
                    Iterator items = this.userConfig.getSubConfigNames().iterator();
                    while (items.hasNext()) {
                        String name = (String)items.next();
                        if (!name.equalsIgnoreCase(pattern)) continue;
                        userRes.add(pattern);
                        break;
                    }
                }
                if (userRes != null) {
                    Iterator it = userRes.iterator();
                    while (it.hasNext()) {
                        String u = (String)it.next();
                        ServiceConfig thisUser = this.userConfig.getSubConfig(u);
                        Map attrs = thisUser.getAttributes();
                        if (u.equalsIgnoreCase("amadmin") || u.equalsIgnoreCase("anonymous")) {
                            attrs.remove("userPassword");
                        }
                        userAttrs.put(u, attrs);
                    }
                }
                return new RepoSearchResults(userRes, errorCode, userAttrs, type);
            }
            if (type.equals(IdType.ROLE)) {
                if (this.roleConfig == null) {
                    this.roleConfig = this.globalConfig.getSubConfig("roles");
                }
                if (pattern.indexOf(42) != -1) {
                    userRes = this.roleConfig.getSubConfigNames(pattern);
                } else {
                    Iterator items = this.roleConfig.getSubConfigNames().iterator();
                    while (items.hasNext()) {
                        String name = (String)items.next();
                        if (!name.equalsIgnoreCase(pattern)) continue;
                        userRes.add(pattern);
                        break;
                    }
                }
                if (userRes != null) {
                    Iterator it = userRes.iterator();
                    while (it.hasNext()) {
                        String u = (String)it.next();
                        ServiceConfig thisUser = this.roleConfig.getSubConfig(u);
                        Map attrs = thisUser.getAttributes();
                        userAttrs.put(u, attrs);
                    }
                }
                return new RepoSearchResults(userRes, errorCode, userAttrs, type);
            }
            return new RepoSearchResults(Collections.EMPTY_SET, 0, Collections.EMPTY_MAP, type);
        }
        catch (SMSException smse) {
            this.debug.error("SpecialRepo.search: Unable to retrieve entries: ", (Throwable)smse);
            Object[] args = new Object[]{NAME};
            throw new IdRepoException("amIdRepo", "219", args);
        }
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, Map avPairs, boolean recursive, int maxResults, int maxTime, Set returnAttrs) throws IdRepoException, SSOException {
        return this.search(token, type, pattern, maxTime, maxResults, returnAttrs, returnAttrs == null, 0, avPairs, recursive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (type.equals(IdType.USER)) {
            try {
                if (this.userConfig == null) {
                    if (this.globalConfig == null) {
                        if (this.scm == null) {
                            this.scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
                        }
                        this.globalConfig = this.scm.getGlobalConfig(null);
                    }
                    this.userConfig = this.globalConfig.getSubConfig("users");
                }
                CaseInsensitiveHashSet userSet = new CaseInsensitiveHashSet();
                userSet.addAll(this.userConfig.getSubConfigNames());
                if (userSet.contains(name)) {
                    ServiceConfig usc1 = this.userConfig.getSubConfig(name);
                    Map attrs = usc1.getAttributes();
                    String newPassword = null;
                    Set vals = (Set)attributes.get("userPassword");
                    if (vals != null || (vals = (Set)attributes.get("userpassword")) != null) {
                        HashSet<String> hashedVals = new HashSet<String>();
                        Iterator it = vals.iterator();
                        while (it.hasNext()) {
                            String val = (String)it.next();
                            hashedVals.add(Hash.hash((String)val));
                            newPassword = val;
                        }
                        attrs.put("userPassword", hashedVals);
                    }
                    if ((vals = (Set)attributes.get(statusAttribute)) != null || (vals = (Set)attributes.get(statusAttribute)) != null) {
                        attrs.put(statusAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(cnAttribute)) != null || (vals = (Set)attributes.get(cnAttribute)) != null) {
                        attrs.put(cnAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(snAttribute)) != null || (vals = (Set)attributes.get(snAttribute)) != null) {
                        attrs.put(snAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(gnAttribute)) != null || (vals = (Set)attributes.get(gnAttribute)) != null) {
                        attrs.put(gnAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(empNumAttribute)) != null || (vals = (Set)attributes.get(empNumAttribute)) != null) {
                        attrs.put(empNumAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(aliasAttribute)) != null || (vals = (Set)attributes.get(aliasAttribute)) != null) {
                        attrs.put(aliasAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(successAttribute)) != null || (vals = (Set)attributes.get(successAttribute)) != null) {
                        attrs.put(successAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(failureAttribute)) != null || (vals = (Set)attributes.get(failureAttribute)) != null) {
                        attrs.put(failureAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(mailAttribute)) != null || (vals = (Set)attributes.get(mailAttribute)) != null) {
                        attrs.put(mailAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(addrAttribute)) != null || (vals = (Set)attributes.get(addrAttribute)) != null) {
                        attrs.put(addrAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(msisdnAttribute)) != null || (vals = (Set)attributes.get(msisdnAttribute)) != null) {
                        attrs.put(msisdnAttribute, vals);
                    }
                    if ((vals = (Set)attributes.get(phoneAttribute)) != null || (vals = (Set)attributes.get(phoneAttribute)) != null) {
                        attrs.put(phoneAttribute, vals);
                    }
                    usc1.setAttributes(attrs);
                    if (!name.equalsIgnoreCase("dsameuser")) return;
                    String op = (String)AccessController.doPrivileged(new AdminPasswordAction());
                    try {
                        ServerConfigMgr sscm = new ServerConfigMgr();
                        sscm.setAdminUserPassword(op, newPassword);
                        sscm.save();
                        return;
                    }
                    catch (Exception e) {
                        this.debug.error("SpecialRepo: error in changing password", (Throwable)e);
                    }
                    return;
                }
                Object[] args = new Object[]{name};
                throw new IdRepoException("amIdRepo", "202", args);
            }
            catch (SMSException smse) {
                this.debug.error("SpecialRepo: Unable to set user attributes ", (Throwable)smse);
                Object[] args = new Object[]{NAME, type.getName(), name};
                throw new IdRepoException("amIdRepo", "212", args);
            }
        } else {
            Object[] args = new Object[]{NAME, IdOperation.READ.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
    }

    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap) throws IdRepoException, SSOException {
        if (this.isSpecialUser(token, type, name)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type + " " + name};
            throw new IdRepoFatalException("amIdRepo", "305", args);
        }
        Object[] args = new Object[]{"com.sun.identity.idm.plugins.specialusers.SpecialRepo", IdOperation.SERVICE.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getSupportedOperations(IdType type) {
        return (Set)this.supportedOps.get(type);
    }

    public Set getSupportedTypes() {
        return this.supportedOps.keySet();
    }

    public void initialize(Map configParams) {
        super.initialize(configParams);
    }

    public boolean isActive(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        Map attributes = this.getAttributes(token, type, name);
        if (attributes == null) {
            Object[] args = new Object[]{NAME, name};
            throw new IdRepoException("amIdRepo", "202", args);
        }
        Set activeVals = (Set)attributes.get(statusAttribute);
        if (activeVals == null || activeVals.isEmpty()) {
            return true;
        }
        Iterator it = activeVals.iterator();
        String active = (String)it.next();
        return active.equalsIgnoreCase(statusActive);
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, boolean active) throws IdRepoException, SSOException {
        HashMap attrs = new HashMap();
        HashSet<String> vals = new HashSet<String>();
        if (active) {
            vals.add(statusActive);
        } else {
            vals.add(statusInactive);
        }
        attrs.put(statusAttribute, vals);
        this.setAttributes(token, type, name, attrs, false);
    }

    public void shutdown() {
        this.scm.removeListener(this.scmListenerId);
        this.ssm.removeListener(this.ssmListenerId);
    }

    private boolean isSpecialUser(SSOToken token, IdType type, String name) throws SSOException {
        boolean isSpecUser = false;
        if (type.equals(IdType.USER)) {
            try {
                if (this.userConfig == null) {
                    if (this.globalConfig == null) {
                        if (this.scm == null) {
                            this.scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
                        }
                        this.globalConfig = this.scm.getGlobalConfig(null);
                    }
                    this.userConfig = this.globalConfig.getSubConfig("users");
                }
                CaseInsensitiveHashSet userSet = new CaseInsensitiveHashSet();
                userSet.addAll(this.userConfig.getSubConfigNames());
                if (userSet != null && userSet.contains(name)) {
                    isSpecUser = true;
                }
            }
            catch (SMSException smse) {
                isSpecUser = false;
            }
        }
        return isSpecUser;
    }

    private void loadSupportedOps() {
        HashSet<IdOperation> opSet = new HashSet<IdOperation>();
        opSet.add(IdOperation.EDIT);
        opSet.add(IdOperation.READ);
        opSet.add(IdOperation.SERVICE);
        HashSet opSet2 = new HashSet(opSet);
        opSet2.remove(IdOperation.EDIT);
        opSet2.remove(IdOperation.SERVICE);
        this.supportedOps.put(IdType.USER, Collections.unmodifiableSet(opSet));
        if (this.debug.messageEnabled()) {
            this.debug.message("SpecialRepo: loadSupportedOps called supportedOps Map = " + this.supportedOps);
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        this.repoListener.allObjectsChanged();
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        this.repoListener.allObjectsChanged();
    }

    public void schemaChanged(String serviceName, String version) {
        this.repoListener.allObjectsChanged();
    }

    public String getFullyQualifiedName(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        RepoSearchResults results = this.search(token, type, name, null, true, 0, 0, null);
        Set dns = results.getSearchResults();
        if (dns.size() != 1) {
            Object[] args = new String[]{name};
            throw new IdRepoException("amIdRepo", "220", args);
        }
        return "sms://specialRepo/" + dns.iterator().next().toString();
    }

    public boolean supportsAuthentication() {
        return true;
    }

    public boolean authenticate(Callback[] credentials) throws IdRepoException, AuthLoginException {
        boolean answer;
        block7: {
            this.debug.message("SpecialRepo:authenticate called");
            String username = null;
            String password = null;
            for (int i = 0; i < credentials.length; ++i) {
                char[] passwd;
                if (credentials[i] instanceof NameCallback) {
                    username = ((NameCallback)credentials[i]).getName();
                    if (!this.debug.messageEnabled()) continue;
                    this.debug.message("SpecialRepo:authenticate username: " + username);
                    continue;
                }
                if (!(credentials[i] instanceof PasswordCallback) || (passwd = ((PasswordCallback)credentials[i]).getPassword()) == null) continue;
                password = new String(passwd);
                this.debug.message("SpecialRepo:authN passwd present");
            }
            if (username == null || password == null) {
                return false;
            }
            HashMap<String, String> sharedState = new HashMap<String, String>();
            sharedState.put("javax.security.auth.login.name", username);
            sharedState.put("javax.security.auth.login.password", password);
            this.debug.message("SpecialRepo:authenticate inst. SMSAuthModule");
            SMSAuthModule module = new SMSAuthModule();
            this.debug.message("SpecialRepo:authenticate SMSAuthModule:init");
            module.initialize(new AuthSubject(), null, sharedState, Collections.EMPTY_MAP);
            answer = false;
            try {
                answer = module.login();
                if (this.debug.messageEnabled()) {
                    this.debug.message("SpecialRepo:authenticate login: " + answer);
                }
            }
            catch (LoginException le) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("authentication: login exception", (Throwable)le);
                }
                if (!(le instanceof AuthLoginException)) break block7;
                throw (AuthLoginException)le;
            }
        }
        return answer;
    }
}

