/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.ldapv3;

import com.iplanet.sso.SSOToken;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo;
import com.sun.identity.idm.plugins.ldapv3.Request;
import com.sun.identity.shared.debug.Debug;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.controls.LDAPEntryChangeControl;
import netscape.ldap.controls.LDAPPersistSearchControl;
import netscape.ldap.factory.JSSESocketFactory;

public class LDAPv3EventService
implements Runnable {
    protected Map _requestList;
    Thread _monitorThread = null;
    LDAPSearchListener _msgQueue;
    private final int DEFAULTPORT = 389;
    private int connNumRetry = 3;
    private int connRetryInterval = 1000;
    private static final boolean CHANGES_ONLY = true;
    private static final boolean RETURN_CONTROLS = true;
    private static final boolean IS_CRITICAL = true;
    protected static Debug debugger = Debug.getInstance((String)"LDAPv3EventService");
    protected static final String EVENT_CONNECTION_NUM_RETRIES = "com.iplanet.am.event.connection.num.retries";
    protected static final String EVENT_CONNECTION_RETRY_INTERVAL = "com.iplanet.am.event.connection.delay.between.retries";
    protected static final String EVENT_CONNECTION_ERROR_CODES = "com.iplanet.am.event.connection.ldap.error.codes.retries";
    protected static final String EVENT_IDLE_TIMEOUT_INTERVAL = "com.sun.am.event.connection.idle.timeout";
    private static final String LDAPv3Config_LDAP_SERVER = "sun-idrepo-ldapv3-config-ldap-server";
    private static final String LDAPv3Config_LDAP_IDLETIMEOUT = "sun-idrepo-ldapv3-config-idletimeout";
    private static final String LDAPv3Config_LDAP_NUM_RETRIES = "sun-idrepo-ldapv3-config-numretires";
    private static final String LDAPv3Config_LDAP_RETRY_INTERVAL = "com.iplanet.am.ldap.connection.delay.between.retries";
    private static final String LDAPv3Config_LDAP_ERROR_CODES = "sun-idrepo-ldapv3-config-errorcodes";
    private static final String LDAPv3Config_LDAP_SSL_ENABLED = "sun-idrepo-ldapv3-config-ssl-enabled";
    private static final String LDAPv3Config_LDAP_PORT = "sun-idrepo-ldapv3-config-ldap-port";
    private static final String LDAPv3Config_AUTHID = "sun-idrepo-ldapv3-config-authid";
    private static final String LDAPv3Config_AUTHPW = "sun-idrepo-ldapv3-config-authpw";
    private static final String LDAPv3Config_LDAP_TIME_LIMIT = "sun-idrepo-ldapv3-config-time-limit";
    private static final String CLASS_NAME = "com.sun.identity.idm.plugins.ldapv3.LDAPv3EventService";
    private int _numRetries = 3;
    private int _retryInterval = 3000;
    protected HashSet _retryErrorCodes;
    protected int _idleTimeOut = 0;
    protected long _idleTimeOutMills;
    private boolean pSearchSupported = false;
    protected volatile boolean _shutdownCalled = false;
    int randomID = 0;
    private static final String ATTR_WHEN_CREATED = "whenCreated";
    private static final String ATTR_WHEN_CHANGED = "whenChanged";
    private static final String ATTR_IS_DELETED = "isDeleted";
    private static final String ATTR_OBJECT_GUID = "objectGUID";
    private static final String AD_NOTIFICATION_OID = "1.2.840.113556.1.4.528";
    private boolean adNotificationSupported = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPropertyIntValue(Map configParams, String key, int defaultValue) {
        int value = defaultValue;
        try {
            Map map = configParams;
            synchronized (map) {
                Set valueSet = (Set)configParams.get(key);
                if (valueSet != null && !valueSet.isEmpty()) {
                    value = Integer.parseInt((String)valueSet.iterator().next());
                }
            }
        }
        catch (NumberFormatException nfe) {
            value = defaultValue;
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.getPropertyIntValue(): " + key + " = " + value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPropertyStringValue(Map configParams, String key) {
        String value = null;
        Map map = configParams;
        synchronized (map) {
            Set valueSet = (Set)configParams.get(key);
            if (valueSet != null && !valueSet.isEmpty()) {
                value = (String)valueSet.iterator().next();
            } else {
                debugger.error("LDAPv3EventService.getPropertyStringValue failed:" + key);
            }
        }
        if (debugger.messageEnabled()) {
            if (!key.equals(LDAPv3Config_AUTHPW)) {
                debugger.message("LDAPv3EventService.getPropertyStringValue(): " + key + " = " + value);
            } else if (value == null || value.length() == 0) {
                debugger.message("LDAPv3EventService.getPropertyStringValue(): " + key + " = NULL or ZERO LENGTH");
            } else {
                debugger.message("LDAPv3EventService.getPropertyStringValue(): " + key + " = has value XXX");
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet getPropertyRetryErrorCodes(Map configParams, String key) {
        Set retryErrorSet;
        HashSet codes = new HashSet();
        Set set = retryErrorSet = (Set)configParams.get(key);
        synchronized (set) {
            Iterator itr = retryErrorSet.iterator();
            while (itr.hasNext()) {
                codes.add(itr.next());
            }
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.getPropertyRetryErrorCodes: " + key + "retryErrorSet=" + retryErrorSet + " ; codes=" + codes);
        }
        return codes;
    }

    protected LDAPv3EventService(Map pluginConfig, String serverNames) throws LDAPException {
        Random randomGen = new Random();
        this.randomID = randomGen.nextInt();
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.constructor. randomID=" + this.randomID);
        }
        this._idleTimeOut = this.getPropertyIntValue(pluginConfig, LDAPv3Config_LDAP_IDLETIMEOUT, this._idleTimeOut);
        this._idleTimeOutMills = this._idleTimeOut * 60000;
        this._numRetries = this.getPropertyIntValue(pluginConfig, LDAPv3Config_LDAP_NUM_RETRIES, this._numRetries);
        this._retryInterval = this.getPropertyIntValue(pluginConfig, LDAPv3Config_LDAP_RETRY_INTERVAL, this._retryInterval);
        this._retryErrorCodes = this.getPropertyRetryErrorCodes(pluginConfig, LDAPv3Config_LDAP_ERROR_CODES);
        this._requestList = Collections.synchronizedMap(new HashMap());
        LDAPConnection lc = null;
        try {
            lc = this.getConnection(pluginConfig, serverNames);
        }
        catch (LDAPException le) {
            debugger.error("EventService.constructor - Failed to connect to server. randomID=" + this.randomID, (Throwable)le);
            throw le;
        }
        for (int retry = 0; retry <= 3; ++retry) {
            try {
                this.checkSupportedControls(lc);
                break;
            }
            catch (LDAPException le) {
                debugger.error("EventService.constructor  retry=" + retry);
                debugger.error("EventService.constructor - Failed to determine if server supports control. randomID=" + this.randomID, (Throwable)le);
                if (retry == 3) {
                    throw le;
                }
                this.sleepRetryInterval();
                continue;
            }
        }
        lc.disconnect();
    }

    protected String getName() {
        return "LDAPv3EventService";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = this;
        synchronized (object) {
            this._shutdownCalled = true;
            if (this._monitorThread != null && this._monitorThread.isAlive()) {
                this._monitorThread.interrupt();
            }
        }
        object = this._requestList;
        synchronized (object) {
            Collection requestObjs = this._requestList.values();
            Iterator iter = requestObjs.iterator();
            while (iter.hasNext()) {
                Request request = (Request)iter.next();
                this.removeListener(request);
            }
            this._requestList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request findRequst(String psIdKey) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.findRequest: requestSize=" + this._requestList.size() + " psIdKey =" + psIdKey);
        }
        Request owner = null;
        Map map = this._requestList;
        synchronized (map) {
            Collection requestObjs = this._requestList.values();
            Iterator iter = requestObjs.iterator();
            while (iter.hasNext()) {
                Request request = (Request)iter.next();
                String tmpOwner = request.getPsIdKey();
                if (debugger.messageEnabled()) {
                    debugger.message("LDAPv3EventService.findRequest: tmpOwner =" + tmpOwner);
                }
                if (!tmpOwner.equalsIgnoreCase(psIdKey)) continue;
                owner = request;
                debugger.message("LDAPv3EventService.findRequest. found it");
                break;
            }
        }
        return owner;
    }

    public synchronized void removeListener(String psIdKey) {
        Request myRequest;
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.removeListener: psIdKey =" + psIdKey);
        }
        if ((myRequest = this.findRequst(psIdKey)) != null) {
            myRequest.setStopStatus(true);
            this._requestList.remove(myRequest);
            this.removeListener(myRequest);
            this.dispatchEventAllChanged(myRequest);
        }
    }

    public synchronized String addListener(SSOToken token, IdRepoListener listener, String base, int scope, String filter, int operations, Map pluginConfig, LDAPv3Repo pluginInstance, String serverNames, String psIdKey) throws LDAPException, IdRepoException {
        if (this._shutdownCalled) {
            debugger.error("LDAPv3EventService.addListener: unable to add listener after system is shutdown. randomID=" + this.randomID);
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "218", args);
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.addListener() - base =" + base + " filter =" + filter + "; psIdKey=" + psIdKey);
        }
        if (!this.pSearchSupported && !this.adNotificationSupported) {
            debugger.error("LDAPv3EventService.addListener: unable to determine if psearch or notification is supported. randomID=" + this.randomID);
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "218", args);
        }
        LDAPConnection lc = null;
        try {
            lc = this.getConnection(pluginConfig, serverNames);
        }
        catch (LDAPException le) {
            debugger.error("LDAPv3EventService.addListener: unable to connect to ldap server. randomID=" + this.randomID);
            throw le;
        }
        LDAPSearchConstraints cons = lc.getSearchConstraints();
        String[] attrs = null;
        if (this.pSearchSupported) {
            LDAPPersistSearchControl psearchCtrl = new LDAPPersistSearchControl(operations, true, true, true);
            cons.setServerControls((LDAPControl)psearchCtrl);
            attrs = new String[]{"objectclass"};
        } else {
            LDAPControl adCtrl = new LDAPControl(AD_NOTIFICATION_OID, true, new byte[0]);
            cons.setServerControls(adCtrl);
            attrs = new String[]{"objectclass", ATTR_WHEN_CREATED, ATTR_WHEN_CHANGED, ATTR_IS_DELETED, ATTR_OBJECT_GUID};
            if (filter == null) {
                debugger.error("LDAPv3EventService.addListener: Filter has to be (objectclass=*)");
                Object[] args = new Object[]{CLASS_NAME};
                throw new IdRepoException("amIdRepo", "218", args);
            }
        }
        cons.setBatchSize(1);
        LDAPSearchListener searchListener = null;
        try {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.addListener() - Submitting Persistent Search on: " + base + " for listener: " + listener + " scope=" + scope + " randomID=" + this.randomID + " serverNames=" + serverNames + " psIdKey=" + psIdKey);
            }
            searchListener = lc.search(base, scope, filter, attrs, false, null, cons);
        }
        catch (LDAPException le) {
            debugger.error("LDAPv3EventService.addListener() - Failed to set Persistent Search randomID=" + this.randomID + le.getMessage());
            throw le;
        }
        int[] outstandingRequests = searchListener.getMessageIDs();
        int id = outstandingRequests[outstandingRequests.length - 1];
        String reqID = Integer.toString(id);
        long startTime = System.currentTimeMillis();
        Request request = new Request(id, reqID, token, base, scope, filter, attrs, operations, listener, lc, startTime, pluginConfig, pluginInstance, serverNames, psIdKey);
        this._requestList.put(reqID, request);
        if (this._msgQueue == null) {
            this._msgQueue = searchListener;
        } else {
            this._msgQueue.merge(searchListener);
            if (debugger.messageEnabled()) {
                outstandingRequests = this._msgQueue.getMessageIDs();
                debugger.message("LDAPv3EventService.addListener(): merged Listener: requestID: " + reqID + " & Request: " + request + " on to message Queue. No. of current outstanding " + "requests = " + outstandingRequests.length + " randomID=" + this.randomID + " serverNames=" + serverNames + " psIdKey=" + psIdKey);
            }
        }
        if (this._monitorThread == null || !this._monitorThread.isAlive()) {
            this.startMonitorThread();
        } else if (this._requestList.size() == 1) {
            this.notify();
        }
        return reqID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.run(): Event Thread is running! No Idle timeout Set: " + this._idleTimeOut + " minutes." + " randomID=" + this.randomID);
            }
            boolean successState = true;
            LDAPMessage message = null;
            while (successState) {
                try {
                    if (debugger.messageEnabled()) {
                        debugger.message("LDAPv3EventService.run(): Waiting for response randomID=" + this.randomID);
                    }
                    message = this._msgQueue.getResponse();
                    LDAPv3EventService lDAPv3EventService = this;
                    synchronized (lDAPv3EventService) {
                        if (this._shutdownCalled) {
                            break;
                        }
                        if (message == null && this._requestList.isEmpty()) {
                            this.wait();
                            continue;
                        }
                        successState = this.processResponse(message);
                    }
                }
                catch (LDAPInterruptedException ex) {
                    if (this._shutdownCalled) {
                        break;
                    }
                    if (!debugger.warningEnabled()) continue;
                    debugger.warning("LDAPv3EventService.run() LDAPInterruptedException received:", (Throwable)ex);
                }
                catch (LDAPException ex) {
                    if (this._shutdownCalled) {
                        break;
                    }
                    int resultCode = ex.getLDAPResultCode();
                    if (debugger.warningEnabled()) {
                        debugger.warning("LDAPv3EventService.run() LDAPException received: randomID=" + this.randomID, (Throwable)ex);
                    }
                    if (this._retryErrorCodes.contains("" + resultCode)) {
                        this.resetErrorSearches(true);
                        continue;
                    }
                    this.processNetworkError((Exception)((Object)ex));
                }
            }
        }
        catch (InterruptedException ex) {
            if (!this._shutdownCalled && debugger.warningEnabled()) {
                debugger.warning("LDAPv3EventService.run(): Interrupted exception caught.", (Throwable)ex);
            }
        }
        catch (RuntimeException ex) {
            if (debugger.warningEnabled()) {
                debugger.warning("LDAPv3EventService.run(): Runtime exception caught.", (Throwable)ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (debugger.warningEnabled()) {
                debugger.warning("LDAPv3EventService.run(): Unknown exception caught.", (Throwable)ex);
            }
        }
        catch (Throwable t) {
            if (debugger.warningEnabled()) {
                debugger.warning("EventService.run(): Unknown exception caught. Sleeping for a while.. ", t);
            }
            throw new Error(t);
        }
        finally {
            LDAPv3EventService ex = this;
            synchronized (ex) {
                if (!this._shutdownCalled) {
                    this._monitorThread = null;
                    this.startMonitorThread();
                }
            }
        }
    }

    private synchronized void startMonitorThread() {
        if (this._monitorThread == null || !this._monitorThread.isAlive() && !this._shutdownCalled) {
            this._monitorThread = new Thread((Runnable)this, this.getName());
            this._monitorThread.start();
        }
    }

    protected boolean processResponse(LDAPMessage message) {
        if (message == null && !this._requestList.isEmpty()) {
            debugger.warning("EventService.processResponse() - Received a NULL Response. Attempting to re-start persistent searches");
            this.resetErrorSearches(false);
            return true;
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processResponse() - received DS message  => " + message.toString() + " randomID=" + this.randomID);
        }
        boolean successState = true;
        Request request = this.getRequestEntry(message.getMessageID());
        if (request == null) {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.processResponse() - Received ldap message with unknown id = " + message.getMessageID() + " randomID=" + this.randomID);
            }
        } else if (message instanceof LDAPSearchResult) {
            this.processSearchResultMessage((LDAPSearchResult)message, request);
            request.setLastUpdatedTime(System.currentTimeMillis());
        } else if (message instanceof LDAPResponse) {
            LDAPResponse rsp = (LDAPResponse)message;
            successState = this.processResponseMessage(rsp, request);
        } else if (message instanceof LDAPSearchResultReference) {
            this.processSearchResultRef((LDAPSearchResultReference)message, request);
        }
        return successState;
    }

    protected void removeListener(Request request) {
        block6: {
            LDAPConnection connection;
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.removeListener: _requestList.size()=" + this._requestList.size());
            }
            if ((connection = request.getLDAPConnection()) != null) {
                if (debugger.messageEnabled()) {
                    debugger.message("LDAPv3EventService.removeListener(): Removing listener requestID: " + request.getRequestID() + " Listener: " + request.getListener() + " randomID=" + this.randomID + " serverNames=" + request.getServerNames());
                }
                try {
                    if (connection != null && connection.isConnected()) {
                        connection.abandon(request.getId());
                        connection.disconnect();
                    }
                }
                catch (LDAPException le) {
                    if (!debugger.warningEnabled()) break block6;
                    debugger.warning("LDAPv3EventService.removeListener(): LDAPException, when trying to remove listener randomID=" + this.randomID, (Throwable)le);
                }
            }
        }
    }

    protected void resetErrorSearches(boolean clearCaches) {
        Hashtable tmpReqList = new Hashtable(this._requestList);
        int[] ids = this._msgQueue.getMessageIDs();
        for (int i = 0; i < ids.length; ++i) {
            String reqID = Integer.toString(ids[i]);
            tmpReqList.remove(reqID);
        }
        Collection reqList = tmpReqList.values();
        Iterator iter = reqList.iterator();
        while (iter.hasNext()) {
            Request req = (Request)iter.next();
            this._requestList.remove(req.getRequestID());
            if (!clearCaches) continue;
            String psIdKey = req.getPsIdKey();
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.dispatchAllEntriesChangedEvent()  psIdKey=" + psIdKey);
            }
            LDAPv3Repo.objectChanged(null, 4, req, psIdKey, true, true);
        }
        RetryTask task = new RetryTask(tmpReqList, this._numRetries);
        SystemTimer.getTimer().schedule((TaskRunnable)task, new Date((System.currentTimeMillis() + (long)this._retryInterval) / 1000L * 1000L));
    }

    protected synchronized boolean resetAllSearches(boolean clearCaches) {
        Iterator iter;
        boolean doItAgain;
        if (this._shutdownCalled) {
            return false;
        }
        Hashtable tmpReqList = new Hashtable(this._requestList);
        this._requestList.clear();
        Collection reqList = tmpReqList.values();
        int retry = 1;
        boolean bl = doItAgain = this._numRetries == -1 || this._numRetries != 0 && retry <= this._numRetries;
        if (clearCaches) {
            iter = reqList.iterator();
            while (iter.hasNext()) {
                Request req = (Request)iter.next();
                String psIdKey = req.getPsIdKey();
                if (debugger.messageEnabled()) {
                    debugger.message("LDAPv3EventService.dispatchAllEntriesChangedEvent()  psIdKey=" + psIdKey);
                }
                LDAPv3Repo.objectChanged(null, 4, req, psIdKey, true, true);
            }
        }
        while (doItAgain) {
            this.sleepRetryInterval();
            if (debugger.messageEnabled()) {
                String str = this._numRetries == -1 ? "indefinitely" : Integer.toString(retry);
                debugger.message("LDAPv3EventService.resetAllSearches(): retrying = " + str + " randomID=" + this.randomID);
            }
            iter = reqList.iterator();
            while (iter.hasNext()) {
                try {
                    Request request = (Request)iter.next();
                    if (!request.getStopStatus()) {
                        this.removeListener(request);
                        this.addListener(request.getRequester(), request.getListener(), request.getBaseDn(), request.getScope(), request.getFilter(), request.getOperations(), request.getPluginConfig(), request.getOwner(), request.getServerNames(), request.getPsIdKey());
                    }
                    iter.remove();
                }
                catch (LDAPException le) {
                    if (retry != this._numRetries) continue;
                    this.processNetworkError((Exception)((Object)le));
                }
                catch (IdRepoException ide) {
                    if (retry != this._numRetries) continue;
                    this.processNetworkError(ide);
                }
            }
            if (reqList.isEmpty()) {
                return true;
            }
            if (this._numRetries == -1 || (doItAgain = ++retry <= this._numRetries)) continue;
            iter = reqList.iterator();
            while (iter.hasNext()) {
                this.removeListener((Request)iter.next());
            }
        }
        if (debugger.warningEnabled()) {
            debugger.warning("LDAPv3EventService.resetAllSearches exit: _requestList.size()=" + this._requestList.size());
        }
        return false;
    }

    protected void sleepRetryInterval() {
        try {
            Thread.sleep(this._retryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void dispatchException(Exception e, Request request) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.dispatchException() - dispatching exception to the listener: " + request.getRequestID() + " Listener: " + request.getListener() + " randomID=" + this.randomID + " serverNames=" + request.getServerNames(), (Throwable)e);
        }
    }

    private void dispatchEventAllChanged(Request request) {
        String psIdKey = request.getPsIdKey();
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.dispatchEventAllChanged()  psIdKey=" + psIdKey);
        }
        LDAPv3Repo.objectChanged(null, 4, request, psIdKey, true, true);
    }

    private void dispatchEvent(String dn, int changeType, Request request) {
        String psIdKey = request.getPsIdKey();
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.dispatchEvent() - dn=" + dn + " changeType=" + changeType + "; psIdKey=" + psIdKey);
        }
        LDAPv3Repo.objectChanged(dn, changeType, request, psIdKey, false, false);
    }

    protected void processNetworkError(Exception ex) {
        Hashtable tmpRequestList = new Hashtable(this._requestList);
        int[] ids = this._msgQueue.getMessageIDs();
        for (int i = 0; i < ids.length; ++i) {
            tmpRequestList.remove(Integer.toString(ids[i]));
        }
        Collection reqList = tmpRequestList.values();
        Iterator iter = reqList.iterator();
        while (iter.hasNext()) {
            Request request = (Request)iter.next();
            this.dispatchException(ex, request);
        }
    }

    protected boolean processResponseMessage(LDAPResponse rsp, Request request) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processResponseMessage().entry - request=" + request + " rsp=" + rsp);
        }
        boolean successState = true;
        if (this._retryErrorCodes.contains("" + rsp.getResultCode())) {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.processResponseMessage() - received LDAP Response for requestID: " + request.getRequestID() + " Listener: " + request.getListener() + "Need restarting" + " randomID=" + this.randomID + " serverNames=" + request.getServerNames());
            }
            this.resetErrorSearches(false);
        } else if (rsp.getResultCode() != 0 || rsp.getResultCode() != 10) {
            LDAPException ex = new LDAPException("Error result", rsp.getResultCode(), rsp.getErrorMessage(), rsp.getMatchedDN());
            this.dispatchException((Exception)((Object)ex), request);
            if (rsp.getResultCode() == 50) {
                successState = false;
            }
        } else {
            this.sleepRetryInterval();
        }
        return successState;
    }

    protected void processSearchResultMessage(LDAPSearchResult res, Request req) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processSearchResultMessage().entry res=" + res + " req=" + req);
        }
        LDAPEntry modEntry = res.getEntry();
        LDAPAttributeSet findAttrs = modEntry.getAttributeSet();
        Enumeration enumAttrs = findAttrs.getAttributes();
        while (enumAttrs.hasMoreElements()) {
            LDAPAttribute anAttr = (LDAPAttribute)enumAttrs.nextElement();
            Enumeration enumVals = anAttr.getStringValues();
            while (enumVals.hasMoreElements()) {
                enumVals.nextElement();
            }
        }
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processSearchResultMessage() - Changed " + modEntry.getDN() + " randomID=" + this.randomID);
        }
        if (this.pSearchSupported) {
            LDAPControl[] ctrls = res.getControls();
            if (ctrls == null) {
                Exception ex = new Exception("LDAPv3EventService - Cannot create NamingEvent, no change control info");
                this.dispatchException(ex, req);
            } else {
                for (int i = 0; i < ctrls.length; ++i) {
                    LDAPEntryChangeControl changeCtrl = null;
                    if (!(ctrls[i] instanceof LDAPEntryChangeControl)) continue;
                    changeCtrl = (LDAPEntryChangeControl)ctrls[i];
                    if (debugger.messageEnabled()) {
                        debugger.message("LDAPv3EventService.processSearchResultMessage() changeCtrl = " + changeCtrl.toString() + " randomID=" + this.randomID);
                    }
                    if (changeCtrl.getChangeType() == -1) {
                        Exception ex = new Exception("LDAPv3EventService - Cannot create NamingEvent, no change control info");
                        this.dispatchException(ex, req);
                    }
                    try {
                        this.dispatchEvent(modEntry.getDN(), changeCtrl.getChangeType(), req);
                        continue;
                    }
                    catch (Exception ex) {
                        this.dispatchException(ex, req);
                    }
                }
            }
        } else {
            try {
                this.createDSEventAD(modEntry, req);
            }
            catch (Exception ex) {
                this.dispatchException(ex, req);
            }
        }
    }

    protected void processSearchResultRef(LDAPSearchResultReference ref, Request req) {
        if (debugger.messageEnabled()) {
            debugger.message("LDAPv3EventService.processSearchResultRef() - Ignoring.. randomID=" + this.randomID);
        }
    }

    protected Request getRequestEntry(int id) {
        return (Request)this._requestList.get(Integer.toString(id));
    }

    private LDAPConnection getConnection(Map pluginConfig, String serverNames) throws LDAPException {
        LDAPConnection conn = null;
        String ssl = this.getPropertyStringValue(pluginConfig, LDAPv3Config_LDAP_SSL_ENABLED);
        if (debugger.messageEnabled()) {
            debugger.message("    LDAPv3Config_LDAP_SERVER: serverNames" + serverNames);
        }
        int ldapPort = 389;
        String authid = this.getPropertyStringValue(pluginConfig, LDAPv3Config_AUTHID);
        String authpw = this.getPropertyStringValue(pluginConfig, LDAPv3Config_AUTHPW);
        if (ssl != null && ssl.equalsIgnoreCase("true")) {
            try {
                conn = new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null));
            }
            catch (Exception e) {
                debugger.error("LDAPv3EventService.getConnection.JSSESocketFactory randomID=" + this.randomID, (Throwable)e);
                int errorCode = 1;
                throw new LDAPException(e.getMessage(), errorCode);
            }
        } else {
            conn = new LDAPConnection();
        }
        int timeLimit = this.getPropertyIntValue(pluginConfig, LDAPv3Config_LDAP_TIME_LIMIT, 3);
        int retry = 0;
        while (retry <= this.connNumRetry) {
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.GetConnection retry: " + retry + " randomID=" + this.randomID);
            }
            try {
                conn.setOption(17, (Object)new Integer(3));
                conn.setOption(4, (Object)new Integer(0));
                conn.setOption(3, (Object)new Integer(0));
                LDAPSearchConstraints constraints = conn.getSearchConstraints();
                conn.setSearchConstraints(constraints);
                if (timeLimit > 0) {
                    conn.setConnectTimeout(timeLimit);
                } else {
                    conn.setConnectTimeout(3);
                }
                if (authid != null && authpw != null) {
                    conn.connect(3, serverNames, ldapPort, authid, authpw);
                } else {
                    conn.setOption(17, (Object)new Integer(3));
                    conn.connect(serverNames, ldapPort);
                }
                constraints = conn.getSearchConstraints();
                constraints.setServerTimeLimit(0);
                conn.setSearchConstraints(constraints);
                conn.setOption(3, (Object)new Integer(0));
                break;
            }
            catch (LDAPException e) {
                try {
                    conn.disconnect();
                }
                catch (LDAPException lde) {
                    debugger.message("LDAPv3EventService disconnct  excection: " + lde.getLDAPResultCode());
                }
                if (!this._retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == this.connNumRetry) {
                    debugger.error("LDAPv3EventService.Connection to LDAP server threw exception:  randomID=" + this.randomID, (Throwable)e);
                    throw e;
                }
                ++retry;
                try {
                    Thread.sleep(this.connRetryInterval);
                }
                catch (InterruptedException ex) {}
            }
        }
        return conn;
    }

    private void checkSupportedControls(LDAPConnection conn) throws LDAPException {
        String _FILT = "(objectclass=*)";
        String _BASE = "";
        String[] _ATTRS = new String[]{"supportedControl"};
        boolean ProxiedAuthSupported = false;
        LDAPSearchResults res = null;
        String PERSISTENT_SEARCH_CONTROL_OID = "2.16.840.1.113730.3.4.3";
        String PROXIED_AUTH_CONTROL_OID = "2.16.840.1.113730.3.4.12";
        try {
            res = conn.search(_BASE, 0, _FILT, _ATTRS, false);
        }
        catch (LDAPException le) {
            debugger.error("LDAPv3EventService().CheckSupportedControls() - Error encountered while checking for supported controls randomID=" + this.randomID);
            throw le;
        }
        while (res.hasMoreElements()) {
            LDAPEntry findEntry = (LDAPEntry)res.nextElement();
            LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
            Enumeration enumAttrs = findAttrs.getAttributes();
            if (debugger.messageEnabled()) {
                debugger.message("LDAPv3EventService.checkSupportedControls: findAttrs:" + findAttrs + "; enumAttrs:" + enumAttrs);
            }
            while (enumAttrs.hasMoreElements()) {
                LDAPAttribute anAttr = (LDAPAttribute)enumAttrs.nextElement();
                String attrName = anAttr.getName();
                Enumeration enumVals = anAttr.getStringValues();
                if (debugger.messageEnabled()) {
                    debugger.message("   inside while: attrName:" + attrName + "; enumVals: " + enumVals);
                }
                while (enumVals.hasMoreElements()) {
                    String aVal = (String)enumVals.nextElement();
                    if (debugger.messageEnabled()) {
                        debugger.message("   inside inside:  aVal:" + aVal);
                    }
                    if (aVal.equals("2.16.840.1.113730.3.4.3")) {
                        this.pSearchSupported = true;
                        continue;
                    }
                    if (aVal.equals(AD_NOTIFICATION_OID)) {
                        this.adNotificationSupported = true;
                        continue;
                    }
                    if (!aVal.equals("2.16.840.1.113730.3.4.12")) continue;
                    ProxiedAuthSupported = true;
                }
            }
        }
        if (debugger.messageEnabled()) {
            debugger.message("EventService.checkSupportedControls: pSearchSupported = " + this.pSearchSupported + ", adNotificationSupported = " + this.adNotificationSupported + " randomID=" + this.randomID);
        }
    }

    public boolean persistentSearchSupported() {
        return this.pSearchSupported;
    }

    public boolean ADNotificationSupported() {
        return this.adNotificationSupported;
    }

    private void createDSEventAD(LDAPEntry entry, Request req) throws LDAPException {
        int op;
        if (debugger.messageEnabled()) {
            debugger.message("EventService.createDSEventAD - entry = " + entry);
            debugger.message("EventService.createDSEventAD - Event Requestor = " + req.getRequester() + " randomID=" + this.randomID);
        }
        LDAPAttribute attr = entry.getAttribute(ATTR_IS_DELETED);
        boolean isDeleted = false;
        if (attr != null && attr.size() == 1) {
            isDeleted = attr.getStringValueArray()[0].equalsIgnoreCase("true");
        }
        if (isDeleted) {
            op = 2;
        } else {
            attr = entry.getAttribute(ATTR_WHEN_CREATED);
            if (attr == null || attr.size() == 0) {
                if (debugger.warningEnabled()) {
                    debugger.warning("EventService.createDSEventAD: missing attribute 'whenCreated' randomID=" + this.randomID);
                }
                return;
            }
            String whenCreated = attr.getStringValueArray()[0];
            attr = entry.getAttribute(ATTR_WHEN_CHANGED);
            if (attr == null || attr.size() == 0) {
                if (debugger.warningEnabled()) {
                    debugger.warning("EventService.createDSEventAD: missing attribute 'whenChanged' randomID=" + this.randomID);
                }
                return;
            }
            String whenChanged = attr.getStringValueArray()[0];
            op = whenCreated.equals(whenChanged) ? 1 : 4;
        }
        if ((op & req.getOperations()) == 0) {
            return;
        }
        if (op != 2) {
            this.dispatchEvent(entry.getDN(), op, req);
        } else {
            this.dispatchEventAllChanged(req);
        }
    }

    class RetryTask
    extends GeneralTaskRunnable {
        private long runPeriod;
        private Map requests;
        private int numOfRetries;
        private int retry;

        public RetryTask(Map requests, int numOfRetries) {
            this.runPeriod = LDAPv3EventService.this._retryInterval;
            this.requests = requests;
            this.numOfRetries = numOfRetries;
            this.retry = 1;
        }

        public void run() {
            Iterator iter = this.requests.values().iterator();
            while (iter.hasNext()) {
                Request req = (Request)iter.next();
                try {
                    if (!req.getStopStatus()) {
                        LDAPv3EventService.this.removeListener(req);
                        LDAPv3EventService.this.addListener(req.getRequester(), req.getListener(), req.getBaseDn(), req.getScope(), req.getFilter(), req.getOperations(), req.getPluginConfig(), req.getOwner(), req.getServerNames(), req.getPsIdKey());
                    }
                    iter.remove();
                }
                catch (Exception e) {
                    if (this.retry != this.numOfRetries) continue;
                    LDAPv3EventService.this.dispatchException(e, req);
                }
            }
            if (this.requests.isEmpty()) {
                this.runPeriod = -1L;
            } else if (this.numOfRetries != -1 && ++this.retry > this.numOfRetries) {
                this.runPeriod = -1L;
            }
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }
    }
}

