/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.factory.JSSESocketFactory;

public class LDAPConnectionPools {
    private static HashMap connectionPools = new HashMap();
    private static final int MIN_CONNECTION_POOL_SIZE = 1;
    private static final int MAX_CONNECTION_POOL_SIZE = 10;
    private static final int DEFAULT_PORT = 389;
    private static Debug debug = Debug.getInstance((String)"amPolicy");

    private LDAPConnectionPools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initConnectionPool(String host, String authDN, String authPasswd, boolean ssl, int minPoolSize, int maxPoolSize) throws PolicyException {
        if (host.length() < 1) {
            debug.message("Invalid host name");
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        LDAPConnectionPool cPool = null;
        try {
            HashMap hashMap = connectionPools;
            synchronized (hashMap) {
                cPool = (LDAPConnectionPool)connectionPools.get(host);
                if (cPool == null) {
                    if (debug.messageEnabled()) {
                        debug.message("Create LDAPConnectionPool: " + host);
                    }
                    LDAPConnection ldc = ssl ? new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null)) : new LDAPConnection();
                    ldc.setOption(17, (Object)new Integer(3));
                    ldc.connect(host, 389, authDN, authPasswd);
                    if (minPoolSize < 1) {
                        minPoolSize = 1;
                    }
                    if (maxPoolSize < 1) {
                        maxPoolSize = 10;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("LDAPConnectionPools.initConnectionPool(): minPoolSize=" + minPoolSize + ", maxPoolSize=" + maxPoolSize);
                    }
                    cPool = new LDAPConnectionPool(host + "-Policy", minPoolSize, maxPoolSize, ldc);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPConnectionPools.initConnectionPool(): host: " + host);
                    }
                    final LDAPConnectionPool finalPool = cPool;
                    ShutdownManager.getInstance().addShutdownListener(new ShutdownListener(){

                        public void shutdown() {
                            if (finalPool != null) {
                                finalPool.destroy();
                            }
                        }
                    });
                    connectionPools.put(host, cPool);
                }
            }
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("Unable to create LDAPConnectionPool", (Throwable)e);
            }
            throw new PolicyException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LDAPConnectionPool getConnectionPool(String host) {
        if (debug.messageEnabled()) {
            debug.message("LDAPConnectionPools.getConnectionPool(): host: " + host);
        }
        HashMap hashMap = connectionPools;
        synchronized (hashMap) {
            return (LDAPConnectionPool)connectionPools.get(host);
        }
    }
}

