/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;

public class PolicyChangeNotification {
    static final String SERVICE_NAME = "serviceName";
    static final String POLICY_CHANGE_TYPE = "type";
    static final String RESOURCE_NAME = "ResourceName";
    static final String ADDED = "added";
    static final String MODIFIED = "modified";
    static final String DELETED = "deleted";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private String serviceName;
    private String changeType = "modified";
    private Set resourceNames = null;

    PolicyChangeNotification() {
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String sn) {
        this.serviceName = sn;
    }

    public String getPolicyChangeType() {
        return this.changeType;
    }

    public void setPolicyChangeType(String type) {
        this.changeType = type;
    }

    public Set getResourceNames() {
        return this.resourceNames;
    }

    void setResourceNames(Set names) {
        this.resourceNames = names;
    }

    public static PolicyChangeNotification parseXML(Node pNode) throws PolicyEvaluationException {
        PolicyChangeNotification pcn = new PolicyChangeNotification();
        String attr = XMLUtils.getNodeAttributeValue((Node)pNode, (String)SERVICE_NAME);
        if (attr == null) {
            debug.error("PolicyChangeNotification: missing attribute serviceName");
            Object[] objs = new String[]{SERVICE_NAME};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        pcn.setServiceName(attr);
        attr = XMLUtils.getNodeAttributeValue((Node)pNode, (String)POLICY_CHANGE_TYPE);
        if (attr == null) {
            debug.error("PolicyChangeNotification: missing attribute type");
            Object[] objs = new String[]{POLICY_CHANGE_TYPE};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        pcn.setPolicyChangeType(attr);
        Set nodeSet = XMLUtils.getChildNodes((Node)pNode, (String)RESOURCE_NAME);
        if (nodeSet == null) {
            if (debug.messageEnabled()) {
                debug.message("PolicyChangeNotification.parseXML:  no resource name specified");
            }
            return pcn;
        }
        HashSet<String> resNames = new HashSet<String>();
        Iterator nodes = nodeSet.iterator();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            String name = XMLUtils.getValueOfValueNode((Node)node);
            if (name == null) continue;
            resNames.add(name);
        }
        pcn.setResourceNames(resNames);
        return pcn;
    }

    public String toXMLString() {
        StringBuffer xmlsb = new StringBuffer(200);
        xmlsb.append("<").append("PolicyChangeNotification").append(" ");
        xmlsb.append(SERVICE_NAME).append("=\"").append(this.serviceName).append("\" ");
        xmlsb.append(POLICY_CHANGE_TYPE).append("=\"").append(this.changeType).append("\">").append(CRLF);
        if (this.resourceNames != null) {
            Iterator iter = this.resourceNames.iterator();
            while (iter.hasNext()) {
                String resName = (String)iter.next();
                xmlsb.append("<").append(RESOURCE_NAME).append(">");
                xmlsb.append(XMLUtils.escapeSpecialCharacters((String)resName));
                xmlsb.append("</").append(RESOURCE_NAME).append(">").append(CRLF);
            }
        }
        xmlsb.append("</").append("PolicyChangeNotification").append(">").append(CRLF);
        return xmlsb.toString();
    }
}

