/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.GetBackendDataStore;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceManager;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class SMSEntry
implements Cloneable {
    public static final String ORGANIZATION_RDN = "o";
    public static final String EQUALS = "=";
    static final String ORG_PLACEHOLDER_RDN = "o=";
    public static final String SERVICES_NODE = "services";
    public static final String PLACEHOLDER_RDN = "ou";
    public static final String SERVICES_RDN = "ou=services";
    public static final String COMMA = ",";
    public static Debug debug = Debug.getInstance((String)"amSMS");
    public static Debug eventDebug = Debug.getInstance((String)"amSMSEvent");
    public static SSOTokenManager tm;
    private static Cache cache;
    static String GLOBAL_CACHE_PROPERTY;
    static String SM_CACHE_PROPERTY;
    static final String AGENTGROUP_RDN = "ou=agentgroup,ou=Instances";
    public static String DATASTORE_FLAT_FILE;
    public static String DATASTORE_SUN_DIR;
    public static String DATASTORE_ACTIVE_DIR;
    static boolean cacheSMSEntries;
    public static ResourceBundle bundle;
    static String baseDN;
    static String dataStore;
    static String amsdkbaseDN;
    static int baseDNCount;
    static SMSException initializationException;
    static final String SMS_OBJECT_PROPERTY = "com.sun.identity.sm.sms_object_class_name";
    static final String DEFAULT_SMS_CLASS_NAME = "com.sun.identity.sm.ldap.SMSLdapObject";
    static final String JAXRPC_SMS_CLASS_NAME = "com.sun.identity.sm.jaxrpc.SMSJAXRPCObject";
    static final String FLATFILE_SMS_CLASS_NAME = "com.sun.identity.sm.flatfile.SMSEnhancedFlatFileObject";
    public static final String SMS_ENABLE_DB_NOTIFICATION = "com.sun.identity.sm.enableDataStoreNotification";
    public static final String DB_PROXY_ENABLE = "com.sun.identity.sm.ldap.enableProxy";
    static SMSObject smsObject;
    static final String SLASH_STR = "/";
    static final String DOT_STR = ".";
    public static final String EXPORTEDARGS = "exportedTo";
    public static final String IMPORTEDARGS = "importedFrom";
    static final String AUTH_SUPER_USER = "com.sun.identity.authentication.super.user";
    static final String READ = "READ";
    static final String MODIFY = "MODIFY";
    static Set specialUserSet;
    static Set readActionSet;
    static Set modifyActionSet;
    static DelegationEvaluator dlgEval;
    static boolean SMSJAXRPCObjectFlg;
    static boolean backendProxyEnabled;
    static SSOToken adminSSOToken;
    static CaseInsensitiveHashSet mCaseSensitiveAttributes;
    static Set changeListeners;
    static List localChanges;
    static int LOCAL_CHANGES_MAX_SIZE;
    static boolean enableDataStoreNotification;
    private SSOToken ssoToken;
    protected String dn;
    protected String normalizedDN;
    private boolean newEntry;
    private boolean readOnly;
    private Map attrSet;
    private Set modSet;
    public static final String DC_RDN = "dc";
    public static final String DEFAULT_RDN = "ou=default";
    static final String DELEGATION_SERVICES_RDN = "ou=services,";
    static final String DELEGATION_SERVICES_RDN_WITH_COMMA = ",ou=services,";
    static final int DELEGATION_SERVICES_RDN_WITH_COMMA_LEN;
    static final int ORG_UNIT_OBJECT = 1;
    static final int SERVICE_OBJECT = 2;
    static final int SERVICE_COMP_OBJECT = 3;
    public static final String ATTR_SCHEMA = "sunServiceSchema";
    public static final String ATTR_PLUGIN_SCHEMA = "sunPluginSchema";
    public static final String ATTR_KEYVAL = "sunKeyValue";
    public static final String ATTR_XML_KEYVAL = "sunxmlKeyValue";
    public static final String ATTR_OBJECTCLASS = "objectclass";
    public static final String ATTR_PRIORITY = "sunsmspriority";
    public static final String ATTR_SERVICE_ID = "sunserviceID";
    public static final String ATTR_LABELED_URI = "labeledURI";
    public static final String ATTR_MODIFY_TIMESTAMP = "modifytimestamp";
    public static final String[] SMS_ATTRIBUTES;
    public static final String OC_TOP = "top";
    public static final String OC_ORG_UNIT = "organizationalunit";
    public static final String OC_SERVICE = "sunService";
    public static final String OC_REALM_SERVICE = "sunRealmService";
    public static final String OC_SERVICE_COMP = "sunServiceComponent";
    public static final String SMS_SERVER_GROUP = "sms";
    public static final String SUN_INTERNAL_REALM_NAME = "sunamhiddenrealm";
    public static final String SUN_INTERNAL_REALM_PREFIX = "o=sunamhiddenrealm";
    public static final String REALM_SERVICE = "sunAMRealmService";
    protected static final String FILTER_PATTERN_ALL = "(&(&(objectclass=top)(ou={0}))(&(objectclass=top)(sunserviceID={1})))";
    protected static final String FILTER_PATTERN = "(&(objectclass=top)(ou={0}))";
    protected static final String FILTER_PATTERN_SERVICE = "(&(objectclass=sunService)(ou={0})(ou={1}))";
    public static final String FILTER_SERVICE_COMPONENTS = "(|(objectclass=sunService)(objectclass=sunServiceComponent))";

    public static void initializeClass() {
        String enable;
        String proxy = SystemProperties.get(DB_PROXY_ENABLE);
        backendProxyEnabled = proxy != null && proxy.equalsIgnoreCase("true");
        String cacheEnabled = System.getProperty(GLOBAL_CACHE_PROPERTY, SystemProperties.get(GLOBAL_CACHE_PROPERTY, "true"));
        if (cacheEnabled.equalsIgnoreCase("true")) {
            cacheSMSEntries = true;
        } else {
            cacheEnabled = SystemProperties.get(SM_CACHE_PROPERTY);
            boolean bl = cacheSMSEntries = cacheEnabled != null && cacheEnabled.equalsIgnoreCase("true");
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: cache enabled: " + cacheSMSEntries);
        }
        boolean bl = enableDataStoreNotification = (enable = SystemProperties.get(SMS_ENABLE_DB_NOTIFICATION)) != null && enable.equalsIgnoreCase("true");
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: DN notification enabled: " + enableDataStoreNotification);
        }
        SMSEntry.initSMSObject();
        String adminUser = SystemProperties.get(AUTH_SUPER_USER, "");
        if (adminUser != null && adminUser.length() != 0) {
            specialUserSet.add(new DN(adminUser).toRFCString().toLowerCase());
        }
        if (SystemProperties.isServerMode()) {
            adminUser = AdminUtils.getAdminDN();
            if (adminUser != null && adminUser.length() != 0) {
                specialUserSet.add(new DN(adminUser).toRFCString().toLowerCase());
            }
        } else {
            try {
                SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                String name = new DN(adminToken.getPrincipal().getName()).toRFCString();
                specialUserSet.add(name.toLowerCase());
            }
            catch (SSOException e) {
                debug.error("SMSEntry.initializeClass", (Throwable)((Object)e));
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Special User Set: " + specialUserSet);
        }
    }

    private static void initSMSObject() {
        String temp;
        String smsClassName = SystemProperties.get(SMS_OBJECT_PROPERTY, DEFAULT_SMS_CLASS_NAME);
        Object[] args = new Object[]{smsClassName};
        try {
            tm = SSOTokenManager.getInstance();
            Class<?> smsEntryClass = Class.forName(smsClassName);
            smsObject = (SMSObject)smsEntryClass.newInstance();
            if (smsClassName.equals(JAXRPC_SMS_CLASS_NAME)) {
                SMSJAXRPCObjectFlg = true;
            }
            if (debug.messageEnabled()) {
                debug.message("Using SMS object class " + smsClassName);
            }
        }
        catch (ClassNotFoundException cfe) {
            if (debug.warningEnabled()) {
                debug.warning("SMSObject class not found: " + smsClassName);
            }
            initializationException = new SMSException(cfe, "sms-init-no-class-found");
        }
        catch (Exception e) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: error in instantiation of: " + smsClassName + " Message: " + e.getMessage());
            }
            initializationException = new SMSException(e, "sms-instantiation-failed");
        }
        if (smsObject == null) {
            try {
                if (smsClassName.equals(DEFAULT_SMS_CLASS_NAME)) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSEntry: Using default JAXRPC implementation");
                    }
                    smsObject = (SMSObject)Class.forName(JAXRPC_SMS_CLASS_NAME).newInstance();
                    SMSJAXRPCObjectFlg = true;
                } else if (smsClassName.equals(JAXRPC_SMS_CLASS_NAME)) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSEntry: Using default JAXRPC implementation");
                    }
                    smsObject = (SMSObject)Class.forName(JAXRPC_SMS_CLASS_NAME).newInstance();
                    SMSJAXRPCObjectFlg = true;
                } else if (smsClassName.equals(FLATFILE_SMS_CLASS_NAME)) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSEntry: Using default FlatFile implementation");
                    }
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("SMSEntry: Using default LDAP implementation");
                    }
                    smsObject = (SMSObject)Class.forName(DEFAULT_SMS_CLASS_NAME).newInstance();
                }
                initializationException = null;
            }
            catch (Exception fe) {
                debug.error("SMSEntry: Error in getting configured/default SMSObject", (Throwable)initializationException);
                debug.error("SMSEntry: Error in getting backupSMSObject", (Throwable)fe);
            }
        }
        if ((baseDN = (temp = smsObject.getRootSuffix()) != null ? new DN(temp).toRFCString().toLowerCase() : "o=unknown-suffix") == null) {
            initializationException = new SMSException(bundle.getString("sms-invalid-dn"), "sms-invalid-dn");
        } else {
            baseDNCount = new StringTokenizer(baseDN, COMMA).countTokens();
        }
        String atemp = null;
        if (SMSJAXRPCObjectFlg) {
            boolean checkForJAXRPCVersion = false;
            try {
                SSOToken appToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                Map versionMap = smsObject.read(appToken, "o=AM_JAXRPC_VERSION");
                if (versionMap == null) {
                    checkForJAXRPCVersion = true;
                } else {
                    String verStr = (String)versionMap.get("AM_JAXRPC_VERSION");
                    if (verStr != null && verStr.length() > 0) {
                        int version = Integer.valueOf(verStr);
                        checkForJAXRPCVersion = version > 10;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                debug.warning("SMSEntry:<init>.", (Throwable)nfe);
            }
            catch (SSOException ssoe) {
                debug.warning("SMSEntry:<init>.", (Throwable)((Object)ssoe));
            }
            catch (SMSException e) {
                debug.warning("SMSEntry:<init>.", (Throwable)e);
            }
            atemp = checkForJAXRPCVersion ? smsObject.getAMSdkBaseDN() : baseDN;
        } else {
            atemp = smsObject.getAMSdkBaseDN();
        }
        amsdkbaseDN = atemp != null ? new DN(atemp).toRFCString().toLowerCase() : "o=unknown-suffix";
        if (amsdkbaseDN == null) {
            initializationException = new SMSException(bundle.getString("sms-invalid-dn"), "sms-invalid-dn");
        }
        if (!baseDN.equalsIgnoreCase(amsdkbaseDN)) {
            enableDataStoreNotification = false;
        }
    }

    public SMSEntry(SSOToken token, String dn) throws SSOException, SMSException {
        if (initializationException != null) {
            throw initializationException;
        }
        this.ssoToken = token;
        this.dn = dn;
        this.normalizedDN = new DN(dn).toRFCString().toLowerCase();
        this.read();
    }

    public Map getAttributes() {
        return this.attrSet;
    }

    public String[] getAttributeValues(String attrName) {
        return this.getAttributeValues(attrName, false);
    }

    public String[] getAttributeValues(String attrName, boolean ignoreCache) {
        if (ignoreCache || !cacheSMSEntries) {
            try {
                this.read();
            }
            catch (SMSException e) {
                debug.error("SMSLdapEntry: Error in reading attrs: " + e);
            }
            catch (SSOException ssoe) {
                debug.error("SMSLdapEntry: SSOToken problem in reading attrs: " + (Object)((Object)ssoe));
            }
        }
        Set attr = this.attrSet == null ? null : (Set)this.attrSet.get(attrName);
        return attr == null ? null : attr.toArray(new String[attr.size()]);
    }

    public void addAttribute(String attrName, String value) throws SMSException {
        HashSet<String> attrValues = null;
        if (this.attrSet == null) {
            this.attrSet = new CaseInsensitiveHashMap();
        } else if (this.attrSet.containsKey(attrName) && (attrValues = (Set)this.attrSet.get(attrName)).contains(value)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEntry: Duplicate value for addition");
            }
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20), "sms-ATTR_OR_VAL_EXISTS");
        }
        if (attrValues == null) {
            attrValues = new HashSet<String>();
        }
        attrValues.add(value);
        this.attrSet.put(attrName, attrValues);
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        this.modSet.add(new ModificationItem(1, new BasicAttribute(attrName, value)));
    }

    public void setAttribute(String attrName, String[] attrValues) {
        HashSet<String> attrs = new HashSet<String>();
        BasicAttribute ba = new BasicAttribute(attrName);
        for (int i = 0; attrValues != null && i < attrValues.length; ++i) {
            attrs.add(attrValues[i]);
            ba.add(attrValues[i]);
        }
        this.attrSet = this.attrSet == null ? new CaseInsensitiveHashMap() : this.attrSet;
        Set set = this.modSet = this.modSet == null ? new HashSet() : this.modSet;
        if (!this.attrSet.containsKey(attrName)) {
            this.modSet.add(new ModificationItem(1, ba));
        } else {
            this.modSet.add(new ModificationItem(2, ba));
        }
        this.attrSet.put(attrName, attrs);
    }

    public void modifyAttributes(ModificationItem[] modItems) {
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        for (int i = 0; modItems != null && i < modItems.length; ++i) {
            this.modSet.add(modItems[i]);
        }
    }

    public void setAttributes(Map attributes) {
        if (attributes != null && !attributes.isEmpty()) {
            Iterator attrNames = attributes.keySet().iterator();
            while (attrNames.hasNext()) {
                String attrName = (String)attrNames.next();
                Set values = (Set)attributes.get(attrName);
                String[] attrValues = null;
                if (values != null && !values.isEmpty()) {
                    attrValues = new String[values.size()];
                    attrValues = values.toArray(attrValues);
                }
                this.setAttribute(attrName, attrValues);
            }
        }
    }

    public void removeAttribute(String attrName, String value) throws SMSException {
        Set attr = null;
        if (this.attrSet == null || (attr = (Set)this.attrSet.get(attrName)) == null || !attr.contains(value)) {
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20), "sms-ATTR_OR_VAL_EXISTS");
        }
        attr.remove(value);
        this.attrSet.put(attrName, attr);
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        this.modSet.add(new ModificationItem(3, new BasicAttribute(attrName, value)));
    }

    public void removeAttribute(String attrName) throws SMSException {
        Set attribute = (Set)this.attrSet.get(attrName);
        if (attribute == null) {
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20), "sms-ATTR_OR_VAL_EXISTS");
        }
        this.attrSet.remove(attrName);
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        BasicAttribute ba = new BasicAttribute(attrName, attribute);
        Iterator items = attribute.iterator();
        while (items.hasNext()) {
            ba.add(items.next());
        }
        this.modSet.add(new ModificationItem(3, ba));
    }

    public boolean containsAttrValue(String attrName, String attrValue) {
        Set attr;
        if (this.attrSet != null && (attr = (Set)this.attrSet.get(attrName)) != null) {
            return attr.contains(attrValue);
        }
        return false;
    }

    void read() throws SSOException, SMSException {
        this.read(this.ssoToken);
    }

    void read(SSOToken token) throws SSOException, SMSException {
        if (backendProxyEnabled) {
            if (SMSEntry.isAllowed(token, this.normalizedDN, readActionSet)) {
                if (adminSSOToken == null) {
                    adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
                token = adminSSOToken;
            }
        } else {
            SMSEntry.getDelegationPermission(token, this.normalizedDN, readActionSet);
        }
        this.attrSet = smsObject.read(token, this.dn);
        this.newEntry = this.attrSet == null;
    }

    public void save() throws SSOException, SMSException {
        if (this.readOnly) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: Attempted to save an entry that is marked as read-only: " + this.dn);
            }
            throw new SMSException(SMSException.STATUS_NO_PERMISSION, "sms-INSUFFICIENT_ACCESS_RIGHTS");
        }
        this.save(this.ssoToken);
    }

    void save(SSOToken token) throws SSOException, SMSException {
        if (backendProxyEnabled) {
            if (SMSEntry.isAllowed(token, this.normalizedDN, modifyActionSet)) {
                if (adminSSOToken == null) {
                    adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
                token = adminSSOToken;
            }
        } else {
            SMSEntry.getDelegationPermission(token, this.normalizedDN, modifyActionSet);
        }
        if (this.newEntry && this.attrSet != null) {
            smsObject.create(token, this.dn, this.attrSet);
            SMSEntry.notifyObjectChanged(this.dn, 0);
        } else if (this.modSet != null) {
            smsObject.modify(token, this.dn, this.modSet.toArray(new ModificationItem[this.modSet.size()]));
            SMSEntry.notifyObjectChanged(this.dn, 3);
        }
        this.newEntry = false;
    }

    public void delete() throws SMSException, SSOException {
        if (this.readOnly) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: Attempted to delete an entry that is marked as read-only: " + this.dn);
            }
            throw new SMSException(SMSException.STATUS_NO_PERMISSION, "sms-INSUFFICIENT_ACCESS_RIGHTS");
        }
        this.delete(this.ssoToken);
    }

    void delete(SSOToken token) throws SMSException, SSOException {
        if (!this.newEntry) {
            if (backendProxyEnabled) {
                if (SMSEntry.isAllowed(token, this.normalizedDN, modifyActionSet)) {
                    if (adminSSOToken == null) {
                        adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    }
                    token = adminSSOToken;
                }
            } else {
                SMSEntry.getDelegationPermission(token, this.normalizedDN, modifyActionSet);
            }
            smsObject.delete(token, this.dn);
            this.newEntry = true;
            this.attrSet = null;
            this.modSet = null;
            SMSEntry.notifyObjectChanged(this.dn, 1);
        } else if (debug.warningEnabled()) {
            debug.warning("SMSEntry: Attempted to delete an entry that does not exist: " + this.dn);
        }
    }

    Set searchSubOrgNames(SSOToken token, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        if (backendProxyEnabled && !SMSJAXRPCObjectFlg) {
            if (SMSEntry.isAllowed(token, this.normalizedDN, readActionSet)) {
                if (adminSSOToken == null) {
                    adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
                token = adminSSOToken;
            }
        } else if (!SMSJAXRPCObjectFlg) {
            SMSEntry.getDelegationPermission(token, this.normalizedDN, readActionSet);
        }
        Set resultSet = smsObject.searchSubOrgNames(token, this.dn, filter, numOfEntries, sortResults, ascendingOrder, recursive);
        if (SMSJAXRPCObjectFlg) {
            return resultSet;
        }
        OrderedSet allowedSet = new OrderedSet();
        Iterator items = resultSet.iterator();
        while (items.hasNext()) {
            String item = (String)items.next();
            if (!SMSEntry.hasReadPermission(token, item)) continue;
            allowedSet.add(item);
        }
        Set answer = SMSEntry.parseResult((Set)allowedSet, this.normalizedDN);
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Successfully obtained suborganization names for : " + this.dn);
        }
        return answer;
    }

    Set subEntries(SSOToken token, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (backendProxyEnabled && !SMSJAXRPCObjectFlg) {
            if (SMSEntry.isAllowed(token, this.normalizedDN, readActionSet)) {
                if (adminSSOToken == null) {
                    adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
                token = adminSSOToken;
            }
        } else if (!SMSJAXRPCObjectFlg) {
            SMSEntry.getDelegationPermission(token, this.normalizedDN, readActionSet);
        }
        Set subEntries = smsObject.subEntries(token, this.dn, filter, numOfEntries, sortResults, ascendingOrder);
        if (SMSJAXRPCObjectFlg) {
            return subEntries;
        }
        OrderedSet answer = new OrderedSet();
        Iterator items = subEntries.iterator();
        while (items.hasNext()) {
            String subEntry = (String)items.next();
            if (!SMSEntry.hasReadPermission(token, "ou=" + subEntry + COMMA + this.dn)) continue;
            answer.add(subEntry);
        }
        return answer;
    }

    Set schemaSubEntries(SSOToken token, String filter, String sidFilter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (backendProxyEnabled && !SMSJAXRPCObjectFlg) {
            if (SMSEntry.isAllowed(token, this.normalizedDN, readActionSet)) {
                if (adminSSOToken == null) {
                    adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
                token = adminSSOToken;
            }
        } else if (!SMSJAXRPCObjectFlg) {
            SMSEntry.getDelegationPermission(token, this.normalizedDN, readActionSet);
        }
        Set subEntries = smsObject.schemaSubEntries(token, this.dn, filter, sidFilter, numOfEntries, sortResults, ascendingOrder);
        if (SMSJAXRPCObjectFlg) {
            return subEntries;
        }
        OrderedSet answer = new OrderedSet();
        Iterator items = subEntries.iterator();
        while (items.hasNext()) {
            String subEntry = (String)items.next();
            if (!SMSEntry.hasReadPermission(token, "ou=" + subEntry + COMMA + this.dn)) continue;
            answer.add(subEntry);
        }
        return answer;
    }

    Set searchOrganizationNames(SSOToken token, int numOfEntries, boolean sortResults, boolean ascendingOrder, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        if (backendProxyEnabled && !SMSJAXRPCObjectFlg) {
            if (SMSEntry.isAllowed(token, this.normalizedDN, readActionSet)) {
                if (adminSSOToken == null) {
                    adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
                token = adminSSOToken;
            }
        } else if (!SMSJAXRPCObjectFlg) {
            SMSEntry.getDelegationPermission(token, this.normalizedDN, readActionSet);
        }
        Set resultSet = smsObject.searchOrganizationNames(token, this.dn, numOfEntries, sortResults, ascendingOrder, serviceName, attrName, values);
        if (SMSJAXRPCObjectFlg) {
            return resultSet;
        }
        OrderedSet allowedSet = new OrderedSet();
        Iterator items = resultSet.iterator();
        while (items.hasNext()) {
            String item = (String)items.next();
            if (!SMSEntry.hasReadPermission(token, item)) continue;
            allowedSet.add(item);
        }
        if (attrName.equalsIgnoreCase(EXPORTEDARGS)) {
            return allowedSet;
        }
        Set answer = SMSEntry.parseResult((Set)allowedSet, this.normalizedDN, true);
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Successfully obtained organization names for : " + this.dn);
        }
        return answer;
    }

    public static Set search(SSOToken token, String dn, String filter) throws SMSException {
        try {
            return smsObject.search(token, dn, filter);
        }
        catch (SSOException ssoe) {
            debug.error("SMSEntry: Search ERROR: " + filter, (Throwable)((Object)ssoe));
            throw new SMSException(bundle.getString("sms-error-in-searching"), (Throwable)((Object)ssoe), "sms-error-in-searching");
        }
    }

    static Set search(String filter) throws SMSException {
        try {
            return smsObject.search(null, baseDN, filter);
        }
        catch (SSOException ssoe) {
            debug.error("SMSEntry: Search ERROR: " + filter, (Throwable)((Object)ssoe));
            throw new SMSException(bundle.getString("sms-error-in-searching"), (Throwable)((Object)ssoe), "sms-error-in-searching");
        }
    }

    void refresh(SMSEntry e) {
        this.attrSet = e.attrSet != null ? SMSUtils.copyAttributes(e.attrSet) : null;
        this.newEntry = e.newEntry;
        this.modSet = null;
    }

    public static boolean checkIfEntryExists(String dn, SSOToken token) {
        try {
            return smsObject.entryExists(token, dn);
        }
        catch (Exception e) {
            debug.error("SMSEntry: Error in checking if entry exists: " + dn, (Throwable)e);
            return false;
        }
    }

    public static void registerCallbackHandler(SSOToken token, SMSObjectListener ocl) throws SMSException, SSOException {
        changeListeners.add(ocl);
        if (!ServiceManager.isRealmEnabled() || enableDataStoreNotification) {
            smsObject.registerCallbackHandler(token, ocl);
            if (eventDebug.messageEnabled()) {
                eventDebug.message("SMSEntry:registerCallbackHander calling SMSObject for co-existence mode");
            }
        }
        eventDebug.message("SMSEntry:registerCallbackHander called");
    }

    public static void objectChanged(String name, int type) {
        SMSEntry.objectChanged(name, type, false);
    }

    public static void objectChanged(String name, int type, boolean isLocal) {
        if (eventDebug.messageEnabled()) {
            eventDebug.message("SMSEntry:objectChanged: " + name + " type: " + type + " IsLocal: " + isLocal + "\nNumber of callback objects: " + changeListeners.size());
        }
        if (type == 0 && name.indexOf(AGENTGROUP_RDN) >= 0) {
            return;
        }
        if (!isLocal) {
            if (localChanges.contains(name + type)) {
                localChanges.remove(name + type);
                if (eventDebug.messageEnabled()) {
                    eventDebug.message("SMSEntry:objectChanged: " + name + " type: " + type + " IsLocal: " + isLocal + "\nHas been delivered locally");
                }
                return;
            }
            if (eventDebug.messageEnabled()) {
                eventDebug.message("SMSEntry:objectChanged: " + name + " type: " + type + " IsLocal: " + isLocal + "\nHas NOT been delivered locally, will be notified");
            }
        } else {
            if (localChanges.size() > LOCAL_CHANGES_MAX_SIZE) {
                localChanges.remove(0);
            }
            localChanges.add(name + type);
        }
        Iterator items = changeListeners.iterator();
        while (items.hasNext()) {
            SMSObjectListener listener = (SMSObjectListener)items.next();
            listener.objectChanged(name, type);
        }
    }

    public static void notifyObjectChanged(String name, int type) {
        if (eventDebug.messageEnabled()) {
            eventDebug.message("SMSEntry:notifyObjectChanged: " + name + " type: " + type + "\nCalling NotificationThread");
        }
        NotificationThread nt = new NotificationThread(name, type);
        if (SystemProperties.isServerMode()) {
            nt.start();
        } else {
            nt.run();
        }
    }

    String getDN() {
        return this.dn;
    }

    Principal getPrincipal() {
        try {
            return this.ssoToken.getPrincipal();
        }
        catch (SSOException ssoe) {
            return null;
        }
    }

    SSOToken getSSOToken() {
        return this.ssoToken;
    }

    void setReadOnly() {
        this.readOnly = true;
    }

    public boolean isNewEntry() {
        return this.newEntry;
    }

    public static SMSObject getSMSObject() {
        return smsObject;
    }

    public static void validateToken(SSOToken token) throws SMSException {
        try {
            tm.validateToken(token);
        }
        catch (SSOException ssoe) {
            throw new SMSException((Throwable)((Object)ssoe), "sms-INVALID_SSO_TOKEN");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SMSEntry answer = (SMSEntry)super.clone();
        answer.ssoToken = this.ssoToken;
        answer.dn = this.dn;
        answer.newEntry = this.newEntry;
        answer.modSet = null;
        answer.attrSet = this.attrSet != null ? SMSUtils.copyAttributes(this.attrSet) : null;
        if (debug.messageEnabled()) {
            debug.message("SMSEntry being cloned: " + this.dn);
        }
        return answer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DN\t\t: " + this.dn + "\n");
        if (this.newEntry) {
            sb.append("\t(NEW Entry)");
        }
        sb.append("Attribute Set\t: " + this.attrSet + "\n");
        sb.append("Modifcation Set\t: " + this.modSet + "\n");
        return sb.toString();
    }

    public static String getRootSuffix() {
        return baseDN;
    }

    public static String getAMSdkBaseDN() {
        return amsdkbaseDN;
    }

    public static String getDataStore(SSOToken token) {
        if (dataStore == null) {
            String smsClassName = smsObject.getClass().getName();
            dataStore = smsClassName.equals(DEFAULT_SMS_CLASS_NAME) || smsClassName.equals(JAXRPC_SMS_CLASS_NAME) ? GetBackendDataStore.getDataStore(token) : "flatfile";
            if (debug.messageEnabled()) {
                debug.message("SMSEntry:getDataStore.dataStore " + dataStore);
            }
        }
        return dataStore;
    }

    public static boolean isAttributeCaseSensitive(String attrName) {
        return mCaseSensitiveAttributes.contains(attrName);
    }

    public static String getFilterPatternService() {
        return FILTER_PATTERN_SERVICE;
    }

    protected static Set parseResult(Set resultSet, String dn) {
        return SMSEntry.parseResult(resultSet, dn, false);
    }

    protected static Set parseResult(Set resultSet, String dn, boolean includeThisDN) {
        OrderedSet answer = new OrderedSet();
        if (resultSet != null) {
            Iterator Iter = resultSet.iterator();
            while (Iter.hasNext()) {
                int indx;
                int i;
                String orgAttr;
                DN sdn = new DN((String)Iter.next());
                String rfcDN = sdn.toRFCString();
                String rfcDNlc = sdn.toRFCString().toLowerCase();
                if (rfcDNlc.equals(baseDN) || rfcDNlc.startsWith(SUN_INTERNAL_REALM_PREFIX)) continue;
                if (rfcDNlc.equals(dn)) {
                    if (!includeThisDN) continue;
                    answer.add(SLASH_STR);
                    continue;
                }
                String string = orgAttr = ServiceManager.isRealmEnabled() ? ORG_PLACEHOLDER_RDN : OrgConfigViaAMSDK.getNamingAttrForOrg() + EQUALS;
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry:parseResult:orgAttr " + orgAttr);
                }
                if ((i = rfcDNlc.indexOf(orgAttr.toLowerCase())) > 0) {
                    rfcDN = rfcDN.substring(i);
                }
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry:parseResult:DNName " + dn);
                    debug.message("SMSEntry:parseResult:RFCDN " + rfcDN);
                }
                if ((indx = rfcDNlc.indexOf(dn)) < 0) {
                    indx = rfcDNlc.lastIndexOf(baseDN);
                }
                String origStr = rfcDN.substring(0, indx - 1);
                if (!ServiceManager.isRealmEnabled()) {
                    ArrayList<String> rdns = new ArrayList<String>();
                    StringTokenizer strtok = new StringTokenizer(origStr, COMMA);
                    while (strtok.hasMoreElements()) {
                        String token = strtok.nextToken().trim();
                        if (debug.messageEnabled()) {
                            debug.message("SMSEntry:parseResult().token  " + token);
                        }
                        if (token == null || token.length() == 0) continue;
                        rdns.add(token);
                    }
                    int size = rdns.size();
                    HashSet<String> dnKeyset = new HashSet<String>();
                    for (int is = 0; is < size; ++is) {
                        String[] strArr = DNMapper.splitString((String)rdns.get(is));
                        dnKeyset.add(strArr[0]);
                    }
                    String orgUnitAttr = OrgConfigViaAMSDK.getNamingAttrForOrgUnit();
                    if (dnKeyset.contains(orgUnitAttr)) {
                        if (!debug.messageEnabled()) continue;
                        debug.message("SMSEntry.parseResult(): Container node: " + origStr);
                        continue;
                    }
                }
                origStr = DNMapper.replaceString(origStr, orgAttr, SLASH_STR);
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry:parseResult:origStr1 " + origStr);
                }
                origStr = DNMapper.replaceString(origStr, COMMA, "");
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry:parseResult:origStr2 " + origStr);
                }
                String tmpStr = "";
                StringBuffer sb = new StringBuffer();
                while (origStr.length() != 0) {
                    int id = origStr.lastIndexOf(SLASH_STR);
                    if (id < 0) continue;
                    sb.append(origStr.substring(id + 1)).append(SLASH_STR);
                    origStr = origStr.substring(0, id);
                }
                tmpStr = sb.toString();
                if (tmpStr == null || tmpStr.length() <= 0) continue;
                answer.add(tmpStr.substring(0, tmpStr.length() - 1));
            }
        }
        return answer;
    }

    static String[] parseOrgDN(String dnName) {
        String[] answer = (String[])cache.get(dnName);
        if (answer != null) {
            return answer;
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry:parseOrgDN:DNName " + dnName);
        }
        answer = new String[5];
        if (dnName == null || dnName.length() == 0) {
            answer[0] = baseDN;
            answer[1] = "*";
            answer[2] = "*";
            answer[3] = "*";
            answer[4] = "*";
            return answer;
        }
        DN sdn = new DN(dnName);
        String rfcDN = sdn.toRFCString().toLowerCase();
        String restOfDN = null;
        int oldStrIndex = rfcDN.indexOf(DELEGATION_SERVICES_RDN_WITH_COMMA);
        if (oldStrIndex == -1 || rfcDN.equals(DNMapper.serviceDN)) {
            answer[0] = rfcDN;
            restOfDN = "";
        } else if (ServiceManager.isRealmEnabled()) {
            int baseDNIndex = rfcDN.indexOf(DNMapper.serviceDN);
            if (baseDNIndex == -1 || baseDNIndex == 0) {
                answer[0] = baseDN;
                restOfDN = "";
            } else {
                String dn1 = rfcDN.substring(0, baseDNIndex - 1);
                if (dn1.indexOf(DELEGATION_SERVICES_RDN) == -1 && !dn1.startsWith(ORG_PLACEHOLDER_RDN)) {
                    answer[0] = baseDN;
                    restOfDN = dn1;
                } else if (dn1.startsWith(DELEGATION_SERVICES_RDN)) {
                    answer[0] = rfcDN.substring(DELEGATION_SERVICES_RDN.length());
                    restOfDN = "";
                } else if (dn1.startsWith(ORG_PLACEHOLDER_RDN)) {
                    answer[0] = rfcDN;
                    restOfDN = "";
                } else {
                    answer[0] = rfcDN.substring(oldStrIndex + DELEGATION_SERVICES_RDN_WITH_COMMA_LEN);
                    restOfDN = rfcDN.substring(0, oldStrIndex);
                }
            }
        } else {
            answer[0] = rfcDN.substring(oldStrIndex + DELEGATION_SERVICES_RDN_WITH_COMMA_LEN);
            restOfDN = rfcDN.substring(0, oldStrIndex);
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry:parseOrgDN: orgDN: " + answer[0] + " restOfDN: " + restOfDN);
        }
        String[] rdns = null;
        if (restOfDN.length() > 0) {
            rdns = LDAPDN.explodeDN((String)restOfDN, (boolean)true);
        }
        int size = rdns == null ? 0 : rdns.length;
        answer[4] = size < 1 ? REALM_SERVICE : rdns[size - 1];
        answer[3] = size < 2 ? "*" : rdns[size - 2];
        String string = answer[2] = size < 3 ? "*" : rdns[size - 3];
        if (size >= 4) {
            StringBuffer sbr = new StringBuffer();
            for (int i = size - 4; i >= 0; --i) {
                sbr.append('/').append(rdns[i]);
            }
            answer[1] = sbr.toString();
        } else {
            answer[1] = "*";
        }
        cache.put(dnName, answer);
        return answer;
    }

    static boolean hasReadPermission(SSOToken token, String dn) {
        try {
            SMSEntry.getDelegationPermission(token, dn, readActionSet);
        }
        catch (SMSException smse) {
            if (debug.messageEnabled()) {
                try {
                    debug.message("SMSEntry::hasReadPermission Denied user: " + token.getPrincipal().getName() + " for dn: " + dn);
                }
                catch (SSOException ssoe) {
                    debug.message("SMSEntry::hasReadPermission Denied access for dn: " + dn + " Got SSOException", (Throwable)((Object)ssoe));
                }
            }
            return false;
        }
        if (debug.messageEnabled()) {
            try {
                debug.message("SMSEntry::hasReadPermission Allowed user: " + token.getPrincipal().getName() + " for dn: " + dn);
            }
            catch (SSOException ssoe) {
                debug.message("SMSEntry::hasReadPermission Allowed access for dn: " + dn + " Got SSOException", (Throwable)((Object)ssoe));
            }
        }
        return true;
    }

    static boolean getDelegationPermission(SSOToken token, String dnName, Set actions) throws SMSException {
        boolean delPermFlag = true;
        if (SMSJAXRPCObjectFlg || backendProxyEnabled || dnName.equals(baseDN) || dnName.equals(DNMapper.serviceDN)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEntry:getDelegationPermission :No delegation check needed for client sdk, db proxy enabled and for baseDNs: " + baseDN);
            }
            return delPermFlag;
        }
        try {
            String normTok;
            String tokenName = token.getPrincipal().getName();
            if (DN.isDN((String)tokenName) && specialUserSet.contains(normTok = new DN(tokenName).toRFCString().toLowerCase())) {
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry.getDelegationPermission: No delegation check needed for special users." + normTok);
                }
                return delPermFlag;
            }
        }
        catch (SSOException se) {
            debug.error("SMSEntry.isAllowed : Invalid Token: ", (Throwable)((Object)se));
            throw new SMSException(bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        if (!ServiceManager.isConfigMigratedTo70()) {
            if (!backendProxyEnabled) {
                debug.error("SMSEntry::getDelegationPermission Must enable LDAP proxy support if configuration (DIT) is not migrated to AM 7.0");
                throw new SMSException(SMSException.STATUS_NO_PERMISSION, "sms-INSUFFICIENT_ACCESS_RIGHTS");
            }
            return delPermFlag;
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry:getDelegationPermission :Calling delegation service for dnName: " + dnName + " for permissions: " + actions);
        }
        if (!SMSEntry.isAllowedByDelegation(token, dnName, actions)) {
            throw new SMSException(SMSException.STATUS_NO_PERMISSION, "sms-INSUFFICIENT_ACCESS_RIGHTS");
        }
        return delPermFlag;
    }

    private static boolean isAllowed(SSOToken token, String dnName, Set actions) throws SMSException {
        if (SMSJAXRPCObjectFlg) {
            return false;
        }
        if (dnName.equals(baseDN) || dnName.equals(DNMapper.serviceDN)) {
            return true;
        }
        try {
            String normTok;
            String tokenName = token.getPrincipal().getName();
            if (DN.isDN((String)tokenName) && specialUserSet.contains(normTok = new DN(tokenName).toRFCString().toLowerCase())) {
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry.isAllowed : No delegation check needed for special users." + normTok);
                }
                return true;
            }
        }
        catch (SSOException se) {
            debug.error("SMSEntry.isAllowed : Invalid Token: ", (Throwable)((Object)se));
            throw new SMSException(bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        if (!ServiceManager.isConfigMigratedTo70()) {
            return false;
        }
        return SMSEntry.isAllowedByDelegation(token, dnName, actions);
    }

    private static boolean isAllowedByDelegation(SSOToken token, String dnName, Set actions) throws SMSException {
        boolean delPermFlag = true;
        String[] parseTokens = SMSEntry.parseOrgDN(dnName);
        String orgName = parseTokens[0];
        String subConfigName = parseTokens[1];
        String configType = parseTokens[2];
        String version = parseTokens[3];
        String serviceName = parseTokens[4];
        if (!serviceName.equals(REALM_SERVICE) && (configType.equalsIgnoreCase("*") || subConfigName.equalsIgnoreCase("*"))) {
            return delPermFlag;
        }
        try {
            DelegationPermission dlgPerm = new DelegationPermission(orgName, serviceName, version, configType, subConfigName, actions, Collections.EMPTY_MAP);
            if (dlgEval == null) {
                dlgEval = new DelegationEvaluator();
            }
            if (!(delPermFlag = dlgEval.isAllowed(token, dlgPerm, Collections.EMPTY_MAP)) && debug.warningEnabled()) {
                try {
                    debug.warning("SMSEntry: Attempt by:  " + token.getPrincipal().getName() + " to read/modify entry: " + dnName + " has no permissions");
                }
                catch (SSOException ssoe) {
                    debug.warning("SMSEntry: Attempted to:  read/modify an entry that has invalid delegation privilege: " + dnName, (Throwable)((Object)ssoe));
                }
            }
        }
        catch (SSOException se) {
            debug.error("SMSEntry.isAllowed : Invalid Token: ", (Throwable)((Object)se));
            throw new SMSException(bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        catch (DelegationException de) {
            debug.error("SMSEntry.isAllowed : Invalid DelegationPermission: ", (Throwable)de);
            throw new SMSException(bundle.getString("sms-invalid_delegation_privilege"), "sms-invalid_delegation_privilege");
        }
        return delPermFlag;
    }

    static {
        cache = new Cache(500);
        GLOBAL_CACHE_PROPERTY = "com.iplanet.am.sdk.caching.enabled";
        SM_CACHE_PROPERTY = "com.sun.identity.sm.cache.enabled";
        DATASTORE_FLAT_FILE = "flatfile";
        DATASTORE_SUN_DIR = "dirServer";
        DATASTORE_ACTIVE_DIR = "activeDir";
        specialUserSet = new HashSet(50);
        readActionSet = new HashSet(2);
        modifyActionSet = new HashSet(2);
        changeListeners = new HashSet();
        localChanges = Collections.synchronizedList(new LinkedList());
        LOCAL_CHANGES_MAX_SIZE = 25;
        readActionSet.add(READ);
        modifyActionSet.add(MODIFY);
        mCaseSensitiveAttributes = new CaseInsensitiveHashSet(3);
        mCaseSensitiveAttributes.add(ATTR_SCHEMA);
        mCaseSensitiveAttributes.add(ATTR_PLUGIN_SCHEMA);
        mCaseSensitiveAttributes.add(ATTR_KEYVAL);
        AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
        bundle = amCache.getResBundle("amSDK", Locale.ENGLISH);
        SMSEntry.initializeClass();
        DELEGATION_SERVICES_RDN_WITH_COMMA_LEN = DELEGATION_SERVICES_RDN_WITH_COMMA.length();
        SMS_ATTRIBUTES = new String[]{PLACEHOLDER_RDN, ATTR_SCHEMA, ATTR_PLUGIN_SCHEMA, ATTR_KEYVAL, ATTR_XML_KEYVAL, ATTR_OBJECTCLASS, ATTR_PRIORITY, ATTR_SERVICE_ID, ATTR_LABELED_URI, ATTR_MODIFY_TIMESTAMP};
    }

    static class NotificationThread
    extends Thread {
        String name;
        int type;

        NotificationThread(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public void run() {
            block11: {
                if (this.type == 0 && (new StringTokenizer(this.name, SMSEntry.COMMA).countTokens() <= baseDNCount + 1 || this.name.indexOf(SMSEntry.AGENTGROUP_RDN) >= 0)) {
                    return;
                }
                String configTime = SystemProperties.get("installTime", "false");
                boolean bConfigTime = configTime.equalsIgnoreCase("true");
                if (SMSJAXRPCObjectFlg || ServiceManager.isRealmEnabled() && !enableDataStoreNotification || bConfigTime) {
                    if (eventDebug.messageEnabled()) {
                        eventDebug.message("SMSEntry::NotificationThread:run sending local notifications");
                    }
                    SMSEntry.objectChanged(this.name, this.type, true);
                }
                if (!SMSJAXRPCObjectFlg && !enableDataStoreNotification && ServiceManager.isRealmEnabled()) {
                    try {
                        Iterator sl = ServiceManager.getAMServerInstances().iterator();
                        while (sl != null && sl.hasNext()) {
                            URL url = new URL((String)sl.next());
                            URL weburl = WebtopNaming.getServiceURL("jaxrpc", url, false);
                            String surl = weburl.toString();
                            surl = !surl.endsWith(SMSEntry.SLASH_STR) ? surl + "/SMSObjectIF" : surl + "SMSObjectIF";
                            try {
                                SOAPClient client = new SOAPClient();
                                client.setURL(surl);
                                Object[] params = new Object[]{this.name, new Integer(this.type)};
                                if (eventDebug.messageEnabled()) {
                                    eventDebug.message("SMSEntry.NotificationThread.run Sending to URL: " + surl);
                                }
                                if (adminSSOToken == null) {
                                    adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                                }
                                client.send("notifyObjectChanged", params, Session.getLBCookie(((Object)adminSSOToken.getTokenID()).toString()), null);
                            }
                            catch (Throwable t) {
                                if (!eventDebug.warningEnabled()) continue;
                                eventDebug.warning("SMSEntry.NotificationThread.run Unable to send notification to: " + surl, t);
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (!eventDebug.warningEnabled()) break block11;
                        eventDebug.warning("SMSEntry.NotificationThread.run Unable to send notifications", t);
                    }
                }
            }
        }
    }
}

