/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.bundles;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.setup.Bootstrap;
import com.sun.identity.tools.bundles.SetupConstants;
import com.sun.identity.tools.bundles.SetupUtils;
import com.sun.identity.tools.bundles.VersionCheck;
import java.io.IOException;
import java.util.Properties;
import java.util.ResourceBundle;

public class Main
implements SetupConstants {
    public static void main(String[] args) {
        ResourceBundle bundle = ResourceBundle.getBundle(System.getProperty("file.setup", "com.sun.identity.tools.bundles.amadmtoolssetup"));
        if (System.getProperty("help.print") != null && System.getProperty("help.print").equals("yes")) {
            SetupUtils.printUsage(bundle);
            System.exit(0);
        }
        if (System.getProperty("version.check") != null && System.getProperty("version.check").equals("yes")) {
            System.exit(VersionCheck.isValid());
        }
        boolean loadConfig = System.getProperty("load.config") != null && System.getProperty("load.config").equals("yes");
        String configPath = null;
        String currentOS = SetupUtils.determineOS();
        Properties configProp = null;
        if (loadConfig) {
            configPath = System.getProperty("path.AMConfig");
            try {
                if (configPath == null || configPath.length() == 0) {
                    configPath = SetupUtils.getUserInput(bundle.getString(currentOS + ".question"));
                }
                if ((configProp = Bootstrap.load(configPath, false)) == null) {
                    System.out.println(bundle.getString("message.error.dir"));
                    System.exit(1);
                }
                if (!configPath.endsWith(FILE_SEPARATOR)) {
                    configPath = configPath + FILE_SEPARATOR;
                }
                configProp.setProperty("UserInput", configPath.substring(0, configPath.length() - 1));
                configProp.setProperty("CurrentPlatform", currentOS);
            }
            catch (Exception ex) {
                System.out.println(bundle.getString("message.error.dir"));
                System.exit(1);
            }
        } else {
            configProp = new Properties();
        }
        SetupUtils.evaluateBundleValues(bundle, configProp);
        try {
            SetupUtils.copyAndFilterScripts(bundle, configProp);
            if (loadConfig) {
                System.out.println(bundle.getString("message.info.version.tools") + " " + bundle.getString("version.tools"));
                System.out.println(bundle.getString("message.info.version.am") + " " + SystemProperties.get("com.iplanet.am.version"));
            }
        }
        catch (IOException ex) {
            System.out.println(bundle.getString("message.error.copy"));
            System.exit(1);
        }
    }
}

