/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.constants.AMTuneConstants;
import com.sun.identity.tune.impl.TuneAS9Container;
import com.sun.identity.tune.impl.TuneDS5Impl;
import com.sun.identity.tune.impl.TuneDS6Impl;
import com.sun.identity.tune.impl.TuneFAM8Impl;
import com.sun.identity.tune.impl.TuneLinuxOS;
import com.sun.identity.tune.impl.TuneSolarisOS;
import com.sun.identity.tune.impl.TuneWS7Container;
import com.sun.identity.tune.intr.Tuning;
import com.sun.identity.tune.util.AMTuneUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class AMTune {
    static AMTuneLogger pLogger = null;
    static MessageWriter mWriter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        AMTuneConfigInfo confInfo = null;
        try {
            String confFilePath = "amtune-env";
            pLogger = AMTuneLogger.getLoggerInst();
            mWriter = MessageWriter.getInstance();
            AMTuneLogger.setLogLevel("FINEST");
            mWriter.writeln("=====================================================================");
            mWriter.writeln("Debug log file : " + pLogger.getLogFilePath());
            mWriter.writeln("Configuration information file : " + mWriter.getConfigurationFilePath());
            mWriter.writeln("=====================================================================");
            AMTuneUtil.initializeUtil();
            if (args.length == 1) {
                StringTokenizer st = new StringTokenizer(args[0], "=");
                st.hasMoreTokens();
                String opt = st.nextToken();
                if (opt.indexOf("debug") != -1) {
                    st.hasMoreTokens();
                    AMTuneLogger.setLogLevel(st.nextToken());
                } else {
                    AMTune.printUsage();
                }
            }
            confInfo = new AMTuneConfigInfo(confFilePath);
            List tunerList = AMTune.getTuners(confInfo);
            Iterator itr = tunerList.iterator();
            while (itr.hasNext()) {
                Tuning compTuner = (Tuning)itr.next();
                compTuner.initialize(confInfo);
                compTuner.startTuning();
            }
            if (confInfo == null) return;
        }
        catch (Exception ex) {
            if (pLogger != null) {
                pLogger.logException("main", ex);
            } else {
                ex.printStackTrace();
            }
            if (mWriter != null) {
                mWriter.writelnLocaleMsg("pt-error-tuning-msg");
                return;
            } else {
                System.out.println("Error occured while tuning. Check logs for root cause.");
            }
            return;
        }
        finally {
            if (confInfo != null) {
                AMTune.replacePasswords(confInfo);
            }
        }
        AMTune.replacePasswords(confInfo);
        return;
    }

    private static void printUsage() {
        System.out.println("Usage:java -cp .;../lib/ldapjdk.jar;../lib/perftuneconfig.jar;../locale;../config com.sun.identity.tune.PerfTuner [-debug=ALL|INFO|FINE|FINEST|FINER|WARNING|SEVERE]");
        System.exit(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List getTuners(AMTuneConfigInfo confInfo) throws AMTuneException {
        ArrayList<AMTuneConstants> tunerList = new ArrayList<AMTuneConstants>();
        if (confInfo.isTuneOS()) {
            if (AMTuneUtil.isSunOs()) {
                tunerList.add(new TuneSolarisOS());
            } else {
                if (!AMTuneUtil.isLinux()) throw new AMTuneException("Unsupported OS for tuning.");
                tunerList.add(new TuneLinuxOS());
            }
        }
        if (confInfo.isTuneDS()) {
            if (confInfo.getDSConfigInfo().isRemoteDS()) {
                pLogger.log(Level.INFO, "getTuners", "UM DS is remote.");
                mWriter.writelnLocaleMsg("pt-remote-ds-msg");
            } else {
                String dsVersion = confInfo.getDSConfigInfo().getDsVersion();
                if (!AMTuneUtil.isSupportedUMDSVersion(dsVersion)) throw new AMTuneException("Invalid UM DS Version: " + dsVersion);
                if (dsVersion.indexOf("5.") != -1) {
                    tunerList.add(new TuneDS5Impl(false));
                } else if (dsVersion.indexOf("6.3") != -1) {
                    tunerList.add(new TuneDS6Impl(false));
                }
            }
            if (!confInfo.isUMSMDSSame() && !confInfo.isUMOnlyTune()) {
                if (confInfo.getSMConfigInfo().isRemoteDS()) {
                    pLogger.log(Level.INFO, "getTuners", "SM DS is remote.");
                    mWriter.writelnLocaleMsg("pt-remote-ds-msg");
                } else {
                    String smDSVersion = confInfo.getSMConfigInfo().getDsVersion();
                    if (!AMTuneUtil.isSupportedSMDSVersion(smDSVersion)) throw new AMTuneException("Invalid SM DS Version: " + smDSVersion);
                    if (smDSVersion.indexOf("5.") != -1) {
                        tunerList.add(new TuneDS5Impl(true));
                    } else {
                        if (smDSVersion.indexOf("6.3") == -1) throw new AMTuneException("Tuner not available for " + smDSVersion);
                        tunerList.add(new TuneDS6Impl(true));
                    }
                }
            }
        }
        if (confInfo.isTuneWebContainer()) {
            if (confInfo.getWebContainer().equals("WS7")) {
                tunerList.add(new TuneWS7Container());
            } else {
                if (!confInfo.getWebContainer().equals("AS91")) throw new AMTuneException("Invalid WebContainer.");
                tunerList.add(new TuneAS9Container());
            }
        }
        if (!confInfo.isTuneFAM()) return tunerList;
        tunerList.add(new TuneFAM8Impl());
        return tunerList;
    }

    private static void replacePasswords(AMTuneConfigInfo confInfo) {
        try {
            String propFile = AMTuneUtil.getCurDir() + "/" + "amtune-env" + ".properties";
            FileHandler fh = new FileHandler(propFile);
            int reqLine = fh.getLineNum("FAMADM_PASSWORD=");
            fh.replaceLine(reqLine, "FAMADM_PASSWORD=");
            reqLine = fh.getLineNum("SM_DIRMGR_PASSWORD=");
            fh.replaceLine(reqLine, "SM_DIRMGR_PASSWORD=");
            reqLine = fh.getLineNum("WSADMIN_PASSWORD=");
            fh.replaceLine(reqLine, "WSADMIN_PASSWORD=");
            reqLine = fh.getLineNum("ASADMIN_PASSWORD=");
            fh.replaceLine(reqLine, "ASADMIN_PASSWORD=");
            reqLine = fh.getLineNum("^DIRMGR_PASSWORD=");
            fh.replaceLine(reqLine, "DIRMGR_PASSWORD=");
            fh.close();
        }
        catch (Exception ex) {
            System.out.println("Error in password replacement " + ex.getMessage());
        }
    }
}

