/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.config;

import com.sun.identity.tune.base.WebContainerConfigInfoBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class AS9ContainerConfigInfo
extends WebContainerConfigInfoBase {
    private String asAdminUser;
    private String asAdminHost;
    private String asAdminPort;
    private String asAdminSecure;
    private boolean isInteractive;
    private String asAdminTarget;
    private String asAdminDir;
    private String asAdminHttpListener;
    private boolean tuneWebContainerJavaPolicy;
    private StringBuffer asAdminCommonParamsNoTarget;
    private StringBuffer asAdminCommonParams;
    private String asAdminCmd;
    private Map cfgMap;
    private String tempFile;
    private String acceptorThreadParam;
    private String adminPassFile;

    public AS9ContainerConfigInfo(ResourceBundle confRbl) throws AMTuneException {
        try {
            this.setWebContainer("AS91");
            this.adminPassFile = AMTuneUtil.TMP_DIR + "asadminpass";
            this.tempFile = AMTuneUtil.TMP_DIR + "cmdoutput";
            this.setContainerBaseDir(confRbl.getString("CONTAINER_BASE_DIR"));
            this.setContainerInstanceName(confRbl.getString("WEB_CONTAINER_INSTANCE_NAME"));
            this.setContainerInstanceDir(confRbl.getString("CONTAINER_INSTANCE_DIR"));
            this.setASAdminUser(confRbl.getString("ASADMIN_USER"));
            this.setASAdminHost(confRbl.getString("ASADMIN_HOST"));
            this.setASAdminPort(confRbl.getString("ASADMIN_PORT"));
            this.setASAdminSecure(confRbl.getString("ASADMIN_SECURE"));
            this.setIsInteractive(confRbl.getString("ASADMIN_INTERACTIVE"));
            this.setASAdminTarget(confRbl.getString("ASADMIN_TARGET"));
            this.setASAdminDir(confRbl.getString("ASADMIN_DIR"));
            this.setASAdminCmd();
            this.setASAdminHttpListener(confRbl.getString("ASADMIN_HTTPLISTENER"));
            this.setTuneWebContainerJavaPolicy(confRbl.getString("AMTUNE_WEB_CONTAINER_JAVA_POLICY"));
            this.asAdminCommonParamsNoTarget = new StringBuffer("--user ");
            this.asAdminCommonParamsNoTarget.append(this.getASAdminUser());
            this.asAdminCommonParamsNoTarget.append(" --passwordfile ");
            this.asAdminCommonParamsNoTarget.append(this.adminPassFile);
            this.asAdminCommonParamsNoTarget.append(" --host ");
            this.asAdminCommonParamsNoTarget.append(this.getWSAdminHost());
            this.asAdminCommonParamsNoTarget.append(" --port ");
            this.asAdminCommonParamsNoTarget.append(this.getASAdminPort());
            if (this.getASAdminSecure() != null) {
                this.asAdminCommonParamsNoTarget.append(" ");
                this.asAdminCommonParamsNoTarget.append(this.getASAdminSecure());
            }
            this.asAdminCommonParamsNoTarget.append(" --interactive=");
            this.asAdminCommonParamsNoTarget.append(this.isInteractive());
            this.asAdminCommonParams = new StringBuffer(this.asAdminCommonParamsNoTarget.toString());
            this.asAdminCommonParams.append(" --target ");
            this.asAdminCommonParams.append(this.getASAdminTarget());
            this.acceptorThreadParam = "server.http-service.http-listener." + this.getASAdminHttpListener() + ".acceptor-threads";
            this.writePasswordToFile(confRbl.getString("ASADMIN_PASSWORD"));
            this.fillCfgMap();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "AS91ContainerConfigInfo", "Failed to set Appserver 91 configuration information. ");
            throw new AMTuneException(ex.getMessage());
        }
        finally {
            File tempF = new File(this.tempFile);
            if (tempF.isFile()) {
                tempF.delete();
            }
        }
    }

    protected void writePasswordToFile(String password) throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "writePasswordToFile", "Creating AS91 password file.");
            if (password == null || password.trim().length() <= 0) {
                this.mWriter.write("ASADMIN_PASSWORD ");
                this.mWriter.writeLocaleMsg("pt-not-configured");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
                this.mWriter.writeln(" amtune-env");
                throw new AMTuneException("Application Server admin password not set.");
            }
            File passFile = new File(this.adminPassFile);
            BufferedWriter pOut = new BufferedWriter(new FileWriter(passFile));
            pOut.write("AS_ADMIN_PASSWORD=");
            pOut.write(password);
            pOut.flush();
            pOut.close();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "writePassWordToFile", "Couldn't write password to file. ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public String getAdminPassfilePath() {
        return this.adminPassFile;
    }

    private void fillCfgMap() throws AMTuneException {
        block11: {
            try {
                StringBuffer getCmd = new StringBuffer(this.getASAdminCmd());
                getCmd.append("get ");
                getCmd.append(this.asAdminCommonParamsNoTarget.toString());
                getCmd.append(" ");
                getCmd.append(this.acceptorThreadParam);
                getCmd.append(" ");
                getCmd.append("server.http-service.connection-pool.max-pending-count");
                getCmd.append(" ");
                getCmd.append("server.http-service.connection-pool.queue-size-in-bytes");
                StringBuffer resultBuffer = new StringBuffer();
                String reqLine = "";
                this.cfgMap = new HashMap();
                int retVal = AMTuneUtil.executeCommand(getCmd.toString(), resultBuffer);
                if (retVal != 0) {
                    this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting acceptor threads, count threads and queue size values. " + resultBuffer.toString());
                    throw new AMTuneException("Error getting current setting for threads and queue size.");
                }
                AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
                FileHandler cfgF = new FileHandler(this.tempFile);
                reqLine = cfgF.getLine(this.acceptorThreadParam);
                this.cfgMap.put(".acceptor-threads", AMTuneUtil.getLastToken(reqLine, "="));
                reqLine = cfgF.getLine("server.http-service.connection-pool.max-pending-count");
                this.cfgMap.put("server.http-service.connection-pool.max-pending-count", AMTuneUtil.getLastToken(reqLine, "="));
                reqLine = cfgF.getLine("server.http-service.connection-pool.queue-size-in-bytes");
                this.cfgMap.put("server.http-service.connection-pool.queue-size-in-bytes", AMTuneUtil.getLastToken(reqLine, "="));
                cfgF.close();
                String jvmOptParam = this.getASAdminTarget() + ".java-config.jvm-options";
                StringBuffer getJvmOptCmd = new StringBuffer(this.getASAdminCmd());
                getJvmOptCmd.append("get ");
                getJvmOptCmd.append(this.asAdminCommonParamsNoTarget.toString());
                getJvmOptCmd.append(" ");
                getJvmOptCmd.append(jvmOptParam);
                resultBuffer.setLength(0);
                retVal = AMTuneUtil.executeCommand(getJvmOptCmd.toString(), resultBuffer);
                ArrayList<String> curJVMOptList = new ArrayList<String>();
                if (retVal == 0) {
                    String cmdOutput = resultBuffer.toString().replace(jvmOptParam + " = ", "");
                    StringTokenizer st = new StringTokenizer(cmdOutput, ",");
                    while (st.hasMoreTokens()) {
                        String flagStr = st.nextToken();
                        curJVMOptList.add(flagStr);
                    }
                    this.cfgMap.put("-Xms", AMTuneUtil.getASJVMOption(curJVMOptList, "-Xms", true));
                    this.cfgMap.put("-Xmx", AMTuneUtil.getASJVMOption(curJVMOptList, "-Xmx", true));
                    this.cfgMap.put("-Xloggc", AMTuneUtil.getASJVMOption(curJVMOptList, "-Xloggc", true));
                    if (cmdOutput.indexOf("-client") != -1) {
                        this.cfgMap.put("-client", "-client");
                    } else {
                        this.cfgMap.put("-client", "");
                    }
                    if (cmdOutput.indexOf("-server") != -1) {
                        this.cfgMap.put("-server", "-server");
                    } else {
                        this.cfgMap.put("-server", "");
                    }
                    this.cfgMap.put("-Xss", AMTuneUtil.getASJVMOption(curJVMOptList, "-Xss", true));
                    this.cfgMap.put("-XX:NewSize", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:NewSize", false));
                    this.cfgMap.put("-XX:MaxNewSize", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:MaxNewSize", false));
                    this.cfgMap.put("-XX:+DisableExplicitGC", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+DisableExplicitGC", true));
                    this.cfgMap.put("-XX:+UseParNewGC", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+UseParNewGC", true));
                    this.cfgMap.put("-XX:+PrintClassHistogram", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+PrintClassHistogram", true));
                    this.cfgMap.put("-XX:+PrintGCTimeStamps", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+PrintGCTimeStamps", true));
                    this.cfgMap.put("-XX:+UseConcMarkSweepGC", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:+UseConcMarkSweepGC", true));
                    if (this.isTuneWebContainerJavaPolicy()) {
                        this.cfgMap.put("-Djava.security.policy", AMTuneUtil.getASJVMOption(curJVMOptList, "-Djava.security.policy", true));
                    }
                    if (AMTuneUtil.isNiagara()) {
                        this.cfgMap.put("-XX:ParallelGCThreads", AMTuneUtil.getASJVMOption(curJVMOptList, "-XX:ParallelGCThreads", true));
                    }
                    break block11;
                }
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting Current JVM options ");
                throw new AMTuneException("Error getting current JVM options");
            }
            catch (Exception ex) {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting Application server configuration information. " + ex.getMessage());
                throw new AMTuneException(ex.getMessage());
            }
        }
    }

    private void setASAdminUser(String asAdminUser) throws AMTuneException {
        if (asAdminUser == null) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
            this.mWriter.writeln("ASADMIN_USER");
            throw new AMTuneException("Appserver adminuser is null.");
        }
        this.asAdminUser = asAdminUser.trim();
    }

    public String getASAdminUser() {
        return this.asAdminUser;
    }

    private void setASAdminHost(String asAdminHost) throws AMTuneException {
        if (asAdminHost != null) {
            this.asAdminHost = asAdminHost.trim();
        } else {
            this.pLogger.log(Level.INFO, "setASAdminHost", "Appserver adminuser host name is null so using localhost. ");
            this.asAdminHost = AMTuneUtil.getHostName();
        }
    }

    public String getWSAdminHost() {
        return this.asAdminHost;
    }

    private void setASAdminPort(String asAdminPort) throws AMTuneException {
        if (asAdminPort == null || asAdminPort.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
            this.mWriter.writeln("ASADMIN_PORT");
            throw new AMTuneException("Invalid Application server Admin port.");
        }
        this.asAdminPort = asAdminPort.trim();
    }

    public String getASAdminPort() {
        return this.asAdminPort;
    }

    private void setASAdminSecure(String asAdminSecure) {
        if (asAdminSecure != null && asAdminSecure.trim().length() > 0) {
            this.asAdminSecure = asAdminSecure.trim();
        } else {
            this.pLogger.log(Level.INFO, "setAdminSecure", "Application Server Admin port is not secured. ");
            asAdminSecure = "";
        }
    }

    public String getASAdminSecure() {
        return this.asAdminSecure;
    }

    private void setIsInteractive(String isInteractive) {
        if (isInteractive != null && isInteractive.trim().length() > 0) {
            this.isInteractive = Boolean.parseBoolean(isInteractive);
        } else {
            this.pLogger.log(Level.INFO, "setIsInteractive", "Setting isInteractive to false.");
            this.isInteractive = false;
        }
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    private void setASAdminTarget(String asAdminTarget) {
        if (asAdminTarget != null && asAdminTarget.trim().length() > 0) {
            this.asAdminTarget = asAdminTarget.trim();
        } else {
            this.pLogger.log(Level.INFO, "setASAdminTarget", "Using \"server\" as target.");
            this.asAdminTarget = "server";
        }
    }

    public String getASAdminTarget() {
        return this.asAdminTarget;
    }

    private void setASAdminDir(String asAdminDir) throws AMTuneException {
        if (asAdminDir != null && asAdminDir.trim().length() > 0) {
            File cmdF = new File(asAdminDir);
            if (!cmdF.isDirectory()) {
                this.mWriter.writeLocaleMsg("pt-not-valid-dir");
                this.mWriter.writeln(" " + asAdminDir);
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
                this.mWriter.writeln("ASADMIN_DIR");
                throw new AMTuneException("Invalid asadmin directory.");
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
            this.mWriter.writeln("ASADMIN_DIR");
            throw new AMTuneException("Null asadmin directory.");
        }
        this.asAdminDir = asAdminDir.trim();
    }

    public String getASAdminDir() {
        return this.asAdminDir;
    }

    private void setASAdminCmd() throws AMTuneException {
        this.asAdminCmd = AMTuneUtil.isWindows2003() ? this.getASAdminDir() + "/" + "asadmin.bat " : this.getASAdminDir() + "/" + "asadmin ";
        File asToolF = new File(this.asAdminCmd.trim());
        if (!asToolF.isFile()) {
            this.mWriter.write(this.asAdminCmd);
            this.mWriter.writelnLocaleMsg("pt-tool-not-found");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
            this.mWriter.writeln("ASADMIN_DIR");
            throw new AMTuneException("asadmin tool not found.");
        }
    }

    public String getASAdminCmd() {
        return this.asAdminCmd;
    }

    private void setASAdminHttpListener(String asAdminHttpListener) {
        if (asAdminHttpListener != null && asAdminHttpListener.trim().length() > 0) {
            this.asAdminHttpListener = asAdminHttpListener.trim();
        } else {
            this.pLogger.log(Level.SEVERE, "setASAdminHttpListener", "Using default value \"http-listener-1\" for ASADMIN_HTTPLISTENER ");
            this.asAdminHttpListener = "http-listener-1";
        }
    }

    public String getASAdminHttpListener() {
        return this.asAdminHttpListener;
    }

    private void setTuneWebContainerJavaPolicy(String tuneWebContainerJavaPolicy) {
        if (tuneWebContainerJavaPolicy != null && tuneWebContainerJavaPolicy.trim().length() > 0) {
            this.tuneWebContainerJavaPolicy = Boolean.parseBoolean(tuneWebContainerJavaPolicy);
        } else {
            this.pLogger.log(Level.INFO, "setTuneWebContainerJavaPolicy", "Using default value false for AMTUNE_WEB_CONTAINER_JAVA_POLICY");
            this.tuneWebContainerJavaPolicy = false;
        }
    }

    public boolean isTuneWebContainerJavaPolicy() {
        return this.tuneWebContainerJavaPolicy;
    }

    public Map getCurASConfigInfo() {
        return this.cfgMap;
    }

    public String getAcceptorThreadString() {
        return this.acceptorThreadParam;
    }

    public String getAsAdminCommonParamsNoTarget() {
        return this.asAdminCommonParamsNoTarget.toString();
    }

    public String getAsAdminCommonParams() {
        return this.asAdminCommonParams.toString();
    }
}

