/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.intr.TuneOS;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class TuneSolarisOS
extends TuneOS {
    private AMTuneConfigInfo confInfo;
    private AMTuneLogger pLogger;
    private MessageWriter mWriter;
    private String osVersion;
    private String nddCmd;
    private static String TCP_DIV = "/dev/tcp ";

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        this.confInfo = configInfo;
        this.pLogger = AMTuneLogger.getLoggerInst();
        this.mWriter = MessageWriter.getInstance();
        this.osVersion = System.getProperty("os.version");
        this.nddCmd = "/usr/sbin/ndd ";
    }

    public void startTuning() throws AMTuneException {
        block4: {
            try {
                if (!this.osVersion.equals("5.10")) break block4;
                String cmd = "/usr/sbin/zoneadm list";
                StringBuffer rBuf = new StringBuffer();
                int extVal = AMTuneUtil.executeCommand(cmd, rBuf);
                if (extVal == -1) {
                    this.mWriter.writelnLocaleMsg("pt-sol-error-tuning");
                    this.pLogger.log(Level.SEVERE, "startTuning", rBuf.toString());
                    throw new AMTuneException("Error executing command zoneadm.");
                }
                if (rBuf.toString().toLowerCase().indexOf("global") != -1) {
                    this.mWriter.writelnLocaleMsg("pt-sol-tuning-msg");
                    this.mWriter.writeln("---------------------------------------------------------------------");
                    this.tuneKernel();
                    this.tuneTCP();
                    this.mWriter.writelnLocaleMsg("pt-lnx-reboot-msg");
                    this.mWriter.writeln("=====================================================================");
                    break block4;
                }
                this.pLogger.log(Level.WARNING, "startTuning", "Not in Global zone");
                this.mWriter.writelnLocaleMsg("pt-non-global-zone-msg");
                return;
            }
            catch (Exception ex) {
                this.pLogger.log(Level.SEVERE, "startTuning", "Error tuning Solaris operating system.");
                this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
                this.mWriter.writeLocaleMsg("pt-os-tuning-error-msg");
                this.mWriter.writelnLocaleMsg("pt-manual-msg");
                this.pLogger.logException("startTuning", ex);
            }
        }
    }

    protected void tuneKernel() throws AMTuneException {
        FileHandler fh = null;
        try {
            String tuneFile = "/etc/system";
            fh = new FileHandler(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-sol-kernel-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-sol-fd-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write("rlim_fd_max=");
            String reqLine = fh.getLine("rlim_fd_max");
            if (reqLine != null && reqLine.trim().length() > 0) {
                this.mWriter.writeln(AMTuneUtil.getLastToken(reqLine, "="));
            } else {
                this.mWriter.writeln(" ");
            }
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write("rlim_fd_max=");
            this.mWriter.writelnLocaleMsg("65536 ");
            this.mWriter.writelnLocaleMsg("pt-sol-fd-cur-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write("rlim_fd_cur=");
            reqLine = fh.getLine("rlim_fd_cur");
            if (reqLine != null && reqLine.trim().length() > 0) {
                this.mWriter.writeln(AMTuneUtil.getLastToken(reqLine, "="));
            } else {
                this.mWriter.writeln(" ");
            }
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write("rlim_fd_cur=");
            this.mWriter.writelnLocaleMsg("65536 ");
            if (this.osVersion.equals("5.9")) {
                this.mWriter.writelnLocaleMsg("pt-sol-tcp-hash-size-msg");
                this.mWriter.writeln("8192 ");
                this.mWriter.writelnLocaleMsg("pt-rec-val");
                this.mWriter.write("tcp:tcp_conn_hash_size=");
                reqLine = fh.getLine("tcp:tcp_conn_hash_size");
                if (reqLine != null && reqLine.trim().length() > 0) {
                    this.mWriter.writeln(AMTuneUtil.getLastToken(reqLine, "="));
                } else {
                    this.mWriter.writeln(" ");
                }
                this.mWriter.writelnLocaleMsg("pt-rec-val");
                this.mWriter.writeln("tcp:tcp_conn_hash_size=");
                this.mWriter.writeln("8192 ");
            }
            this.mWriter.writeln(" ");
            if (this.confInfo.isReviewMode()) {
                return;
            }
            AMTuneUtil.backupConfigFile(tuneFile);
            String[] delStrs = new String[]{"*Start: Federated Access Manager Tuning", "tcp:tcp_conn_hash_size", "rlim_fd_cur", "rlim_fd_max", "*End: Federated Access Manager Tuning"};
            fh.removeMatchingLines(delStrs);
            fh.appendLine("*Start: Federated Access Manager Tuning");
            fh.appendLine("set rlim_fd_max=65536");
            fh.appendLine("set rlim_fd_cur=65536");
            if (this.osVersion.equals("5.9")) {
                fh.appendLine("set tcp:tcp_conn_hash_size=8192");
            }
            fh.appendLine("*End: Federated Access Manager Tuning");
            fh.close();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "tuneKernal", "Error tuning Solaris system file");
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void tuneTCP() throws AMTuneException {
        try {
            Map tcpCurCFGMap = this.getCurTCPVals();
            String tuneFile = "/etc/rc2.d/S71ndd_tcp";
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-tcp-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-wait-2-flush-interval");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_fin_wait_2_flush_interval");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_fin_wait_2_flush_interval"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_fin_wait_2_flush_interval");
            this.mWriter.writeln(" 67500");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-conn-req-maz-q");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_conn_req_max_q");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_conn_req_max_q"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_conn_req_max_q");
            this.mWriter.writeln(" 8192");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-conn-req-max-q0");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_conn_req_max_q0");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_conn_req_max_q0"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_conn_req_max_q0");
            this.mWriter.writeln(" 8192");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-keepalive-interval");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_keepalive_interval");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_keepalive_interval"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_keepalive_interval");
            this.mWriter.writeln(" 90000");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-smallest-anon-port");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_smallest_anon_port");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_smallest_anon_port"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_smallest_anon_port");
            this.mWriter.writeln(" 1024");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-slow-start-initial");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_slow_start_initial");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_slow_start_initial"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_slow_start_initial");
            this.mWriter.writeln(" 2");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-xmit-hiwat");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_xmit_hiwat");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_xmit_hiwat"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_xmit_hiwat");
            this.mWriter.writeln(" 65536");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-recv-hiwat");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_recv_hiwat");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_recv_hiwat"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_recv_hiwat");
            this.mWriter.writeln(" 65536");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-ip-abort-cinterval");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_ip_abort_cinterval");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_ip_abort_cinterval"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_ip_abort_cinterval");
            this.mWriter.writeln(" 10000");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-deferred-ack-interval");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_deferred_ack_interval");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_deferred_ack_interval"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_ip_abort_cinterval");
            this.mWriter.writeln(" 5");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-tcp-strong-iss");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write(TCP_DIV + "tcp_strong_iss");
            this.mWriter.writeln(" " + tcpCurCFGMap.get("tcp_strong_iss"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write(TCP_DIV + "tcp_strong_iss");
            this.mWriter.writeln(" 2");
            this.mWriter.writeln(" ");
            if (this.confInfo.isReviewMode()) {
                return;
            }
            AMTuneUtil.backupConfigFile(tuneFile);
            FileHandler fh = new FileHandler(tuneFile);
            String[] delStrs = new String[]{"#Start: Federated Access Manager Tuning", "tcp_time_wait_interval", "tcp_fin_wait_2_flush_interval", "tcp_conn_req_max_q", "tcp_conn_req_max_q0", "tcp_ip_abort_interval", "tcp_keepalive_interval", "tcp_rexmit_interval_max", "tcp_rexmit_interval_min", "tcp_rexmit_interval_initial", "tcp_smallest_anon_port", "tcp_slow_start_initial", "tcp_xmit_hiwat", "tcp_recv_hiwat", "tcp_ip_abort_cinterval", "tcp_deferred_ack_interval", "tcp_strong_iss", "#End: Federated Access Manager Tuning"};
            fh.removeMatchingLines(delStrs);
            fh.appendLine("#Start: Federated Access Manager Tuning");
            String setCmd = "ndd -set " + TCP_DIV;
            fh.appendLine(setCmd + "tcp_fin_wait_2_flush_interval" + " " + "67500");
            fh.appendLine(setCmd + "tcp_conn_req_max_q" + " " + 8192);
            fh.appendLine(setCmd + "tcp_conn_req_max_q0" + " " + 8192);
            fh.appendLine(setCmd + "tcp_keepalive_interval" + " " + "90000");
            fh.appendLine(setCmd + "tcp_smallest_anon_port" + " " + "1024");
            fh.appendLine(setCmd + "tcp_slow_start_initial" + " " + "2");
            fh.appendLine(setCmd + "tcp_xmit_hiwat" + " " + 65536);
            fh.appendLine(setCmd + "tcp_recv_hiwat" + " " + 65536);
            fh.appendLine(setCmd + "tcp_ip_abort_cinterval" + " " + "10000");
            fh.appendLine(setCmd + "tcp_deferred_ack_interval" + " " + "5");
            fh.appendLine(setCmd + "tcp_strong_iss" + " " + "2");
            fh.appendLine("#End: Federated Access Manager Tuning");
            fh.close();
            File wrap = new File(AMTuneUtil.TMP_DIR + "wrapper");
            BufferedWriter br = new BufferedWriter(new FileWriter(wrap));
            br.write("#!/bin/sh\n");
            br.write(". " + tuneFile.trim());
            br.close();
            String chmd = "chmod 744 ";
            StringBuffer rBuff = new StringBuffer();
            AMTuneUtil.executeCommand(chmd + tuneFile + " " + wrap.getAbsolutePath(), rBuff);
            rBuff.setLength(0);
            int extVal = AMTuneUtil.executeCommand("/bin/sh " + wrap.getAbsolutePath(), rBuff);
            if (extVal == -1) {
                this.mWriter.writeln("Error sourcing file please check debug log file");
                this.pLogger.log(Level.SEVERE, "tuneTCP", "Error sourcing tune file " + tuneFile);
            } else {
                this.pLogger.log(Level.INFO, "tuneTCP", "Sourcing tune file success.");
            }
            wrap.delete();
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    private Map getCurTCPVals() {
        HashMap<String, String> curCfg = new HashMap<String, String>();
        try {
            String getCmd = this.nddCmd + "-get " + TCP_DIV;
            String[] reqParams = new String[]{"tcp_fin_wait_2_flush_interval", "tcp_conn_req_max_q", "tcp_conn_req_max_q0", "tcp_keepalive_interval", "tcp_smallest_anon_port", "tcp_slow_start_initial", "tcp_xmit_hiwat", "tcp_recv_hiwat", "tcp_ip_abort_cinterval", "tcp_deferred_ack_interval", "tcp_strong_iss"};
            StringBuffer rBuf = new StringBuffer();
            for (int i = 0; i < reqParams.length; ++i) {
                rBuf.setLength(0);
                int extVal = AMTuneUtil.executeCommand(getCmd + reqParams[i], rBuf);
                if (extVal == -1) {
                    this.pLogger.log(Level.WARNING, "getCurTCPVals", "Couldn't get " + reqParams[i]);
                    curCfg.put(reqParams[i], "");
                    continue;
                }
                if (rBuf != null && rBuf.toString().trim().length() > 0) {
                    this.pLogger.log(Level.FINEST, "getCurTCPVals", "Cur TCP value of " + reqParams[i] + ": " + rBuf.toString());
                    curCfg.put(reqParams[i], rBuf.toString().trim());
                    continue;
                }
                curCfg.put(reqParams[i], "");
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "getCurTCPVals", "Error getting tcp values " + ex.getMessage());
        }
        return curCfg;
    }
}

