/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMEvent;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.AMSDKRepo;
import com.iplanet.am.sdk.AMStoreConnection;
import com.sun.identity.shared.debug.Debug;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class AMObjectListenerImpl
implements AMObjectListener {
    private Debug debug = Debug.getInstance("amProfileListener");

    AMObjectListenerImpl() {
    }

    public void objectChanged(String name, int eventType, Map configMap) {
        String normalizedDN;
        block5: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AMObjectListenerImpl.objectChanged(): name: " + name + " type: " + eventType);
            }
            normalizedDN = new DN(name).toRFCString().toLowerCase();
            AMStoreConnection.updateCache(normalizedDN, eventType);
            try {
                if (AMCompliance.isComplianceUserDeletionEnabled()) {
                    AMCompliance.cleanDeletedOrgCache(normalizedDN);
                }
                if (AMDCTree.isRequired()) {
                    AMDCTree.cleanDomainMap(normalizedDN);
                }
            }
            catch (AMException ame) {
                if (!this.debug.warningEnabled()) break block5;
                this.debug.warning("AMObjectListenerImpl.objectChanged() AMException occured: ", ame);
            }
        }
        AMObjectImpl.notifyEntryEvent(normalizedDN, eventType, false);
        AMSDKRepo.notifyObjectChangedEvent(normalizedDN, eventType);
    }

    public void objectsChanged(String parentName, int eventType, Set attrNames, Map configMap) {
        String dn;
        block5: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AMObjectListenerImpl.objectsChanged(): parentName: " + parentName + " type: " + eventType + "\n config map= " + configMap);
            }
            dn = new DN(parentName).toRFCString().toLowerCase();
            AMStoreConnection.updateCache(dn, eventType);
            try {
                if (AMCompliance.isComplianceUserDeletionEnabled()) {
                    AMCompliance.cleanDeletedOrgCache(dn);
                }
                if (AMDCTree.isRequired()) {
                    AMDCTree.cleanDomainMap(dn);
                }
            }
            catch (AMException ame) {
                if (!this.debug.warningEnabled()) break block5;
                this.debug.warning("AMObjectListenerImpl.objectsChanged() AMException occured: ", ame);
            }
        }
        AMObjectImpl.notifyEntryEvent(dn, eventType, true);
        AMSDKRepo.notifyAllObjectsChangedEvent();
    }

    public void permissionsChanged(String orgName, Map configMap) {
        if (this.debug.messageEnabled()) {
            this.debug.message("AMObjectListenerImpl.permissionsChanged(): orgName: " + orgName);
        }
        String dn = new DN(orgName).toRFCString().toLowerCase();
        AMStoreConnection.updateCache(dn, 4);
        AMObjectImpl.notifyACIChangeEvent(dn, 4);
        AMSDKRepo.notifyAllObjectsChangedEvent();
    }

    public void allObjectsChanged() {
        this.debug.error("AMObjectListenerImpl: Received all objects changed event from event service");
        AMEvent amEvent = new AMEvent(AMStoreConnection.getAMSdkBaseDN());
        AMObjectImpl.notifyAffectedDNs(AMStoreConnection.getAMSdkBaseDN(), amEvent);
        AMSDKRepo.notifyAllObjectsChangedEvent();
    }

    public Map getConfigMap() {
        return null;
    }

    public void setConfigMap(Map cMap) {
    }
}

