/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.client;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.services.cdm.AuthClient;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.common.DNUtils;
import com.sun.identity.common.FQDNUtils;
import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.common.ResourceLookup;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthClientUtils {
    public static final String DEFAULT_CLIENT_TYPE = "genericHTML";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_FILE_PATH = "html";
    private static final String DSAME_VERSION = "7.0";
    public static final String ERROR_MESSAGE = "Error_Message";
    public static final String ERROR_TEMPLATE = "Error_Template";
    public static final String MSG_DELIMITER = "|";
    public static final String BUNDLE_NAME = "amAuth";
    private static boolean setRequestEncoding = false;
    private static AMClientDetector clientDetector;
    private static Client defaultClient;
    private static FQDNUtils fqdnUtils;
    private static ResourceBundle bundle;
    private static final boolean urlRewriteInPath;
    public static final String templatePath;
    private static final String rootSuffix;
    private static String dsameVersion;
    private static String cookieName;
    private static String authCookieName;
    private static String loadBalanceCookieName;
    private static String persistentCookieName;
    private static String loadBalanceCookieValue;
    private static String serviceURI;
    private static String webContainer;
    private static String serverURL;
    static Debug utilDebug;
    private static boolean useCache;

    protected AuthClientUtils() {
    }

    public static Hashtable parseRequestParameters(HttpServletRequest request) {
        Enumeration requestEnum = request.getParameterNames();
        return AuthClientUtils.decodeHash(request, requestEnum);
    }

    private static Hashtable decodeHash(HttpServletRequest request, Enumeration names) {
        Hashtable<String, String> data = new Hashtable<String, String>();
        String enc = request.getParameter("gx_charset");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils::decodeHash:enc = " + enc);
        }
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            if (setRequestEncoding) {
                data.put(name, com.iplanet.am.util.Locale.URLDecodeField(value, enc, utilDebug));
                continue;
            }
            data.put(name, value);
        }
        return data;
    }

    public static Cookie getLogoutCookie(SessionID sid, String cookieDomain) {
        String logoutCookieString = AuthClientUtils.getLogoutCookieString(sid);
        Cookie logoutCookie = AuthClientUtils.createCookie(logoutCookieString, cookieDomain);
        logoutCookie.setMaxAge(0);
        return logoutCookie;
    }

    public static String getLogoutCookieString(SessionID sid) {
        String logout_cookie;
        block3: {
            logout_cookie = null;
            try {
                logout_cookie = (String)AccessController.doPrivileged(new EncodeAction("LOGOUT@" + sid.getSessionServerProtocol() + "@" + sid.getSessionServer() + "@" + sid.getSessionServerPort() + "@" + sid.getSessionDomain(), Crypt.getHardcodedKeyEncryptor()));
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Logout cookie : " + logout_cookie);
                }
            }
            catch (Exception e) {
                if (!utilDebug.messageEnabled()) break block3;
                utilDebug.message("Error creating cookie : " + e.getMessage());
            }
        }
        return logout_cookie;
    }

    public static Cookie createCookie(String cookieValue, String cookieDomain) {
        String cookieName = AuthClientUtils.getCookieName();
        if (utilDebug.messageEnabled()) {
            utilDebug.message("cookieName : " + cookieName);
            utilDebug.message("cookieValue : " + cookieValue);
            utilDebug.message("cookieDomain : " + cookieDomain);
        }
        return AuthClientUtils.createCookie(cookieName, cookieValue, cookieDomain);
    }

    public static String getQueryOrgName(HttpServletRequest request, String org) {
        String queryOrg = null;
        if (org != null && org.length() != 0) {
            queryOrg = org;
        } else if (request != null) {
            queryOrg = request.getServerName();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("queryOrg is :" + queryOrg);
        }
        return queryOrg;
    }

    public static void printCookies(HttpServletRequest req) {
        Cookie[] ck = req.getCookies();
        if (ck == null) {
            utilDebug.message("No Cookie in header");
            return;
        }
        for (int i = 0; i < ck.length; ++i) {
            if (!utilDebug.messageEnabled()) continue;
            utilDebug.message("Received Cookie:" + ck[i].getName() + " = " + ck[i].getValue());
        }
    }

    public static void printHash(Hashtable reqParameters) {
        block6: {
            try {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("AuthRequest: In printHash" + reqParameters);
                }
                if (reqParameters == null) {
                    return;
                }
                Enumeration Edata = reqParameters.keys();
                while (Edata.hasMoreElements()) {
                    Object key = Edata.nextElement();
                    Object value = reqParameters.get(key);
                    utilDebug.message("printHash Key is : " + key);
                    if (!(value instanceof String[])) continue;
                    String[] tmp = (String[])value;
                    for (int ii = 0; ii < tmp.length; ++ii) {
                        if (!utilDebug.messageEnabled()) continue;
                        utilDebug.message("printHash : String[] keyname (" + key + ") = " + tmp[ii]);
                    }
                }
            }
            catch (Exception e) {
                if (!utilDebug.messageEnabled()) break block6;
                utilDebug.warning("Exception: printHash :", e);
            }
        }
    }

    public static void setlbCookie(HttpServletResponse response) throws AuthException {
        String cookieName = AuthClientUtils.getlbCookieName();
        if (cookieName != null && cookieName.length() != 0) {
            Set domains = AuthClientUtils.getCookieDomains();
            if (!domains.isEmpty()) {
                Iterator it = domains.iterator();
                while (it.hasNext()) {
                    String domain = (String)it.next();
                    Cookie cookie = AuthClientUtils.createlbCookie(domain);
                    response.addCookie(cookie);
                }
            } else {
                response.addCookie(AuthClientUtils.createlbCookie(null));
            }
        }
    }

    public static Cookie createCookie(String cookieName, String cookieValue, String cookieDomain) {
        Cookie cookie;
        block4: {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieName   : " + cookieName);
                utilDebug.message("cookieValue  : " + cookieValue);
                utilDebug.message("cookieDomain : " + cookieDomain);
            }
            cookie = null;
            try {
                cookie = CookieUtils.newCookie(cookieName, cookieValue, "/", cookieDomain);
            }
            catch (Exception e) {
                if (!utilDebug.messageEnabled()) break block4;
                utilDebug.message("Error creating cookie. : " + e.getMessage());
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("createCookie Cookie is set : " + cookie);
        }
        return cookie;
    }

    public static void clearlbCookie(HttpServletResponse response) {
        String cookieName = AuthClientUtils.getlbCookieName();
        if (cookieName != null && cookieName.length() != 0) {
            Set domains = AuthClientUtils.getCookieDomains();
            if (!domains.isEmpty()) {
                Iterator it = domains.iterator();
                while (it.hasNext()) {
                    String domain = (String)it.next();
                    Cookie cookie = AuthClientUtils.createPersistentCookie(cookieName, "LOGOUT", 0, domain);
                    response.addCookie(cookie);
                }
            } else {
                response.addCookie(AuthClientUtils.createPersistentCookie(cookieName, "LOGOUT", 0, null));
            }
        }
    }

    public static String getErrorMessage(String errorCode) {
        String errorMessage = AuthClientUtils.getErrorVal(errorCode, ERROR_MESSAGE);
        return errorMessage;
    }

    public static String getErrorTemplate(String errorCode) {
        String errorTemplate = AuthClientUtils.getErrorVal(errorCode, ERROR_TEMPLATE);
        return errorTemplate;
    }

    public static boolean checkForCookies(HttpServletRequest req) {
        return CookieUtils.getCookieValueFromReq(req, AuthClientUtils.getAuthCookieName()) != null || CookieUtils.getCookieValueFromReq(req, AuthClientUtils.getCookieName()) != null;
    }

    public static String getOrigRedirectURL(HttpServletRequest request, SessionID sessID) {
        try {
            SSOToken ssoToken;
            SSOTokenManager manager;
            String sidString = null;
            if (sessID != null) {
                sidString = sessID.toString();
            }
            if ((manager = SSOTokenManager.getInstance()).isValidToken(ssoToken = manager.createSSOToken(sidString))) {
                utilDebug.message("Valid SSOToken");
                String origRedirectURL = ssoToken.getProperty("successURL");
                String gotoURL = request.getParameter("goto");
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Original successURL : " + origRedirectURL);
                    utilDebug.message("Request gotoURL : " + gotoURL);
                }
                if (gotoURL != null && gotoURL.length() != 0 && !gotoURL.equalsIgnoreCase("null")) {
                    String encoded = request.getParameter("encoded");
                    origRedirectURL = encoded != null && encoded.equals("true") ? AuthClientUtils.getBase64DecodedValue(gotoURL) : gotoURL;
                }
                return origRedirectURL;
            }
        }
        catch (Exception e) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error in getOrigRedirectURL:" + e.toString());
            }
            return null;
        }
        return null;
    }

    public static String addLogoutCookieToURL(String url, String logoutCookie, boolean isCookieSupported) {
        String logoutURL = null;
        if (logoutCookie == null || isCookieSupported) {
            logoutURL = url;
        } else {
            StringBuffer cookieString = new StringBuffer();
            cookieString.append(URLEncDec.encode(AuthClientUtils.getCookieName())).append("=").append(URLEncDec.encode(logoutCookie));
            StringBuffer encodedURL = new StringBuffer();
            if (url.indexOf("?") != -1) {
                cookieString.insert(0, "&amp;");
            } else {
                cookieString.insert(0, "?");
            }
            cookieString.insert(0, url);
            logoutURL = cookieString.toString();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieString is : " + cookieString);
            }
        }
        return logoutURL;
    }

    private static SessionID getSidFromCookie(HttpServletRequest request) {
        SessionID sessionID = null;
        String authCookieName = AuthClientUtils.getAuthCookieName();
        String sidValue = CookieUtils.getCookieValueFromReq(request, authCookieName);
        if (sidValue == null) {
            sidValue = SessionEncodeURL.getSidFromURL(request, authCookieName);
        }
        if (sidValue != null) {
            sessionID = new SessionID(sidValue);
            utilDebug.message("sidValue from Auth Cookie");
        }
        return sessionID;
    }

    public static SessionID getSessionIDFromRequest(HttpServletRequest request) {
        boolean isGetRequest = request != null && request.getMethod().equalsIgnoreCase("GET");
        SessionID amCookieSid = new SessionID(request);
        SessionID authCookieSid = AuthClientUtils.getSidFromCookie(request);
        SessionID sessionID = authCookieSid == null ? amCookieSid : (isGetRequest ? amCookieSid : authCookieSid);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils:returning sessionID:" + sessionID);
        }
        return sessionID;
    }

    public static boolean newSessionArgExists(Hashtable reqDataHash) {
        boolean newSessionArgExists;
        String arg = (String)reqDataHash.get("arg");
        boolean bl = newSessionArgExists = arg != null && arg.equals("newsession");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("newSessionArgExists : " + newSessionArgExists);
        }
        return newSessionArgExists;
    }

    public static AuthContext.IndexType getIndexType(String strIndexType) {
        AuthContext.IndexType indexType = null;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getIndexType : strIndexType = " + strIndexType);
        }
        if (strIndexType != null) {
            if (strIndexType.equalsIgnoreCase("user")) {
                indexType = AuthContext.IndexType.USER;
            } else if (strIndexType.equalsIgnoreCase("role")) {
                indexType = AuthContext.IndexType.ROLE;
            } else if (strIndexType.equalsIgnoreCase("service")) {
                indexType = AuthContext.IndexType.SERVICE;
            } else if (strIndexType.equalsIgnoreCase("module_instance")) {
                indexType = AuthContext.IndexType.MODULE_INSTANCE;
            } else if (strIndexType.equalsIgnoreCase("level")) {
                indexType = AuthContext.IndexType.LEVEL;
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getIndexType : IndexType = " + indexType);
        }
        return indexType;
    }

    public static String getIndexName(SSOToken ssoToken, AuthContext.IndexType indexType) {
        String indexName = "";
        try {
            if (indexType == AuthContext.IndexType.USER) {
                indexName = ssoToken.getProperty("UserToken");
            } else if (indexType == AuthContext.IndexType.ROLE) {
                indexName = ssoToken.getProperty("Role");
            } else if (indexType == AuthContext.IndexType.SERVICE) {
                indexName = ssoToken.getProperty("Service");
            } else if (indexType == AuthContext.IndexType.MODULE_INSTANCE) {
                indexName = AuthClientUtils.getLatestIndexName(ssoToken.getProperty("AuthType"));
            } else if (indexType == AuthContext.IndexType.LEVEL) {
                indexName = ssoToken.getProperty("AuthLevel");
            }
        }
        catch (Exception e) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error in getIndexName :" + e.toString());
            }
            return indexName;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getIndexName : IndexType = " + indexType);
            utilDebug.message("getIndexName : IndexName = " + indexName);
        }
        return indexName;
    }

    private static String getLatestIndexName(String indexName) {
        StringTokenizer st;
        String firstIndexName = indexName;
        if (indexName != null && (st = new StringTokenizer(indexName, MSG_DELIMITER)).hasMoreTokens()) {
            firstIndexName = st.nextToken();
        }
        return firstIndexName;
    }

    private static boolean isContain(String value, String key) {
        if (value == null) {
            return false;
        }
        try {
            if (value.indexOf(MSG_DELIMITER) != -1) {
                StringTokenizer st = new StringTokenizer(value, MSG_DELIMITER);
                while (st.hasMoreTokens()) {
                    if (!st.nextToken().equals(key)) continue;
                    return true;
                }
            } else if (value.trim().equals(key.trim())) {
                return true;
            }
        }
        catch (Exception e) {
            utilDebug.error("error : " + e.toString());
        }
        return false;
    }

    public static boolean checkSessionUpgrade(SSOToken ssoToken, Hashtable reqDataHash) {
        utilDebug.message("Check Session upgrade!");
        String tmp = null;
        String value = null;
        boolean upgrade = false;
        try {
            if (reqDataHash.get("user") != null) {
                tmp = (String)reqDataHash.get("user");
                value = ssoToken.getProperty("UserToken");
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("user : " + tmp);
                    utilDebug.message("userToken : " + value);
                }
                if (!tmp.equals(value)) {
                    upgrade = true;
                }
            } else if (reqDataHash.get("role") != null) {
                tmp = (String)reqDataHash.get("role");
                value = ssoToken.getProperty("Role");
                if (!AuthClientUtils.isContain(value, tmp)) {
                    upgrade = true;
                }
            } else if (reqDataHash.get("service") != null) {
                tmp = (String)reqDataHash.get("service");
                value = ssoToken.getProperty("Service");
                if (!AuthClientUtils.isContain(value, tmp)) {
                    upgrade = true;
                }
            } else if (reqDataHash.get("module") != null) {
                tmp = (String)reqDataHash.get("module");
                value = ssoToken.getProperty("AuthType");
                if (!AuthClientUtils.isContain(value, tmp)) {
                    upgrade = true;
                }
            } else if (reqDataHash.get("authlevel") != null) {
                int i = Integer.parseInt((String)reqDataHash.get("authlevel"));
                if (i > Integer.parseInt(ssoToken.getProperty("AuthLevel"))) {
                    upgrade = true;
                }
            } else if (reqDataHash.get("sunamcompositeadvice") != null) {
                upgrade = true;
            }
        }
        catch (Exception e) {
            utilDebug.message("Exception in checkSessionUpgrade : ", e);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Check session upgrade : " + upgrade);
        }
        return upgrade;
    }

    public static boolean isClientDetectionEnabled() {
        boolean clientDetectionEnabled = false;
        if (clientDetector != null) {
            String detectionEnabled = clientDetector.detectionEnabled();
            clientDetectionEnabled = detectionEnabled.equalsIgnoreCase("true");
        } else {
            utilDebug.message("getClientDetector,Service does not exist");
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("clientDetectionEnabled = " + clientDetectionEnabled);
        }
        return clientDetectionEnabled;
    }

    public static String getClientType(HttpServletRequest req) {
        if (AuthClientUtils.isClientDetectionEnabled() && clientDetector != null) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("clienttype = " + clientDetector.getClientType(req));
            }
            return clientDetector.getClientType(req);
        }
        return AuthClientUtils.getDefaultClientType();
    }

    public static String getDefaultClientType() {
        String defaultClientType = DEFAULT_CLIENT_TYPE;
        if (defaultClient != null) {
            try {
                defaultClientType = defaultClient.getClientType();
            }
            catch (Exception e) {
                utilDebug.error("getDefaultClientType Error : " + e.toString());
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getDefaultClientType, ClientType = " + defaultClientType);
        }
        return defaultClientType;
    }

    private static Client getClientInstance(String clientType) {
        if (!clientType.equals(AuthClientUtils.getDefaultClientType())) {
            try {
                return AuthClient.getInstance(clientType, null);
            }
            catch (Exception ce) {
                utilDebug.warning("getClientInstance()", ce);
            }
        }
        return defaultClient;
    }

    private static String getProperty(String clientType, String property) {
        try {
            return AuthClientUtils.getClientInstance(clientType).getProperty(property);
        }
        catch (Exception ce) {
            utilDebug.warning("Error retrieving Client Data : " + property + ce.toString());
            return AuthClientUtils.getDefaultProperty(property);
        }
    }

    public static String getDefaultProperty(String property) {
        try {
            return defaultClient.getProperty(property);
        }
        catch (Exception ce) {
            utilDebug.warning("Could not get " + property + ce.toString());
            return null;
        }
    }

    public static String getCharSet(String clientType, Locale locale) {
        String charset = "ISO-8859-1";
        try {
            charset = AuthClientUtils.getClientInstance(clientType).getCharset(locale);
        }
        catch (Exception ce) {
            utilDebug.warning("AuthClientUtils.getCharSet:Client data was not found, setting charset to UTF-8.");
            charset = "UTF-8";
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthClientUtils.getCharSet: Charset from Client is : " + charset);
        }
        return charset;
    }

    public static String getFilePath(String clientType) {
        String filePath = AuthClientUtils.getProperty(clientType, "filePath");
        if (filePath == null) {
            return DEFAULT_FILE_PATH;
        }
        return filePath;
    }

    public static String getContentType(String clientType) {
        String contentType = AuthClientUtils.getProperty(clientType, "contentType");
        if (contentType == null) {
            return DEFAULT_CONTENT_TYPE;
        }
        return contentType;
    }

    public static String getCookieSupport(String clientType) {
        String cookieSup = AuthClientUtils.getProperty(clientType, "cookieSupport");
        return cookieSup;
    }

    public static boolean isGenericHTMLClient(String clientType) {
        String type = AuthClientUtils.getProperty(clientType, DEFAULT_CLIENT_TYPE);
        return type == null || type.equals("true");
    }

    public static boolean isSetCookie(String clientType) {
        boolean setCookie = AuthClientUtils.setCookieVal(clientType, "true");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("setCookie : " + setCookie);
        }
        return setCookie;
    }

    public static boolean setCookieVal(String clientType, String value) {
        boolean setCookie;
        String cookieSupport = AuthClientUtils.getCookieSupport(clientType);
        boolean cookieDetect = AuthClientUtils.getCookieDetect(cookieSupport);
        boolean cookieSup = cookieSupport != null && (cookieSupport.equalsIgnoreCase(value) || cookieSupport.equalsIgnoreCase("cookieDetect"));
        boolean bl = setCookie = cookieSup || cookieDetect;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("cookieSupport : " + cookieSupport);
            utilDebug.message("cookieDetect : " + cookieDetect);
            utilDebug.message(" setCookie is : " + setCookie);
        }
        return setCookie;
    }

    public static boolean getCookieDetect(String cookieSupport) {
        boolean cookieDetect;
        boolean bl = cookieDetect = cookieSupport == null || cookieSupport.equalsIgnoreCase("cookieDetect");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("CookieDetect : " + cookieDetect);
        }
        return cookieDetect;
    }

    public static String getClientURLFromString(String urlString, int index, HttpServletRequest request) {
        String clientTypeInUrl;
        String clientURL = null;
        if (urlString != null && (clientTypeInUrl = urlString.substring(0, index)) != null && clientTypeInUrl.equals(AuthClientUtils.getClientType(request)) && urlString.length() > index) {
            clientURL = urlString.substring(index + 1);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Client URL is :" + clientURL);
        }
        return clientURL;
    }

    public static boolean isUrlRewrite(String clientType) {
        boolean rewriteURL = AuthClientUtils.setCookieVal(clientType, "false");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("rewriteURL : " + rewriteURL);
        }
        return rewriteURL;
    }

    public static String getDSAMEVersion() {
        return dsameVersion;
    }

    public static String getAuthCookieName() {
        return authCookieName;
    }

    public static String getCookieName() {
        return cookieName;
    }

    public static String getPersistentCookieName() {
        return persistentCookieName;
    }

    public static String getlbCookieName() {
        loadBalanceCookieName = SystemProperties.get("com.iplanet.am.lbcookie.name", "amlbcookie");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthClientUtils.getlbCookieName()loadBalanceCookieName is:" + loadBalanceCookieName);
        }
        return loadBalanceCookieName;
    }

    public static String getlbCookieValue() {
        if (SystemProperties.isServerMode()) {
            try {
                return WebtopNaming.getLBCookieValue(WebtopNaming.getAMServerID());
            }
            catch (Exception e) {
                return null;
            }
        }
        return loadBalanceCookieValue;
    }

    public static Set getCookieDomains() {
        Set cookieDomains = Collections.EMPTY_SET;
        try {
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMPlatformService", token);
                ServiceSchema psc = scm.getGlobalSchema();
                Map attrs = psc.getAttributeDefaults();
                cookieDomains = (Set)attrs.get("iplanet-am-platform-cookie-domains");
            }
            catch (SMSException ex) {
                utilDebug.message("getCookieDomains - SMSException ");
            }
            if (cookieDomains == null) {
                cookieDomains = Collections.EMPTY_SET;
            }
        }
        catch (SSOException ex) {
            utilDebug.message("getCookieDomains - SSOException ");
        }
        if (utilDebug.messageEnabled() && !cookieDomains.isEmpty()) {
            utilDebug.message("CookieDomains : ");
            Iterator iter = cookieDomains.iterator();
            while (iter.hasNext()) {
                utilDebug.message("  " + (String)iter.next());
            }
        }
        return cookieDomains;
    }

    public static String getOrganizationDN(String orgParam, boolean noQueryParam, HttpServletRequest request) {
        String orgName;
        block8: {
            SSOToken token;
            block7: {
                orgName = null;
                token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                try {
                    orgName = IdUtils.getOrganization(token, orgParam);
                    if (orgName != null && orgName.length() != 0) {
                        orgName = orgName.toLowerCase();
                    }
                }
                catch (Exception oe) {
                    if (!utilDebug.messageEnabled()) break block7;
                    utilDebug.message("Could not get orgName", oe);
                }
            }
            if ((orgName == null || orgName.length() == 0) && noQueryParam && request != null) {
                String url = request.getRequestURL().toString();
                int index = url.indexOf(";");
                orgParam = index != -1 ? AuthClientUtils.stripPort(url.substring(0, index)) : AuthClientUtils.stripPort(url);
                try {
                    orgName = IdUtils.getOrganization(token, orgParam);
                }
                catch (Exception e) {
                    if (!utilDebug.messageEnabled()) break block8;
                    utilDebug.message("Could not get orgName" + orgParam, e);
                }
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getOrganizationDN : orgParam... :" + orgParam);
            utilDebug.message("getOrganizationDN : orgDN ... :" + orgName);
        }
        return orgName;
    }

    public static String getDomainNameByRequest(HttpServletRequest request, Hashtable requestHash) {
        boolean noQueryParam = false;
        String orgParam = AuthClientUtils.getOrgParam(requestHash);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgParam is.. :" + orgParam);
        }
        if (orgParam == null || orgParam.length() == 0) {
            noQueryParam = true;
            orgParam = request.getServerName();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Hostname : " + orgParam);
            }
        }
        String orgDN = AuthClientUtils.getOrganizationDN(orgParam, noQueryParam, request);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgDN is " + orgDN);
        }
        return orgDN;
    }

    public static String getOrgParam(Hashtable requestHash) {
        String orgParam = null;
        if (requestHash != null && !requestHash.isEmpty()) {
            orgParam = (String)requestHash.get("domain");
            if (orgParam == null || orgParam.length() == 0) {
                orgParam = (String)requestHash.get("org");
            }
            if (orgParam == null || orgParam.length() == 0) {
                orgParam = (String)requestHash.get("realm");
            }
            if (orgParam != null && orgParam.length() != 0) {
                String encoded = (String)requestHash.get("encoded");
                String new_org = (String)requestHash.get("new_org");
                if (new_org != null && new_org.equals("true") && encoded != null && encoded.equals("true")) {
                    orgParam = AuthClientUtils.getBase64DecodedValue(orgParam);
                }
            }
        }
        return orgParam;
    }

    static String stripPort(String in) {
        try {
            URL url = new URL(in);
            return url.getProtocol() + "://" + url.getHost() + url.getFile();
        }
        catch (MalformedURLException ex) {
            return in;
        }
    }

    public static boolean isValidFQDNRequest(String hostName) {
        boolean retVal;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("hostName is : " + hostName);
        }
        if (retVal = fqdnUtils.isHostnameValid(hostName)) {
            utilDebug.message("hostname  and fqdnDefault match returning true");
        } else {
            utilDebug.message("hostname and fqdnDefault don't match");
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("retVal is : " + retVal);
        }
        return retVal;
    }

    public static String getValidFQDNResource(String partialHostName, HttpServletRequest servletRequest) {
        String validHostName;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Get mapping for " + partialHostName);
        }
        if ((validHostName = fqdnUtils.getFullyQualifiedHostName(partialHostName)) == null) {
            validHostName = partialHostName;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("fully qualified hostname :" + validHostName);
        }
        String requestURL = AuthClientUtils.constructURL(validHostName, servletRequest);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Request URL :" + requestURL);
        }
        return requestURL;
    }

    public static String getHostName(HttpServletRequest servletRequest) {
        String hostname = servletRequest.getHeader("host");
        if (hostname != null) {
            int i = hostname.indexOf(":");
            if (i != -1) {
                hostname = hostname.substring(0, i);
            }
        } else {
            hostname = servletRequest.getServerName();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Returning host name : " + hostname);
        }
        return hostname;
    }

    static String constructURL(String validHostName, HttpServletRequest servletRequest) {
        String scheme = RequestUtils.getRedirectProtocol(servletRequest.getScheme(), validHostName);
        int port = servletRequest.getServerPort();
        String requestURI = servletRequest.getRequestURI();
        String queryString = servletRequest.getQueryString();
        StringBuffer urlBuffer = new StringBuffer();
        urlBuffer.append(scheme).append("://").append(validHostName).append(":").append(port).append(requestURI);
        if (queryString != null) {
            urlBuffer.append("?").append(queryString);
        }
        String urlString = urlBuffer.toString();
        if (utilDebug.messageEnabled()) {
            utilDebug.message("returning new url : " + urlString);
        }
        return urlString;
    }

    public static String constructLoginURL(HttpServletRequest request) {
        StringBuffer loginURL = new StringBuffer(serviceURI);
        String qString = request.getQueryString();
        if (qString != null && qString.length() != 0) {
            loginURL.append("?");
            loginURL.append(qString);
        }
        return loginURL.toString();
    }

    public static SSOToken getExistingValidSSOToken(SessionID sessID) {
        SSOToken ssoToken = null;
        try {
            if (sessID != null) {
                SSOToken currentToken;
                String sidString = sessID.toString();
                SSOTokenManager manager = SSOTokenManager.getInstance();
                if (manager.isValidToken(currentToken = manager.createSSOToken(sidString))) {
                    ssoToken = currentToken;
                }
            }
        }
        catch (Exception e) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error in getExistingValidSSOToken :" + e.toString());
            }
            return ssoToken;
        }
        return ssoToken;
    }

    public static boolean isTimedOut(SessionID sessID) {
        boolean isTimedOut;
        block5: {
            isTimedOut = false;
            try {
                if (sessID != null) {
                    SSOToken currentToken;
                    String sidString = sessID.toString();
                    SSOTokenManager manager = SSOTokenManager.getInstance();
                    if (manager.isValidToken(currentToken = manager.createSSOToken(sidString))) {
                        isTimedOut = false;
                    }
                }
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("Session timed out") == -1) break block5;
                isTimedOut = true;
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Session Timed Out :" + isTimedOut);
        }
        return isTimedOut;
    }

    public static String getErrorVal(String errorCode, String type) {
        String errorMsg = null;
        String templateName = null;
        String resProperty = bundle.getString(errorCode);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("errorCod is.. : " + errorCode);
            utilDebug.message("resProperty is.. : " + resProperty);
        }
        if (resProperty != null && resProperty.length() != 0) {
            int commaIndex = resProperty.indexOf(MSG_DELIMITER);
            if (commaIndex != -1) {
                templateName = resProperty.substring(commaIndex + 1, resProperty.length());
                errorMsg = resProperty.substring(0, commaIndex);
            } else {
                errorMsg = resProperty;
            }
        }
        if (type.equals(ERROR_MESSAGE)) {
            return errorMsg;
        }
        if (type.equals(ERROR_TEMPLATE)) {
            return templateName;
        }
        return null;
    }

    public static boolean isCookieSupported(HttpServletRequest req) {
        boolean cookieSupported = true;
        String cookieSupport = AuthClientUtils.getCookieSupport(AuthClientUtils.getClientType(req));
        if (cookieSupport != null && cookieSupport.equals("false")) {
            cookieSupported = false;
        }
        return cookieSupported;
    }

    public static boolean isCookieSet(HttpServletRequest req) {
        boolean cookieSet = false;
        String cookieSupport = AuthClientUtils.getCookieSupport(AuthClientUtils.getClientType(req));
        boolean cookieDetect = AuthClientUtils.getCookieDetect(cookieSupport);
        if (AuthClientUtils.isClientDetectionEnabled() && cookieDetect) {
            cookieSet = true;
        }
        return cookieSet;
    }

    public static Cookie createPersistentCookie(String name, String value, int maxAge, String cookieDomain) {
        Cookie pCookie = CookieUtils.newCookie(name, value, "/", cookieDomain);
        if (maxAge >= 0) {
            pCookie.setMaxAge(maxAge);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("pCookie is.. :" + pCookie);
        }
        return pCookie;
    }

    public static Cookie createlbCookie(String cookieDomain) throws AuthException {
        Cookie lbCookie = null;
        try {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieDomain : " + cookieDomain);
            }
            String cookieName = AuthClientUtils.getlbCookieName();
            String cookieValue = AuthClientUtils.getlbCookieValue();
            lbCookie = AuthClientUtils.createPersistentCookie(cookieName, cookieValue, -1, cookieDomain);
            return lbCookie;
        }
        catch (Exception e) {
            utilDebug.message("Unable to create Load Balance Cookie");
            throw new AuthException("102", null);
        }
    }

    public static Cookie getCookieString(AuthContext ac, String cookieDomain) {
        Cookie cookie;
        block4: {
            cookie = null;
            String cookieName = AuthClientUtils.getAuthCookieName();
            String cookieValue = serverURL + serviceURI;
            try {
                if (ac.getStatus() == AuthContext.Status.SUCCESS) {
                    cookieName = AuthClientUtils.getCookieName();
                    cookieValue = ac.getAuthIdentifier();
                    utilDebug.message("Create AM cookie");
                }
                cookie = AuthClientUtils.createCookie(cookieName, cookieValue, cookieDomain);
            }
            catch (Exception e) {
                if (!utilDebug.messageEnabled()) break block4;
                utilDebug.message("Error getCookieString : " + e.getMessage());
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Cookie is : " + cookie);
        }
        return cookie;
    }

    public static String encodeURL(String url, HttpServletRequest request, AuthContext ac) {
        if (AuthClientUtils.isCookieSupported(request)) {
            return url;
        }
        String cookieName = AuthClientUtils.getAuthCookieName();
        if (ac.getStatus() == AuthContext.Status.SUCCESS) {
            cookieName = AuthClientUtils.getCookieName();
        }
        String encodedURL = url;
        encodedURL = urlRewriteInPath ? AuthClientUtils.encodeURL(url, (short)2, false, cookieName, ac.getAuthIdentifier()) : AuthClientUtils.encodeURL(url, (short)0, true, cookieName, ac.getAuthIdentifier());
        if (utilDebug.messageEnabled()) {
            utilDebug.message("encodeURL : URL = " + url + ", \nRewritten URL = " + encodedURL);
        }
        return encodedURL;
    }

    private static String encodeURL(String url, short encodingScheme, boolean escape, String cookieName, String strSessionID) {
        String encodedURL = url;
        String cookieStr = SessionEncodeURL.createCookieString(cookieName, strSessionID);
        encodedURL = SessionEncodeURL.encodeURL(cookieStr, url, encodingScheme, escape);
        return encodedURL;
    }

    public static String getDefaultFileName(HttpServletRequest request, String fileName, Locale locale, ServletContext servletContext) {
        String strlocale = "";
        if (locale != null) {
            strlocale = locale.toString();
        }
        String filePath = AuthClientUtils.getFilePath(AuthClientUtils.getClientType(request));
        String fileRoot = "default";
        String templateFile = null;
        try {
            templateFile = ResourceLookup.getFirstExisting(servletContext, fileRoot, strlocale, null, filePath, fileName, templatePath, true);
        }
        catch (Exception e) {
            templateFile = templatePath + fileRoot + "/" + fileName;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getDefaultFileName:templateFile is :" + templateFile);
        }
        return templateFile;
    }

    public static String getRootSuffix() {
        return rootSuffix;
    }

    private static String getFileRoot() {
        String fileRoot = "default";
        String rootOrgName = DNUtils.DNtoName(rootSuffix);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("rootOrgName is : " + rootOrgName);
        }
        if (rootOrgName != null) {
            fileRoot = rootOrgName;
        }
        return fileRoot;
    }

    private static String getCharsetFileName(String fileName) {
        ISLocaleContext localeContext = new ISLocaleContext();
        String charset = localeContext.getMIMECharset();
        if (fileName == null) {
            return null;
        }
        int i = fileName.indexOf(".");
        String charsetFilename = null;
        charsetFilename = i != -1 ? fileName.substring(0, i) + "_" + charset + fileName.substring(i) : fileName + "_" + charset;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("charsetFilename is : " + charsetFilename);
        }
        return charsetFilename;
    }

    public static String getResourceLocation(String fileRoot, String localeName, String orgFilePath, String filePath, String filename, String templatePath, ServletContext servletContext, HttpServletRequest request) {
        String resourceName = null;
        String clientType = AuthClientUtils.getClientType(request);
        if (clientType != null && !clientType.equals(AuthClientUtils.getDefaultClientType())) {
            String charsetFileName = AuthClientUtils.getCharsetFileName(filename);
            resourceName = ResourceLookup.getFirstExisting(servletContext, fileRoot, localeName, orgFilePath, filePath, charsetFileName, templatePath, true);
        }
        if (resourceName == null) {
            resourceName = ResourceLookup.getFirstExisting(servletContext, fileRoot, localeName, orgFilePath, filePath, filename, templatePath, true);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Resource is.. " + resourceName);
        }
        return resourceName;
    }

    public static String getFilePath(HttpServletRequest request, AuthContext.IndexType indexType, String indexName) {
        String filePath = AuthClientUtils.getFilePath(AuthClientUtils.getClientType(request));
        String serviceName = null;
        StringBuffer filePathBuffer = new StringBuffer();
        if (indexType != null && indexType.equals(AuthContext.IndexType.SERVICE)) {
            serviceName = indexName;
        }
        if (filePath == null && serviceName == null) {
            return null;
        }
        if (filePath != null && filePath.length() > 0) {
            filePathBuffer.append("/").append(filePath);
        }
        if (serviceName != null && serviceName.length() > 0) {
            filePathBuffer.append("/").append(serviceName);
        }
        String newFilePath = filePathBuffer.toString();
        if (utilDebug.messageEnabled()) {
            utilDebug.message("FilePath is.. :" + newFilePath);
        }
        return newFilePath;
    }

    static String getOrgFilePath(String orgDN) {
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getOrgFilePath : orgDN is: " + orgDN);
        }
        String normOrgDN = DNUtils.normalizeDN(orgDN);
        String orgPath = null;
        if (normOrgDN != null) {
            int i;
            StringBuffer orgFilePath = new StringBuffer();
            String orgName = null;
            for (String remOrgDN = normOrgDN; remOrgDN != null && remOrgDN.length() != 0 && !remOrgDN.equals(AuthClientUtils.getRootSuffix()); remOrgDN = remOrgDN.substring(i + 1)) {
                orgName = DNUtils.DNtoName(remOrgDN);
                orgFilePath = orgFilePath.insert(0, "/" + orgName);
                i = remOrgDN.indexOf(",");
                if (i == -1) break;
                if (!utilDebug.messageEnabled()) continue;
                utilDebug.message("remOrgDN is : " + remOrgDN);
            }
            orgPath = orgFilePath.toString();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getOrgFilePath: orgPath is : " + orgPath);
        }
        return orgPath;
    }

    public static String getFileName(String fileName, String localeName, String orgDN, HttpServletRequest servletRequest, ServletContext servletContext, AuthContext.IndexType indexType, String indexName) {
        String fileRoot = AuthClientUtils.getFileRoot();
        String templateFile = null;
        try {
            String filePath = AuthClientUtils.getFilePath(servletRequest, indexType, indexName);
            String orgFilePath = AuthClientUtils.getOrgFilePath(orgDN);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Calling ResourceLookup: filename = " + fileName + ", defaultOrg = " + fileRoot + ", locale = " + localeName + ", filePath = " + filePath + ", orgPath = " + orgFilePath);
            }
            templateFile = AuthClientUtils.getResourceLocation(fileRoot, localeName, orgFilePath, filePath, fileName, templatePath, servletContext, servletRequest);
        }
        catch (Exception e) {
            utilDebug.message("Error getting File : " + e.getMessage());
            templateFile = templatePath + "/" + "default" + "/" + fileName;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("File/Resource is : " + templateFile);
        }
        return templateFile;
    }

    public static String getAuthCookieValue(HttpServletRequest req) {
        return CookieUtils.getCookieValueFromReq(req, AuthClientUtils.getAuthCookieName());
    }

    public static String getDomainNameByRequest(Hashtable requestHash) {
        String orgParam = AuthClientUtils.getOrgParam(requestHash);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgParam is.. :" + orgParam);
        }
        if (orgParam == null || orgParam.length() == 0) {
            orgParam = "/";
            if (utilDebug.messageEnabled()) {
                utilDebug.message("defaultOrg : " + orgParam);
            }
        }
        String orgDN = AuthClientUtils.getOrganizationDN(orgParam, false, null);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgDN is " + orgDN);
        }
        return orgDN;
    }

    public static boolean isLocalServer(String cookieURL, boolean isServer) {
        boolean local;
        block8: {
            local = false;
            try {
                String urlStr = serverURL + serviceURI;
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("This server URL : " + urlStr);
                    utilDebug.message("Server URL from cookie : " + cookieURL);
                }
                if (urlStr != null && cookieURL != null && cookieURL.equalsIgnoreCase(urlStr)) {
                    local = true;
                }
                if (!local && isServer && cookieURL != null) {
                    int uriIndex = cookieURL.indexOf(serviceURI);
                    String tmpCookieURL = cookieURL;
                    if (uriIndex != -1) {
                        tmpCookieURL = cookieURL.substring(0, uriIndex) + SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
                    }
                    Vector platformList = WebtopNaming.getPlatformServerList();
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("search CookieURL : " + tmpCookieURL);
                        utilDebug.message("platform server List : " + platformList);
                    }
                    if (!platformList.contains(tmpCookieURL)) {
                        local = true;
                    }
                }
            }
            catch (Exception e) {
                if (!utilDebug.messageEnabled()) break block8;
                utilDebug.message("Error isLocalServer : " + e.getMessage());
            }
        }
        return local;
    }

    public static boolean isLocalServer(String cookieURL, String inputURI) {
        int uriIndex = cookieURL.indexOf(inputURI);
        String tmpCookieURL = cookieURL;
        if (uriIndex != -1) {
            tmpCookieURL = cookieURL.substring(0, uriIndex);
        }
        return AuthClientUtils.isLocalServer(tmpCookieURL + serviceURI, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap sendAuthRequestToOrigServer(HttpServletRequest request, HttpServletResponse response, String cookieURL) {
        HashMap<String, String> origRequestData = new HashMap<String, String>();
        if (utilDebug.messageEnabled()) {
            Enumeration requestHeaders = request.getHeaderNames();
            while (requestHeaders.hasMoreElements()) {
                String name = (String)requestHeaders.nextElement();
                Enumeration value = request.getHeaders(name);
                utilDebug.message("Header name = " + name + " Value = " + value);
            }
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        String strCookies = null;
        try {
            String redirect_url;
            URL authURL = new URL(cookieURL);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Connecting to : " + authURL);
            }
            conn = HttpURLConnectionManager.getConnection(authURL);
            conn.setDoOutput(true);
            conn.setUseCaches(useCache);
            conn.setRequestMethod("POST");
            HttpURLConnection.setFollowRedirects(false);
            conn.setInstanceFollowRedirects(false);
            strCookies = AuthClientUtils.getCookiesString(request);
            if (strCookies != null) {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Sending cookies : " + strCookies);
                }
                conn.setRequestProperty("Cookie", strCookies);
            }
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", request.getHeader("content-length"));
            conn.setRequestProperty("Host", request.getHeader("host"));
            utilDebug.message("SENDING DATA ... ");
            String in_requestData = AuthClientUtils.getFormData(request);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Request data : " + in_requestData);
            }
            out = conn.getOutputStream();
            PrintWriter pw = new PrintWriter(out);
            pw.print(in_requestData);
            pw.flush();
            pw.close();
            utilDebug.message("RECEIVING DATA ... ");
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Response Code: " + conn.getResponseCode());
                utilDebug.message("Response Message: " + conn.getResponseMessage());
                utilDebug.message("Follow redirect : " + conn.getFollowRedirects());
            }
            if (conn.getResponseCode() == 200) {
                int len;
                StringBuffer in_buf = new StringBuffer();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                char[] buf = new char[1024];
                while ((len = in.read(buf, 0, buf.length)) != -1) {
                    in_buf.append(buf, 0, len);
                }
                String in_string = in_buf.toString();
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Received response data : " + in_string);
                }
                origRequestData.put("OUTPUT_DATA", in_string);
            } else {
                utilDebug.message("Response code NOT OK");
            }
            String client_type = conn.getHeaderField("AM_CLIENT_TYPE");
            if (client_type != null) {
                origRequestData.put("AM_CLIENT_TYPE", client_type);
            }
            if ((redirect_url = conn.getHeaderField("Location")) != null) {
                origRequestData.put("AM_REDIRECT_URL", redirect_url);
            }
            Map<String, List<String>> headers = conn.getHeaderFields();
            AuthClientUtils.processCookies(headers, response);
            out.flush();
        }
        catch (Exception e) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("send exception : ", e);
            }
        }
        finally {
            block27: {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {
                        if (!utilDebug.messageEnabled()) break block27;
                        utilDebug.message("send IOException : " + ioe.toString());
                    }
                }
            }
        }
        return origRequestData;
    }

    private static String getFormData(HttpServletRequest request) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("");
        Enumeration requestEnum = request.getParameterNames();
        while (requestEnum.hasMoreElements()) {
            String name = (String)requestEnum.nextElement();
            String value = request.getParameter(name);
            buffer.append(URLEncDec.encode(name));
            buffer.append('=');
            buffer.append(URLEncDec.encode(value));
            if (!requestEnum.hasMoreElements()) continue;
            buffer.append('&');
        }
        return buffer.toString();
    }

    private static void processCookies(Map headers, HttpServletResponse response) {
        if (utilDebug.messageEnabled()) {
            utilDebug.message("processCookies : headers : " + headers);
        }
        if (headers == null || headers.isEmpty()) {
            return;
        }
        Iterator hrs = headers.entrySet().iterator();
        while (hrs.hasNext()) {
            List list;
            Map.Entry me = hrs.next();
            String key = (String)me.getKey();
            if (key == null || !key.equalsIgnoreCase("Set-cookie") && !key.equalsIgnoreCase("Cookie") || (list = (List)me.getValue()) == null || list.isEmpty()) continue;
            Cookie cookie = null;
            String domain = null;
            Object path = null;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String nameValue;
                int index;
                StringTokenizer stz;
                String cookieStr = (String)it.next();
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("processCookies : cookie : " + cookieStr);
                }
                if (!(stz = new StringTokenizer(cookieStr, ";")).hasMoreTokens() || (index = (nameValue = stz.nextToken()).indexOf("=")) == -1) continue;
                String tmpName = nameValue.substring(0, index).trim();
                String value = nameValue.substring(index + 1);
                Set domains = AuthClientUtils.getCookieDomains();
                if (!domains.isEmpty()) {
                    Iterator itcd = domains.iterator();
                    while (itcd.hasNext()) {
                        domain = (String)itcd.next();
                        cookie = AuthClientUtils.createCookie(tmpName, value, domain);
                        response.addCookie(cookie);
                    }
                    continue;
                }
                cookie = AuthClientUtils.createCookie(tmpName, value, null);
                response.addCookie(cookie);
            }
        }
    }

    private static String getCookiesString(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        StringBuffer cookieStr = null;
        String strCookies = null;
        if (cookies != null) {
            for (int nCookie = 0; nCookie < cookies.length; ++nCookie) {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Cookie name = " + cookies[nCookie].getName());
                    utilDebug.message("Cookie value = " + cookies[nCookie].getValue());
                }
                if (cookieStr == null) {
                    cookieStr = new StringBuffer();
                } else {
                    cookieStr.append(";");
                }
                cookieStr.append(cookies[nCookie].getName()).append("=").append(cookies[nCookie].getValue());
            }
        }
        if (cookieStr != null) {
            strCookies = cookieStr.toString();
        }
        return strCookies;
    }

    public static void setServerCookie(Cookie aCookie, HttpServletResponse response) throws AuthException {
        String cookieName = aCookie.getName();
        String cookieValue = aCookie.getValue();
        if (cookieName != null && cookieName.length() != 0) {
            Set domains = AuthClientUtils.getCookieDomains();
            if (!domains.isEmpty()) {
                Iterator it = domains.iterator();
                while (it.hasNext()) {
                    String domain = (String)it.next();
                    Cookie cookie = AuthClientUtils.createCookie(cookieName, cookieValue, domain);
                    response.addCookie(cookie);
                }
            } else {
                response.addCookie(AuthClientUtils.createCookie(cookieName, cookieValue, null));
            }
        }
    }

    public static void setRedirectBackServerCookie(String cookieName, String cookieValue, HttpServletResponse response) throws AuthException {
        if (cookieName != null && cookieName.length() != 0) {
            Set domains = AuthClientUtils.getCookieDomains();
            if (!domains.isEmpty()) {
                Iterator it = domains.iterator();
                while (it.hasNext()) {
                    String domain = (String)it.next();
                    Cookie cookie = AuthClientUtils.createCookie(cookieName, cookieValue, domain);
                    response.addCookie(cookie);
                }
            } else {
                response.addCookie(AuthClientUtils.createCookie(cookieName, cookieValue, null));
            }
        }
    }

    public static void clearServerCookie(String cookieName, HttpServletResponse response) {
        if (utilDebug.messageEnabled()) {
            utilDebug.message("In clear server Cookie = " + cookieName);
        }
        if (cookieName != null && cookieName.length() != 0) {
            Set domains = AuthClientUtils.getCookieDomains();
            if (!domains.isEmpty()) {
                Iterator it = domains.iterator();
                while (it.hasNext()) {
                    String domain = (String)it.next();
                    Cookie cookie = AuthClientUtils.createPersistentCookie(cookieName, "LOGOUT", 0, domain);
                    response.addCookie(cookie);
                    utilDebug.message("In clear server Cookie added cookie");
                }
            } else {
                response.addCookie(AuthClientUtils.createPersistentCookie(cookieName, "LOGOUT", 0, null));
                utilDebug.message("In clear server added cookie no domain");
            }
        }
    }

    public static String getQueryStrFromParameters(Map paramMap) {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        if (paramMap != null && !paramMap.isEmpty()) {
            Iterator i = paramMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                String key = (String)me.getKey();
                String value = (String)me.getValue();
                if (first) {
                    buff.append("?");
                    first = false;
                } else {
                    buff.append("&");
                }
                buff.append(key).append("=").append(value);
            }
        }
        return buff.toString();
    }

    public static String getBase64DecodedValue(String encodedStr) {
        String returnValue = null;
        if (encodedStr != null && encodedStr.length() != 0) {
            try {
                returnValue = new String(Base64.decode(encodedStr), "UTF-8");
            }
            catch (RuntimeException rtex) {
                utilDebug.warning("getBase64DecodedValue:RuntimeException");
            }
            catch (UnsupportedEncodingException ueex) {
                utilDebug.warning("getBase64DecodedValue:UnsupportedEncodingException");
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getBase64DecodedValue:returnValue : " + returnValue);
        }
        return returnValue;
    }

    public static boolean persistAMCookie(Hashtable reqDataHash) {
        boolean persistCookie = false;
        String persistCookieString = (String)reqDataHash.get("PersistAMCookie");
        if (persistCookieString != null) {
            persistCookie = Boolean.valueOf(persistCookieString);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils.persistAMCookie(): " + persistCookie);
        }
        return persistCookie;
    }

    public static boolean forceAuthFlagExists(Hashtable reqDataHash) {
        String force = (String)reqDataHash.get("ForceAuth");
        boolean forceFlag = Boolean.valueOf(force);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils.forceFlagExists : " + forceFlag);
        }
        if (!forceFlag && reqDataHash.get("sunamcompositeadvice") != null) {
            String tmp = (String)reqDataHash.get("sunamcompositeadvice");
            forceFlag = AuthClientUtils.checkForForcedAuth(tmp);
        }
        return forceFlag;
    }

    public static boolean checkForForcedAuth(String xmlCompositeAdvice) {
        boolean returnForcedAuth = false;
        try {
            String decodedAdviceXML = URLDecoder.decode(xmlCompositeAdvice);
            Map adviceMap = PolicyUtils.parseAdvicesXML(decodedAdviceXML);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtils.checkForForcedAuth : decoded XML = " + decodedAdviceXML);
                utilDebug.message("AuthUtils.checkForForcedAuth : result Map = " + adviceMap);
            }
            if (adviceMap != null && adviceMap.containsKey("ForceAuth")) {
                returnForcedAuth = true;
            }
        }
        catch (PolicyException polExp) {
            utilDebug.error("AuthUtils.checkForForcedAuth : Error in Policy  XML parsing ", polExp);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils.checkForForcedAuth: returnForcedAuth= " + returnForcedAuth);
        }
        return returnForcedAuth;
    }

    public static void setServiceURI(String strServiceURI) {
        serviceURI = strServiceURI;
    }

    public static String getServiceURI() {
        return serviceURI;
    }

    static {
        urlRewriteInPath = Boolean.valueOf(SystemProperties.get("com.sun.identity.cookieRewritingInPath", ""));
        templatePath = "/" + "config" + "/" + "auth";
        rootSuffix = SMSEntry.getRootSuffix();
        dsameVersion = SystemProperties.get("com.iplanet.am.version", DSAME_VERSION);
        cookieName = SystemProperties.get("com.iplanet.am.cookie.name");
        authCookieName = SystemProperties.get("com.sun.identity.auth.cookieName", "AMAuthCookie");
        loadBalanceCookieName = null;
        persistentCookieName = SystemProperties.get("com.iplanet.am.pcookie.name");
        loadBalanceCookieValue = SystemProperties.get("com.iplanet.am.lbcookie.value");
        serviceURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor") + "/UI/Login";
        webContainer = SystemProperties.get("com.sun.identity.webcontainer");
        serverURL = null;
        utilDebug = Debug.getInstance("amAuthClientUtils");
        useCache = Boolean.getBoolean(SystemProperties.get("com.sun.identity.urlconnection.useCache", "false"));
        String installTime = SystemProperties.get("com.sun.identity.security.amadmin", "false");
        if (installTime.equalsIgnoreCase("false")) {
            clientDetector = new AMClientDetector();
            if (AuthClientUtils.isClientDetectionEnabled()) {
                defaultClient = ClientsManager.getDefaultInstance();
            }
        }
        fqdnUtils = new FQDNUtils();
        bundle = com.iplanet.am.util.Locale.getInstallResourceBundle(BUNDLE_NAME);
        if (webContainer != null && webContainer.length() > 0 && (webContainer.indexOf("BEA") >= 0 || webContainer.indexOf("IBM5.1") >= 0)) {
            setRequestEncoding = true;
        }
        loadBalanceCookieName = SystemProperties.isServerMode() ? SystemProperties.get("com.iplanet.am.lbcookie.name", "amlbcookie") : SystemProperties.get("com.iplanet.am.lbcookie.name");
        String proto = SystemProperties.get("com.iplanet.distAuth.server.protocol");
        String host = null;
        String port = null;
        if (proto != null && proto.length() != 0) {
            host = SystemProperties.get("com.iplanet.distAuth.server.host");
            port = SystemProperties.get("com.iplanet.distAuth.server.port");
        } else {
            proto = SystemProperties.get("com.iplanet.am.server.protocol");
            host = SystemProperties.get("com.iplanet.am.server.host");
            port = SystemProperties.get("com.iplanet.am.server.port");
        }
        serverURL = proto + "://" + host + ":" + port;
    }
}

