/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConfiguredAuthServices
extends ChoiceValues {
    protected static final String SERVICE_NAME = "iPlanetAMAuthConfiguration";
    protected static final String NAMED_CONFIGURATION = "Configurations";

    public Map getChoiceValues() {
        return this.getChoiceValues(Collections.EMPTY_MAP);
    }

    public Map getChoiceValues(Map envParams) {
        String orgDN = null;
        SSOToken adminToken = null;
        if (envParams != null) {
            orgDN = (String)envParams.get("organization_name");
            adminToken = (SSOToken)envParams.get("SSOToken");
        }
        if (orgDN == null || orgDN.length() == 0) {
            orgDN = SMSEntry.getRootSuffix();
        }
        if (adminToken == null) {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        Set namedConfigs = Collections.EMPTY_SET;
        HashMap<String, String> answer = new HashMap<String, String>();
        try {
            ServiceConfig namedConfig;
            ServiceConfigManager scm = new ServiceConfigManager(SERVICE_NAME, adminToken);
            ServiceConfig oConfig = scm.getOrganizationConfig(orgDN, null);
            if (oConfig != null && (namedConfig = oConfig.getSubConfig(NAMED_CONFIGURATION)) != null) {
                namedConfigs = namedConfig.getSubConfigNames("*");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (namedConfigs != null && !namedConfigs.isEmpty()) {
            Iterator it = namedConfigs.iterator();
            while (it.hasNext()) {
                String config = (String)it.next();
                answer.put(config, config);
            }
        }
        answer.put("[Empty]", "[Empty]");
        return answer;
    }
}

