/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSScoping;
import com.sun.identity.federation.message.common.Extension;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.RequestAuthnContext;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSAuthnRequest
extends AbstractRequest {
    private List extensions = null;
    private boolean isPassive = false;
    private boolean forceAuthn = false;
    private boolean federate = false;
    private String nameIDPolicy = null;
    private String protocolProfile = null;
    private String providerId = null;
    private RequestAuthnContext authnContext = null;
    private String relayState = null;
    protected String xmlString = null;
    protected String signatureString = null;
    protected String authContextCompType = null;
    protected String id = null;
    protected String assertionConsumerServiceID = null;
    protected String consentURI = null;
    protected String affiliationID = null;
    protected int minorVersion = 0;
    protected FSScoping scoping = null;
    private static final String QUERY_STRING_EXTENSION_PREFIX = "AE_";

    public FSAuthnRequest() {
        this.setIssueInstant(new Date());
    }

    public FSAuthnRequest(String requestId, List respondWiths, String providerID, boolean forceAuthn, boolean isPassive, boolean fed, String nameIDPolicy, String protocolProf, RequestAuthnContext authnCxt, String relaySt, String authContextCompType) throws FSMsgException {
        this.setIssueInstant(new Date());
        if (respondWiths != null && respondWiths != Collections.EMPTY_LIST) {
            int length = respondWiths.size();
            for (int i = 0; i < length; ++i) {
                Object temp = respondWiths.get(i);
                if (temp instanceof String) continue;
                FSUtils.debug.error("FSAuthnRequest: wrong input for RespondWith");
                throw new FSMsgException("wrongInput", null);
            }
            this.respondWiths = respondWiths;
        }
        if (requestId != null && requestId.length() != 0) {
            this.requestID = requestId;
        } else {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSAuthnRequest: couldn't gen RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        this.isPassive = isPassive;
        this.forceAuthn = forceAuthn;
        this.providerId = providerID;
        this.federate = fed;
        this.nameIDPolicy = nameIDPolicy;
        this.protocolProfile = protocolProf;
        this.relayState = relaySt;
        this.authnContext = authnCxt;
        this.authContextCompType = authContextCompType;
        this.id = this.requestID;
    }

    public FSAuthnRequest(Element root) throws FSMsgException {
        String tag = null;
        if (root == null) {
            FSUtils.debug.error("FSAuthnRequest(Element): null input.");
            throw new FSMsgException("nullInput", null);
        }
        tag = root.getLocalName();
        if (tag == null || !tag.equals("AuthnRequest")) {
            FSUtils.debug.error("FSAuthnRequest(Element): wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            FSUtils.debug.error("FSAuthnRequest(Element): missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (ParseException e) {
            FSUtils.debug.error("FSAuthnRequest(Element): could not parse IssueInstant", e);
            throw new FSMsgException("wrongInput", null);
        }
        this.consentURI = root.getAttribute("consent");
        this.id = root.getAttribute("id");
        this.requestID = root.getAttribute("RequestID");
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        NodeList contentnl = root.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("RespondWith")) {
                if (this.respondWiths == Collections.EMPTY_LIST) {
                    this.respondWiths = new ArrayList();
                }
                this.respondWiths.add(XMLUtils.getElementValue((Element)child));
                continue;
            }
            if (nodeName.equals("ProviderID")) {
                if (this.providerId != null && this.providerId.length() != 0) {
                    FSUtils.debug.error("FSAuthnRequest(Element): shouldcontain only one ProviderID.");
                    throw new FSMsgException("wrongInput", null);
                }
                this.providerId = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (nodeName.equals("NameIDPolicy")) {
                this.nameIDPolicy = XMLUtils.getElementValue((Element)child);
                if (this.nameIDPolicy == null || !this.nameIDPolicy.equals("federated") && !this.nameIDPolicy.equals("onetime")) continue;
                this.federate = true;
                continue;
            }
            if (nodeName.equals("Federate")) {
                String strFederate = XMLUtils.getElementValue((Element)child);
                if ((strFederate == null || strFederate.length() == 0 || !strFederate.equals("true")) && !strFederate.equals("1")) continue;
                this.federate = true;
                continue;
            }
            if (nodeName.equals("IsPassive")) {
                String strIsPassive = XMLUtils.getElementValue((Element)child);
                if (strIsPassive != null && strIsPassive.length() != 0 && strIsPassive.equals("true")) {
                    this.isPassive = true;
                    continue;
                }
                this.isPassive = false;
                continue;
            }
            if (nodeName.equals("ForceAuthn")) {
                String strForceAuthn = XMLUtils.getElementValue((Element)child);
                if (strForceAuthn != null && strForceAuthn.length() != 0 && strForceAuthn.equals("true")) {
                    this.forceAuthn = true;
                    continue;
                }
                this.forceAuthn = false;
                continue;
            }
            if (nodeName.equals("ProtocolProfile")) {
                if (this.protocolProfile != null && this.protocolProfile.length() != 0) {
                    FSUtils.debug.error("FSAuthnRequest(Element): should contain only one ProtocolProfile.");
                    throw new FSMsgException("wrongInput", null);
                }
                this.protocolProfile = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (nodeName.equals("AuthnContext")) {
                this.authnContext = new RequestAuthnContext((Element)child);
                continue;
            }
            if (nodeName.equals("RequestAuthnContext")) {
                this.authnContext = new RequestAuthnContext((Element)child);
                continue;
            }
            if (nodeName.equals("RelayState")) {
                this.relayState = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (nodeName.equals("AuthnContextComparison")) {
                this.authContextCompType = XMLUtils.getElementValue((Element)child);
                if (this.authContextCompType.equals("minimum") || this.authContextCompType.equals("exact") || this.authContextCompType.equals("maximum") || this.authContextCompType.equals("better")) continue;
                throw new FSMsgException("wrongInput", null);
            }
            if (nodeName.equals("AssertionConsumerServiceID")) {
                this.assertionConsumerServiceID = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (nodeName.equals("AffiliationID")) {
                this.affiliationID = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (nodeName.equals("Extension")) {
                if (this.extensions == null) {
                    this.extensions = new ArrayList();
                }
                this.extensions.add(new Extension((Element)child));
                continue;
            }
            if (nodeName.equals("Scoping")) {
                this.scoping = new FSScoping((Element)child);
                continue;
            }
            FSUtils.debug.error("FSAuthnRequest(Element): invalid node" + nodeName);
            throw new FSMsgException("wrongInput", null);
        }
        List signs = XMLUtils.getElementsByTagNameNS1(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.xmlString = XMLUtils.print(root);
            this.signed = true;
        } else if (signsSize != 0) {
            FSUtils.debug.error("FSAuthnRequest(Element): included more than one Signature element.");
            throw new FSMsgException("moreElement", null);
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        if (this.xmlString != null) {
            return this.xmlString;
        }
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSAuthnRequest.toXMLString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSAuthnRequest.toXMLString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>");
        }
        String prefix = "";
        String samlpPrefix = "";
        String uri = "";
        String samlpUri = "";
        if (includeNS) {
            prefix = "lib:";
            samlpPrefix = "samlp:";
        }
        if (declareNS) {
            uri = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            samlpUri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        String instantString = DateUtils.toUTCDateFormat(this.issueInstant);
        if (this.requestID != null) {
            String strFederate;
            xml.append("<").append(prefix).append("AuthnRequest").append(uri).append(" ").append(samlpUri);
            if (this.minorVersion == 0 && this.id != null && this.id.length() != 0) {
                xml.append(" ").append("id").append('=').append("\"").append(this.id).append("\"");
            }
            xml.append(" ").append("RequestID").append('=').append("\"").append(this.requestID).append("\"").append(" ").append("MajorVersion").append('=').append("\"").append(this.majorVersion).append("\"").append(" ").append("MinorVersion").append('=').append("\"").append(this.minorVersion).append("\"").append(" ").append("IssueInstant").append('=').append("\"").append(instantString).append("\"");
            if (this.consentURI != null) {
                xml.append(" ").append("consent").append('=').append("\"").append(this.consentURI).append("\"");
            }
            xml.append(">");
            if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
                Iterator i = this.respondWiths.iterator();
                while (i.hasNext()) {
                    xml.append("<").append(samlpPrefix).append("RespondWith").append(">").append((String)i.next()).append("</").append(samlpPrefix).append("RespondWith").append(">");
                }
            }
            if (this.signed) {
                if (this.signatureString != null) {
                    xml.append(this.signatureString);
                } else if (this.signature != null) {
                    this.signatureString = XMLUtils.print(this.signature);
                    xml.append(this.signatureString);
                }
            }
            if (this.extensions != null && !this.extensions.isEmpty()) {
                Iterator iter = this.extensions.iterator();
                while (iter.hasNext()) {
                    Extension extension = (Extension)iter.next();
                    extension.setMinorVersion(this.minorVersion);
                    xml.append(extension.toXMLString());
                }
            }
            xml.append("<").append(prefix).append("ProviderID").append(">").append(this.providerId).append("</").append(prefix).append("ProviderID").append(">");
            if (this.affiliationID != null) {
                xml.append("<").append(prefix).append("AffiliationID").append(">").append(this.affiliationID).append("</").append(prefix).append("AffiliationID").append(">");
            }
            if (this.minorVersion == 2) {
                strFederate = "none";
                if (this.federate) {
                    strFederate = "federated";
                    if (this.nameIDPolicy != null && this.nameIDPolicy.length() > 0) {
                        strFederate = this.nameIDPolicy;
                    }
                }
                xml.append("<").append(prefix).append("NameIDPolicy").append(">").append(strFederate).append("</").append(prefix).append("NameIDPolicy").append(">");
            } else {
                strFederate = "false";
                if (this.federate) {
                    strFederate = "true";
                }
                xml.append("<").append(prefix).append("Federate").append(">").append(strFederate).append("</").append(prefix).append("Federate").append(">");
            }
            String strForceAuthn = "false";
            if (this.forceAuthn) {
                strForceAuthn = "true";
            }
            xml.append("<").append(prefix).append("ForceAuthn").append(">").append(strForceAuthn).append("</").append(prefix).append("ForceAuthn").append(">");
            String strIsPassive = "false";
            if (this.isPassive) {
                strIsPassive = "true";
            }
            xml.append("<").append(prefix).append("IsPassive").append(">").append(strIsPassive).append("</").append(prefix).append("IsPassive").append(">");
            if (this.protocolProfile != null && this.protocolProfile.length() != 0) {
                xml.append("<").append(prefix).append("ProtocolProfile").append(">").append(this.protocolProfile).append("</").append(prefix).append("ProtocolProfile").append(">");
            }
            if (this.assertionConsumerServiceID != null) {
                xml.append("<").append(prefix).append("AssertionConsumerServiceID").append(">").append(this.assertionConsumerServiceID).append("</").append(prefix).append("AssertionConsumerServiceID").append(">");
            }
            if (this.authnContext != null) {
                this.authnContext.setMinorVersion(this.minorVersion);
                xml.append(this.authnContext.toXMLString());
            }
            if (this.relayState != null && this.relayState.length() != 0) {
                xml.append("<").append(prefix).append("RelayState").append(">").append(XMLUtils.escapeSpecialCharacters(this.relayState)).append("</").append(prefix).append("RelayState").append(">");
            }
            if (this.minorVersion == 2 && this.scoping != null) {
                xml.append(this.scoping.toXMLString(true, false));
            }
            if (this.minorVersion == 0 && this.authContextCompType != null && this.authContextCompType.length() != 0) {
                xml.append("<").append(prefix).append("AuthnContextComparison").append(">").append(this.authContextCompType).append("</").append(prefix).append("AuthnContextComparison").append(">");
            }
        } else {
            FSUtils.debug.error("FSAuthnRequest.toString: requestID is null ");
            throw new FSMsgException("nullAuthnRequestID", null);
        }
        xml.append("</").append(prefix).append("AuthnRequest").append(">");
        return xml.toString();
    }

    public static FSAuthnRequest parseXML(String xml) throws FSMsgException {
        Document doc = XMLUtils.toDOMDocument(xml, FSUtils.debug);
        if (doc == null) {
            FSUtils.debug.error("FSAuthnRequest.parseXML:Error while parsing input xml string");
            throw new FSMsgException("parseError", null);
        }
        Element root = doc.getDocumentElement();
        return new FSAuthnRequest(root);
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public List getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List extensions) {
        this.extensions = extensions;
    }

    public boolean getForceAuthn() {
        return this.forceAuthn;
    }

    public void setForceAuthn(boolean forceAuthn) {
        this.forceAuthn = forceAuthn;
    }

    public boolean getIsPassive() {
        return this.isPassive;
    }

    public void setIsPassive(boolean isPassive) {
        this.isPassive = isPassive;
    }

    public boolean getFederate() {
        return this.federate;
    }

    public void setFederate(boolean fed) {
        this.federate = fed;
    }

    public String getNameIDPolicy() {
        return this.nameIDPolicy;
    }

    public void setNameIDPolicy(String nameIDPolicy) {
        this.nameIDPolicy = nameIDPolicy;
    }

    public String getProtocolProfile() {
        return this.protocolProfile;
    }

    public void setProtocolProfile(String protocolProf) {
        this.protocolProfile = protocolProf;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relaySt) {
        this.relayState = relaySt;
    }

    public RequestAuthnContext getAuthnContext() {
        return this.authnContext;
    }

    public void setAuthnContext(RequestAuthnContext authnCxt) {
        this.authnContext = authnCxt;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String provId) {
        this.providerId = provId;
    }

    public String getAuthContextCompType() {
        return this.authContextCompType;
    }

    public void setAuthContextCompType(String authType) {
        this.authContextCompType = authType;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public String getAffiliationID() {
        return this.affiliationID;
    }

    public void setAffiliationID(String affiliationID) {
        this.affiliationID = affiliationID;
    }

    public String getAssertionConsumerServiceID() {
        return this.assertionConsumerServiceID;
    }

    public void setAssertionConsumerServiceID(String assertionConsumerServiceID) {
        this.assertionConsumerServiceID = assertionConsumerServiceID;
    }

    public String getConsent() {
        return this.consentURI;
    }

    public void setConsent(String consentURI) {
        this.consentURI = consentURI;
    }

    public void setScoping(FSScoping scoping) {
        this.scoping = scoping;
    }

    public FSScoping getScoping() {
        return this.scoping;
    }

    private void parseMajorVersion(String majorVer) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest(Element): invalid MajorVersion", e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnRequest(Element): MajorVersion of the AuthnRequest is too high.");
                }
                throw new FSMsgException("requestVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest(Element): MajorVersion of the AuthnRequest is too low.");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String minorVer) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest(Element): invalid MinorVersion", e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion > 2) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: Minor Version of the AuthnRequest is too high.");
            }
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: Minor Version of the AuthnRequest is too low.");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    private static int checkMajorVersion(String majorVer) throws FSMsgException {
        int majorVersion;
        if (majorVer == null) {
            throw new FSMsgException("nullMajorVersion", null);
        }
        try {
            majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMajorVersion: invalid MajorVersion: " + e.getMessage());
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (majorVersion != 1) {
            if (majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnRequest.checkMajorVersion: MajorVersion of the AuthnRequest is too high" + majorVersion);
                }
                throw new FSMsgException("requestVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMajorVersion:MajorVersion of the AuthnRequest is too low. " + majorVersion);
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
        return majorVersion;
    }

    private static int checkMinorVersion(String minorVer) throws FSMsgException {
        int minorVersion;
        if (minorVer == null) {
            throw new FSMsgException("nullMinorVersion", null);
        }
        try {
            minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: invalid MinorVersion", e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (minorVersion == 2 || minorVersion == 0) {
            return minorVersion;
        }
        if (minorVersion > 2) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: Minor Version of the AuthnRequest is too high.");
            }
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnRequest.checkMinorVersion: Minor Version of the AuthnRequest is too low.");
        }
        throw new FSMsgException("requestVersionTooLow", null);
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        int len;
        String strFederate;
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSAuthnRequest.toURLEncodedQueryString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSAuthnRequest.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer urlEncodedAuthnReq = new StringBuffer(300);
        urlEncodedAuthnReq.append("RequestID").append('=').append(URLEncDec.encode(this.requestID)).append('&').append("MajorVersion").append('=').append(this.majorVersion).append('&').append("MinorVersion").append('=').append(this.minorVersion).append('&');
        if (this.extensions != null && !this.extensions.isEmpty()) {
            Extension extension = (Extension)this.extensions.get(0);
            urlEncodedAuthnReq.append(extension.toURLEncodedQueryString(QUERY_STRING_EXTENSION_PREFIX)).append('&');
            if (this.extensions.size() > 1 && FSUtils.debug.warningEnabled()) {
                FSUtils.debug.warning("FSAuthnRequest.toURLEncodedQueryString: only one Extension element is allowed and extras  will be removed");
            }
        }
        urlEncodedAuthnReq.append("ProviderID").append('=').append(URLEncDec.encode(this.providerId)).append('&');
        if (this.consentURI != null) {
            urlEncodedAuthnReq.append("consent").append('=').append(URLEncDec.encode(this.consentURI)).append('&');
        }
        if (this.affiliationID != null) {
            urlEncodedAuthnReq.append("AffiliationID").append('=').append(URLEncDec.encode(this.affiliationID)).append('&');
        }
        if (this.issueInstant == null) {
            FSUtils.debug.error("FSAuthnRequest.toURLEncodedQueryString: issueInstant missing");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        urlEncodedAuthnReq.append("IssueInstant").append('=').append(URLEncDec.encode(DateUtils.toUTCDateFormat(this.issueInstant))).append('&');
        String strForceAuthn = "false";
        if (this.forceAuthn) {
            strForceAuthn = "true";
        }
        urlEncodedAuthnReq.append("ForceAuthn").append('=').append(strForceAuthn).append('&');
        String strIsPassive = "false";
        if (this.isPassive) {
            strIsPassive = "true";
        }
        urlEncodedAuthnReq.append("IsPassive").append('=').append(strIsPassive).append('&');
        if (this.minorVersion == 2) {
            strFederate = "none";
            if (this.federate) {
                strFederate = "federated";
                if (this.nameIDPolicy != null && this.nameIDPolicy.length() > 0) {
                    strFederate = this.nameIDPolicy;
                }
            }
            urlEncodedAuthnReq.append("NameIDPolicy").append('=').append(strFederate).append('&');
        } else {
            strFederate = "false";
            if (this.federate) {
                strFederate = "true";
            }
            urlEncodedAuthnReq.append("Federate").append('=').append(strFederate).append('&');
        }
        if (this.protocolProfile != null && this.protocolProfile.length() != 0) {
            urlEncodedAuthnReq.append("ProtocolProfile").append('=').append(URLEncDec.encode(this.protocolProfile)).append('&');
        }
        if (this.authnContext != null) {
            this.authnContext.setMinorVersion(this.minorVersion);
            urlEncodedAuthnReq.append(this.authnContext.toURLEncodedQueryString());
        }
        if (this.relayState != null && this.relayState.length() != 0) {
            urlEncodedAuthnReq.append("RelayState").append('=').append(URLEncDec.encode(this.relayState)).append('&');
        }
        if (this.scoping != null) {
            urlEncodedAuthnReq.append(this.scoping.toURLEncodedQueryString());
        }
        if (this.minorVersion == 0 && this.authContextCompType != null && this.authContextCompType.length() != 0) {
            urlEncodedAuthnReq.append("AuthnContextComparison").append('=').append(URLEncDec.encode(this.authContextCompType)).append('&');
        }
        if (urlEncodedAuthnReq.charAt(len = urlEncodedAuthnReq.length() - 1) == '&') {
            urlEncodedAuthnReq = urlEncodedAuthnReq.deleteCharAt(len);
        }
        return urlEncodedAuthnReq.toString();
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSAuthnRequest.toBASE64EncodedString: providerId is null in the request with requestId:" + this.requestID);
            Object[] args = new String[]{this.requestID};
            throw new FSMsgException("nullProviderIdWRequestId", args);
        }
        if (this.requestID == null || this.requestID.length() == 0) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSAuthnRequest.toBASE64EncodedString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        return Base64.encode(this.toXMLString().getBytes());
    }

    public static FSAuthnRequest parseURLEncodedRequest(HttpServletRequest request) throws FSMsgException {
        String authnContextComparison;
        String relayState;
        FSAuthnRequest retAuthnRequest = new FSAuthnRequest();
        String authReqID = request.getParameter("RequestID");
        if (authReqID == null || authReqID.length() == 0) {
            throw new FSMsgException("nullAuthnRequestID", null);
        }
        retAuthnRequest.requestID = authReqID;
        String instantString = request.getParameter("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            retAuthnRequest.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (ParseException e) {
            throw new FSMsgException("parseError", null);
        }
        retAuthnRequest.majorVersion = FSAuthnRequest.checkMajorVersion(request.getParameter("MajorVersion"));
        retAuthnRequest.minorVersion = FSAuthnRequest.checkMinorVersion(request.getParameter("MinorVersion"));
        String providerId = request.getParameter("ProviderID");
        if (providerId == null || providerId.length() == 0) {
            throw new FSMsgException("nullProviderIdInRequest", null);
        }
        FSUtils.debug.message("ProviderID of the sender: " + providerId);
        retAuthnRequest.providerId = providerId;
        retAuthnRequest.affiliationID = request.getParameter("AffiliationID");
        String forceAuthn = request.getParameter("ForceAuthn");
        retAuthnRequest.forceAuthn = forceAuthn != null && forceAuthn.length() != 0 && forceAuthn.equals("true") || forceAuthn.equals("1");
        String isPassive = request.getParameter("IsPassive");
        retAuthnRequest.isPassive = isPassive != null && isPassive.length() != 0 && (isPassive.equals("true") || isPassive.equals("1"));
        if (retAuthnRequest.minorVersion == 2) {
            String nameIDPolicy = request.getParameter("NameIDPolicy");
            if (nameIDPolicy != null && (nameIDPolicy.equals("federated") || nameIDPolicy.equals("onetime"))) {
                retAuthnRequest.federate = true;
            }
            retAuthnRequest.nameIDPolicy = nameIDPolicy;
        } else {
            String federate = request.getParameter("Federate");
            retAuthnRequest.federate = federate != null && federate.length() != 0 && (federate.equals("true") || federate.equals("1"));
        }
        String protocolProfile = request.getParameter("ProtocolProfile");
        if (protocolProfile != null && protocolProfile.length() != 0) {
            retAuthnRequest.protocolProfile = protocolProfile;
        }
        if ((relayState = request.getParameter("RelayState")) != null && relayState.length() != 0) {
            retAuthnRequest.setRelayState(relayState);
        }
        if ((authnContextComparison = request.getParameter("AuthnContextComparison")) != null && authnContextComparison.length() != 0) {
            retAuthnRequest.setAuthContextCompType(authnContextComparison);
            String authType = retAuthnRequest.getAuthContextCompType();
            if (!(authType.equals("minimum") || authType.equals("exact") || authType.equals("maximum") || authType.equals("better"))) {
                throw new FSMsgException("wrongInput", null);
            }
        }
        retAuthnRequest.authnContext = RequestAuthnContext.parseURLEncodedRequest(request, retAuthnRequest.getMinorVersion());
        retAuthnRequest.scoping = FSScoping.parseURLEncodedRequest(request);
        Extension extension = Extension.parseURLEncodedRequest((HttpServletRequest)request, (String)QUERY_STRING_EXTENSION_PREFIX, (int)retAuthnRequest.getMinorVersion());
        if (extension != null) {
            retAuthnRequest.extensions = new ArrayList();
            retAuthnRequest.extensions.add(extension);
        }
        return retAuthnRequest;
    }

    public static FSAuthnRequest parseBASE64EncodedString(String encodedReq) throws FSMsgException {
        if (encodedReq != null && encodedReq.length() != 0) {
            String decodedAuthnReq = new String(Base64.decode(encodedReq));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.parseBASE64EncodedString: decoded input string: " + decodedAuthnReq);
            }
            return FSAuthnRequest.parseXML(decodedAuthnReq);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnRequest.parseBASE64EncodedString: null String passed in as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSAuthnRequest.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnRequest.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() == 0) {
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, (String)null, "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, (String)null, "RequestID", this.getRequestID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument(this.signatureString, FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception e) {
            throw new SAMLResponderException("libIDFF", "signFailed", null);
        }
    }

    public void signXML() throws SAMLException {
        throw new SAMLException("libIDFF", "unsupportedOperation", null);
    }

    public boolean setSignature(Element elem) {
        this.signatureString = XMLUtils.print(elem);
        return super.setSignature(elem);
    }
}

