/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.protocol;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.protocol.PasswordTransforms;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SASLResponse {
    public static final String CONTINUE = "continue";
    public static final String ABORT = "abort";
    public static final String OK = "OK";
    private String statusCode = null;
    private PasswordTransforms passwordTransforms = null;
    private byte[] data = null;
    private ResourceOffering resourceOffering = null;
    private List credentials = null;
    private String serverMechanism = null;
    private String id = null;
    private String messageID = null;
    private String refToMessageID = null;

    public SASLResponse(String statusCode) {
        this.statusCode = statusCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SASLResponse(Element element) throws AuthnSvcException {
        Node child;
        String statusCodeStr;
        QName statusCodeQN;
        int i;
        Element statusE = null;
        Element ptE = null;
        Element dataE = null;
        Element roE = null;
        Node credentialsE = null;
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (i = 0; i < length; ++i) {
            Node child2 = nl.item(i);
            if (child2.getNodeType() != 1) continue;
            Element childElement = (Element)child2;
            String localName = childElement.getLocalName();
            String namespaceURI = childElement.getNamespaceURI();
            if (!"urn:liberty:sa:2004-04".equals(namespaceURI) || !"Status".equals(localName)) throw new AuthnSvcException("missingStatus");
            statusE = childElement;
            break;
        }
        if (!"urn:liberty:sa:2004-04".equals((statusCodeQN = Utils.convertStringToQName(statusCodeStr = XMLUtils.getNodeAttributeValue(statusE, "code"), statusE)).getNamespaceURI())) {
            throw new AuthnSvcException("invalidStatusCodeNS");
        }
        this.statusCode = statusCodeQN.getLocalPart();
        ++i;
        while (i < length) {
            child = nl.item(i);
            if (child.getNodeType() == 1) {
                Element childElement = (Element)child;
                String localName = childElement.getLocalName();
                String namespaceURI = childElement.getNamespaceURI();
                if ("urn:liberty:sa:2004-04".equals(namespaceURI)) {
                    if ("Status".equals(localName)) {
                        throw new AuthnSvcException("tooManyStatus");
                    }
                    if ("PasswordTransforms".equals(localName)) {
                        if (ptE != null) {
                            throw new AuthnSvcException("tooManyPT");
                        }
                        if (dataE != null || roE != null || credentialsE != null) {
                            throw new AuthnSvcException("invalidSeq");
                        }
                        ptE = childElement;
                    } else if ("Data".equals(localName)) {
                        if (dataE != null) {
                            throw new AuthnSvcException("tooManyData");
                        }
                        if (roE != null || credentialsE != null) {
                            throw new AuthnSvcException("invalidSeq");
                        }
                        dataE = childElement;
                    } else {
                        if (!"Credentials".equals(localName)) throw new AuthnSvcException("invalidChild");
                        if (credentialsE != null) {
                            throw new AuthnSvcException("tooManyCr");
                        }
                        credentialsE = childElement;
                    }
                } else {
                    if (!"urn:liberty:disco:2003-08".equals(namespaceURI) || !"ResourceOffering".equals(localName)) throw new AuthnSvcException("invalidChild");
                    if (roE != null) {
                        throw new AuthnSvcException("tooManyRO");
                    }
                    if (credentialsE != null) {
                        throw new AuthnSvcException("invalidSeq");
                    }
                    roE = childElement;
                }
            }
            ++i;
        }
        if (ptE != null) {
            this.passwordTransforms = new PasswordTransforms(ptE);
        }
        this.data = AuthnSvcUtils.decodeDataElement(dataE);
        if (roE != null) {
            try {
                this.resourceOffering = new ResourceOffering(roE);
            }
            catch (Exception ex) {
                throw new AuthnSvcException(ex);
            }
        }
        if (credentialsE != null) {
            this.credentials = new ArrayList();
            nl = credentialsE.getChildNodes();
            for (i = 0; i < nl.getLength(); ++i) {
                child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                this.credentials.add(child);
            }
        }
        this.serverMechanism = XMLUtils.getNodeAttributeValue(element, "serverMechanism");
        this.id = XMLUtils.getNodeAttributeValue(element, "id");
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public PasswordTransforms getPasswordTransforms() {
        return this.passwordTransforms;
    }

    public byte[] getData() {
        return this.data;
    }

    public ResourceOffering getResourceOffering() {
        return this.resourceOffering;
    }

    public List getCredentials() {
        return this.credentials;
    }

    public String getServerMechanism() {
        return this.serverMechanism;
    }

    public String getId() {
        return this.id;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getRefToMessageID() {
        return this.refToMessageID;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setPasswordTransforms(PasswordTransforms passwordTransforms) {
        this.passwordTransforms = passwordTransforms;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setResourceOffering(ResourceOffering resourceOffering) {
        this.resourceOffering = resourceOffering;
    }

    public void setCredentials(List credentials) {
        this.credentials = credentials;
    }

    public void setServerMechanism(String serverMechanism) {
        this.serverMechanism = serverMechanism;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public void setRefToMessageID(String refToMessageID) {
        this.refToMessageID = refToMessageID;
    }

    public Element toElement() throws AuthnSvcException {
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (Exception ex) {
            AuthnSvcUtils.debug.error("SASLResponse:toElement", ex);
            throw new AuthnSvcException(ex.getMessage());
        }
        Element saslRespE = doc.createElementNS("urn:liberty:sa:2004-04", "sa:SASLResponse");
        saslRespE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sa", "urn:liberty:sa:2004-04");
        saslRespE.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:disco", "urn:liberty:disco:2003-08");
        Element statusE = doc.createElementNS("urn:liberty:sa:2004-04", "sa:Status");
        statusE.setAttributeNS(null, "code", "sa:" + this.statusCode);
        saslRespE.appendChild(statusE);
        if (this.passwordTransforms != null) {
            this.passwordTransforms.addToParent(saslRespE);
        }
        if (this.data != null) {
            Element dataE = doc.createElementNS("urn:liberty:sa:2004-04", "sa:Data");
            dataE.appendChild(doc.createTextNode(Base64.encode(this.data)));
            saslRespE.appendChild(dataE);
        }
        if (this.resourceOffering != null) {
            Document roDoc = XMLUtils.toDOMDocument(this.resourceOffering.toString(), AuthnSvcUtils.debug);
            if (roDoc == null) {
                throw new AuthnSvcException("invalidRO");
            }
            saslRespE.appendChild(doc.importNode(roDoc.getDocumentElement(), true));
        }
        if (this.credentials != null && !this.credentials.isEmpty()) {
            Element credentialsE = doc.createElementNS("urn:liberty:sa:2004-04", "sa:Credentials");
            Iterator iter = this.credentials.iterator();
            while (iter.hasNext()) {
                credentialsE.appendChild(doc.importNode((Element)iter.next(), true));
            }
            saslRespE.appendChild(credentialsE);
        }
        if (this.serverMechanism != null) {
            saslRespE.setAttributeNS(null, "serverMechanism", this.serverMechanism);
        }
        if (this.id != null) {
            saslRespE.setAttributeNS(null, "id", this.id);
        }
        doc.appendChild(saslRespE);
        return doc.getDocumentElement();
    }
}

