/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.configuration.impl;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.impl.ServiceListenerImpl;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConfigurationInstanceImpl
implements ConfigurationInstance {
    private static Map serviceNameMap = new HashMap();
    private ServiceSchemaManager ssm;
    private ServiceConfigManager scm;
    private String componentName = null;
    private String subConfigId = null;
    private boolean hasOrgSchema = false;
    private static final int SUBCONFIG_PRIORITY = 0;
    private static final String RESOURCE_BUNDLE = "fmConfigurationService";
    static Debug debug = Debug.getInstance("fmConfiguration");

    public void init(String componentName, Object session) throws ConfigurationException {
        String serviceName = (String)serviceNameMap.get(componentName);
        if (serviceName == null) {
            throw new ConfigurationException(RESOURCE_BUNDLE, "componentNameUnsupported", null);
        }
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            this.ssm = new ServiceSchemaManager(serviceName, adminToken);
            ServiceSchema oss = this.ssm.getOrganizationSchema();
            if (oss != null) {
                this.hasOrgSchema = true;
                Set subSchemaNames = oss.getSubSchemaNames();
                if (subSchemaNames != null && subSchemaNames.size() == 1) {
                    this.subConfigId = (String)subSchemaNames.iterator().next();
                }
            }
            this.scm = new ServiceConfigManager(serviceName, adminToken);
        }
        catch (SMSException smsex) {
            debug.error("ConfigurationInstanceImpl.init:", smsex);
            throw new ConfigurationException(smsex);
        }
        catch (SSOException ssoex) {
            debug.error("ConfigurationInstanceImpl.init:", ssoex);
            throw new ConfigurationException(ssoex);
        }
        this.componentName = componentName;
    }

    public Map getConfiguration(String realm, String configName) throws ConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("ConfigurationInstanceImpl.getConfiguration: componentName = " + this.componentName + ", realm = " + realm + ", configName = " + configName);
        }
        try {
            if (this.hasOrgSchema) {
                ServiceConfig sc = null;
                sc = this.scm.getOrganizationConfig(realm, null);
                if (sc == null) {
                    return null;
                }
                if (configName == null || configName.length() == 0) {
                    return sc.getAttributes();
                }
                if (this.subConfigId == null) {
                    if (debug.messageEnabled()) {
                        debug.message("ConfigurationInstanceImpl.getConfiguration: sub configuraton not supported.");
                    }
                    Object[] data = new String[]{this.componentName};
                    throw new ConfigurationException(RESOURCE_BUNDLE, "noSubConfig", data);
                }
                if ((sc = sc.getSubConfig(configName)) == null) {
                    return null;
                }
                return sc.getAttributes();
            }
            if (realm != null && !realm.equals("/")) {
                if (debug.messageEnabled()) {
                    debug.message("ConfigurationInstanceImpl.getConfiguration: organization configuraton not supported.");
                }
                Object[] data = new String[]{this.componentName};
                throw new ConfigurationException(RESOURCE_BUNDLE, "noOrgConfig", data);
            }
            ServiceSchema ss = this.ssm.getGlobalSchema();
            if (ss == null) {
                if (debug.messageEnabled()) {
                    debug.message("ConfigurationInstanceImpl.getConfiguration: configuraton not supported.");
                }
                Object[] data = new String[]{this.componentName};
                throw new ConfigurationException(RESOURCE_BUNDLE, "noConfig", data);
            }
            Map retMap = ss.getAttributeDefaults();
            if (this.componentName.equals("PLATFORM")) {
                SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                retMap.put("iplanet-am-platform-server-list", ServerConfiguration.getServerInfo(token));
                retMap.put("iplanet-am-platform-site-list", SiteConfiguration.getSiteInfo(token));
            }
            return retMap;
        }
        catch (SMSException smsex) {
            debug.error("ConfigurationInstanceImpl.getConfiguration:", smsex);
            Object[] data = new String[]{this.componentName, realm};
            throw new ConfigurationException(RESOURCE_BUNDLE, "failedGetConfig", data);
        }
        catch (SSOException ssoex) {
            debug.error("ConfigurationInstanceImpl.getConfiguration:", ssoex);
            Object[] data = new String[]{this.componentName, realm};
            throw new ConfigurationException(RESOURCE_BUNDLE, "failedGetConfig", data);
        }
    }

    public void setConfiguration(String realm, String configName, Map avPairs) throws ConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("ConfigurationInstanceImpl.setConfiguration: componentName = " + this.componentName + ", realm = " + realm + ", configName = " + configName + ", avPairs = " + avPairs);
        }
        try {
            if (this.hasOrgSchema) {
                ServiceConfig sc = null;
                sc = this.scm.getOrganizationConfig(realm, null);
                if (sc == null) {
                    Object[] data = new String[]{this.componentName, realm};
                    throw new ConfigurationException(RESOURCE_BUNDLE, "configNotExist", data);
                }
                if (configName == null || configName.length() == 0) {
                    sc.setAttributes(avPairs);
                } else {
                    if (this.subConfigId == null) {
                        if (debug.messageEnabled()) {
                            debug.message("ConfigurationInstanceImpl.setConfiguration: sub configuraton not supported.");
                        }
                        Object[] data = new String[]{this.componentName};
                        throw new ConfigurationException(RESOURCE_BUNDLE, "noSubConfig", data);
                    }
                    if ((sc = sc.getSubConfig(configName)) == null) {
                        Object[] data = new String[]{this.componentName, realm};
                        throw new ConfigurationException(RESOURCE_BUNDLE, "configNotExist", data);
                    }
                    sc.setAttributes(avPairs);
                }
            } else {
                if (realm != null && !realm.equals("/")) {
                    if (debug.messageEnabled()) {
                        debug.message("ConfigurationInstanceImpl.setConfiguration: organization configuraton not supported.");
                    }
                    Object[] data = new String[]{this.componentName};
                    throw new ConfigurationException(RESOURCE_BUNDLE, "noOrgConfig", data);
                }
                ServiceSchema ss = this.ssm.getGlobalSchema();
                if (ss == null) {
                    if (debug.messageEnabled()) {
                        debug.message("ConfigurationInstanceImpl.setConfiguration: configuraton not supported.");
                    }
                    Object[] data = new String[]{this.componentName};
                    throw new ConfigurationException(RESOURCE_BUNDLE, "noConfig", data);
                }
                ss.setAttributeDefaults(avPairs);
            }
        }
        catch (SMSException smsex) {
            debug.error("ConfigurationInstanceImpl.setConfiguration:", smsex);
            Object[] data = new String[]{this.componentName, realm};
            throw new ConfigurationException(RESOURCE_BUNDLE, "failedSetConfig", data);
        }
        catch (SSOException ssoex) {
            debug.error("ConfigurationInstanceImpl.setConfiguration:", ssoex);
            Object[] data = new String[]{this.componentName, realm};
            throw new ConfigurationException(RESOURCE_BUNDLE, "failedSetConfig", data);
        }
    }

    public void createConfiguration(String realm, String configName, Map avPairs) throws ConfigurationException {
        block13: {
            if (debug.messageEnabled()) {
                debug.message("ConfigurationInstanceImpl.createConfiguration: componentName = " + this.componentName + ", realm = " + realm + ", configName = " + configName + ", avPairs = " + avPairs);
            }
            try {
                if (this.hasOrgSchema) {
                    ServiceConfig sc = null;
                    sc = this.scm.getOrganizationConfig(realm, null);
                    if (configName == null || configName.length() == 0) {
                        this.scm.createOrganizationConfig(realm, avPairs);
                    } else {
                        if (this.subConfigId == null) {
                            if (debug.messageEnabled()) {
                                debug.message("ConfigurationInstanceImpl.createConfiguration: sub configuraton not supported.");
                            }
                            Object[] data = new String[]{this.componentName};
                            throw new ConfigurationException(RESOURCE_BUNDLE, "noSubConfig", data);
                        }
                        if (sc == null) {
                            sc = this.scm.createOrganizationConfig(realm, null);
                        } else if (sc.getSubConfigNames().contains(configName)) {
                            Object[] data = new String[]{this.componentName, realm, configName};
                            throw new ConfigurationException(RESOURCE_BUNDLE, "configExist", data);
                        }
                        sc.addSubConfig(configName, this.subConfigId, 0, avPairs);
                    }
                    break block13;
                }
                if (debug.messageEnabled()) {
                    debug.message("ConfigurationInstanceImpl.createConfiguration: configuraton creation not supported.");
                }
                Object[] data = new String[]{this.componentName};
                throw new ConfigurationException(RESOURCE_BUNDLE, "noConfigCreation", data);
            }
            catch (SMSException smsex) {
                debug.error("ConfigurationInstanceImpl.createConfiguration:", smsex);
                Object[] data = new String[]{this.componentName, realm};
                throw new ConfigurationException(RESOURCE_BUNDLE, "failedCreateConfig", data);
            }
            catch (SSOException ssoex) {
                debug.error("ConfigurationInstanceImpl.createConfiguration:", ssoex);
                Object[] data = new String[]{this.componentName, realm};
                throw new ConfigurationException(RESOURCE_BUNDLE, "failedCreateConfig", data);
            }
        }
    }

    public void deleteConfiguration(String realm, String configName, Set attributes) throws ConfigurationException {
        block17: {
            if (debug.messageEnabled()) {
                debug.message("ConfigurationInstanceImpl.deleteConfiguration: componentName = " + this.componentName + ", realm = " + realm + ", configName = " + configName + ", attributes = " + attributes);
            }
            boolean removeConfig = attributes == null || attributes.isEmpty();
            try {
                if (this.hasOrgSchema) {
                    ServiceConfig sc = null;
                    if (configName == null || configName.length() == 0) {
                        if (removeConfig) {
                            this.scm.removeOrganizationConfiguration(realm, null);
                        } else {
                            sc = this.scm.getOrganizationConfig(realm, null);
                            if (sc != null) {
                                sc.removeAttributes(attributes);
                            }
                        }
                    } else {
                        if (this.subConfigId == null) {
                            if (debug.messageEnabled()) {
                                debug.message("ConfigurationInstanceImpl.deleteConfiguration: sub configuraton not supported.");
                            }
                            Object[] data = new String[]{this.componentName};
                            throw new ConfigurationException(RESOURCE_BUNDLE, "noSubConfig", data);
                        }
                        sc = this.scm.getOrganizationConfig(realm, null);
                        if (sc != null) {
                            if (removeConfig) {
                                sc.removeSubConfig(configName);
                            } else if ((sc = sc.getSubConfig(configName)) != null) {
                                sc.removeAttributes(attributes);
                            }
                        }
                    }
                    break block17;
                }
                if (debug.messageEnabled()) {
                    debug.message("ConfigurationInstanceImpl.deleteConfiguration: configuraton deletion not supported.");
                }
                Object[] data = new String[]{this.componentName};
                throw new ConfigurationException(RESOURCE_BUNDLE, "noConfigDeletion", data);
            }
            catch (SMSException smsex) {
                debug.error("ConfigurationInstanceImpl.deleteConfiguration:", smsex);
                Object[] data = new String[]{this.componentName, realm};
                throw new ConfigurationException(RESOURCE_BUNDLE, "failedDeleteConfig", data);
            }
            catch (SSOException ssoex) {
                debug.error("ConfigurationInstanceImpl.deleteConfiguration:", ssoex);
                Object[] data = new String[]{this.componentName, realm};
                throw new ConfigurationException(RESOURCE_BUNDLE, "failedDeleteConfig", data);
            }
        }
    }

    public Set getAllConfigurationNames(String realm) throws ConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("ConfigurationInstanceImpl.getAllConfigurationNames: realm = " + realm + ", componentName = " + this.componentName);
        }
        try {
            if (this.hasOrgSchema) {
                ServiceConfig sc = this.scm.getOrganizationConfig(realm, null);
                if (sc == null) {
                    return null;
                }
                Set subConfigNames = sc.getSubConfigNames();
                if (subConfigNames != null && subConfigNames.size() > 0) {
                    return subConfigNames;
                }
                return Collections.EMPTY_SET;
            }
            if (realm != null && !realm.equals("/")) {
                return null;
            }
            ServiceSchema ss = this.ssm.getGlobalSchema();
            if (ss == null) {
                return null;
            }
            return Collections.EMPTY_SET;
        }
        catch (SMSException smsex) {
            debug.error("ConfigurationInstanceImpl.getAllConfigurationNames:", smsex);
            Object[] data = new String[]{this.componentName, realm};
            throw new ConfigurationException(RESOURCE_BUNDLE, "failedGetConfigNames", data);
        }
        catch (SSOException ssoex) {
            debug.error("ConfigurationInstanceImpl.getAllConfigurationNames:", ssoex);
            Object[] data = new String[]{this.componentName, realm};
            throw new ConfigurationException(RESOURCE_BUNDLE, "failedGetConfigNames", data);
        }
    }

    public String addListener(ConfigurationListener listener) throws ConfigurationException {
        if (this.hasOrgSchema) {
            return this.scm.addListener(new ServiceListenerImpl(listener, this.componentName));
        }
        return this.ssm.addListener(new ServiceListenerImpl(listener, this.componentName));
    }

    public void removeListener(String listenerID) throws ConfigurationException {
        if (this.hasOrgSchema) {
            this.scm.removeListener(listenerID);
        } else {
            this.ssm.removeListener(listenerID);
        }
    }

    static {
        serviceNameMap = new HashMap();
        serviceNameMap.put("SAML1", "iPlanetAMSAMLService");
        serviceNameMap.put("SAML2", "sunFMSAML2MetadataService");
        serviceNameMap.put("WS-FEDERATION", "sunFMWSFederationMetadataService");
        serviceNameMap.put("ID-FF_META", "sunFMIDFFMetadataService");
        serviceNameMap.put("LIBCOT", "sunFMCOTConfigService");
        serviceNameMap.put("ID-FF", "iPlanetAMProviderConfigService");
        serviceNameMap.put("AUTHN_SVC", "sunIdentityServerAuthnService");
        serviceNameMap.put("DISCO", "sunIdentityServerDiscoveryService");
        serviceNameMap.put("IDPP", "sunIdentityServerLibertyPPService");
        serviceNameMap.put("SOAP_BINDING", "sunIdentityServerSOAPBinding");
        serviceNameMap.put("PLATFORM", "iPlanetAMPlatformService");
        serviceNameMap.put("NAMING", "iPlanetAMNamingService");
        serviceNameMap.put("SAML2_SOAP_BINDING", "sunfmSAML2SOAPBindingService");
        serviceNameMap.put("MULTI_PROTOCOL", "sunMultiFederationProtocol");
        serviceNameMap.put("STS_CONFIG", "sunFAMSTSService");
        serviceNameMap.put("SAML2_CONFIG", "sunFAMSAML2Configuration");
    }
}

