/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.PluginSchema;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ReferralTypeManager {
    private static String REFERRAL = "Referral";
    private SSOToken token;
    private PolicyManager pm;
    private ResourceBundle rb;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    static Debug debug = PolicyManager.debug;

    protected ReferralTypeManager() throws SSOException {
        this.token = ServiceTypeManager.getSSOToken();
        String lstr = this.token.getProperty("Locale");
        java.util.Locale loc = Locale.getLocale(lstr);
        this.rb = amCache.getResBundle("amPolicy", loc);
    }

    protected ReferralTypeManager(PolicyManager pm) {
        java.util.Locale loc;
        this.pm = pm;
        this.token = pm.token;
        try {
            String lstr = this.token.getProperty("Locale");
            loc = Locale.getLocale(lstr);
        }
        catch (SSOException ex) {
            debug.error("ConditionTypeManager:Unable to retreive locale from SSOToken", ex);
            loc = Locale.getDefaultLocale();
        }
        if (debug.messageEnabled()) {
            debug.message("SubjectManager locale=" + loc + "\tI18nFileName = " + "amPolicy");
        }
        this.rb = amCache.getResBundle("amPolicy", loc);
    }

    public Set getReferralTypeNames() throws SSOException, PolicyException {
        return PolicyManager.getPluginSchemaNames(REFERRAL);
    }

    public Set getSelectedReferralTypeNames() throws SSOException, PolicyException {
        Map policyConfig = this.pm.getPolicyConfig();
        Set selectedReferrals = null;
        if (policyConfig != null) {
            selectedReferrals = (Set)policyConfig.get("iplanet-am-policy-selected-referrals");
        }
        if (selectedReferrals == null) {
            selectedReferrals = Collections.EMPTY_SET;
        }
        return selectedReferrals;
    }

    public String getReferralTypeName(Referral referral) {
        return ReferralTypeManager.referralTypeName(referral);
    }

    protected String getI18NPropertiesFileName(String referralType) {
        return null;
    }

    public String getI18NKey(String referralType) {
        PluginSchema ps = PolicyManager.getPluginSchema(REFERRAL, referralType);
        if (ps != null) {
            return ps.getI18NKey();
        }
        return null;
    }

    public String getDisplayName(String referralType) {
        String displayName = null;
        String i18nKey = this.getI18NKey(referralType);
        displayName = i18nKey == null || i18nKey.length() == 0 ? referralType : Locale.getString(this.rb, i18nKey, debug);
        return displayName;
    }

    public Referral getReferral(String referralType) throws NameNotFoundException, PolicyException {
        PluginSchema ps = PolicyManager.getPluginSchema(REFERRAL, referralType);
        if (ps == null) {
            throw new NameNotFoundException("amPolicy", "invalid_referral", null, referralType, 5);
        }
        Referral answer = null;
        try {
            String className = ps.getClassName();
            answer = (Referral)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
        Map policyConfig = this.pm.getPolicyConfig();
        answer.initialize(policyConfig);
        return answer;
    }

    static String referralTypeName(Referral referral) {
        if (referral == null) {
            return null;
        }
        String answer = null;
        String className = referral.getClass().getName();
        Iterator items = PolicyManager.getPluginSchemaNames(REFERRAL).iterator();
        while (items.hasNext()) {
            String pluginName = (String)items.next();
            PluginSchema ps = PolicyManager.getPluginSchema(REFERRAL, pluginName);
            if (!className.equals(ps.getClassName())) continue;
            answer = pluginName;
            break;
        }
        return answer;
    }

    public String getViewBeanURL(Referral referral) {
        return PolicyManager.getViewBeanURL(REFERRAL, referral.getClass().getName());
    }
}

