/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.keystore;

import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.SecurityDebug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class AMCallbackHandler
implements CallbackHandler {
    static final String bundleName = "amSecurity";
    static ResourceBundle bundle = null;
    static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    static String passwdPrompt = null;
    char[] password = null;
    boolean cleared;

    public AMCallbackHandler() {
        this(passwdPrompt);
    }

    public AMCallbackHandler(String prompt) {
        String passWDFile = System.getProperty("com.sun.identity.security.keyStorePasswordFile", null);
        String keystorePW = System.getProperty("javax.net.ssl.keyStorePassword", null);
        if (prompt == null) {
            prompt = passwdPrompt;
        }
        if (passWDFile != null) {
            try {
                FileInputStream fis = new FileInputStream(passWDFile);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                keystorePW = (String)AccessController.doPrivileged(new DecodeAction(br.readLine()));
                fis.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SecurityDebug.debug.error("AMCallbackHandler: Unable to read keystore password file " + passWDFile);
            }
        }
        if (keystorePW != null) {
            this.password = keystorePW.toCharArray();
        }
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        int i = 0;
        try {
            for (i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof PasswordCallback) {
                    if (SecurityDebug.debug.messageEnabled()) {
                        SecurityDebug.debug.message("AMCallbackHandler() :  PasswordCallback()");
                    }
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    if (this.password == null) {
                        if (SecurityDebug.debug.messageEnabled()) {
                            SecurityDebug.debug.message("AMCallbackHandler() :  Prompt Password ");
                        }
                        if (passwdPrompt != null) {
                            System.out.print(passwdPrompt);
                        } else {
                            System.out.print(pc.getPrompt());
                        }
                        System.out.flush();
                        pc.setPassword(this.readPassword(System.in));
                        continue;
                    }
                    pc.setPassword(this.password);
                    continue;
                }
                SecurityDebug.debug.error("Got UnknownCallback");
                break;
            }
        }
        catch (Exception e) {
            SecurityDebug.debug.error("Exception in Callback : " + e);
            e.printStackTrace();
            throw new UnsupportedCallbackException(callbacks[i], "Callback exception: " + e);
        }
    }

    private char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (offset == 0) {
            return null;
        }
        this.password = new char[offset];
        System.arraycopy(buf, 0, this.password, 0, offset);
        Arrays.fill(buf, ' ');
        this.cleared = false;
        return this.password;
    }

    public synchronized void clear() {
        int len = this.password.length;
        for (int i = 0; i < len; ++i) {
            this.password[i] = '\u0000';
        }
        this.cleared = true;
    }

    protected void finalize() throws Throwable {
        this.clear();
    }

    public void setPassword(String pw) {
        this.password = pw.toCharArray();
        this.cleared = false;
    }

    static {
        bundle = amCache.getResBundle(bundleName, Locale.getDefault());
        passwdPrompt = bundle.getString("KeyStorePrompt");
    }
}

