/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.locale;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Locale {
    static BitSet dontEncode;
    static final int caseDiff = 32;
    private static final int LOCALE_STRING_MAX_LEN = 5;
    static java.util.Locale defaultLocale;
    static Debug debug;
    protected static final String USER_PROPERTIES = "amUser";
    protected static final String DATE_SYNTAX = "dateSyntax";
    private static final String normalizedDateString = "yyyy/MM/dd HH:mm:ss";
    private static final SimpleDateFormat normalizedDateFormat;

    public static void main(String[] args) {
        System.out.println(":" + Locale.getLocale(args[0]) + ":");
        System.out.println(":" + Locale.getLocale(args[0]).getCountry() + ":");
    }

    public static java.util.Locale getLocale(String stringformat) {
        if (stringformat == null) {
            return java.util.Locale.getDefault();
        }
        StringTokenizer tk = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tk.hasMoreTokens()) {
            lang = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            country = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            variant = tk.nextToken();
        }
        return new java.util.Locale(lang, country, variant);
    }

    public static String getLocaleStringFromAcceptLangHeader(String langstr) {
        if (langstr == null) {
            return null;
        }
        char[] lstr = langstr.toCharArray();
        int leadSpace = 0;
        try {
            while (Character.isWhitespace(lstr[leadSpace])) {
                ++leadSpace;
            }
            int len = lstr.length;
            if (len > leadSpace + 5) {
                len = leadSpace + 5;
            }
            boolean isCountry = false;
            for (int i = leadSpace; i < len; ++i) {
                char ch = lstr[i];
                if (ch == '*') {
                    return null;
                }
                if (ch == '-') {
                    lstr[i] = 95;
                    isCountry = true;
                    continue;
                }
                if (ch == ';' || ch == ',') {
                    return new String(lstr, leadSpace, i - leadSpace);
                }
                if (!isCountry) continue;
                lstr[i] = Character.toUpperCase(ch);
            }
            return new String(lstr, 0, len);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static java.util.Locale getLocaleObjFromAcceptLangHeader(String langStr) {
        String lstr = Locale.getLocaleStringFromAcceptLangHeader(langStr);
        if (lstr == null) {
            return null;
        }
        String lang = lstr.substring(0, 2);
        String country = "";
        if (lstr.length() == 5) {
            country = lstr.substring(3, 5);
        }
        return new java.util.Locale(lang, country);
    }

    public static ResourceBundle getResourceBundle(String bundle, String stringformat) {
        return ResourceBundle.getBundle(bundle, Locale.getLocale(stringformat));
    }

    protected static ResourceBundle getResourceBundle(String bundle) {
        return Locale.getInstallResourceBundle(bundle);
    }

    public static ResourceBundle getInstallResourceBundle(String bundle) {
        String loc = SystemPropertiesManager.get("com.iplanet.am.locale", "en_US");
        return ResourceBundle.getBundle(bundle, Locale.getLocale(loc));
    }

    public static java.util.Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static String formatMessage(String formatStr, Object obj1) {
        Object[] arr = new Object[]{obj1};
        return MessageFormat.format(formatStr, arr);
    }

    public static String formatMessage(String formatStr, Object[] objs) {
        return MessageFormat.format(formatStr, objs);
    }

    public static Date parseNormalizedDateString(String dateString) {
        if (dateString == null) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Date date = normalizedDateFormat.parse(dateString, pos);
        if (date == null) {
            debug.error("Locale.parseNormalizedDateString: Unable to parse date string");
        }
        if (debug.messageEnabled()) {
            debug.message("Locale.parseNormalizedDateString(" + dateString + ")=" + date);
        }
        return date;
    }

    public static Date parseDateString(String dateString, java.util.Locale locale, String dateSyntax) {
        if (debug.messageEnabled()) {
            debug.message("Local.parseDateString(date, locale, syntax)");
            debug.message("date string = " + dateString);
            debug.message("date syntax = " + dateSyntax);
            debug.message("locale = " + locale.toString());
        }
        if (dateString == null || dateString.length() < 1 || dateSyntax == null || dateSyntax.length() < 1) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateSyntax);
        sdf.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        Date date = sdf.parse(dateString, pos);
        if (date == null) {
            debug.warning("Locale.parseDateString: unable to parse the date.");
        }
        return date;
    }

    public static Date parseDateString(String dateString, java.util.Locale locale) {
        ResourceBundle rb = AMResourceBundleCache.getInstance().getResBundle(USER_PROPERTIES, locale);
        if (rb == null) {
            debug.error("Locale.parseDateString: Unable to get resource bundle. Locale = " + locale);
            return null;
        }
        String dateSyntax = null;
        try {
            dateSyntax = rb.getString(DATE_SYNTAX);
            dateSyntax.trim();
        }
        catch (Exception ex) {
            debug.error("Locale.parseDateString: Unable to get dateSyntax. Locale " + locale);
            return null;
        }
        return Locale.parseDateString(dateString, locale, dateSyntax);
    }

    public static String getNormalizedDateString(Date date) {
        if (date == null) {
            return null;
        }
        return normalizedDateFormat.format(date);
    }

    public static String getDateString(Date date, java.util.Locale locale) {
        if (date == null) {
            return null;
        }
        ResourceBundle rb = AMResourceBundleCache.getInstance().getResBundle(USER_PROPERTIES, locale);
        if (rb == null) {
            debug.error("Locale.getDateString: Unable to get resource bundle. Locale = " + locale);
            return null;
        }
        String dateSyntax = null;
        try {
            dateSyntax = rb.getString(DATE_SYNTAX);
        }
        catch (Exception ex) {
            debug.error("Locale.getDateString: Unable to get dateSyntax. Locale " + locale);
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("Locale.getDateString: dateSyntax = " + dateSyntax);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateSyntax);
        return sdf.format(date);
    }

    public static String convertDateString(String srcDateString, java.util.Locale srcLocale, java.util.Locale dstLocale) {
        Date date = Locale.parseDateString(srcDateString, srcLocale);
        return Locale.getDateString(date, dstLocale);
    }

    public static String getString(ResourceBundle rb, String resource, Object[] params) {
        try {
            return MessageFormat.format(rb.getString(resource), params);
        }
        catch (Exception mre) {
            if (debug.messageEnabled()) {
                debug.message("missing resource: " + resource);
            }
            return resource;
        }
    }

    public static String getString(ResourceBundle rb, String resource, ResourceBundle defaultRb, Object[] params) {
        try {
            return MessageFormat.format(rb.getString(resource), params);
        }
        catch (Exception mre) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("missing resource: " + resource);
                    debug.message("fall back to default resource bundle");
                }
                return MessageFormat.format(defaultRb.getString(resource), params);
            }
            catch (Exception mrde) {
                if (debug.messageEnabled()) {
                    debug.message("missing resource in default resource bundle:" + resource);
                }
                return resource;
            }
        }
    }

    public static String getString(ResourceBundle rb, String resource, Debug debug) {
        try {
            return rb.getString(resource);
        }
        catch (Exception mre) {
            if (debug.messageEnabled()) {
                debug.message("missing resource: " + resource);
            }
            return resource;
        }
    }

    public static String getString(ResourceBundle rb, String resource, Debug debug, ResourceBundle defaultRb) {
        try {
            return rb.getString(resource);
        }
        catch (Exception mre) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("missing resource: " + resource);
                    debug.message("fall back to default resource bundle");
                }
                return defaultRb.getString(resource);
            }
            catch (Exception mrde) {
                if (debug.messageEnabled()) {
                    debug.message("missing resource in default resource bundle:" + resource);
                }
                return resource;
            }
        }
    }

    public static String getString(ResourceBundle rb, String resource) {
        try {
            return rb.getString(resource);
        }
        catch (Exception mre) {
            if (debug.messageEnabled()) {
                debug.message("missing resource: " + resource);
            }
            return resource;
        }
    }

    public static String getString(ResourceBundle rb, String resource, ResourceBundle defaultRb) {
        try {
            return rb.getString(resource);
        }
        catch (Exception mre) {
            try {
                if (debug.messageEnabled()) {
                    debug.message("missing resource: " + resource);
                    debug.message("fall back to default resource bundle");
                }
                return defaultRb.getString(resource);
            }
            catch (Exception mrde) {
                if (debug.messageEnabled()) {
                    debug.message("missing resource in default resource bundle:" + resource);
                }
                return resource;
            }
        }
    }

    public static String URLEncodeField(String input, String enc) throws UnsupportedEncodingException {
        int inputLen = input.length();
        byte[] byteOut = input.getBytes(enc);
        StringBuffer result = new StringBuffer(inputLen * 4);
        for (int i = 0; i < byteOut.length; ++i) {
            int c = byteOut[i] & 0xFF;
            if (dontEncode.get(c)) {
                if (c == 32) {
                    c = 43;
                }
                result.append((char)c);
                continue;
            }
            result.append('%');
            char ch = Character.forDigit(c >> 4 & 0xF, 16);
            if ('a' <= ch && ch <= 'f') {
                ch = (char)(ch - 32);
            }
            result.append(ch);
            ch = Character.forDigit(c & 0xF, 16);
            if ('a' <= ch && ch <= 'f') {
                ch = (char)(ch - 32);
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String URLEncodeField(String input, String enc, Debug debug) {
        byte[] byteOut;
        int inputLen = input.length();
        try {
            byteOut = input.getBytes(enc);
        }
        catch (UnsupportedEncodingException ex) {
            if (debug != null) {
                debug.error("Locale.URLEncodeField: Unsupported Encoding " + enc, ex);
            }
            return input;
        }
        StringBuffer result = new StringBuffer(inputLen * 4);
        for (int i = 0; i < byteOut.length; ++i) {
            int c = byteOut[i] & 0xFF;
            if (dontEncode.get(c)) {
                if (c == 32) {
                    c = 43;
                }
                result.append((char)c);
                continue;
            }
            result.append('%');
            char ch = Character.forDigit(c >> 4 & 0xF, 16);
            if ('a' <= ch && ch <= 'f') {
                ch = (char)(ch - 32);
            }
            result.append(ch);
            ch = Character.forDigit(c & 0xF, 16);
            if ('a' <= ch && ch <= 'f') {
                ch = (char)(ch - 32);
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String URLDecodeField(String strIn, Debug debug) {
        return Locale.URLDecodeField(strIn, "UTF-8", debug);
    }

    public static String URLDecodeField(String strIn, String charset, Debug debug) {
        if (strIn == null) {
            return strIn;
        }
        String strOut = null;
        try {
            int len = strIn.length();
            byte[] buf = new byte[len];
            int i = 0;
            int offset = 0;
            char[] carr = strIn.toCharArray();
            block6: while (i < len) {
                byte b = (byte)carr[i];
                switch (b) {
                    case 43: {
                        buf[offset++] = 32;
                        ++i;
                        continue block6;
                    }
                    case 37: {
                        int val = 0;
                        if (i + 2 >= len) continue block6;
                        if (97 <= (b = (byte)carr[++i]) && b <= 102) {
                            b = (byte)(b - 32);
                        }
                        if (65 <= b && b <= 70) {
                            val = 10 + b - 65;
                            val <<= 4;
                        } else if (48 <= b && b <= 57) {
                            val = b - 48 << 4;
                        } else {
                            throw new IllegalArgumentException("invalid hex char");
                        }
                        b = (byte)carr[++i];
                        if (97 <= b && b <= 102) {
                            b = (byte)(b - 32);
                        }
                        if (65 <= b && b <= 70) {
                            val += 10 + b - 65;
                        } else if (48 <= b && b <= 57) {
                            val += b - 48;
                        } else {
                            throw new IllegalArgumentException("invalid hex char");
                        }
                        buf[offset++] = (byte)val;
                        ++i;
                        continue block6;
                    }
                }
                buf[offset++] = (byte)carr[i++];
            }
            strOut = charset == null || charset.length() == 0 ? new String(buf, 0, offset, "UTF-8") : new String(buf, 0, offset, charset);
        }
        catch (Exception ex) {
            debug.error("Locale::decodeField", ex);
            strOut = strIn;
        }
        return strOut;
    }

    static {
        int i;
        debug = Debug.getInstance("amUtil");
        dontEncode = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontEncode.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontEncode.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontEncode.set(i);
        }
        dontEncode.set(32);
        dontEncode.set(45);
        dontEncode.set(95);
        dontEncode.set(46);
        dontEncode.set(42);
        String loc = SystemPropertiesManager.get("com.iplanet.am.locale", "en_US");
        defaultLocale = Locale.getLocale(loc);
        normalizedDateFormat = new SimpleDateFormat(normalizedDateString);
    }
}

