/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.request;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecTimestamp;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AddWSTimestampAction
extends AbstractAction {
    private final WsdlRequest request;

    public AddWSTimestampAction(WsdlRequest request) {
        super("Add WS-Timestamp");
        this.request = request;
    }

    public void actionPerformed(ActionEvent e) {
        String req = this.request.getRequestContent();
        try {
            String ttlString = UISupport.prompt("Add WS-Timestamp", "Specify Time-To-Live value", "60");
            if (ttlString == null) {
                return;
            }
            int ttl = 0;
            try {
                ttl = Integer.parseInt(ttlString);
            }
            catch (Exception ex) {
                // empty catch block
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(req)));
            WSSecTimestamp addTimestamp = new WSSecTimestamp();
            addTimestamp.setTimeToLive(ttl);
            StringWriter writer = new StringWriter();
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            XmlUtils.serializePretty(addTimestamp.build(doc, secHeader), (Writer)writer);
            this.request.setRequestContent(writer.toString());
        }
        catch (Exception e1) {
            UISupport.showErrorMessage(e1);
        }
    }
}

