/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.impl.wsdl.panels.request.StringToStringMapTableModel;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.ref.SoftReference;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class ShowMessageExchangeAction
extends AbstractAction {
    private DefaultDesktopPanel desktopPanel;
    private final SoftReference<MessageExchange> reference;
    private final String ownerName;

    public ShowMessageExchangeAction(MessageExchange messageExchange, String ownerName) {
        super("Show Results");
        this.ownerName = ownerName;
        this.reference = new SoftReference<MessageExchange>(messageExchange);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.reference.get() == null) {
                UISupport.showInfoMessage("Message has been discarded..");
            } else {
                UISupport.showDesktopPanel(this.buildFrame());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DesktopPanel buildFrame() {
        if (this.desktopPanel == null) {
            this.desktopPanel = new DefaultDesktopPanel("Message Viewer", "Message for " + this.ownerName, this.buildContent());
        }
        return this.desktopPanel;
    }

    private JComponent buildContent() {
        JTabbedPane messageTabs = new JTabbedPane();
        messageTabs.addTab("Request Message", this.buildRequestTab());
        messageTabs.addTab("Response Message", this.buildResponseTab());
        messageTabs.addTab("Properties", this.buildPropertiesTab());
        messageTabs.setPreferredSize(new Dimension(500, 400));
        return UISupport.createTabPanel(messageTabs, true);
    }

    private Component buildPropertiesTab() {
        MessageExchange messageExchange = this.reference.get();
        StringToStringMap properties = new StringToStringMap();
        if (messageExchange != null && messageExchange.getProperties() != null) {
            properties.putAll(messageExchange.getProperties());
            properties.put("Timestamp", new Date(messageExchange.getTimestamp()).toString());
            properties.put("Time Taken", String.valueOf(messageExchange.getTimeTaken()));
        }
        JTable table = new JTable(new StringToStringMapTableModel(properties, "Name", "Value", false));
        return new JScrollPane(table);
    }

    private Component buildResponseTab() {
        JXEditTextArea resultArea = JXEditTextArea.createXmlEditor();
        MessageExchange messageExchange = this.reference.get();
        if (messageExchange != null) {
            resultArea.setText(XmlUtils.prettyPrintXml(messageExchange.getResponseContent()));
        } else {
            resultArea.setText("- null -");
        }
        resultArea.setEditable(false);
        resultArea.setToolTipText("Response Content");
        JScrollPane scrollPane = new JScrollPane(resultArea);
        if (messageExchange != null) {
            JSplitPane split = UISupport.createVerticalSplit(new JScrollPane(new JTable(new StringToStringMapTableModel(messageExchange.getResponseHeaders(), "Header", "Value", false))), scrollPane);
            split.setDividerLocation(150);
            return split;
        }
        return scrollPane;
    }

    private Component buildRequestTab() {
        JXEditTextArea resultArea = JXEditTextArea.createXmlEditor();
        MessageExchange messageExchange = this.reference.get();
        if (messageExchange != null) {
            resultArea.setText(XmlUtils.prettyPrintXml(messageExchange.getRequestContent()));
        } else {
            resultArea.setText("- null -");
        }
        resultArea.setEditable(false);
        resultArea.setToolTipText("Request Content");
        JScrollPane scrollPane = new JScrollPane(resultArea);
        if (messageExchange != null) {
            JSplitPane split = UISupport.createVerticalSplit(new JScrollPane(new JTable(new StringToStringMapTableModel(messageExchange.getRequestHeaders(), "Header", "Value", false))), scrollPane);
            split.setDividerLocation(150);
            return split;
        }
        return scrollPane;
    }
}

