/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.core.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDefinitionImpl
extends ItemDefinitionImpl
implements NodeDefinition {
    private static Logger log = LoggerFactory.getLogger((Class)NodeDefinitionImpl.class);

    NodeDefinitionImpl(NodeDef nodeDef, NodeTypeManagerImpl ntMgr, NamespaceResolver nsResolver) {
        super(nodeDef, ntMgr, nsResolver);
    }

    public NodeDef unwrap() {
        return (NodeDef)this.itemDef;
    }

    public NodeType getDefaultPrimaryType() {
        QName ntName = ((NodeDef)this.itemDef).getDefaultPrimaryType();
        if (ntName == null) {
            return null;
        }
        try {
            return this.ntMgr.getNodeType(ntName);
        }
        catch (NoSuchNodeTypeException e) {
            log.error("invalid default node type " + ntName, (Throwable)e);
            return null;
        }
    }

    public NodeType[] getRequiredPrimaryTypes() {
        QName[] ntNames = ((NodeDef)this.itemDef).getRequiredPrimaryTypes();
        try {
            if (ntNames == null || ntNames.length == 0) {
                return new NodeType[]{this.ntMgr.getNodeType(QName.NT_BASE)};
            }
            NodeType[] nodeTypes = new NodeType[ntNames.length];
            for (int i = 0; i < ntNames.length; ++i) {
                nodeTypes[i] = this.ntMgr.getNodeType(ntNames[i]);
            }
            return nodeTypes;
        }
        catch (NoSuchNodeTypeException e) {
            log.error("required node type does not exist", (Throwable)e);
            return new NodeType[0];
        }
    }

    public boolean allowsSameNameSiblings() {
        return ((NodeDef)this.itemDef).allowsSameNameSiblings();
    }
}

