/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.query.BusinessServiceQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.log4j.Logger;
import org.uddi.api_v3.TModelBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindServiceByTModelKeyQuery
extends BusinessServiceQuery {
    private static Logger log = Logger.getLogger(FindServiceByTModelKeyQuery.class);
    public static final String ENTITY_NAME_CHILD = "TmodelInstanceInfo";
    protected static String entityAliasChild = FindServiceByTModelKeyQuery.buildAlias("TmodelInstanceInfo");

    public static List<?> select(EntityManager em, FindQualifiers fq, TModelBag tModels, String parentKey, List<?> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (tModels == null) {
            return keysIn;
        }
        List tmodelKeys = tModels.getTModelKey();
        if (tmodelKeys == null || tmodelKeys.size() == 0) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        FindServiceByTModelKeyQuery.appendConditions(dynamicQry, fq, tmodelKeys);
        if (parentKey != null && parentKey.length() > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(new DynamicQuery.Parameter("bt.businessService.entityKey", parentKey, DynamicQuery.PREDICATE_EQUALS));
        }
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindServiceByTModelKeyQuery.getQueryResult(em, dynamicQry, keysIn, "bs.entityKey");
    }

    public static void appendConditions(DynamicQuery qry, FindQualifiers fq, List<String> tmodelKeys) {
        FindServiceByTModelKeyQuery.appendJoinTables(qry, fq, tmodelKeys);
        qry.AND().pad().openParen().pad();
        int count = 0;
        int tblCount = -1;
        for (String tmodelKey : tmodelKeys) {
            String tmodelKeyTerm = (fq.isOrAllKeys() ? entityAliasChild + "0" : entityAliasChild + ++tblCount) + ".tmodelKey";
            qry.appendGroupedAnd(new DynamicQuery.Parameter(tmodelKeyTerm, tmodelKey, DynamicQuery.PREDICATE_EQUALS));
            if (count + 1 < tmodelKeys.size()) {
                if (fq.isOrAllKeys()) {
                    qry.OR().pad();
                } else {
                    qry.AND().pad();
                }
            }
            ++count;
        }
        qry.closeParen().pad();
    }

    public static void appendJoinTables(DynamicQuery qry, FindQualifiers fq, List<String> tmodelKeys) {
        if (tmodelKeys != null & tmodelKeys.size() > 0) {
            qry.comma().pad().append("BindingTemplate bt").pad();
            StringBuffer thetaJoins = new StringBuffer(200);
            int tblCount = 0;
            for (int count = 0; count < tmodelKeys.size(); ++count) {
                if (count != 0) {
                    if (fq.isOrAllKeys()) continue;
                    qry.comma().pad().append("TmodelInstanceInfo " + entityAliasChild + ++tblCount).pad();
                    thetaJoins.append(entityAliasChild + (tblCount - 1) + "." + "bindingTemplate" + "." + "entityKey" + " = " + entityAliasChild + tblCount + "." + "bindingTemplate" + "." + "entityKey" + " ");
                    thetaJoins.append(DynamicQuery.OPERATOR_AND + " ");
                    continue;
                }
                qry.comma().pad().append("TmodelInstanceInfo " + entityAliasChild + tblCount).pad();
                thetaJoins.append("bt.entityKey = " + entityAliasChild + tblCount + "." + "bindingTemplate" + "." + "entityKey" + " ");
                thetaJoins.append(DynamicQuery.OPERATOR_AND + " ");
            }
            qry.WHERE().pad().openParen().pad();
            qry.append("bs.entityKey = bt.businessService.entityKey").pad();
            qry.AND().pad();
            String thetaJoinsStr = thetaJoins.toString();
            if (thetaJoinsStr.endsWith(DynamicQuery.OPERATOR_AND + " ")) {
                thetaJoinsStr = thetaJoinsStr.substring(0, thetaJoinsStr.length() - (DynamicQuery.OPERATOR_AND + " ").length());
            }
            qry.append(thetaJoinsStr);
            qry.closeParen().pad();
        }
    }
}

