/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.query.TModelQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.log4j.Logger;
import org.uddi.api_v3.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindTModelByNameQuery
extends TModelQuery {
    private static Logger log = Logger.getLogger(FindTModelByNameQuery.class);

    public static List<?> select(EntityManager em, FindQualifiers fq, Name name, List<?> keysIn, DynamicQuery.Parameter ... restrictions) {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        if (name == null) {
            return keysIn;
        }
        DynamicQuery dynamicQry = new DynamicQuery(selectSQL);
        FindTModelByNameQuery.appendConditions(dynamicQry, fq, name);
        dynamicQry.AND().pad().appendGroupedAnd(new DynamicQuery.Parameter("t.deleted", new Boolean(false), DynamicQuery.PREDICATE_EQUALS));
        if (restrictions != null && restrictions.length > 0) {
            dynamicQry.AND().pad().appendGroupedAnd(restrictions);
        }
        return FindTModelByNameQuery.getQueryResult(em, dynamicQry, keysIn, "t.entityKey");
    }

    public static void appendConditions(DynamicQuery qry, FindQualifiers fq, Name name) {
        String namePredicate = DynamicQuery.PREDICATE_EQUALS;
        if (fq.isApproximateMatch()) {
            namePredicate = DynamicQuery.PREDICATE_LIKE;
        }
        qry.WHERE().pad().openParen().pad();
        String nameTerm = "t.name";
        String nameValue = name.getValue();
        if (fq.isCaseInsensitiveMatch()) {
            nameTerm = "upper(t.name)";
            nameValue = name.getValue().toUpperCase();
        }
        if (name.getLang() == null || name.getLang().length() == 0) {
            qry.appendGroupedAnd(new DynamicQuery.Parameter(nameTerm, nameValue, namePredicate));
        } else {
            String langValue = name.getLang().endsWith(DynamicQuery.WILDCARD) ? name.getLang().toUpperCase() : name.getLang().toUpperCase() + DynamicQuery.WILDCARD;
            qry.appendGroupedAnd(new DynamicQuery.Parameter(nameTerm, nameValue, namePredicate), new DynamicQuery.Parameter("upper(t.langCode)", langValue, DynamicQuery.PREDICATE_LIKE));
        }
        qry.closeParen().pad();
    }
}

