/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.rmi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.juddi.rmi.JUDDIApiService;
import org.apache.juddi.rmi.UDDICustodyTransferService;
import org.apache.juddi.rmi.UDDIInquiryService;
import org.apache.juddi.rmi.UDDIPublicationService;
import org.apache.juddi.rmi.UDDISecurityService;
import org.apache.juddi.rmi.UDDISubscriptionListenerService;
import org.apache.juddi.rmi.UDDISubscriptionService;
import org.apache.log4j.Logger;

public class JNDIRegistration {
    public static String JUDDI = "/juddiv3";
    public static String UDDI_SECURITY_SERVICE = JUDDI + "/UDDISecurityService";
    public static String UDDI_PUBLICATION_SERVICE = JUDDI + "/UDDIPublicationService";
    public static String UDDI_INQUIRY_SERVICE = JUDDI + "/UDDIInquiryService";
    public static String UDDI_SUBSCRIPTION_SERVICE = JUDDI + "/UDDISubscriptionService";
    public static String UDDI_SUBSCRIPTION_LISTENER_SERVICE = JUDDI + "/UDDISubscriptionListenerService";
    public static String UDDI_CUSTODY_TRANSFER_SERVICE = JUDDI + "/UDDICustodyTransferService";
    public static String JUDDI_PUBLISHER_SERVICE = JUDDI + "/JUDDIApiService";
    private UDDISecurityService securityService = null;
    private UDDIPublicationService publicationService = null;
    private UDDIInquiryService inquiryService = null;
    private UDDISubscriptionService subscriptionService = null;
    private UDDISubscriptionListenerService subscriptionListenerService = null;
    private UDDICustodyTransferService custodyTransferService = null;
    private JUDDIApiService publisherService = null;
    private Logger log = Logger.getLogger(this.getClass());
    InitialContext context = new InitialContext();
    private static JNDIRegistration registration = null;

    public static JNDIRegistration getInstance() throws NamingException {
        if (registration == null) {
            registration = new JNDIRegistration();
        }
        return registration;
    }

    private JNDIRegistration() throws NamingException {
    }

    public void register() {
        try {
            Context juddiContext = this.context.createSubcontext(JUDDI);
            this.securityService = new UDDISecurityService();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_SECURITY_SERVICE + ", " + this.securityService.getClass()));
            }
            juddiContext.rebind(UDDI_SECURITY_SERVICE, (Object)this.securityService);
            this.publicationService = new UDDIPublicationService();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_PUBLICATION_SERVICE + ", " + this.publicationService.getClass()));
            }
            juddiContext.rebind(UDDI_PUBLICATION_SERVICE, (Object)this.publicationService);
            this.inquiryService = new UDDIInquiryService();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_INQUIRY_SERVICE + ", " + this.inquiryService.getClass()));
            }
            juddiContext.rebind(UDDI_INQUIRY_SERVICE, (Object)this.inquiryService);
            this.subscriptionService = new UDDISubscriptionService();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_SUBSCRIPTION_SERVICE + ", " + this.subscriptionService.getClass()));
            }
            juddiContext.rebind(UDDI_SUBSCRIPTION_SERVICE, (Object)this.subscriptionService);
            this.subscriptionListenerService = new UDDISubscriptionListenerService();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_SUBSCRIPTION_LISTENER_SERVICE + ", " + this.subscriptionListenerService.getClass()));
            }
            juddiContext.rebind(UDDI_SUBSCRIPTION_LISTENER_SERVICE, (Object)this.subscriptionListenerService);
            this.custodyTransferService = new UDDICustodyTransferService();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + UDDI_CUSTODY_TRANSFER_SERVICE + ", " + this.custodyTransferService.getClass()));
            }
            juddiContext.rebind(UDDI_CUSTODY_TRANSFER_SERVICE, (Object)this.custodyTransferService);
            this.publisherService = new JUDDIApiService();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting " + JUDDI_PUBLISHER_SERVICE + ", " + this.publisherService.getClass()));
            }
            juddiContext.rebind(JUDDI_PUBLISHER_SERVICE, (Object)this.publisherService);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void unregister() {
        try {
            this.context.unbind(UDDI_SECURITY_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.securityService = null;
        try {
            this.context.unbind(UDDI_PUBLICATION_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.publicationService = null;
        try {
            this.context.unbind(UDDI_INQUIRY_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.inquiryService = null;
        try {
            this.context.unbind(UDDI_SUBSCRIPTION_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.subscriptionService = null;
        try {
            this.context.unbind(UDDI_SUBSCRIPTION_LISTENER_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.subscriptionListenerService = null;
        try {
            this.context.unbind(UDDI_CUSTODY_TRANSFER_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.custodyTransferService = null;
        try {
            this.context.unbind(JUDDI_PUBLISHER_SERVICE);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.publisherService = null;
        try {
            this.context.unbind(JUDDI);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

