/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validation;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.juddi.keygen.KeyGenerator;
import org.apache.juddi.keygen.KeyGeneratorFactory;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.apache.juddi.v3.error.InvalidTimeException;
import org.apache.juddi.v3.error.KeyUnavailableException;
import org.apache.juddi.v3.error.UserMismatchException;
import org.apache.juddi.v3.error.ValueNotAllowedException;
import org.apache.juddi.validation.ValidateInquiry;
import org.apache.juddi.validation.ValidateUDDIApi;
import org.apache.juddi.validation.ValidateUDDIKey;
import org.uddi.sub_v3.CoveragePeriod;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionFilter;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateSubscription
extends ValidateUDDIApi {
    public ValidateSubscription(UddiEntityPublisher publisher) {
        super(publisher);
    }

    public void validateSubscriptions(EntityManager em, List<Subscription> entityList) throws DispositionReportFaultMessage {
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savesubscription.NoInput"));
        }
        for (Subscription entity : entityList) {
            this.validateSubscription(em, entity);
        }
    }

    public void validateSubscription(EntityManager em, Subscription subscription) throws DispositionReportFaultMessage {
        if (subscription == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.subscription.NullInput"));
        }
        boolean entityExists = false;
        String entityKey = subscription.getSubscriptionKey();
        if (entityKey == null || entityKey.length() == 0) {
            KeyGenerator keyGen = KeyGeneratorFactory.getKeyGenerator();
            entityKey = keyGen.generate();
            subscription.setSubscriptionKey(entityKey);
        } else {
            entityKey = entityKey.toLowerCase();
            subscription.setSubscriptionKey(entityKey);
            Object obj = em.find(org.apache.juddi.model.Subscription.class, (Object)entityKey);
            if (obj != null) {
                entityExists = true;
                if (!this.publisher.getAuthorizedName().equals(((org.apache.juddi.model.Subscription)obj).getAuthorizedName())) {
                    throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
                }
            } else {
                ValidateUDDIKey.validateUDDIv3Key(entityKey);
                if (!this.publisher.isValidPublisherKey(em, entityKey)) {
                    throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.BadPartition", entityKey));
                }
            }
        }
        if (!entityExists && !ValidateSubscription.isUniqueKey(em, entityKey)) {
            throw new KeyUnavailableException(new ErrorMessage("errors.keyunavailable.KeyExists", entityKey));
        }
        this.validateSubscriptionFilter(subscription.getSubscriptionFilter(), entityExists);
    }

    public void validateSubscriptionFilter(SubscriptionFilter subscriptionFilter, boolean entityExists) throws DispositionReportFaultMessage {
        if (!entityExists && subscriptionFilter == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.subscription.NoFilterOnNewSubscription"));
        }
        if (subscriptionFilter != null) {
            int filterCount = 0;
            ValidateInquiry validateInquiry = new ValidateInquiry(this.publisher);
            if (subscriptionFilter.getFindBinding() != null) {
                ++filterCount;
                validateInquiry.validateFindBinding(subscriptionFilter.getFindBinding());
            }
            if (subscriptionFilter.getFindBusiness() != null) {
                ++filterCount;
                validateInquiry.validateFindBusiness(subscriptionFilter.getFindBusiness());
            }
            if (subscriptionFilter.getFindService() != null) {
                ++filterCount;
                validateInquiry.validateFindService(subscriptionFilter.getFindService());
            }
            if (subscriptionFilter.getFindTModel() != null) {
                ++filterCount;
                validateInquiry.validateFindTModel(subscriptionFilter.getFindTModel(), false);
            }
            if (subscriptionFilter.getFindRelatedBusinesses() != null) {
                ++filterCount;
                validateInquiry.validateFindRelatedBusinesses(subscriptionFilter.getFindRelatedBusinesses(), false);
            }
            if (subscriptionFilter.getGetBindingDetail() != null) {
                ++filterCount;
                validateInquiry.validateGetBindingDetail(subscriptionFilter.getGetBindingDetail());
            }
            if (subscriptionFilter.getGetBusinessDetail() != null) {
                ++filterCount;
                validateInquiry.validateGetBusinessDetail(subscriptionFilter.getGetBusinessDetail());
            }
            if (subscriptionFilter.getGetServiceDetail() != null) {
                ++filterCount;
                validateInquiry.validateGetServiceDetail(subscriptionFilter.getGetServiceDetail());
            }
            if (subscriptionFilter.getGetTModelDetail() != null) {
                ++filterCount;
                validateInquiry.validateGetTModelDetail(subscriptionFilter.getGetTModelDetail());
            }
            if (subscriptionFilter.getGetAssertionStatusReport() != null) {
                ++filterCount;
            }
            if (filterCount == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.subscription.BlankFilter"));
            }
            if (filterCount > 1) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.subscription.TooManyFilters", String.valueOf(filterCount)));
            }
        }
    }

    public void validateDeleteSubscription(EntityManager em, DeleteSubscription body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List entityKeyList = body.getSubscriptionKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            boolean inserted = dupCheck.add(entityKey);
            if (!inserted) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
            }
            Object obj = em.find(org.apache.juddi.model.Subscription.class, (Object)entityKey);
            if (obj == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.SubscriptionNotFound", entityKey));
            }
            if (this.publisher.getAuthorizedName().equals(((org.apache.juddi.model.Subscription)obj).getAuthorizedName())) continue;
            throw new UserMismatchException(new ErrorMessage("errors.usermismatch.InvalidOwner", entityKey));
        }
    }

    public void validateGetSubscriptionResults(EntityManager em, GetSubscriptionResults body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        String subscriptionKey = body.getSubscriptionKey();
        if (subscriptionKey == null || subscriptionKey.length() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NullKey", subscriptionKey));
        }
        Object obj = em.find(org.apache.juddi.model.Subscription.class, (Object)subscriptionKey);
        if (obj == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.SubscriptionNotFound", subscriptionKey));
        }
        Date expiresAfter = ((org.apache.juddi.model.Subscription)obj).getExpiresAfter();
        Date now = new Date();
        if (expiresAfter.getTime() < now.getTime()) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.getsubscriptionresult.SubscriptionExpired", subscriptionKey));
        }
        CoveragePeriod coveragePeriod = body.getCoveragePeriod();
        if (coveragePeriod == null) {
            throw new InvalidTimeException(new ErrorMessage("errors.getsubscriptionresult.NullCoveragePeriod"));
        }
        if (coveragePeriod.getStartPoint() == null || coveragePeriod.getEndPoint() == null) {
            throw new InvalidTimeException(new ErrorMessage("errors.getsubscriptionresult.InvalidDateInCoveragePeriod"));
        }
        GregorianCalendar startPoint = coveragePeriod.getStartPoint().toGregorianCalendar();
        GregorianCalendar endPoint = coveragePeriod.getEndPoint().toGregorianCalendar();
        if (startPoint.getTimeInMillis() > endPoint.getTimeInMillis()) {
            throw new InvalidTimeException(new ErrorMessage("errors.getsubscriptionresult.StartPointAfterEndPoint", startPoint.toString()));
        }
    }
}

