/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public abstract class BERCharacterString
extends BERElement {
    protected String m_value = null;
    private byte[] byte_buf;

    public BERCharacterString() {
    }

    public BERCharacterString(String string) {
        this.m_value = string;
    }

    public BERCharacterString(byte[] byArray) {
        try {
            this.m_value = new String(byArray, "UTF8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public BERCharacterString(BERTagDecoder bERTagDecoder, InputStream inputStream, int[] nArray) throws IOException {
        int n;
        int[] nArray2 = new int[1];
        BERElement bERElement = null;
        if (n == -1) {
            do {
                nArray2[0] = 0;
                bERElement = BERCharacterString.getElement(bERTagDecoder, inputStream, nArray2);
                if (bERElement == null) continue;
                BERCharacterString bERCharacterString = (BERCharacterString)bERElement;
                String string = bERCharacterString.getValue();
                this.m_value = this.m_value == null ? string : this.m_value + string;
            } while (bERElement != null);
        } else {
            nArray[0] = nArray[0] + n;
            for (n = BERElement.readLengthOctets(inputStream, nArray); n > 0; n -= nArray2[0]) {
                nArray2[0] = 0;
                bERElement = BERCharacterString.getElement(bERTagDecoder, inputStream, nArray2);
                if (bERElement == null) continue;
                BERCharacterString bERCharacterString = (BERCharacterString)bERElement;
                String string = bERCharacterString.getValue();
                this.m_value = this.m_value == null ? string : this.m_value + string;
            }
        }
    }

    public BERCharacterString(InputStream inputStream, int[] nArray) throws IOException {
        int n = BERElement.readLengthOctets(inputStream, nArray);
        if (n > 0) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)inputStream.read();
            }
            nArray[0] = nArray[0] + n;
            try {
                this.m_value = new String(byArray, "UTF8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        if (this.m_value == null) {
            BERCharacterString.sendDefiniteLength(outputStream, 0);
        } else {
            try {
                this.byte_buf = this.m_value.getBytes("UTF8");
                BERCharacterString.sendDefiniteLength(outputStream, this.byte_buf.length);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            outputStream.write(this.byte_buf, 0, this.byte_buf.length);
        }
    }

    public String getValue() {
        return this.m_value;
    }

    public abstract int getType();

    public abstract String toString();
}

