/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testing.core.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.drools.testing.core.beans.Fact;
import org.drools.testing.core.beans.Rule;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;

public abstract class ScenarioType
implements Serializable {
    private String _name;
    private List _factList = new ArrayList();
    private List _ruleList = new ArrayList();

    public void addFact(Fact vFact) throws IndexOutOfBoundsException {
        this._factList.add(vFact);
    }

    public void addFact(int index, Fact vFact) throws IndexOutOfBoundsException {
        this._factList.add(index, vFact);
    }

    public void addRule(Rule vRule) throws IndexOutOfBoundsException {
        this._ruleList.add(vRule);
    }

    public void addRule(int index, Rule vRule) throws IndexOutOfBoundsException {
        this._ruleList.add(index, vRule);
    }

    public Enumeration enumerateFact() {
        return Collections.enumeration(this._factList);
    }

    public Enumeration enumerateRule() {
        return Collections.enumeration(this._ruleList);
    }

    public Fact getFact(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._factList.size()) {
            throw new IndexOutOfBoundsException("getFact: Index value '" + index + "' not in range [0.." + (this._factList.size() - 1) + "]");
        }
        return (Fact)this._factList.get(index);
    }

    public Fact[] getFact() {
        int size = this._factList.size();
        Fact[] array = new Fact[size];
        for (int index = 0; index < size; ++index) {
            array[index] = (Fact)this._factList.get(index);
        }
        return array;
    }

    public int getFactCount() {
        return this._factList.size();
    }

    public String getName() {
        return this._name;
    }

    public Rule getRule(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ruleList.size()) {
            throw new IndexOutOfBoundsException("getRule: Index value '" + index + "' not in range [0.." + (this._ruleList.size() - 1) + "]");
        }
        return (Rule)this._ruleList.get(index);
    }

    public Rule[] getRule() {
        int size = this._ruleList.size();
        Rule[] array = new Rule[size];
        for (int index = 0; index < size; ++index) {
            array[index] = (Rule)this._ruleList.get(index);
        }
        return array;
    }

    public int getRuleCount() {
        return this._ruleList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateFact() {
        return this._factList.iterator();
    }

    public Iterator iterateRule() {
        return this._ruleList.iterator();
    }

    public void removeAllFact() {
        this._factList.clear();
    }

    public void removeAllRule() {
        this._ruleList.clear();
    }

    public boolean removeFact(Fact vFact) {
        boolean removed = this._factList.remove(vFact);
        return removed;
    }

    public Fact removeFactAt(int index) {
        Object obj = this._factList.remove(index);
        return (Fact)obj;
    }

    public boolean removeRule(Rule vRule) {
        boolean removed = this._ruleList.remove(vRule);
        return removed;
    }

    public Rule removeRuleAt(int index) {
        Object obj = this._ruleList.remove(index);
        return (Rule)obj;
    }

    public void setFact(int index, Fact vFact) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._factList.size()) {
            throw new IndexOutOfBoundsException("setFact: Index value '" + index + "' not in range [0.." + (this._factList.size() - 1) + "]");
        }
        this._factList.set(index, vFact);
    }

    public void setFact(Fact[] vFactArray) {
        this._factList.clear();
        for (int i = 0; i < vFactArray.length; ++i) {
            this._factList.add(vFactArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRule(int index, Rule vRule) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ruleList.size()) {
            throw new IndexOutOfBoundsException("setRule: Index value '" + index + "' not in range [0.." + (this._ruleList.size() - 1) + "]");
        }
        this._ruleList.set(index, vRule);
    }

    public void setRule(Rule[] vRuleArray) {
        this._ruleList.clear();
        for (int i = 0; i < vRuleArray.length; ++i) {
            this._ruleList.add(vRuleArray[i]);
        }
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

