/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testing.core.main;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.drools.lang.descr.ColumnDescr;
import org.drools.lang.descr.LiteralDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.testing.core.beans.Rule;
import org.drools.testing.core.beans.Scenario;
import org.drools.testing.core.beans.TestSuite;
import org.drools.testing.core.configuration.ApplicationProperties;
import org.drools.testing.core.configuration.PropertyNotFoundException;
import org.drools.testing.core.exception.RuleTestLanguageException;
import org.drools.testing.core.utils.CollectionUtils;
import org.drools.testing.core.utils.ObjectUtils;
import org.drools.testing.core.wrapper.FactWrapper;
import org.drools.testing.core.wrapper.FieldWrapper;

public final class Testing {
    private TestSuite testSuite;
    private Scenario scenario;
    private PackageDescr packageDescr;
    private Random rng;
    private List facts = new ArrayList();
    private ApplicationProperties applicationProperties = ApplicationProperties.getInstance();
    private ClassLoader classLoader;

    public Testing() {
    }

    public Testing(String suiteName, PackageDescr packageDescr) {
        this.testSuite = new TestSuite();
        this.testSuite.setName(suiteName);
        this.packageDescr = packageDescr;
    }

    public Testing(String suiteName, PackageDescr packageDescr, ClassLoader classLoader) {
        this.testSuite = new TestSuite();
        this.testSuite.setName(suiteName);
        this.packageDescr = packageDescr;
        this.classLoader = classLoader;
    }

    public TestSuite getTestSuite() throws RuleTestLanguageException {
        return this.testSuite;
    }

    public Scenario generateScenario(String name, List rules) throws RuleTestLanguageException {
        this.scenario = new Scenario();
        this.scenario.setName(name);
        this.rng = new Random();
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            RuleDescr rule = (RuleDescr)i.next();
            this.scenario.addRule(this.getRule(rule));
            this.processColumnDescriptors(rule.getLhs().getDescrs());
        }
        Iterator j = this.facts.iterator();
        while (j.hasNext()) {
            FactWrapper factWrapper = (FactWrapper)j.next();
            factWrapper.setId(this.rng.nextInt());
            this.scenario.addFact(factWrapper);
        }
        return this.scenario;
    }

    public List processColumnDescriptors(List descrs) throws RuleTestLanguageException {
        Iterator i = descrs.iterator();
        while (i.hasNext()) {
            ColumnDescr columnDescr = (ColumnDescr)i.next();
            Class classDefn = ObjectUtils.getClassDefn(columnDescr.getObjectType(), this.packageDescr.getImports(), this.classLoader);
            FactWrapper fact = new FactWrapper();
            fact.setType(classDefn.getName());
            if (this.facts.contains(fact)) {
                fact = (FactWrapper)this.facts.get(this.facts.indexOf(fact));
                this.facts.remove(fact);
            }
            this.processLiteralDescriptors(classDefn, fact, columnDescr.getDescrs());
            this.facts.add(fact);
        }
        return this.facts;
    }

    public void processLiteralDescriptors(Class classDefn, FactWrapper fact, List descrs) throws RuleTestLanguageException {
        List fields = (List)CollectionUtils.arrayToCollection(fact.getField());
        Iterator i = descrs.iterator();
        while (i.hasNext()) {
            LiteralDescr literalDescr = (LiteralDescr)i.next();
            FieldWrapper field = new FieldWrapper();
            field.setName(literalDescr.getFieldName());
            field.setValue(this.getValue(literalDescr.getFieldName(), literalDescr.getText(), literalDescr.getEvaluator()));
            field.setType(this.getType(classDefn, literalDescr.getFieldName()).getName());
            if (fields.contains(field)) continue;
            fact.addField(field);
        }
    }

    public Rule getRule(RuleDescr ruleDescr) throws RuleTestLanguageException {
        Rule rule = new Rule();
        rule.setName(ruleDescr.getName());
        rule.setFire(true);
        return rule;
    }

    public void addScenarioToSuite(Scenario scenario) throws RuleTestLanguageException {
        this.testSuite.addScenario(scenario);
    }

    public Class getType(Class classDefn, String fieldName) {
        Class<?> type = null;
        try {
            type = classDefn.getDeclaredField(fieldName).getType();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return type;
    }

    public String getValue(String fieldName, String value, String operator) {
        String result = null;
        result = "<,>".indexOf(operator) != -1 ? this.getRangeValue(operator, value) : value;
        return result;
    }

    public String getRangeValue(String operator, String value) {
        String result = null;
        try {
            Integer min = new Integer(this.applicationProperties.getProperty("range.min"));
            Integer max = new Integer(this.applicationProperties.getProperty("range.max"));
            if (operator.indexOf("<") != -1) {
                max = new Integer(value);
            } else if (operator.indexOf(">") != -1) {
                min = new Integer(value);
            }
            result = min.toString();
            for (int i = min + 1; i < max; ++i) {
                result = result + "," + i;
            }
        }
        catch (PropertyNotFoundException e) {
            // empty catch block
        }
        return result;
    }
}

