/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.crypto.Cipher;
import javax.management.ObjectName;
import org.jboss.security.auth.spi.Util;
import org.jboss.security.config.SecurityConfiguration;

class DecodeAction
implements PrivilegedExceptionAction {
    private static final RuntimePermission decodePermission = new RuntimePermission("org.jboss.security.auth.spi.DecodeAction.decode");
    String password;
    ObjectName serviceName;

    DecodeAction(String password, ObjectName serviceName) {
        this.password = password;
        this.serviceName = serviceName;
    }

    public Object run() throws Exception {
        byte[] secret = this.decode64(this.password);
        String secretPassword = new String(secret, "UTF-8");
        return secretPassword.toCharArray();
    }

    private byte[] decode64(String secret) throws Exception {
        byte[] encoding = Util.fromb64(secret);
        byte[] decode = this.decode(encoding);
        return decode;
    }

    private byte[] decode(byte[] secret) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(decodePermission);
        }
        Cipher cipher = Cipher.getInstance(SecurityConfiguration.getCipherAlgorithm());
        cipher.init(2, SecurityConfiguration.getCipherKey(), SecurityConfiguration.getCipherSpec());
        byte[] decode = cipher.doFinal(secret);
        return decode;
    }

    static char[] decode(String password, ObjectName serviceName) throws Exception {
        DecodeAction action = new DecodeAction(password, serviceName);
        try {
            char[] decode = (char[])AccessController.doPrivileged(action);
            return decode;
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }
}

