/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.crypto.digest.DigestCallback;
import org.jboss.logging.Logger;
import org.jboss.security.Base64Encoder;
import org.jboss.security.Base64Utils;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.plugins.TransactionManagerLocator;

public class Util {
    private static Logger log = Logger.getLogger(Util.class);
    public static final String BASE64_ENCODING = "BASE64";
    public static final String BASE16_ENCODING = "HEX";
    public static final String RFC2617_ENCODING = "RFC2617";
    private static char[] MD5_HEX = "0123456789abcdef".toCharArray();

    static Group[] getRoleSets(String targetUser, Properties roles, char roleGroupSeperator, AbstractServerLoginModule aslm) {
        Logger log = aslm.log;
        boolean trace = log.isTraceEnabled();
        Enumeration<?> users = roles.propertyNames();
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        ArrayList<SimpleGroup> groups = new ArrayList<SimpleGroup>();
        groups.add(rolesGroup);
        while (users.hasMoreElements() && targetUser != null) {
            String user = (String)users.nextElement();
            String value = roles.getProperty(user);
            if (trace) {
                log.trace((Object)("Checking user: " + user + ", roles string: " + value));
            }
            int index = user.indexOf(roleGroupSeperator, targetUser.length());
            boolean isRoleGroup = false;
            boolean userMatch = false;
            if (index > 0 && targetUser.regionMatches(0, user, 0, index)) {
                isRoleGroup = true;
            } else {
                userMatch = targetUser.equals(user);
            }
            if (isRoleGroup) {
                String groupName = user.substring(index + 1);
                if (groupName.equals("Roles")) {
                    if (trace) {
                        log.trace((Object)("Adding to Roles: " + value));
                    }
                    Util.parseGroupMembers(rolesGroup, value, aslm);
                    continue;
                }
                if (trace) {
                    log.trace((Object)("Adding to " + groupName + ": " + value));
                }
                SimpleGroup group = new SimpleGroup(groupName);
                Util.parseGroupMembers(group, value, aslm);
                groups.add(group);
                continue;
            }
            if (!userMatch) continue;
            if (trace) {
                log.trace((Object)("Adding to Roles: " + value));
            }
            Util.parseGroupMembers(rolesGroup, value, aslm);
        }
        Group[] roleSets = new Group[groups.size()];
        groups.toArray(roleSets);
        return roleSets;
    }

    static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm) throws LoginException {
        return Util.getRoleSets(username, dsJndiName, rolesQuery, aslm, false);
    }

    /*
     * Loose catch block
     */
    static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm, boolean suspendResume) throws LoginException {
        HashMap<String, Group> setsMap;
        block61: {
            Exception e22222;
            Transaction tx;
            TransactionManager tm;
            ResultSet rs;
            Statement ps;
            Connection conn;
            boolean trace;
            Logger log;
            block57: {
                block52: {
                    Exception e22222;
                    Group[] groupArray;
                    block53: {
                        Group[] roleSets;
                        log = aslm.log;
                        trace = log.isTraceEnabled();
                        conn = null;
                        setsMap = new HashMap<String, Group>();
                        ps = null;
                        rs = null;
                        TransactionManagerLocator tml = new TransactionManagerLocator();
                        try {
                            tm = tml.getTM("java:/TransactionManager");
                        }
                        catch (NamingException e1) {
                            throw new RuntimeException(e1);
                        }
                        if (tm == null) {
                            throw new IllegalStateException("Transaction Manager is null");
                        }
                        tx = null;
                        if (suspendResume) {
                            try {
                                tx = tm.suspend();
                            }
                            catch (SystemException e3) {
                                throw new RuntimeException(e3);
                            }
                            if (trace) {
                                log.trace((Object)"suspendAnyTransaction");
                            }
                        }
                        InitialContext ctx = new InitialContext();
                        DataSource ds = (DataSource)ctx.lookup(dsJndiName);
                        conn = ds.getConnection();
                        if (trace) {
                            log.trace((Object)("Excuting query: " + rolesQuery + ", with username: " + username));
                        }
                        ps = conn.prepareStatement(rolesQuery);
                        try {
                            ps.setString(1, username);
                        }
                        catch (ArrayIndexOutOfBoundsException ignore) {
                            // empty catch block
                        }
                        rs = ps.executeQuery();
                        if (rs.next()) break block52;
                        if (trace) {
                            log.trace((Object)"No roles found");
                        }
                        if (aslm.getUnauthenticatedIdentity() == null) {
                            throw new FailedLoginException("No matching username found in Roles");
                        }
                        groupArray = roleSets = new Group[]{new SimpleGroup("Roles")};
                        Object var21_25 = null;
                        if (rs == null) break block53;
                        try {
                            rs.close();
                        }
                        catch (SQLException e22222) {
                            // empty catch block
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e22222) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (suspendResume) {
                        try {
                            tm.resume(tx);
                        }
                        catch (Exception e22222) {
                            throw new RuntimeException(e22222);
                        }
                        if (trace) {
                            log.trace((Object)"resumeAnyTransaction");
                        }
                    }
                    return groupArray;
                }
                do {
                    Group group;
                    String name = rs.getString(1);
                    String groupName = rs.getString(2);
                    if (groupName == null || groupName.length() == 0) {
                        groupName = "Roles";
                    }
                    if ((group = (Group)setsMap.get(groupName)) == null) {
                        group = new SimpleGroup(groupName);
                        setsMap.put(groupName, group);
                    }
                    try {
                        Principal p = aslm.createIdentity(name);
                        if (trace) {
                            log.trace((Object)("Assign user to role " + name));
                        }
                        group.addMember(p);
                    }
                    catch (Exception e4) {
                        log.debug((Object)("Failed to create principal: " + name), (Throwable)e4);
                    }
                } while (rs.next());
                Object var21_26 = null;
                if (rs == null) break block57;
                try {
                    rs.close();
                }
                catch (SQLException e22222) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e22222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!suspendResume) break block61;
            try {
                tm.resume(tx);
            }
            catch (Exception e22222) {
                throw new RuntimeException(e22222);
            }
            if (trace) {
                log.trace((Object)"resumeAnyTransaction");
            }
            break block61;
            {
                LoginException le;
                catch (NamingException ex) {
                    le = new LoginException("Error looking up DataSource from: " + dsJndiName);
                    le.initCause(ex);
                    throw le;
                }
                catch (SQLException ex) {
                    le = new LoginException("Query failed");
                    le.initCause(ex);
                    throw le;
                }
            }
            catch (Throwable throwable) {
                Object var21_27 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e22222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e22222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (suspendResume) {
                    try {
                        tm.resume(tx);
                    }
                    catch (Exception e22222) {
                        throw new RuntimeException(e22222);
                    }
                    if (trace) {
                        log.trace((Object)"resumeAnyTransaction");
                    }
                }
                throw throwable;
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    static Properties loadProperties(String defaultsName, String propertiesName, Logger log) throws IOException {
        InputStream is;
        Properties bundle = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL defaultUrl = null;
        URL url = null;
        if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            defaultUrl = ucl.findResource(defaultsName);
            url = ucl.findResource(propertiesName);
            log.trace((Object)("findResource: " + url));
        }
        if (defaultUrl == null) {
            defaultUrl = loader.getResource(defaultsName);
        }
        if (url == null) {
            url = loader.getResource(propertiesName);
        }
        if (url == null && defaultUrl == null) {
            String msg = "No properties file: " + propertiesName + " or defaults: " + defaultsName + " found";
            throw new IOException(msg);
        }
        log.trace((Object)("Properties file=" + url + ", defaults=" + defaultUrl));
        Properties defaults = new Properties();
        if (defaultUrl != null) {
            try {
                is = defaultUrl.openStream();
                defaults.load(is);
                is.close();
                log.debug((Object)("Loaded defaults, users=" + defaults.keySet()));
            }
            catch (Throwable e) {
                log.debug((Object)"Failed to load defaults", e);
            }
        }
        bundle = new Properties(defaults);
        if (url != null) {
            is = url.openStream();
            if (is == null) {
                throw new IOException("Properties file " + propertiesName + " not avilable");
            }
            bundle.load(is);
            is.close();
            log.debug((Object)("Loaded properties, users=" + bundle.keySet()));
        }
        return bundle;
    }

    static Properties loadProperties(String propertiesName, Logger log) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            url = ucl.findResource(propertiesName);
            log.trace((Object)("findResource: " + url));
        }
        if (url == null) {
            url = loader.getResource(propertiesName);
        }
        if (url == null) {
            url = new URL(propertiesName);
        }
        log.trace((Object)("Properties file=" + url));
        Properties bundle = new Properties();
        if (url != null) {
            InputStream is = url.openStream();
            if (is == null) {
                throw new IOException("Properties file " + propertiesName + " not avilable");
            }
            bundle.load(is);
            is.close();
            log.debug((Object)("Loaded properties, users=" + bundle.keySet()));
        }
        return bundle;
    }

    static void parseGroupMembers(Group group, String roles, AbstractServerLoginModule aslm) {
        StringTokenizer tokenizer = new StringTokenizer(roles, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                Principal p = aslm.createIdentity(token);
                group.addMember(p);
            }
            catch (Exception e) {
                aslm.log.warn((Object)("Failed to create principal for: " + token), (Throwable)e);
            }
        }
    }

    public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password) {
        return Util.createPasswordHash(hashAlgorithm, hashEncoding, hashCharset, username, password, null);
    }

    public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password, DigestCallback callback) {
        byte[] passBytes;
        String passwordHash = null;
        try {
            passBytes = hashCharset == null ? password.getBytes() : password.getBytes(hashCharset);
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)("charset " + hashCharset + " not found. Using platform default."), (Throwable)uee);
            passBytes = password.getBytes();
        }
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
            if (callback != null) {
                callback.preDigest(md);
            }
            md.update(passBytes);
            if (callback != null) {
                callback.postDigest(md);
            }
            byte[] hash = md.digest();
            if (hashEncoding.equalsIgnoreCase(BASE64_ENCODING)) {
                passwordHash = Util.encodeBase64(hash);
            } else if (hashEncoding.equalsIgnoreCase(BASE16_ENCODING)) {
                passwordHash = Util.encodeBase16(hash);
            } else if (hashEncoding.equalsIgnoreCase(RFC2617_ENCODING)) {
                passwordHash = Util.encodeRFC2617(hash);
            } else {
                log.error((Object)("Unsupported hash encoding format " + hashEncoding));
            }
        }
        catch (Exception e) {
            log.error((Object)"Password hash calculation failed ", (Throwable)e);
        }
        return passwordHash;
    }

    public static String encodeRFC2617(byte[] data) {
        char[] hash = new char[32];
        for (int i = 0; i < 16; ++i) {
            int j = data[i] >> 4 & 0xF;
            hash[i * 2] = MD5_HEX[j];
            j = data[i] & 0xF;
            hash[i * 2 + 1] = MD5_HEX[j];
        }
        return new String(hash);
    }

    public static String encodeBase16(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            char c = (char)(b >> 4 & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
            c = (char)(b & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String encodeBase64(byte[] bytes) {
        String base64 = null;
        try {
            base64 = Base64Encoder.encode(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return base64;
    }

    public static String tob64(byte[] buffer) {
        return Base64Utils.tob64(buffer);
    }

    public static byte[] fromb64(String str) throws NumberFormatException {
        return Base64Utils.fromb64(str);
    }
}

