/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.AuthorizationModule;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.ResourceType;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;

public abstract class AbstractAuthorizationModule
implements AuthorizationModule {
    protected Subject subject = null;
    protected CallbackHandler handler = null;
    protected Map sharedState = null;
    protected Map options = null;
    protected Logger log = null;
    protected Map delegateMap = new HashMap();

    public abstract int authorize(Resource var1);

    public boolean abort() throws AuthorizationException {
        return true;
    }

    public boolean commit() throws AuthorizationException {
        return true;
    }

    public boolean destroy() {
        this.subject = null;
        this.handler = null;
        this.sharedState = null;
        this.options = null;
        return true;
    }

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        String commaSeparatedDelegates;
        this.subject = subject;
        this.handler = handler;
        this.sharedState = sharedState;
        this.options = options;
        if (options != null && (commaSeparatedDelegates = (String)options.get("delegateMap")) != null && commaSeparatedDelegates.length() > 0) {
            this.populateDelegateMap(commaSeparatedDelegates);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Name=" + this.getClass().getName());
        buf.append(":subject=" + this.subject);
        return buf.toString();
    }

    protected int invokeDelegate(Resource resource) {
        int authorizationDecision = -1;
        ResourceType layer = resource.getLayer();
        String delegateStr = (String)this.delegateMap.get(layer);
        if (delegateStr == null) {
            throw new IllegalStateException("Delegate is missing for layer=" + layer);
        }
        AuthorizationModuleDelegate delegate = null;
        try {
            delegate = this.getDelegate(delegateStr);
            authorizationDecision = delegate.authorize(resource);
        }
        catch (Exception e) {
            this.log.debug((Object)"Error with delegate:", (Throwable)e);
            IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
            ise.initCause(e);
            throw ise;
        }
        return authorizationDecision;
    }

    protected AuthorizationModuleDelegate getDelegate(String delegateStr) throws Exception {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = tcl.loadClass(delegateStr);
        return (AuthorizationModuleDelegate)clazz.newInstance();
    }

    protected void populateDelegateMap(String commaSeparatedDelegates) {
        StringTokenizer st = new StringTokenizer(commaSeparatedDelegates, ",");
        while (st.hasMoreTokens()) {
            String keyPair = st.nextToken();
            StringTokenizer keyst = new StringTokenizer(keyPair, "=");
            if (keyst.countTokens() != 2) {
                throw new IllegalStateException("DelegateMap entry invalid:" + keyPair);
            }
            String key = keyst.nextToken();
            String value = keyst.nextToken();
            this.delegateMap.put(key, value);
        }
    }
}

