/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.cache.JBossAuthenticationCache;
import org.jboss.security.cache.SecurityCache;
import org.jboss.security.cache.SecurityCacheException;
import org.jboss.security.plugins.SubjectActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAuthenticationManager
implements AuthenticationManager {
    private static Logger log = Logger.getLogger(JBossAuthenticationManager.class);
    protected String securityDomain = "other";
    protected CallbackHandler callbackHandler = null;
    private ThreadLocal<Subject> subjectLocal = new ThreadLocal();
    private SecurityCache<Principal> sCache = null;
    private boolean cacheValidation = false;

    public JBossAuthenticationManager(String sdomain, CallbackHandler cbh) {
        this.securityDomain = sdomain;
        this.callbackHandler = cbh;
        this.sCache = new JBossAuthenticationCache();
    }

    public JBossAuthenticationManager(String sdomain, CallbackHandler cbh, int initCapacity, float loadFactor, int level) {
        this.securityDomain = sdomain;
        this.callbackHandler = cbh;
        this.sCache = new JBossAuthenticationCache(initCapacity, loadFactor, level);
    }

    public void setSecurityCache(String className) {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        ClassLoader cl = SubjectActions.getContextClassLoader();
        try {
            Class<?> clazz = cl.loadClass(className);
            this.sCache = (SecurityCache)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Subject getActiveSubject() {
        return this.subjectLocal.get();
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public Principal getTargetPrincipal(Principal principal, Map<String, Object> map) {
        throw new RuntimeException("Unimplemented");
    }

    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, new Subject());
    }

    public boolean isValid(Principal principal, Object credential, Subject subject) {
        Subject cacheSubject;
        if (subject == null) {
            throw new IllegalArgumentException("Subject is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.sCache.cacheHit((Object)principal) && (cacheSubject = this.validateCache(principal, credential, subject)) != null) {
            subject = cacheSubject;
            this.subjectLocal.set(cacheSubject);
            return true;
        }
        LoginContext lc = null;
        try {
            this.cacheValidation = false;
            lc = new LoginContext(this.securityDomain, subject, this.callbackHandler);
            lc.login();
            map.put("Credential", credential);
            map.put("Subject", subject);
            try {
                this.sCache.addCacheEntry((Object)principal, map);
            }
            catch (SecurityCacheException e) {
                throw new RuntimeException(e);
            }
            this.subjectLocal.set(lc.getSubject());
        }
        catch (LoginException e) {
            log.trace((Object)"Login Failure:", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean fromCache() {
        return this.cacheValidation;
    }

    private Subject validateCache(Principal principal, Object credential, Subject subject) {
        this.cacheValidation = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Credential", credential);
        try {
            this.sCache.cacheOperation((Object)principal, map);
            Object cacheReturn = this.sCache.get((Object)principal);
            if (cacheReturn != null && cacheReturn instanceof Subject) {
                subject = (Subject)cacheReturn;
                this.cacheValidation = true;
                return subject;
            }
        }
        catch (SecurityCacheException e) {
            // empty catch block
        }
        return null;
    }
}

