/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.authorization;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class SecurityActions {
    public static ClassLoader getContextClassLoader() throws PrivilegedActionException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static Class loadClass(final String name) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws PrivilegedActionException {
                try {
                    return SecurityActions.getContextClassLoader().loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }
}

