/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.iplanet.security.x509.X500Name;
import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.cert.AMLDAPCertStoreParameters;
import com.sun.identity.shared.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class AMCertStore {
    protected AMLDAPCertStoreParameters storeParam = null;
    protected LDAPConnection ldapconn = null;
    protected X509Certificate certificate = null;
    protected static CertificateFactory cf = null;
    static final String amSecurity = "amSecurity";
    static Debug debug = SecurityDebug.debug;

    public AMCertStore(AMLDAPCertStoreParameters param) {
        this.storeParam = param;
    }

    synchronized LDAPConnection getConnection() {
        if (this.ldapconn != null) {
            return this.ldapconn;
        }
        if (this.storeParam.isSecure()) {
            if (debug.messageEnabled()) {
                debug.message("AMCertStore.getConnection: initial ldc  using ssl.");
            }
            try {
                this.ldapconn = new LDAPConnection(this.storeParam.getSecureSocketFactory());
                if (debug.messageEnabled()) {
                    debug.message("AMCertStore.getConnection: SSLSocketFactory called");
                }
            }
            catch (Exception e) {
                debug.error("AMCertStore.getConnection: JSSSocketFactory", e);
            }
        } else {
            this.ldapconn = new LDAPConnection();
        }
        try {
            this.ldapconn.connect(this.storeParam.getServerName(), this.storeParam.getPort());
            this.ldapconn.authenticate(3, this.storeParam.getUser(), this.storeParam.getPassword());
        }
        catch (LDAPException e) {
            debug.error("AMCertStore.getConnection: Exception in connection to LDAP server", e);
        }
        return this.ldapconn;
    }

    LDAPSearchResults getSearchResults(LDAPConnection ldc) {
        LDAPSearchResults results = null;
        try {
            results = ldc.search(this.storeParam.getStartLoc(), 2, this.storeParam.getSearchFilter(), null, false);
            if (results == null || !results.hasMoreElements()) {
                debug.error("No ldap Entry found !");
                return null;
            }
        }
        catch (Exception e) {
            debug.error("AMCertStore.getSearchResults : Error in ldap search for " + this.storeParam.getSearchFilter());
            debug.error("AMCertStore.getSearchResults : ", e);
            return null;
        }
        return results;
    }

    LDAPEntry getLdapEntry(LDAPConnection ldc) {
        LDAPEntry ldapEntry = null;
        try {
            LDAPSearchResults results = this.getSearchResults(ldc);
            ldapEntry = results.next();
        }
        catch (Exception e) {
            debug.error("AMCertStore.getLdapEntry : Error in getting Cached CRL");
            return null;
        }
        return ldapEntry;
    }

    public X509Certificate getCertificate(X509Certificate cert) {
        X509Certificate c = this.getCertificate();
        if (c != null && c.equals(cert)) {
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate getCertificate() {
        LDAPConnection ldc = this.getConnection();
        try {
            LDAPSearchResults results = this.getSearchResults(ldc);
            while (results != null && results.hasMoreElements()) {
                LDAPEntry entry = results.next();
                LDAPAttributeSet attrSet = entry.getAttributeSet();
                LDAPAttribute certAttribute = attrSet.getAttribute("usercertificate");
                if (certAttribute == null && (certAttribute = attrSet.getAttribute("usercertificate;binary")) == null) {
                    debug.message("AMCertStore.getCertificate : Certificate - get usercertificate is null ");
                    continue;
                }
                Enumeration allCert = certAttribute.getByteValues();
                while (allCert.hasMoreElements()) {
                    byte[] bytes = (byte[])allCert.nextElement();
                    ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                    X509Certificate c = null;
                    try {
                        c = (X509Certificate)cf.generateCertificate(bis);
                    }
                    catch (CertificateParsingException e) {
                        debug.error("AMCertStore.getCertificate : Error in Certificate parsing : ", e);
                    }
                    if (c == null) continue;
                    X509Certificate x509Certificate = c;
                    return x509Certificate;
                }
            }
        }
        catch (Exception e) {
            debug.error("AMCertStore.getCertificate : Certificate - Error finding registered certificate = ", e);
        }
        finally {
            try {
                ldc.disconnect();
            }
            catch (LDAPException lDAPException) {}
        }
        return null;
    }

    public static X500Name getIssuerDN(X509Certificate certificate) throws IOException {
        X500Name dn = null;
        try {
            X500Principal issuerPrincipal = certificate.getIssuerX500Principal();
            dn = new X500Name(issuerPrincipal.getEncoded());
        }
        catch (IOException e) {
            debug.error("AMCertStore.getIssuerDN : Error in getting issuer DN : ", e);
        }
        return dn;
    }

    public static X500Name getSubjectDN(X509Certificate certificate) throws IOException {
        X500Name dn = null;
        try {
            X500Principal subjectPrincipal = certificate.getSubjectX500Principal();
            dn = new X500Name(subjectPrincipal.getEncoded());
        }
        catch (Exception e) {
            debug.error("AMCertStore.getSubjectDN : Error in getting subject DN : " + e.toString());
        }
        return dn;
    }

    public static String setSearchFilter(String attrName, String attrValue) {
        String searchFilter = new StringBuffer(128).append("(").append(attrName).append("=").append(attrValue).append(")").toString();
        if (debug.messageEnabled()) {
            debug.message("AMCertStore.setSearchFilter : ldc.search: using this filter: " + searchFilter);
        }
        return searchFilter;
    }

    public static AMLDAPCertStoreParameters setLdapStoreParam(String serverHost, int serverPort, String principleUser, String principlePasswd, String startSearchLoc, String uriParamsCRL, boolean isSSL) throws Exception {
        AMLDAPCertStoreParameters ldapParam = new AMLDAPCertStoreParameters(serverHost, serverPort);
        AMLDAPCertStoreParameters.setLdapStoreParam(ldapParam, principleUser, principlePasswd, startSearchLoc, uriParamsCRL, isSSL);
        return ldapParam;
    }

    public static X509Certificate getIssuerCertificate(AMLDAPCertStoreParameters ldapParam, X509Certificate cert, String attrName) {
        String attrValue = null;
        try {
            X500Name dn = AMCertStore.getIssuerDN(cert);
            if (dn != null) {
                attrValue = dn.getAttributeValue(attrName);
            }
        }
        catch (Exception ex) {
            if (debug.messageEnabled()) {
                debug.message("getIssuerCertificate - cn substring: " + ex);
            }
            return null;
        }
        if (attrValue == null) {
            return null;
        }
        return AMCertStore.getCertificate(ldapParam, attrName, attrValue);
    }

    public static X509Certificate getRegisteredCertificate(AMLDAPCertStoreParameters ldapParam, X509Certificate cert, String attrName) {
        String attrValue = null;
        X509Certificate c = null;
        try {
            X500Name dn = AMCertStore.getSubjectDN(cert);
            if (dn != null) {
                attrValue = dn.getAttributeValue(attrName);
            }
        }
        catch (Exception ex) {
            if (debug.messageEnabled()) {
                debug.message("Certificate - cn substring: " + ex);
            }
            return null;
        }
        if (attrValue == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("Certificate - cn substring: " + attrValue);
        }
        if ((c = AMCertStore.getCertificate(ldapParam, attrName, attrValue)) != null && c.equals(cert)) {
            return c;
        }
        return null;
    }

    public static X509Certificate getCertificate(AMLDAPCertStoreParameters ldapParam, String attrName, String attrValue) {
        X509Certificate ldapcert;
        block3: {
            ldapcert = null;
            if (attrValue == null) {
                return null;
            }
            try {
                String searchFilter = AMCertStore.setSearchFilter(attrName, attrValue);
                ldapParam.setSearchFilter(searchFilter);
                AMCertStore store = new AMCertStore(ldapParam);
                ldapcert = store.getCertificate();
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("Certificate - Error finding registered certificate = ", e);
            }
        }
        return ldapcert;
    }

    public static boolean isRootCA(X509Certificate cert) {
        X500Name subjectDN = null;
        X500Name issuerDN = null;
        try {
            subjectDN = AMCertStore.getIssuerDN(cert);
            issuerDN = AMCertStore.getSubjectDN(cert);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return issuerDN.equals(subjectDN);
    }

    static {
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            debug.error("AMCertStore : ", e);
        }
    }
}

