/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */

package org.jboss.internal.soa.esb.listeners.gateway.filefilter;

import java.io.File;
import java.io.FileFilter;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.util.Util;

// worker file filter (used if input suffix is null)

public class IgnoreFile implements FileFilter
{
    public IgnoreFile(String workSuffix, String errorSuffix, String postSuffix)
            throws ConfigurationException
    {
        _workSuffix = workSuffix;
        _errorSuffix = errorSuffix;
        _postSuffix = postSuffix;

        if (Util.isNullString(_workSuffix))
            throw new ConfigurationException("Must specify workSuffix");
        if (Util.isNullString(_errorSuffix))
            throw new ConfigurationException("Must specify errorSuffix");
        if (Util.isNullString(_postSuffix))
            throw new ConfigurationException("Must specify postProcessSuffix");
    } // ______________________________

    public boolean accept (File p_f)
    {
        if (p_f.isFile())
        {
            /*
             * If file is a work file then ignore it.
             */

            String fileName = p_f.toString();

            if (fileName.endsWith(_workSuffix)
                    || fileName.endsWith(_errorSuffix)
                    || fileName.endsWith(_postSuffix))
            {
                return false;
            }
            else
                return true;
        }
        else
            return false;
    }
    
    private String _workSuffix;
    private String _errorSuffix;
    private String _postSuffix;
}
